function AppAnimation() {
	var _this = this;
	var Selector = {};
	_this.animate = function (_obj){
		
		Selector = {
			TYPE: 'fade-in',
			EL: 'div',
			DURATION: 1,					
			DELAY: 0,
			REPEAT: 0,
			YOYO: false,
			REVERSED: false,
			STAGGER: false,
			VAL:'100%',
			START_VAL:'0%',
			END_VAL: '100%',
			EASE: 'Power1.easeOut',		
			ON_INIT: null,
			ON_COMPLETE: null
		};		
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	//tweemax object
	_this.generateAniObj = function (_el){
		var _obj = $(_el).data();
		var newObj = {
			EL: $(_el),
			TYPE: _obj.animateType || 'fade-in',
			START_VAL: _obj.animateStartVal || '0%',
			END_VAL: _obj.animateEndVal || '100%',
			EASE: _obj.animateEase || 'Power1.easeOut',
			DURATION: _obj.animateDuration || 1,
			DELAY: _obj.animateDelay || 0,
			REPEAT: _obj.animateRepeat || 0,
			YOYO: _obj.animateYoyo || false,
			REVERSED: _obj.animateReversed || false,
			STAGGER: Boolean(_obj.animateStagger) || false,
			ON_INIT: _obj.animateOnInit || null,
			ON_COMPLETE: _obj.animateOnComplete || null,
		}
		
		return newObj;
	}
	//animate css object
	_this.generateAniCssObj = function (_obj){
		var newObj = {
			in: _obj.animateInClass || 'fadeIn',
			out: _obj.animateOutClass || 'fadeOut'			
		}
		
		return newObj;
	}
	function initTemplate() {
		//created new object to prevent updation if may animation call at a time...
		var currSelector = Object.assign({}, Selector);
		var _type = currSelector.TYPE.toLowerCase();
		//--for multi lang
		if(APP.configObj.language.dir == 'rtl'){
			if(_type == 'fade-in-left'){
				_type = 'fade-in-right' 
			}else if(_type == 'fade-out-left'){
				_type = 'fade-out-right' 
			}else if(_type == 'fade-in-right'){
				_type = 'fade-in-left' 
			}else if(_type == 'fade-out-right'){
				_type = 'fade-out-left'
			}
		}
		
		switch(_type) {
			case 'fade-in':
				if(currSelector.START_VAL == '0%' || currSelector.START_VAL == '100%'){currSelector.START_VAL = '0'};
				if(currSelector.END_VAL == '0%' || currSelector.END_VAL == '100%'){currSelector.END_VAL = '1'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity: currSelector.START_VAL, visibility: 'hidden'}, 
						{opacity: currSelector.END_VAL, visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity: currSelector.START_VAL, visibility: 'hidden'}, 
						{opacity: currSelector.END_VAL, visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}					
					});
				}
			break;
			case 'fade-out':
				if(currSelector.START_VAL == '0%' || currSelector.START_VAL == '100%'){currSelector.START_VAL = '1'};
				if(currSelector.END_VAL == '0%' || currSelector.END_VAL == '100%'){currSelector.END_VAL = '0'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity: currSelector.START_VAL}, 
						{opacity: currSelector.END_VAL, 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity: currSelector.START_VAL}, 
						{opacity: currSelector.END_VAL, 
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-in-top':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{y:'-'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{y: currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{y:'-'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{y: currSelector.END_VAL, opacity: '1', visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-out-top':
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, opacity:'1'}, 
						{y:'-'+currSelector.END_VAL, opacity: '0', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, opacity:'1'}, 
						{y:'-'+currSelector.END_VAL, opacity: '0',  
						ease: currSelector.EASE, 
						delay: currSelector.DELAY,
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO, 
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-in-bottom':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{y:'+'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{y:currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{y:'+'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{y: currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-out-bottom':
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, opacity:'1'}, 
						{y:'+'+currSelector.END_VAL, opacity: '0', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, opacity:'1'}, 
						{y:'+'+currSelector.END_VAL, opacity: '0',  
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-in-left':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{x:'-'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{x: currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{x:'-'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{x: currSelector.END_VAL, opacity: '1', visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY,
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,  
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-out-left':
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{x: currSelector.START_VAL, opacity:'1'}, 
						{x:'-'+currSelector.END_VAL, opacity: '0', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{x: currSelector.START_VAL, opacity:'1'}, 
						{x:'-'+currSelector.END_VAL, opacity: '0',  
						ease: currSelector.EASE, 
						delay: currSelector.DELAY,
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO, 
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-in-right':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{x: '+'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{x: currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{x: '+'+currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{x: currSelector.END_VAL, opacity: '1', visibility: 'visible',
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'fade-out-right':
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
					{x: currSelector.START_VAL, opacity:'1'}, 
					{x:'+'+currSelector.END_VAL, opacity: '0', 
					ease: currSelector.EASE,
					},	
					currSelector.DELAY,					 
					currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{x: currSelector.START_VAL, opacity:'1'}, 
						{x:'+'+currSelector.END_VAL, opacity: '0',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'slide-x':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{x: currSelector.START_VAL, visibility: 'hidden'}, 
						{x: currSelector.END_VAL, visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{x: currSelector.START_VAL, visibility: 'hidden'}, 
						{x: currSelector.END_VAL, visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'slide-y':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, visibility: 'hidden'}, 
						{y: currSelector.END_VAL, visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,	
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{y: currSelector.START_VAL, visibility: 'hidden'}, 
						{y: currSelector.END_VAL, visibility: 'visible',
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'zoom-in':
				if(currSelector.START_VAL == '0%' || currSelector.START_VAL == '100%'){currSelector.START_VAL = '0'};
				if(currSelector.END_VAL == '0%' || currSelector.END_VAL == '100%'){currSelector.END_VAL = '1'};
				if(currSelector.STAGGER === true){		
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}					
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{scale: currSelector.START_VAL, opacity:'0', visibility: 'hidden' }, 
						{scale: currSelector.END_VAL, opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{scale: currSelector.START_VAL, opacity:'0', visibility: 'hidden'}, 
						{scale: currSelector.END_VAL, opacity: '1', visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
						
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'zoom-out':
				if(currSelector.START_VAL == '0%' || currSelector.START_VAL == '100%'){currSelector.START_VAL = '1'};
				if(currSelector.END_VAL == '0%' || currSelector.END_VAL == '100%'){currSelector.END_VAL = '0'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{scale: currSelector.START_VAL, opacity:'1'}, 
						{scale: currSelector.END_VAL, opacity: '0', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{scale: currSelector.START_VAL, opacity:'1'}, 
						{scale: currSelector.END_VAL, opacity: '0', 
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'margin-left':
				if(currSelector.START_VAL == '100%'){currSelector.START_VAL = '0'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerTo($(currSelector.EL), currSelector.DURATION, 
						{marginLeft: currSelector.START_VAL, 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.to($(currSelector.EL), currSelector.DURATION, 
						{marginLeft: currSelector.START_VAL,
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'move-right':
				if(currSelector.VAL == '100%'){currSelector.VAL = '0'};
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}
					TweenMax.staggerTo($(currSelector.EL), currSelector.DURATION, 
					{marginLeft: currSelector.START_VAL, 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.to($(currSelector.EL), currSelector.DURATION, 
						{marginLeft: currSelector.VAL,
						ease: currSelector.EASE,
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
							//console.log('onComplete...')
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							//console.log('onReverseComplete...')
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
			break;
			case 'next-blink':				
				TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
					{x:'-5px'}, 
					{x:currSelector.VAL,
					ease: Power1.easeInOut, 
					delay: currSelector.DELAY, 
					repeat: currSelector.REPEAT,
					yoyo: currSelector.YOYO,
					reversed: currSelector.REVERSED,
					onComplete: function(){
						
						//call onComplete only when reversed is false...
						if(!currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					},
					onReverseComplete: function(){
						
						//call onComplete only when reversed is true...
						if(currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					}
				});				
			break;
			case 'shake-x':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};				
				TweenMax.to($(currSelector.EL), currSelector.DURATION, 
					{x: currSelector.START_VAL,
					ease: currSelector.EASE, 
					delay: currSelector.DELAY, 
					repeat: currSelector.REPEAT,
					yoyo: currSelector.YOYO,
					reversed: currSelector.REVERSED,
					onComplete: function(){
						
						//call onComplete only when reversed is false...
						if(!currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					},
					onReverseComplete: function(){
						
						//call onComplete only when reversed is true...
						if(currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					}
				});
				
			break;
			case 'shake-y':
				if(currSelector.START_VAL == '0%'){currSelector.START_VAL = '100%'};
				if(currSelector.END_VAL == '100%'){currSelector.END_VAL = '0%'};				
				TweenMax.to($(currSelector.EL), currSelector.DURATION, 
					{y: currSelector.START_VAL,
					ease: currSelector.EASE, 
					delay: currSelector.DELAY, 
					repeat: currSelector.REPEAT,
					yoyo: currSelector.YOYO,
					reversed: currSelector.REVERSED,
					onComplete: function(){
						
						//call onComplete only when reversed is false...
						if(!currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					},
					onReverseComplete: function(){
						
						//call onComplete only when reversed is true...
						if(currSelector.REVERSED){
							if(currSelector.ON_COMPLETE){
								currSelector.ON_COMPLETE();
							}
						}
					}
				});
				
			break;
			default:
				if(currSelector.STAGGER === true){
					if(currSelector.DELAY =='0'){currSelector.DELAY = 0.5}		
					TweenMax.staggerFromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity:'0', visibility: 'hidden'}, 
						{opacity: '1', visibility: 'visible', 
						ease: currSelector.EASE,
						},	
						currSelector.DELAY,					 
						currSelector.ON_COMPLETE
					);
				}else{
					TweenMax.fromTo($(currSelector.EL), currSelector.DURATION, 
						{opacity:'0', visibility: 'hidden'}, 
						{opacity: '1', visibility: 'visible',
						ease: currSelector.EASE, 
						delay: currSelector.DELAY, 
						repeat: currSelector.REPEAT,
						yoyo: currSelector.YOYO,
						reversed: currSelector.REVERSED,
						onComplete: function(){
						
							//call onComplete only when reversed is false...
							if(!currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						},
						onReverseComplete: function(){
							
							//call onComplete only when reversed is true...
							if(currSelector.REVERSED){
								if(currSelector.ON_COMPLETE){
									currSelector.ON_COMPLETE();
								}
							}
						}
					});
				}
		} 
	}
	
}