function AppEvent() {
	var _this = this;
	_this.ON_SCREEN_LOADING = "screenLoading";
	_this.ON_SCREEN_LOADCOMPLETE = "screenLoadingCompleted";
	_this.ON_SCREEN_COMPLETE = "screenCompleted";
	_this.ON_NAVIGATIONXML_LOADING = "navigationLoading";
	_this.ON_NAVIGATIONXML_LOADCOMPLETE = "navigationLoadingCompleted";
	_this.ON_GLOBALXML_LOADING = "globalxmlLoading";
	_this.ON_GLOBALXML_LOADCOMPLETE = "globalxmlLoadingCompleted";
	_this.ON_SCREEN_RESIZE = "screenResize";
	_this.ON_CUSTOM_RESIZE = "customResize";
	_this.ON_SCREEN_UPDATE = "screenUpdated";
	_this.ON_SCORE_UPDATE = "scoreUpdated";
	_this.ON_SWIPER_NEXT = "swiperNext";
	_this.ON_SWIPER_BACK = "swiperBack";
	_this.ON_SWIPER_SLIDE_TO = "swiperSlideTo";
  	_this.ON_SCREEN_HTML_LOAD = "screenHtmlLoaded";
	_this.ON_TIME_UPDATE = "timeUpdate";
	_this.ON_TIME_COMPLETE = "timeComplete";
	_this.ON_TIMEOUT_CONTINUE_CLICKED = "timeoutContinueClicked";
	_this.ON_ASSESSMENT_QUE_SHOW_ANI_DONE = "assessmentQueShowAniDone";
	_this.ON_ASSESSMENT_NEXT_QUE = "assessmentNextQue";
	_this.ON_ASSESSMENT_BACK_QUE = "assessmentBackQue";
	_this.ON_NICE_SELECT_CLICK = "niceSelectClick";
	_this.ON_INITIAL_ANIM_COMPLETE = "initialAnimComplete";
	_this.ON_MODAL_HTML_LOAD = "modalHtmlLoaded";
	_this.ON_MODAL_LOADCOMPLETE = "modalLoadingCompleted";
	_this.ON_BG_VIDEO_ENDED = "bgVideEnded";
	_this.ON_EXTRA_INFO_MODAL_CLOSE = "extraInfoModalCLose";
	_this.blinkExitButton = blinkExitButton;
	_this.blinkNextButton = blinkNextButton;
	_this.removeBlinkNextButton = removeBlinkNextButton;
	_this.applyGbPopCloseEvent = applyGbPopCloseEvent;
	if (APP.systemDetectorObj.deviceType == 'desktop') {
		$('#app-body').on('mouseenter', 'a', function () {
			if ($(this).hasClass('disabled') || $(this).hasClass('locked') || $(this).parent().hasClass('disabled') || $(this).parent().hasClass('locked')) {
				$(this).removeClass('hover');
				return false
			}
			$(this).addClass('hover');
		});
		$('#app-body').on('mouseleave', 'a', function () {
			$(this).removeClass('hover');
		})
		
		$('#app-body').on('mouseenter', 'a .magnify-box', function () {			
			$(this).addClass('hover');
		});
		$('#app-body').on('mouseleave', 'a .magnify-box', function () {
			$(this).removeClass('hover');
		})
	}
	$(document).on('click', 'a', function (e) {		
		if ($(this).hasClass('locked') || $(this).parent().hasClass('disabled') || $(this).parent().hasClass('locked')) {					
			return false;
		}
		var soundName = $(this).data('sound-type') || 'clicked';		
		APP.commonFunObj.playSoundEffect({name: soundName});
		
	});
	//--check if network status
	function updateOnlineStatus(event) {
		var condition = navigator.onLine ? "online" : "offline";		
		if(condition == "offline"){
			if(APP.commonFunObj != null){
				if(APP.commonFunObj.isScorm()){	
					APP.commonFunObj.showNetworkFailPop();
				}
			}
		}		
	}	
	window.addEventListener('online',  updateOnlineStatus);
	window.addEventListener('offline', updateOnlineStatus);
	//--
	$(document).on(_this.ON_NAVIGATIONXML_LOADING, function (e) {
		
		APP.preloaderObj.show();
	});
	$(document).on(_this.ON_NAVIGATIONXML_LOADCOMPLETE, function (e) {
		       
		//APP.preloaderObj.hide();
		APP.globalXmlsObj.loadGlobalXML();		
	});
	$(document).on(_this.ON_GLOBALXML_LOADING, function (e) {
		
		APP.preloaderObj.show();
	});
	$(document).on(_this.ON_GLOBALXML_LOADCOMPLETE, function (e) {
		
		APP.preloaderObj.hide();
		applyLangWiseData();
		if(APP.langChanged){
			//--check bookmark
						
				//consider for single assessment
			if(APP.globalQuizObj.isAvalable){
				if (APP.configObj.assessment[APP.globalQuizObj.currentQuizId].noOfAttempts != 0 && APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataCurrentAttempt >= APP.configObj.assessment[APP.globalQuizObj.currentQuizId].noOfAttempts) {
					APP.commonFunObj.showAttemptEndPop();
					return false;
				}else{
					APP.courseDataObj.checkBookmark();
				}
			}else{
				APP.courseDataObj.checkBookmark();
			}						
		}else if(APP.userLanguageChanged){
			APP.navigationObj.loadNextScreen();
			APP.langChanged = false;
			APP.userLanguageChanged = false;			
		}else{
			//-- first time
			
			APP.dataComObj.start();	
      // Check for screenid parameter in querystring and load screen if found
  		var paramScreenID = APP.commonFunObj.getQueryStringParams().screenid;
  		//console.log(paramScreenID);
  		if (typeof(paramScreenID) != "undefined"){
  		  APP.navigationObj.loadScreenById(paramScreenID);  
  		}
		}	
		//--to preload bg images
		APP.courseDataObj.preloadScreenBgImgs();	
	});
	$(document).on(_this.ON_SCREEN_LOADING, function (e) {
		$('#play-overlay').addClass('hide');
		APP.prevView = APP.commonFunObj.getCurrentView();
		
		$(document).off(_this.ON_CUSTOM_RESIZE);
		$(document).off(_this.ON_SWIPER_NEXT);
		$(document).off(_this.ON_SWIPER_BACK);
		$(document).off(_this.ON_SWIPER_SLIDE_TO);
		$(document).off(_this.ON_NICE_SELECT_CLICK);
		$(document).off(_this.ON_INITIAL_ANIM_COMPLETE);
		$(document).off(_this.ON_BG_VIDEO_ENDED);

		$('#bg-video').addClass('hide');

		//APP.commonFunObj.removeBgMusic();
		APP.commonFunObj.removeBgMusic1();
		APP.commonFunObj.removeScreenAudio();
		
		removeBlinkNextButton();
		removeBlinkExitButton();
		APP.preloaderObj.show();
		APP.progressBarObj.revertHorizontalProgressBar();
		
		$('#screen-container').attr('class', 'screen-container').hide();
		$('#screen-container').find('.screen')
		.attr('data-refid', '')
		.attr('data-mid', '')
		.attr('data-tid', '')
		.attr('data-sid', '');
		
		$('.screen-counter').removeClass('black white');
		APP.courseBookmark=APP.navData.moduleId+"_"+APP.navData.topicId+"_"+APP.navData.screenId;	
		//-- custom for client
		var obj= APP.navData.currentScreenObj;
		var screenType = obj.screenType || '';
		if(screenType.toLowerCase() == 'assessmentscreen'){
			APP.courseBookmark=APP.navData.moduleId+"_"+APP.navData.topicId+"_"+(APP.navData.screenId - 1);
		}
		//console.log('APP.courseBookmark: '+APP.courseBookmark)
		updateAppLayout();
	});
	
	$(document).on(_this.ON_SCREEN_LOADCOMPLETE, function (e) {
		$(document).off(APP.eventObj.ON_EXTRA_INFO_MODAL_CLOSE);
		$("html, body").scrollTop(0);
		APP.prevView = APP.commonFunObj.getCurrentView();
		APP.preloaderObj.hide();
		
		var dyClass = 'md'+APP.navData.moduleId+'-sm'+APP.navData.topicId+'-pg'+APP.navData.screenId;
		//$('#global-bg').attr('data-refid', 'bg-'+dyClass);
		
		$('#screen-container').find('.screen')
		.attr('data-refid', dyClass)
		.attr('data-mid', APP.navData.moduleId)
		.attr('data-tid', APP.navData.topicId)
		.attr('data-sid', APP.navData.screenId);
		
		//--animation
		$('#screen-container').show();

		APP.commonFunObj.updateLearnerNameInScreen();

		var isComplete = APP.courseDataObj.isScreenComplete(APP.navData);
		
			var animObj = $('#screen-container').find('.screen').find('.anim');
			animObj.addClass('visibility-hidden');								
			//animate screen initial element	
			animObj.removeClass('visibility-hidden');			
			animObj.each(function(inx){
				let curr = $(this);
				let aniObj1 = APP.animationObj.generateAniObj(curr);
				
				if(inx >= animObj.length - 1){
					aniObj1.ON_COMPLETE = function(){
						$(document).trigger(_this.ON_INITIAL_ANIM_COMPLETE);
					}
				}
				APP.animationObj.animate(aniObj1);
			})
			
		//--if screen not mandatory complete the screen
		var currScreenMandatory = APP.navData.currentScreenObj.mandatory || "";
		if(currScreenMandatory == "false"){
			APP.courseDataObj.updateScreenCompletion('2');
		}else{
			APP.courseDataObj.updateScreenCompletion('1');
		}
		//--		
		APP.commonFunObj.updateScoreTxt();
		updateNavigationButtons();
		updateScreenTitle();
		updateScreenCounter();
		APP.dataComObj.updateUserData();
		APP.progressBarObj.update();
		//--
		var percentage = APP.courseDataObj.getCourseComPercentage();
		$('.static-progress').find('.progress-txt').html(percentage + '%');
		//--

		updateAppLayout();
		$(document).trigger(APP.eventObj.ON_SCREEN_UPDATE);
	});
	$(document).on(_this.ON_SCREEN_COMPLETE, function (e) {
		
		//APP.progressBarObj.updateHorizontalProgressBar();
		checkNextButton();	
		
		var obj= APP.navData.currentScreenObj;
		var screenType = obj.screenType || '';
		var isEndScreen = obj.isEndScreen || '';		
		var hideNext = obj.hideNext || '';
			
		//$('.btn-next').addClass('disabled');
		if(screenType.toLowerCase() != 'assessmentintroscreen' && screenType.toLowerCase() != 'assessmentscreen' && screenType.toLowerCase() != 'assessmentresultscreen' && hideNext != 'true' ){		
			blinkNextButton();
		}
		if(isEndScreen == 'true'){
			APP.eventObj.blinkExitButton();
		}
		APP.progressBarObj.update();
		//--
		var percentage = APP.courseDataObj.getCourseComPercentage();
		$('.static-progress').find('.progress-txt').html(percentage + '%');
		//--
	});
	
	$(window).on('resize', function () {
		$(document).trigger(_this.ON_SCREEN_RESIZE);
	});
	$(window).on("orientationchange", function () {
		$("html, body").scrollTop(0);
		$(document).trigger(_this.ON_SCREEN_RESIZE);
	});
	$(document).on(_this.ON_SCREEN_RESIZE, function (e) {
		//checkMobileNav();
		updateAppLayout();		
		updateScreenCounter();
		$(document).trigger(_this.ON_CUSTOM_RESIZE);
	});
	$(document).on(_this.ON_SCREEN_UPDATE, function (e) {
		
	});
	$(document).on('click','.home-btn', function (e) {
		APP.navigationObj.loadMainMenuScreen();		
	});
	$(document).on('click','.menu-btn', function (e) {
		APP.sideNavMenu = new SideNavMenu();
		APP.sideNavMenu.start();	
	});
	$(document).on('click','.exit-btn', function (e) {
		APP.commonFunObj.showExitPop();
	});
	$(document).on('click','.resources-btn', function (e) {
		APP.commonFunObj.showResourcesPop();
	});
	$(document).on('click','.gamification-btn', function (e) {
		APP.commonFunObj.showGamificationPop();
	});
	$(document).on('click','.glossary-btn', function (e) {
		APP.commonFunObj.showGlossaryPop();
	});
	$(document).on('click','.help-btn', function (e) {
		APP.commonFunObj.showHelpPop();
	});
		
	$(document).on('click','.btn-back', function (e) {
		if($(this).hasClass('disabled')){return false;}
		//--bind in coverflow_screenjs
		if($(this).hasClass('swiper-back-gb')){
			$(document).trigger(APP.eventObj.ON_SWIPER_BACK);
		}else if($(this).hasClass('assessment-back-que')){
			$(document).trigger(APP.eventObj.ON_ASSESSMENT_BACK_QUE);
		}else{
			APP.navigationObj.loadBackScreen();
		}
	});
	$(document).on('click','.btn-next', function (e) {
		if($(this).hasClass('disabled')){return false;}
		//--bind in coverflow_screenjs
		if($(this).hasClass('swiper-next-gb')){
			$(document).trigger(APP.eventObj.ON_SWIPER_NEXT);
		}else if($(this).hasClass('assessment-next-que')){
			$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
		}else{
			APP.navigationObj.loadNextScreen();
		}
	});
	$(document).on('click','.gb-pdf-btn', function (e) {
		if($(this).hasClass('disabled')){return false;}
		var pdfPath = APP.globalXmlsObj.globalXML.navBtnText[0].pdfBtnTxt[0].pdfPath;
		var _path= APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + pdfPath;
		var pdfWin = window.open(_path, "_blank");
		pdfWin.focus();
	});
	$(document).on('click', '.audio-btn', function (e) {
		if ($(this).hasClass('disabled')) { return false; }
		if ($(this).hasClass('on')) {
			//make audio off
			$(this).removeClass('on').addClass('off');
			$(this).find('.btn-icon').removeClass('icon-audio-on').addClass('icon-audio-off');
			//for audio
			if(Howler){Howler.mute(true);}
			APP.isScreenAudioPlay=false;
			if(APP.screenAudio){
				APP.screenAudio.pause();
				
			}
			//for video
			$("video").prop('muted', true);
		} else {
			//make audio on
			$(this).removeClass('off').addClass('on');
			$(this).find('.btn-icon').removeClass('icon-audio-off').addClass('icon-audio-on');
			//for audio
			if(Howler){Howler.mute(false);}
			APP.isScreenAudioPlay=true;
			if(APP.screenAudio){
				APP.screenAudio.play();
				
			}
			//for video
			$("video").prop('muted', false);
		}
	});
	$(document).on('click', '.tutorials-btn', function (e) {
		if ($(this).hasClass('disabled')) { return false; }
		APP.commonFunObj.showTutorialPop();
	});
	
	$(document).on('click','.debug-go-btn', function (e) {
		var val = $('#debug-screen-input').val().trim();
		if(val != null && val!= ''){
			//--for next and back screen
			if(val == '>'){
				APP.navigationObj.loadNextScreen();
			}else if(val=='<'){
				APP.navigationObj.loadBackScreen();
			}if(val=='/'){
				APP.navigationObj.loadScreen();
			}else{
				APP.navigationObj.loadScreenById(val);
				//$('#debug-screen-input').val('');
			}
			
		}
	});
	$('#debug-screen-input').on('keypress', function (e) {
		var key = e.which;
		if(key == 13)  // the enter key code
		 {
		   $('.debug-go-btn').trigger('click');
		   return false;  
		 }
   });
   $(document).on('click','.gb-magnify-btn', function(e){	
		e.stopPropagation();
		APP.commonFunObj.playSoundEffect({name: 'clicked'});
		$(this).removeClass('hover');					
		var currPop = $(this).next('.gb-magnify-pop');
		//APP.commonFunObj.removeScreenAudio();
		//for animation				
		var aniObj = APP.animationObj.generateAniObj($(currPop));
		aniObj.ON_COMPLETE = function(){
			
		};		
		var isModalPop = currPop.hasClass('screen-modal-pop');
		if(isModalPop){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currPop.clone(true)
			.appendTo("#main-div")
			.fadeIn()
				
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
			}	
			APP.animationObj.animate(aniObj);	
			//--for popup el animation 
			var aniEl = $(aniObj.EL).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--			
		}else{			
			currPop.show();
			if($('body').hasClass('responsive')){	
				//--check only when responsive 		
				isInView = APP.commonFunObj.isElementInView($(currPop));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
				}	
				
			}
			APP.animationObj.animate(aniObj);
			//--for popup el animation
			var aniEl = $(currPop).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--				
		}
		applyGbPopCloseEvent();		
	});
	$(document).on('click','.gb-extra-info-btn', function(e){	
		e.stopPropagation();
		APP.commonFunObj.playSoundEffect({name: 'clicked'});
		$(this).removeClass('hover');					
		var currPop = $(this).next('.gb-extra-info-pop');
		
		var _ref = $(this).data('pop-ref');
		if(_ref != null && _ref!= ''){
			currPop = $(this).parents('.screen').find('.'+_ref);
		}					
		
		if(currPop.length == 0 ){return false;}

		APP.commonFunObj.removeScreenAudio();
		//for animation				
		var aniObj = APP.animationObj.generateAniObj($(currPop));
		aniObj.ON_COMPLETE = function(){
			$(currPop).find('.scroll-parent').scrollTop(0);
		};		
		var isModalPop = currPop.hasClass('screen-modal-pop');
		if(isModalPop){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currPop.clone(true)
			.appendTo("#main-div")
			.fadeIn()
				
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
			}	
			APP.animationObj.animate(aniObj);
			if(aniObj.EL.find('.tab-activity').length){
				
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',	
					TYPE: 'split-with-pop',		
					ACTIVITY_CONTAINER: aniObj.EL.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
						
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}
			if(aniObj.EL.find('.accordion-activity').length){
				
				var tabTemplate = new AccordionScreen();
				tabTemplate.start({
					CLASS_NAME: 'accordion-screen',	
					ACTIVITY_CONTAINER: aniObj.EL.find('.accordion-activity'),						
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
						
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}

			//--for popup el animation 
			var aniEl = $(aniObj.EL).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--			
		}else{			
			currPop.show();
			if(currPop.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currPop.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}
			if(currPop.find('.accordion-activity').length){
				
				var tabTemplate = new AccordionScreen();
				tabTemplate.start({
					CLASS_NAME: 'accordion-screen',	
					ACTIVITY_CONTAINER: currPop.find('.accordion-activity'),						
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
						
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currPop));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
				}
			}
			APP.animationObj.animate(aniObj);	
			//--for popup el animation
			var aniEl = $(currPop).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--			
		}
		applyGbPopCloseEvent();		
	});
	$(document).on('click','.play-overlay-btn, .play-overlay', function (e) {
		$('#play-overlay').addClass('hide');
		/* try{
			if($('#bg-video').find('#mp4_src').attr('src') != null && $('#bg-video').find('#mp4_src').attr('src') != ''){
				$('#bg-video').get(0).play();
			}
		}catch(e){
			
		} */
		try{
			if(APP.vidPlayer){
				APP.vidPlayer.currentTime = 0;						
				APP.vidPlayer.play();
			}
		}catch(e){
				
		}
	});
	_this.sideNavMenuStatus = function(_str){
		APP.isSideNavMenuOpen = _str;
		if(APP.isSideNavMenuOpen){
			
		}else{
			
		}
	}
	_this.updateOnlineStatus = function () {
		updateOnlineStatus();
	}
	_this.applyBgVideoEvent= function() {		
		var currVidObj = $('#bg-video').get(0);
		$(currVidObj).off();
		$(currVidObj).on('loadstart', function(e){			
			//APP.preloaderObj.show();
			$('#debug-text').val( $('#debug-text').val() + "\nloadstart...");
			
		})
	
		$(currVidObj).on('canplay', function(e){				
			$('#debug-text').val( $('#debug-text').val() + "\ncanplay...");
		}) 
		
		$(currVidObj).on('canplaythrough', function(e){			
			$('#debug-text').val( $('#debug-text').val() + "\ncanplaythrough "+ e.target.readyState);
			if(e.target.readyState >= 3){				
				//APP.preloaderObj.hide();				
			}
		});
		$(currVidObj).on('error', function(e){			
			$('#debug-text').val( $('#debug-text').val() + "\nerror...");
			
		});
		$(currVidObj).on('waiting', function(e){			
			$('#debug-text').val( $('#debug-text').val() + "\nwaiting...");
			
		});

		$(currVidObj).on('pause', function(e){
			$('#debug-text').val( $('#debug-text').val() + "\npause...");
			
		});
		$(currVidObj).on('play', function(e){			
			$('#debug-text').val( $('#debug-text').val() + "\nplaying...");
		});
		$(currVidObj).on('timeupdate', function(e){			
			//prevent event for blank video
			if(isBlankVid){return false;}
			
			var currTime =$(this).get(0).currentTime;
			$('#debug-screener').find('.vid-time-txt').html(currTime.toFixed(2));
			
		});
		$(currVidObj).on('ended', function(e){
			$(document).trigger(_this.ON_BG_VIDEO_ENDED);	
		});
	}
	function applyGbPopCloseEvent(){
		$('#main-div > .screen-modal-pop').find('.close-popup-btn').off('click');
		$(document).on('click', '#main-div > .screen-modal-pop .close-popup-btn, #main-div .gb-extra-info-pop .close-popup-btn', function (e) {	
		//$('#main-div > .screen-modal-pop').find('.close-popup-btn').one('click', function () {
			
			if ($(this).hasClass('disabled')) { return false; };
			var _this = $(this);
			var popObj = $(this).parents('.popup');
			isModalPop = popObj.hasClass('screen-modal-pop');
			APP.commonFunObj.removeSoundEffect();
			//APP.commonFunObj.removeScreenAudio();
			var aniObj1 = APP.animationObj.generateAniObj($(popObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
					$(document).trigger(APP.eventObj.ON_EXTRA_INFO_MODAL_CLOSE);
				}
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(popObj).hide();				
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
					$(document).trigger(APP.eventObj.ON_EXTRA_INFO_MODAL_CLOSE);
				}
				APP.animationObj.animate(aniObj1);
			}
			
		});
	}
	function applyLangWiseData(){
		document.title = APP.commonFunObj.getIndexCourseTitle();
		//--multi lang
		$('html').attr('lang', APP.configObj.language.lang);
		$('html').attr('dir', APP.configObj.language.dir);
		//--
		$('body').attr('class','');
		var brNameVerClass=APP.systemDetectorObj.browserName+"_"+parseInt(APP.systemDetectorObj.browserVersion);
		$('body').addClass(APP.systemDetectorObj.browserName)
		.addClass(APP.systemDetectorObj.deviceType)
		.addClass(brNameVerClass)
		.addClass(APP.configObj.language.lang)
		.addClass(APP.configObj.language.dir);
		$('#footer').find('.intro-band').find('.title-txt').html(APP.commonFunObj.getProjectTitle());
		$('#footer').find('.regular-band').find('.title-txt').html(APP.commonFunObj.getProjectTitle());
		if(APP.globalXmlsObj.globalXML.navBtnText){
			var txtObj = APP.globalXmlsObj.globalXML.navBtnText[0];			
			if(txtObj.menuTxt) $('.menu-btn').find('.btn-txt').html(txtObj.menuTxt[0].Text);			
			if(txtObj.homeTxt) $('.home-btn').find('.btn-txt').html(txtObj.homeTxt[0].Text);	
			if(txtObj.resourcesTxt) $('.resources-btn').find('.btn-txt').html(txtObj.resourcesTxt[0].Text);			
			if(txtObj.progressTxt) $('.progress-cell').find('.btn-txt').html(txtObj.progressTxt[0].Text);		
			if(txtObj.helpTxt) $('.help-btn').find('.btn-txt').html(txtObj.helpTxt[0].Text);	
			if(txtObj.exitTxt) $('.exit-btn').find('.btn-txt').html(txtObj.exitTxt[0].Text);		
			if(txtObj.glossaryTxt) $('.glossary-btn').find('.btn-txt').html(txtObj.glossaryTxt[0].Text);
			if(txtObj.nextTxt) $('.btn-next').find('.btn-txt').html(txtObj.nextTxt[0].Text);
			if(txtObj.backTxt) $('.btn-back').find('.btn-txt').html(txtObj.backTxt[0].Text);

			if(txtObj.pdfBtnTxt) $('.gb-pdf-btn').find('.btn-txt').html(txtObj.pdfBtnTxt[0].Text);
			if(txtObj.audioTxt) $('.audio-btn').find('.btn-txt').html(txtObj.audioTxt[0].Text);
			if(txtObj.transTxt) $('.transcript-btn').find('.btn-txt').html(txtObj.transTxt[0].Text);
			if(txtObj.gamificationTxt) $('.gamification-btn').find('.btn-txt').html(txtObj.gamificationTxt[0].Text);
      if(txtObj.progressTxt) $('.circle-progress-bar').find('.t-txt').html(txtObj.progressTxt[0].Text);
			if(txtObj.scoreTxt) $('.static-score-div').find('.btn-txt').html(txtObj.scoreTxt[0].Text);
			//--hover text
			if(txtObj.homeTxt) $('.home-btn').attr('title', txtObj.homeTxt[0].Text);	
			if(txtObj.menuTxt) $('.menu-btn').attr('title', txtObj.menuTxt[0].Text);	
			if(txtObj.resourcesTxt) $('.resources-btn').attr('title', txtObj.resourcesTxt[0].Text);				
			if(txtObj.helpTxt) $('.help-btn').attr('title', txtObj.helpTxt[0].Text);		
			if(txtObj.exitTxt) $('.exit-btn').attr('title', txtObj.exitTxt[0].Text);	
			if(txtObj.glossaryTxt) $('.glossary-btn').attr('title', txtObj.glossaryTxt[0].Text);
			if(txtObj.nextTxt) $('.btn-next').attr('title', txtObj.nextTxt[0].Text);
			if(txtObj.backTxt) $('.btn-back').attr('title', txtObj.backTxt[0].Text);
     	if(txtObj.progressTxt) $('.circle-progress-bar').attr('title', txtObj.progressTxt[0].Text);
			if(txtObj.progressTxt) $('.static-progress').attr('title', txtObj.progressTxt[0].Text);
			if(txtObj.pdfBtnTxt) $('.gb-pdf-btn').attr('title', txtObj.pdfBtnTxt[0].Text);	
			if(txtObj.audioTxt) $('.audio-btn').attr('title', txtObj.audioTxt[0].Text);	
			if(txtObj.gamificationTxt) $('.gamification-btn').attr('title', txtObj.gamificationTxt[0].Text);	
		}
				
	}
	_this.disabledNavButton = function(){
		//$('.menu-btn').addClass('disabled');
		//$('.home-btn').addClass('disabled');
		
		$('.btn-back').addClass('disabled');
		$('.btn-next').addClass('disabled');
	}
	_this.enabledNavButton = function(){
		//$('.menu-btn').removeClass('disabled');
		//$('.home-btn').removeClass('disabled');
		
		$('.btn-back').removeClass('disabled');
		$('.btn-next').removeClass('disabled');
	}
	function updateNavigationButtons() {		
		var winWd = window.innerWidth;
		var obj = APP.navData.currentScreenObj;
		var moduleType = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].moduleType || '';
		var screenType = obj.screenType || '';
		var hideBack = obj.hideBack || '';

		$('#main-div').removeClass('ani-slide');
		$('.content-master').removeClass('full-height');
		$('#nav-btn-panel').addClass('hide');
		$('#side-navigation').addClass('hide');

		$('.menu-btn').removeClass('disabled hide visibility-hidden')
		$('.home-btn').removeClass('disabled hide visibility-hidden');
		
		$('.btn-back').removeClass('swiper-back-gb assessment-back-que disabled');
		$('.btn-next').removeClass('swiper-next-gb assessment-next-que');
		showHideFooter('show');		
		
		var screenType = obj.screenType || '';
		var isMissionActivity = obj.isMissionActivity || 'false';
		
		if(screenType.toLowerCase() == 'splashscreen' || screenType.toLowerCase() == 'welcomescreen'){		
			$('.content-master').addClass('full-height');	
			$('.header').addClass('hide');					
			$('.mobile-titlebar').addClass('hide');	
			$('#footer').addClass('hide');				
		}else{
			$('.content-master').removeClass('full-height');
			showHideHeader('show');		
			$('.mobile-titlebar').removeClass('hide');	
			//$('#footer').find('.intro-band').addClass('hide');					
			//$('#footer').find('.regular-band').removeClass('hide');	
			$('#footer').find('.regular-band').find('.splitter').removeClass('hide');	
			$('#footer').find('.regular-band').find('.title-txt').removeClass('hide');	
		}
		
		if(screenType.toLowerCase() == 'menuscreen'){
			$('.menu-btn').removeClass('disabled');
			$('.home-btn').addClass('disabled');
		}

		if (APP.navData.moduleId == 0) {
			$('#nav-btn-panel').addClass('hide');
			$('#side-navigation').addClass('hide');
			$('.menu-btn').addClass('disabled');
			$('.home-btn').addClass('disabled');
			if(screenType.toLowerCase() == 'menuscreen'){
				$('.menu-btn').removeClass('disabled');
			}
		} else if (APP.navData.screenId == 0) {
			$('#nav-btn-panel').removeClass('hide');
			$('#side-navigation').removeClass('hide');
			//$('.btn-back').addClass('disabled');			
			//$('.btn-back').hide();
			//$('.btn-back').addClass('visibility-hidden');
			$('.btn-back').removeClass('visibility-hidden');
		} else {
			$('#nav-btn-panel').removeClass('hide');
			$('#side-navigation').removeClass('hide');
			//$('.btn-back').removeClass('disabled');
			//$('.btn-back').show();
			$('.btn-back').removeClass('visibility-hidden');
		}
		
		if(screenType.toLowerCase() == 'assessmentscreen'){
			$('.btn-back').addClass('disabled');
		}
		if(screenType.toLowerCase() == 'assessmentresultscreen'){
			$('.btn-back').addClass('disabled');			
		}
							
		//checkMobileNav();
		checkNextButton();
		checkBackButton();
	}
	function checkMobileNav(){
		//--to show next back button bottom on mobile
		if(APP.navData.moduleId != 0){	
			var currentView = APP.commonFunObj.getCurrentView();
			if(currentView == 'mobile'){
				$('#nav-btn-panel').addClass('hide');	
				var t = $('.bottom-navigation').clone();
				var prevNav = $('.screen .screen-panel .bottom-navigation')
				if(prevNav.length == 0){
					$('.screen .screen-panel').append(t);
				}else{
					prevNav.show();
				}			
			}else{
				$('#nav-btn-panel').removeClass('hide');	
			}
		}
	}
	function checkBackButton(){
		if(APP.globalXmlsObj.navigationXML == null){return false;}
		var obj=APP.navData.currentScreenObj;
		var hideBack = obj.hideBack || '';
		if(hideBack == 'true'){				
			$('.btn-back').addClass('disabled visibility-hidden');
		}
	}
	function checkNextButton(){
		if(APP.globalXmlsObj.navigationXML == null){return false;}
		var obj=APP.navData.currentScreenObj;
		var screenType = obj.screenType || '';
		var isEndScreen = obj.isEndScreen || '';
		var hideNext = obj.hideNext || '';
		var totScreens = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length - 1;
		if(APP.navData.moduleId == 0){
			$('.btn-next').addClass('visibility-hidden');
		}else {
			//$('.btn-next').removeClass('disabled');
			//$('.btn-next').show();
			$('.btn-next').removeClass('visibility-hidden');
			var currScreenMandatory=APP.navData.currentScreenObj.mandatory || "";
			var isComplete=APP.courseDataObj.isScreenComplete();
			var isLinearNavigation = APP.configObj.screenWise.linearNavigation;
			if(currScreenMandatory == "true" && !isComplete && isLinearNavigation){
				//$('.btn-next').hide();
				$('.btn-next').addClass('disabled');
			}
			var cheatMode = APP.configObj.cheatMode;
			if(cheatMode === true){
				//$('.btn-next').hide();
				$('.btn-next').removeClass('disabled');
			}
			if(screenType.toLowerCase() == 'assessmentintroscreen' || screenType.toLowerCase() == 'assessmentscreen' || screenType.toLowerCase() == 'assessmentresultscreen'){				
				$('.btn-next').addClass('disabled');
			}
			if(isEndScreen == 'true'){				
				$('.btn-next').addClass('disabled');
			}
			if(hideNext == 'true'){				
				$('.btn-next').addClass('disabled visibility-hidden');
			}
			//for review mode
			if(APP.inlineQuizObj.revMod == 'on'){
				$('.btn-next').addClass('disabled');		
			} 
		}
	}
	function blinkNextButton(){
		if($('.btn-next').length){
			$('.btn-next').removeClass('disabled');
			if(!($('.btn-next').hasClass('visibility-hidden'))){			
				$('.btn-next').find('.btn-icon').addClass('blinkNext');		
			}			
		}
	}
	function removeBlinkNextButton(){
		if($('.btn-next').length){
			//for better support in IE used css animation
			$('.btn-next').find('.btn-icon').removeClass('blinkNext');
		}
	}
	function blinkExitButton(){
		if($('.exit-btn').length){		
			$('.exit-btn').addClass('blink animated pulse infinite');	
		}
	}
	function removeBlinkExitButton(){
		if($('.exit-btn.blink').length){			
			$('.exit-btn').removeClass('blink animated pulse infinite');		
		}
	}
	function showHideNavPanel(str){
		var el = $('#footer').find('.nav-btn-panel');
		if(str === 'show'){			
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-in-bottom',
				START_VAL: '30px',
				END_VAL: '0px',
				DURATION: 1,
				EASE: 'Power0.easeIn',
			}); 
		}else{
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-out-bottom',
				START_VAL: '0px',
				END_VAL: '30px',
				DURATION: 1,
				EASE: 'Power0.easeIn',
			}); 
		}
	}
	function showHideHeader(str){
		var el = $('.header');		
		if(str === 'show'){	
			$(el).removeClass('hide');
			if($(el).hasClass('animated')){return false;}
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-in-top',
				START_VAL: '100%',
				END_VAL: '0%',
				DURATION: 0.3,
				EASE: 'Power1.easeOut',
				ON_COMPLETE: function(){
					$(el).addClass('animated');
				}
			});
		}else{				
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-out-top',
				START_VAL: '0%',
				END_VAL: '100%',
				DURATION: 0.3,
				EASE: 'Power1.easeOut',
				ON_COMPLETE: function(){
					$(el).addClass('hide').removeClass('animated');
				}
				
			});			
		}
	}
	function showHideFooter(str){		
		var el = $('#footer');		
		if(str === 'show'){	
			$(el).removeClass('hide');
			if($(el).hasClass('animated')){return false;}		
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-in-bottom',
				DURATION: 0.3,
				EASE: 'Power1.easeOut',
				ON_COMPLETE: function(){
					$(el).addClass('animated');
				}
			}); 
		}else{
			APP.animationObj.animate({
				EL: el,
				TYPE: 'fade-out-bottom',
				DURATION: 0.3,
				EASE: 'Power1.easeOut',
				ON_COMPLETE: function(){
					$(el).addClass('hide').removeClass('animated');
				}
			});
			
		}
			
	}
	function updateScreenTitle(){		
		var projectTitle = APP.commonFunObj.getProjectTitle();
		var courseTitle = APP.commonFunObj.getCourseTitle();
		var moduleTitle = APP.commonFunObj.getModuleTitle();
		var topicTitle = APP.commonFunObj.getTopicTitle();
		var screenTitle = APP.commonFunObj.getScreenTitle();
		if(APP.navData.moduleId <= 0){
			APP.commonFunObj.updateHeaderTitle(screenTitle);
		}else{
			/* var str = '';
			str += '<span class="module-txt">'+moduleTitle+'</span>';
			str += '<span class="splitter"> | </span>';
			str += '<span class="topic-txt">'+topicTitle+'</span>';			 */
			APP.commonFunObj.updateHeaderTitle(moduleTitle);
		}

	}
	function updateScreenCounter(){
		if(APP.globalXmlsObj.navigationXML == null){return false;}	
		var moduleType = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].moduleType || '';
		if(moduleType == 'intro'){
			$('.screen-counter').find('.txt').html('');
			return false;
		}
		var str ="";
		//--topic wise counter
		/* var totScreens = (APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length);
		var currScreen = APP.navData.screenId + 1; */
		//--total course counter
		var totScreens = APP.navigationObj.getCourseTotScreenCount() || 0;
		var t = APP.navData.currentScreenObj.relScreenIndex || 0;
		var currScreen = t + 1;	

		var newTot = totScreens < 10 ? (''+totScreens) : totScreens;
		var newCurr = currScreen < 10 ? (''+currScreen) : currScreen;
		var splitter = APP.globalXmlsObj.globalXML.commonText[0].screenCounterSplitter[0].Text || ' / '
		str = newCurr +' '+splitter+' '+ newTot;	
		
		$('.screen-counter').find('.txt').html(str);
	}
	
	function updateAppLayout() {
		APP.commonFunObj.scaleContents();	
		if(APP.globalXmlsObj.globalXML == null || APP.globalXmlsObj.globalXML == ''){return false }

		if(document.body._gsTransform){
			APP.scalex = document.body._gsTransform.scaleX;
		}
		//--reload screen as difficult to maintain 2 view
		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView == 'mobile'){
			APP.scalex = 1;
		}		
		if(APP.prevView != currentView){
			//-- prevent to close global popup
			if(APP.globalModalObj){
				var currClass = APP.globalModalObj.getClassName();
				if(currClass == 'bookmark-pop' || currClass == 'api-fail-pop'){
					return false;
				}				
			}
			//--for responsive
			$('body').removeClass('modal-open');
			$('#alpha-bg').hide();
			//--			
			//close modal pop
			if(APP.globalModalObj){
				var currClass = APP.globalModalObj.getClassName();
				//APP.globalModalObj.closeModal();				
				APP.globalMessageOpen = false;				
				$('#global-modal-pop').attr('class', 'global-modal-pop');
				$('#global-modal-pop').attr('style', '');
				$('#global-modal-pop').html('');
				APP.globalModalObj = null;
							
			}
			//open screen level modal pop
			if($('.main-div > .screen-modal-pop').length){
				//$('.main-div > .screen-modal-pop').find('.close-popup-btn').trigger('click');
				$('.main-div > .screen-modal-pop').remove();				
			}	
			APP.navigationObj.loadScreen({transition: 'fadeIn'});
			APP.prevView = currentView;
			return false;
		}
		APP.commonFunObj.scaleContents();
		APP.commonFunObj.checkScreenSizePop();		

		var winWd = window.innerWidth;
		var winHt = window.innerHeight;

		var headerEl = $('.header');
		var appBodyEl = $('.app-body');		
		var mainDivEl = $('.main-div');
		var tsDivEl = $('#gb-transcript-div');
		var conMasterEl = $('.content-master');
		var scContnrEl = $('.screen-container');
		var scrnEl = $('.screen');
		var scrnPanelEl = $('.screen-panel');
		var scrnBgEl = $('.screen-background');
		var scrnDataEL = $('.screen-data');
		var scrBottomNavEl = $('.screen').find('.bottom-navigation');
		var bgVidEL = $('#bg-video');
		var avlHt = winHt;
		
		if(currentView == 'mobile'){
			APP.scalex = 1;
			if(headerEl.length){
				avlHt = winHt - headerEl.outerHeight(true, true);
				if(bgVidEL.length){
					bgVidEL.css('padding-top', headerEl.outerHeight(true, true)+'px');
				}
				if(conMasterEl.length){
					conMasterEl.css('padding-top', headerEl.outerHeight(true, true)+'px');
				}
			}
			if (appBodyEl.length) appBodyEl.css('min-height', avlHt);
			if (mainDivEl.length) mainDivEl.css('min-height', avlHt);
			if (conMasterEl.length) conMasterEl.css('min-height', avlHt);
			if (scContnrEl.length) scContnrEl.css('min-height', avlHt);
			if (scrnEl.length) scrnEl.css('min-height', avlHt);
			if (scrnPanelEl.length) scrnPanelEl.css('min-height', avlHt);
			if (scrnBgEl.length) scrnBgEl.css('min-height', avlHt);
			//--to set bottom nav screen bottom
			if(scrBottomNavEl.length){
				avlHt -= scrBottomNavEl.outerHeight(true);				
			}
			//custom for this course
			if($('.screen-panel > .title-box').length){
				avlHt -= $('.screen-panel > .title-box').outerHeight(true);	
			}
			if($('.screen-panel > .top-div').length){
				avlHt -= $('.screen-panel > .top-div').outerHeight(true);	
			}
			
			if (scrnDataEL.length) scrnDataEL.css('min-height', avlHt);
		}else{
			//if (tsDivEl.length) tsDivEl.css('padding-top', '0px');
			if (conMasterEl.length) conMasterEl.css('padding-top', '0px');
			if (appBodyEl.length) appBodyEl.css('min-height', 'auto');
			if (mainDivEl.length) mainDivEl.css('min-height', 'auto');
			if (conMasterEl.length) conMasterEl.css('min-height', 'auto');
			if (scContnrEl.length) scContnrEl.css('min-height', 'auto');
			if (scrnEl.length) scrnEl.css('min-height', 'auto');
			if (scrnPanelEl.length) scrnPanelEl.css('min-height', 'auto');
			if (scrnBgEl.length) scrnBgEl.css('min-height', '100%');
			if (scrnDataEL.length) scrnDataEL.css('min-height', 'auto');
			if(bgVidEL.length){
				bgVidEL.css('padding-top','0px');
			}
		}
		APP.commonFunObj.updateScreenModalPopLayout();
	}
	
	
}