
function DataCompliance(){
	/**Variables*/
	var _this=this;
	var Selector = {};
	
	var lmsConnected=false;
	var scormApi;
	var bookmark;
	var suspendData="";
	var lessonStatus="incomplete";
	var lmsScore = "";
	var scoreRaw="";
	var scoreMin=0;
	var scoreMax=100;
	var lang;
	var successStatus = "unknown";	
	var entryState="";
	var lessonMode=""; 
	var studentName="[Learner Name]";
	
	_this.start = function (_obj) {
		Selector={
			BOOKMARK : "cmi.core.lesson_location",
			LESSONSTATUS : "cmi.core.lesson_status",
			SUSPENDDATA : "cmi.suspend_data",
			ENTRYSTATE : "cmi.core.entry",
			LESSON_MODE : "cmi.core.lesson_mode",
			SESSIONTIME : "cmi.core.session_time",
			SCORE : "cmi.core.score.raw",
			STUDENT_NAME:"cmi.core.student_name",	
			SCORE_MAX:"cmi.core.score.max",
			SCORE_MIN:"cmi.core.score.min",
			EXIT:"cmi.core.exit",
			PREFER_LANG:"cmi.student_preference.language",
			USER_RESPONCE:".student_response",
			TIME:".time"
			
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	
	
	//---
	function initTemplate(){
	
	/**complianceType
		 *  0: STANDALONE/No tracking
		 *  1: SCORM1.2
		 *  2: SCORM2004
		 */
		scormApi = pipwerks.SCORM;
		scormApi.version="1.2";
		if(APP.configObj.tracking.complianceType == "2"){
			scormApi.version="2004";
			Selector.BOOKMARK = "cmi.location";
			Selector.LESSONSTATUS = "cmi.completion_status";
			Selector.SUSPENDDATA = "cmi.suspend_data";
			Selector.ENTRYSTATE = "cmi.entry";
			Selector.LESSON_MODE = "cmi.mode";
			Selector.SESSIONTIME = "cmi.session_time";
			Selector.SCORE="cmi.score.raw";
			Selector.STUDENT_NAME="cmi.learner_name";
			Selector.SCORE_MAX="cmi.score.max";
			Selector.SCORE_MIN="cmi.score.min";	
			Selector.EXIT="cmi.exit";	
			Selector.PREFER_LANG="cmi.learner_preference.language";
			Selector.SCORE_SCALED="cmi.score.scaled";
			Selector.SUCCESS_STATUS="cmi.success_status";
			Selector.USER_RESPONCE=".learner_response";
			Selector.TIME=".timestamp";
		}
		if(APP.configObj.tracking.complianceType=="0"){
			lmsConnected=false;
		}else{
			lmsConnected = scormApi.init();
		}
		if (lmsConnected) {
			getLMSData();
			
		} else {			
			startCourse();
		}		
	}
	
	_this.getStudentName=function(){
		return studentName;
	}
	_this.getLangObj=function(){
		return lang;
	}
	_this.getSuspendData=function(){
		return suspendData;
	}
	_this.getLessonStatus = function(){
		return lessonStatus;
	}
	_this.getBookMark=function(){
		return bookmark;
	}
	_this.setBookMark=function(val){		
		bookmark = val;		
	}
	
	function getLMSData(){
		var lang=scormApi.get(Selector.PREFER_LANG);
		
		entryState = scormApi.get(Selector.ENTRYSTATE);
		lessonMode = scormApi.get(Selector.LESSON_MODE);
		suspendData = scormApi.get(Selector.SUSPENDDATA);
		
		bookmark = scormApi.get(Selector.BOOKMARK);			
		
		lessonStatus=scormApi.get(Selector.LESSONSTATUS);
		if(APP.configObj.tracking.complianceType == "2"){
			successStatus=	scormApi.get(Selector.SUCCESS_STATUS);
		}
		//scoreRaw = scormApi.get(Selector.SCORE);
		//lmsScore = scoreRaw;
		
		studentName = scormApi.get(Selector.STUDENT_NAME);
		
		if(studentName != null && studentName.toString() != ""){
			if(studentName.indexOf(",") != -1){
				var nameArr = studentName.split(",");
				studentName = nameArr[1] + " " + nameArr[0];
			}	
		}
		
		if(lessonStatus==null){
			lessonStatus="incomplete";
		}		
		
		//scormApi.set(Selector.SCORE_MIN, scoreMin);
		//scormApi.set(Selector.SCORE_MAX, scoreMax);

		//-- to prevent data lose 	
		scormApi.set(Selector.EXIT, "suspend");

		startCourse();
		//--
		APP.commonFunObj.startLmsInterval();		
		//--
	}	

    _this.resetScormData=function() {
        lessonStatus = "incomplete";		
		successStatus = "unknown";
		scoreRaw = "";		
    }
	_this.updateUserData = function(){		
		
		//--
		APP.commonFunObj.stopLmsInterval();		
		//-- for score
		//-- if assessment available set lesson status over score
		//--consider single quiz
		/* if(APP.globalQuizObj.isAvalable){
			if (APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPercentage != null && APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPercentage !== "") {		
				if (APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPercentage >= lmsScore) {			
					scoreRaw = APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPercentage;
				}
			}

		}else{
			//---if assessment not available then check all screen complition
			if (APP.courseDataObj.isAllScreenCompleted()) {	
				lessonStatus = "completed";
			} else {
				lessonStatus = "incomplete";
			}
		} */		
		
		/* if (scoreRaw.toString() !== "" && scoreRaw != null) {					
			if (scoreRaw >= APP.configObj.assessment[APP.globalQuizObj.currentQuizId].passingScore) {
				successStatus = "passed";
				lessonStatus = "passed";
				if(APP.configObj.tracking.complianceType == "2"){
					lessonStatus = "completed";	
				}			
			}else{
				successStatus = "failed";
				lessonStatus = "failed";
				if(APP.configObj.tracking.complianceType == "2"){
					lessonStatus = "completed";	
				}
			}
		}else{
			successStatus='unknown';
		} */
		//custom edit for client
		if(lessonStatus != "completed"){
			if(APP.globalQuizObj.isAvalable){
				if (APP.courseDataObj.isAllScreenCompleted() && APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataStatus == 'passed') {	
					APP.commonFunObj.setPassDate();	
					lessonStatus = "completed";
					successStatus = "passed";
				} else {
					lessonStatus = "incomplete";
					successStatus='unknown';
				}
			}else{
				if (APP.courseDataObj.isAllScreenCompleted()) {	
					APP.commonFunObj.setPassDate();	
					lessonStatus = "completed";
					successStatus = "passed";
				} else {
					lessonStatus = "incomplete";
					successStatus='unknown';
				}
			}
			
		}
		setLMSData();		
	}

	_this.closeCourse = function(){			
		if (!APP.courseClosed && lmsConnected && scormApi != null)
		{				
			_this.updateUserData();
			//--
			APP.commonFunObj.stopLmsInterval();		
			//--
			APP.commonFunObj.insertDelay(200);
			var timeSpent = getSessionTime(APP.currentTime.getTime());
			scormApi.set(Selector.SESSIONTIME, timeSpent);
			//custom edit for client lms
			
			
			
			var commit=scormApi.save();
			if(!commit){
				APP.commonFunObj.showNetworkFailPop();
			}	
			scormApi.quit();
			lmsConnected = false;
			APP.courseClosed = true;
		}	
			
	}
	_this.callCommit = function(){
		
		if (lmsConnected && scormApi != null) {
			APP.commonFunObj.checkConnection(myCallBack);
			var commit=scormApi.save();
			if(!commit){
				APP.commonFunObj.showNetworkFailPop();
			}
		}
	}
	function setLMSData(){
		if (lmsConnected && scormApi != null) {	
			APP.commonFunObj.checkConnection(myCallBack);
			if (APP.winOpener && APP.winOpener.closed){
				APP.commonFunObj.showLmsWinClosedPop();
				return false;
			}
			scormApi.set(Selector.PREFER_LANG, APP.configObj.language.lang);
			
			bookmark = APP.courseBookmark;
			//--for reviewmylearning tool
			if(APP.configObj.tracking.isReviewMyELearning === true){
				bookmark = APP.navData.currentScreenObj.screenId || '';
			}
			scormApi.set(Selector.BOOKMARK, bookmark);
			
			var currSusData=APP.courseDataObj.updateSuspendData();
			scormApi.set(Selector.SUSPENDDATA, currSusData);
			
			scormApi.set(Selector.LESSONSTATUS, lessonStatus);
			/* if(APP.globalQuizObj.isAvalable){
				if (scoreRaw.toString() != "" && scoreRaw!=null) {
					//for scorm2004 version
					if(APP.configObj.tracking.complianceType == "2"){
						var perScore=scoreRaw / 100;
						scormApi.set(Selector.SCORE, scoreRaw);
						scormApi.set(Selector.SCORE_SCALED, perScore);
					}else{
						scormApi.set(Selector.SCORE, scoreRaw);
					}
				}
			} */			
			//for scorm2004 version
			if(APP.configObj.tracking.complianceType == "2"){
				scormApi.set(Selector.SUCCESS_STATUS, successStatus);	
			}
			var commit=scormApi.save();
			if(!commit){
				APP.commonFunObj.showNetworkFailPop();
			}	
			//--
			APP.commonFunObj.startLmsInterval();		
			//--
		}  
		
	}
	//-----------
	_this.sendInlineInteractionData=function(_qObj){
		if(APP.configObj.tracking.complianceType == "0" || !_qObj.dataTobeSend){return false;}
		if(lmsConnected && scormApi != null ){
			//--for multi lang(only send numbers)
			var onlyNumbericDataSend = false;
			//-
			APP.commonFunObj.checkConnection(myCallBack);
			var currQuesObj	= _qObj;
			if(currQuesObj.dataIsUserOptionSelected==null || currQuesObj.dataIsUserOptionSelected.toString()=="false"){return false;}
			var InteractionIndex;
			//InteractionIndex = _questionNo;
			InteractionIndex=scormApi.get("cmi.interactions._count");
			var startTime= currQuesObj.dataStartTime;
			var endTime = startTime.getTime();
			
			var sbQId=currQuesObj.qId || "que-"+InteractionIndex;
			var actualNum=sbQId.split('-')[1];
			//-- Attempt1_Question1_110
			//var qId="Attempt"+APP.globalQuizObj.globalAttempt+"_Question"+(_questionNo + 1)+"_"+actualNum;
			var qId="Question_"+actualNum;
			
			var qType="";
			if(currQuesObj.type == "inputBox"){
				qType="fill-in";
			}else if (currQuesObj.subType == "trueFalse"){
				qType="true-false";
			}else{
				qType="choice";
			}
			questionText = sbQId;
			
			var qTxtObj=currQuesObj.questionText;
			var baseStr=""
			for(var i=0; i<qTxtObj.length; i++){
				baseStr+=qTxtObj[i]+" ";
			}
			//--remove html tag
			var patt1 = /<.*?>/gim;
			var patt2 = /\s\s+/gim;
			//--remove space
			var descrText = baseStr.replace(patt1,"").replace(patt2," ");
			if(descrText.length >= 255){
				descrText = descrText.slice(0, 250);
				descrText += "...";
			}
			
			var correctAnswer="";
			var learnerResponse="";
			  
			var removeSpacialCharPatt = /[\~\`\!\@\#\$\%\^\&\*\(\)\_\+\=\-\{\}\|\[\]\\:\"\;\'\<\>\?\,\.\—\–\¬\–\…\‘\’\“\”\/]/gim;

			//for scorm 1.2
			if(APP.configObj.tracking.complianceType == "1"){
				var cStr=currQuesObj.dataAnswerArray.toString();
				//correctAnswer=cStr.replaceAll(",", "_").replaceAll("^", "_").replaceAll(".", "-");
				//scorm 1.2 only support ',' separator
				correctAnswer=cStr.replaceAll("^", ",").replaceAll(".", ",");
				var uStr=currQuesObj.dataUserArray.toString();
				//learnerResponse=uStr.replaceAll(",", "_").replaceAll("^", "_").replaceAll(".", "-");
				learnerResponse=uStr.replaceAll("^", ",").replaceAll(".", ",");
			}else{
				//-- lang data problem
				//-- so we send option id + 1 instead of option text
				if(currQuesObj.type == "dropDown"){
					var str="";
					/* console.log('currQuesObj.dataUserArray: '+currQuesObj.dataUserArray);
					console.log('currQuesObj.dataUserOptText: '+currQuesObj.dataUserOptText);

					console.log('currQuesObj.dataAnswerArray: '+currQuesObj.dataAnswerArray);
					console.log('currQuesObj.dataCorrOptText: '+currQuesObj.dataCorrOptText); */

					if(onlyNumbericDataSend){
						var ansArr=currQuesObj.dataAnswerArray.split('^');
					}else{
						var ansArr=currQuesObj.dataCorrOptText.split('^');
					}
					
					var temp = [];
					
					for(var i=0; i<ansArr.length; i++){
						var newArr1 = ansArr[i].split('-');
						temp[i] = [];
						
						for(var j=0; j<newArr1.length; j++){
							temp[i][j] = [];
							temp[i][j] = newArr1[j].split(',');	
							
																	
							for(var k=0; k<temp[i][j].length; k++){													
								
								if(onlyNumbericDataSend){
									var t = (parseInt(temp[i][j][k]) + 1).toString();
								}else{
									var t= temp[i][j][k];
								}
									
								t=t.replace(removeSpacialCharPatt,"");
								t=(i+1)+'-'+(j+1)+'='+t;
								if(t.length >= 36){
									t = t.slice(0, 28);
									t += "__";
								}
								str+=t;
								if(k != temp[i][j].length - 1){
									str+=" OR ";
								}
							}
							if(j != newArr1.length - 1){
								str+="[,]";
							}														
						}
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt1,"").replace(patt2,"_");
					
					var str1="";
					//console.log('currQuesObj.dataUserArray '+currQuesObj.dataUserArray);
					if(onlyNumbericDataSend){
						var tempUsrArr = currQuesObj.dataUserArray.split('^');
					}else{
						var tempUsrArr = currQuesObj.dataUserOptText.split('^');
					}
										
					for(var l=0; l<tempUsrArr.length; l++){
						var newArr = tempUsrArr[l].split(',');							
														
						for(var m=0; m<newArr.length; m++){	
							if(newArr[m]!=null && newArr[m]!="0" && newArr[m]!=""){
								if(onlyNumbericDataSend){
									var t = (parseInt(newArr[m]) + 1).toString();
								}else{
									var t= newArr[m];
								}
																
								t=t.replace(removeSpacialCharPatt,"");										
								t=(l+1)+'-'+(m+1)+'='+t;
								if(t.length >= 36){
									t = t.slice(0, 28);
									t += "__";
								}
								str1+=t;
								if(m != newArr.length - 1){
									str1+="[,]";
								}										
							}
						}
						if(l != tempUsrArr.length - 1){
							str1+="[,]";
						}
					}				
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt1,"").replace(patt2,"_");
				}else if(currQuesObj.type == "dragNDrop"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray.split('^');
					
					for(var i=0; i<ansArr.length; i++){
						var temp=ansArr[i].split(',');
						for(var j=0; j<temp.length; j++){
							if(onlyNumbericDataSend){
								var t = (parseInt(temp[j]) + 1).toString();
							}else{
								var t=currQuesObj.options[parseInt(temp[j])];	
							}										
									
							t=t.replace(removeSpacialCharPatt,"");
							t=(i+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(j != temp.length - 1){
								str+=" OR ";
							}
						}
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt1,"").replace(patt2,"_");
					
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k]!=null && currQuesObj.dataUserArray[k]!="-1" && currQuesObj.dataUserArray[k]!="-blank-"){
							if(onlyNumbericDataSend){
								var t = (parseInt(currQuesObj.dataUserArray[k]) + 1).toString();
							}else{
								var t=currQuesObj.options[parseInt(currQuesObj.dataUserArray[k])];	
							}						
							
							t=t.replace(removeSpacialCharPatt,"");
							t=(k+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str1+=t;
							if(k != currQuesObj.dataUserArray.length - 1){
								str1+="[,]";
							}
						}
					}
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt1,"").replace(patt2,"_");
				}else if(currQuesObj.type.toLowerCase() == "mcq" || currQuesObj.type.toLowerCase() == "mrq"){
					var str="";
					for(var k=0; k<currQuesObj.dataAnswerArray.length; k++){
						if(currQuesObj.dataAnswerArray[k]=="1"){
							if(onlyNumbericDataSend){
								var t = (k + 1).toString();
							}else{
								var t=currQuesObj.options[k];
							}						
							
							t=t.replace(removeSpacialCharPatt,"");
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(k != currQuesObj.dataAnswerArray.length - 1){
								str+="[,]";
							}
						}
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt1,"").replace(patt2,"_");
					//--for true false question
					if (currQuesObj.subType == "trueFalse"){
						correctAnswer = correctAnswer.toLowerCase();
					}
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k]=="1"){	
							if(onlyNumbericDataSend){
								var t = (k + 1).toString();
							}else{
								var t=currQuesObj.options[k];
							}	
							t=t.replace(removeSpacialCharPatt,"");
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str1+=t;
							if(k != currQuesObj.dataAnswerArray.length - 1){
								str1+="[,]";
							}
						}						
					}
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt1,"").replace(patt2,"_");
					//--for true false question
					if (currQuesObj.subType == "trueFalse"){
						learnerResponse = learnerResponse.toLowerCase();
					}
				}else if(currQuesObj.type == "multiColOption"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray;
					
					for(var i=0; i<ansArr.length; i++){		
						if(onlyNumbericDataSend){
							var t=(parseInt(ansArr[i]) + 1).toString();
						}else{
							var t=currQuesObj.options[parseInt(ansArr[i])];	
						}
							
						t=t.replace(removeSpacialCharPatt,"");
						t=(i+1)+'='+t;
						if(t.length >= 36){
							t = t.slice(0, 28);
							t += "__";
						}
						str+=t;						
					
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt2,"_");
					
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k] != null && currQuesObj.dataUserArray[k] != "-1"){
							var curr1 = parseInt(currQuesObj.dataUserArray[k]);	
							if(onlyNumbericDataSend){
								var t=(curr1 + 1).toString();	
							}else{
								var t=currQuesObj.options[curr1];
							}							
							t=t.replace(removeSpacialCharPatt,"");
							t=(k+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str1+=t;
							if(k != currQuesObj.dataUserArray.length - 1){
								str1+="[,]";
							}
						}
					}
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt2,"_");
				}else if(currQuesObj.type == "slidingScale"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray.split('^');
					
					for(var i=0; i<ansArr.length; i++){
						var temp=ansArr[i].split(',');
						for(var j=0; j<temp.length; j++){
							if(onlyNumbericDataSend){
								var t=(parseInt(temp[j]) + 1).toString();
							}else{
								var t=currQuesObj.options[i][parseInt(temp[j])];
							}		
																
							t=t.replace(removeSpacialCharPatt,"");
							t=(i+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(j != temp.length - 1){
								str+=" OR ";
							}
						}
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt2,"_");
					
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k] != null && currQuesObj.dataUserArray[k] != "-1"){
							var curr1 = parseInt(currQuesObj.dataUserArray[k]);	
							if(onlyNumbericDataSend){
								var t= (curr1 + 1).toString();		
							}else{
								var t=currQuesObj.options[k][curr1];
							}						
												
							t=t.replace(removeSpacialCharPatt,"");
							t=(k+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str1+=t;
							if(k != currQuesObj.dataUserArray.length - 1){
								str1+="[,]";
							}
						}
					}
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt2,"_");
				}
			}
			var qPoint=currQuesObj.dataEarnPoint;
			
			var result="";		
			if(currQuesObj.dataStatus=="correct"){
				result="correct";
			}else{
				result="wrong";
				if(APP.configObj.tracking.complianceType == "2"){
					result="incorrect";
				}
			}
			
			scormApi.set("cmi.interactions." + InteractionIndex + ".id", qId);
			//for scorm 2004
			if(APP.configObj.tracking.complianceType == "2"){
				if(onlyNumbericDataSend){
					scormApi.set("cmi.interactions." + InteractionIndex + ".description", qId);
				}else{
					scormApi.set("cmi.interactions." + InteractionIndex + ".description", descrText);
				}
			}	
			/* console.log('--------------');		
			console.log('qId: '+qId);		
			console.log('descrText: '+descrText);		
			console.log('questionText: '+questionText);		
			console.log('qType: '+qType);		
			console.log('learnerResponse: '+learnerResponse);		
			console.log('correctAnswer: '+correctAnswer);		
			console.log('qPoint: '+qPoint);		
			console.log('result: '+result); */

			scormApi.set("cmi.interactions." + InteractionIndex + ".objectives.0.id", questionText);
			scormApi.set("cmi.interactions." + InteractionIndex + ".type", qType);
			scormApi.set("cmi.interactions." + InteractionIndex + Selector.USER_RESPONCE, learnerResponse);			
			scormApi.set("cmi.interactions." + InteractionIndex + ".correct_responses.0.pattern", correctAnswer);			
			scormApi.set("cmi.interactions." + InteractionIndex + ".weighting", qPoint);
			scormApi.set("cmi.interactions." + InteractionIndex + ".result", result);
			// to remove miliseconds and Z format is 2019-05-03T13:15:01.034Z 
			//for scorm 2004
			if(APP.configObj.tracking.complianceType == "2"){
				var st= startTime.toISOString().split('.')[0];
				scormApi.set("cmi.interactions." + InteractionIndex + Selector.TIME, st);		
				//scorm 1.2 format is hh:mm:ss
				//scorm 2004 format is P49Y4MT13H15M1.87S			
				scormApi.set("cmi.interactions." + InteractionIndex + ".latency", getSessionTime(endTime));		
			}else{
				//---scorm 1.2 not supported cmiTime well in IE so disabled
				//"‎1‎/‎20‎/‎2021‎ ‎15‎:‎53‎:‎43"
				/* var st= (startTime.toLocaleString('en-GB',{ hour12: false }).split(' ')[1]).trim();
				scormApi.set("cmi.interactions." + InteractionIndex + Selector.TIME, st);
				 */
			}
			var commit=scormApi.save();
			if(!commit){
				APP.commonFunObj.showNetworkFailPop();
			}
		}
	}
	_this.sendInteractionData=function(_questionNo){
		if(APP.configObj.tracking.complianceType == "0" || APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataReviewMode || !APP.configObj.assessment[APP.globalQuizObj.currentQuizId].sendQueInteractionData){return false;}
		if(lmsConnected && scormApi != null ){
			APP.commonFunObj.checkConnection(myCallBack);
			var currQuesObj=APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataFinalAssessmentObj[_questionNo];
			if(currQuesObj.dataIsUserOptionSelected==null || currQuesObj.dataIsUserOptionSelected.toString()=="false"){return false;}
			var InteractionIndex;
			//InteractionIndex = _questionNo;
			InteractionIndex=scormApi.get("cmi.interactions._count");
			
			var startTime= currQuesObj.dataStartTime;
			var endTime = startTime.getTime();
			
			var sbQId=currQuesObj.sbRef || "que-"+(_questionNo + 1);
			var actualNum=sbQId.split('-')[1];
			//-- Attempt1_Question1_110
			//var qId="Attempt"+APP.globalQuizObj.globalAttempt+"_Question"+(_questionNo + 1)+"_"+actualNum;
			var qId="Question"+(_questionNo + 1)+"_"+actualNum;
			
			var qType="";
			if(currQuesObj.type == "inputBox"){
				qType="fill-in";
			}else if (currQuesObj.subType == "trueFalse"){
				qType="true-false";
			}else{
				qType="choice";
			}
			
			questionText = "test_"+(APP.globalQuizObj.currentQuizId + 1);
			
			var qTxtObj=currQuesObj.questionText[0].text;
			var baseStr=""
			for(var i=0; i<qTxtObj.length; i++){
				baseStr+=qTxtObj[i].Text+" ";
			}
			//--remove html tag
			var patt1 = /<.*?>/gim;
			var patt2 = /\s\s+/gim;
			//--remove space
			var descrText = baseStr.replace(patt1,"").replace(patt2," ");
			if(descrText.length >= 255){
				descrText = descrText.slice(0, 250);
				descrText += "...";
			}
			//descrText="{lang="+APP.configObj.language.lang+"}"+descrText;
			
			var correctAnswer="";
			var learnerResponse="";
			  
			var removeSpacialCharPatt = /[\~\`\!\@\#\$\%\^\&\*\(\)\_\+\=\-\{\}\|\[\]\\:\"\;\'\<\>\?\,\.\—\–\¬\–\…\‘\’\“\”\/]/gim;
			//for scorm 1.2
			if(APP.configObj.tracking.complianceType == "1"){
				var cStr=currQuesObj.dataAnswerArray.toString();
				//correctAnswer=cStr.replaceAll(",", "_").replaceAll("^", "_").replaceAll(".", "-");
				//scorm 1.2 only support ',' separator
				correctAnswer=cStr.replaceAll("^", ",").replaceAll(".", ",");
				var uStr=currQuesObj.dataUserArray.toString();
				//learnerResponse=uStr.replaceAll(",", "_").replaceAll("^", "_").replaceAll(".", "-");
				learnerResponse=uStr.replaceAll("^", ",").replaceAll(".", ",");
			}else{
				if(currQuesObj.type == "inputBox"){
					//correctAnswer=currQuesObj.dataAnswerArray.toString();
					//learnerResponse=currQuesObj.dataUserArray.toString();
					var str="";
					for(var i=0; i<currQuesObj.dataAnswerArray.length; i++){
						var t=(i+1)+'='+currQuesObj.dataAnswerArray[i].toString();
						if(t.length >= 255){
							t = t.slice(0, 220);
							t += "__";
						}
						if(i !=currQuesObj.dataAnswerArray.length - 1){
							t +="[,]";
						}
						//str+="{lang="+APP.configObj.language.lang+"}"+t;
						str+=t;
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//correctAnswer=str.replaceAll("^", "_").replaceAll(".", "-");
					correctAnswer=str.replaceAll("^", "-");
					var str="";
					for(var i=0; i<currQuesObj.dataUserArray.length; i++){
						var t=(i+1)+'='+currQuesObj.dataUserArray[i].toString();
						if(t.length >= 255){
							t = t.slice(0, 220);
							t += "__";
						}
						if(i !=currQuesObj.dataUserArray.length - 1){
							t +="[,]";
						}
						//str+="{lang="+APP.configObj.language.lang+"}"+t;
						str+=t;
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//learnerResponse=str.replaceAll("^", "_").replaceAll(".", "-");
					learnerResponse=str.replaceAll("^", "-");
				}else if(currQuesObj.type == "dropDown" ||  currQuesObj.type == "dragNDrop"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray.split('^');
					
					for(var i=0; i<ansArr.length; i++){
						var temp=ansArr[i].split(',');
						for(var j=0; j<temp.length; j++){
							var t=currQuesObj.options[0].option[parseInt(temp[j])].Text;							
							t=t.replace(removeSpacialCharPatt,"");
							t=(i+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(j != temp.length - 1){
								str+=" OR ";
							}
						}
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt2,"_");
					
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k]!=null && currQuesObj.dataUserArray[k]!="-1" && currQuesObj.dataUserArray[k]!="-blank-"){
								
							var t=currQuesObj.options[0].option[parseInt(currQuesObj.dataUserArray[k])].Text;
								t=t.replace(removeSpacialCharPatt,"");
								t=(k+1)+'='+t;
								if(t.length >= 36){
									t = t.slice(0, 28);
									t += "__";
								}
								str1+=t;
							if(k != currQuesObj.dataUserArray.length - 1){
								str1+="[,]";
							}
						}
					}
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt2,"_");
				}else if(currQuesObj.type == "multiColOption" || currQuesObj.type == "slidingScale"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray.split('^');
					
					for(var i=0; i<ansArr.length; i++){
						var temp=ansArr[i].split(',');
						for(var j=0; j<temp.length; j++){
							var t=currQuesObj.header[0].headerText[parseInt(temp[j])].Text;							
							t=t.replace(removeSpacialCharPatt,"");
							t=(i+1)+'='+t;
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(j != temp.length - 1){
								str+=" OR ";
							}
						}
						if(i != ansArr.length - 1){
							str+="[,]";
						}
					}
					
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt2,"_");
					
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k] != null && currQuesObj.dataUserArray[k] != "-1"){
							var curr1 = parseInt(currQuesObj.dataUserArray[k]);						
							var t=currQuesObj.header[0].headerText[curr1].Text;							
								t=t.replace(removeSpacialCharPatt,"");
								t=(k+1)+'='+t;
								if(t.length >= 36){
									t = t.slice(0, 28);
									t += "__";
								}
								str1+=t;
							if(k != currQuesObj.dataUserArray.length - 1){
								str1+="[,]";
							}
						}
					}
					
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt2,"_");
				}else if(currQuesObj.type == "categoryDragNDrop"){
					var str="";
					var ansArr=currQuesObj.dataAnswerArray.split('^');					
					for(var i=0; i<ansArr.length; i++){
						var temp = ansArr[i].split(',');
						var t = currQuesObj.dropOptions[0].option[i].titleText[0].Text || (i+1);
						t = t.replace(removeSpacialCharPatt,"");
						t += '=';
						for(var j=0; j<temp.length; j++){
							var t1 = currQuesObj.options[0].option[parseInt(temp[j])].Text;
							t1 = t1.replace(removeSpacialCharPatt,"");							
							if(t1.length >= 36){
								t1 = t1.slice(0, 26);
								t1 += "__";
							}
							t += t1;
							if(j != temp.length - 1){
								t += " AND ";
							}
						}
						if(i != ansArr.length - 1){
							t += "[,]";
						}
						str += t;
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt2,"_");
					
					var str1="";
					var userArr = currQuesObj.dataUserArray.split('^');
					for(var k=0; k<userArr.length; k++){
						var temp1 = userArr[k].split(',');
						var tu = currQuesObj.dropOptions[0].option[k].titleText[0].Text || (k+1);
						tu = tu.replace(removeSpacialCharPatt,"");
						tu += '=';
						for(var m=0; m<temp1.length; m++){
							var tu1 = currQuesObj.options[0].option[parseInt(temp1[m])].Text;
							tu1 = tu1.replace(removeSpacialCharPatt,"");							
							if(tu1.length >= 36){
								tu1 = tu1.slice(0, 26);
								tu1 += "__";
							}
							tu += tu1;
							if(m != temp1.length - 1){
								tu += " AND ";
							}
						}
						if(k != userArr.length - 1){
							tu += "[,]";
						}
						str1 += tu;
					}

					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt2,"_");
				}else{
					var str="";
					for(var k=0; k<currQuesObj.dataAnswerArray.length; k++){
						if(currQuesObj.dataAnswerArray[k]=="1"){
							var t=currQuesObj.options[0].option[k].Text;
							t=t.replace(removeSpacialCharPatt,"");
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str+=t;
							if(k != currQuesObj.dataAnswerArray.length - 1){
								str+="[,]";
							}
						}
					}
					var lastIndex = str.lastIndexOf("[,]");
					if(lastIndex == (str.length - 3)){
						str = str.substring(0, lastIndex);
					}
					
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					correctAnswer = str.replace(patt1,"").replace(patt2,"_");
					//--for true false question
					if (currQuesObj.subType == "trueFalse"){
						correctAnswer = correctAnswer.toLowerCase();
					}
					var str1="";
					for(var k=0; k<currQuesObj.dataUserArray.length; k++){
						if(currQuesObj.dataUserArray[k]=="1"){							
							var t=currQuesObj.options[0].option[k].Text;
							t=t.replace(removeSpacialCharPatt,"");
							if(t.length >= 36){
								t = t.slice(0, 28);
								t += "__";
							}
							str1+=t;
							if(k != currQuesObj.dataAnswerArray.length - 1){
								str1+="[,]";
							}
						}						
					}
					var lastIndex = str1.lastIndexOf("[,]");
					if(lastIndex == (str1.length - 3)){
						str1 = str1.substring(0, lastIndex);
					}
					//--remove last , space
					var patt1 = /.[,]\W$/gim;
					var patt2 = /\s/gim;
					learnerResponse = str1.replace(patt1,"").replace(patt2,"_");
					//--for true false question
					if (currQuesObj.subType == "trueFalse"){
						learnerResponse = learnerResponse.toLowerCase();
					}
				}
			}
						
			var qPoint=currQuesObj.dataEarnPoint;
			
			var result="";		
			if(currQuesObj.dataStatus=="correct"){
				result="correct";
			}else{
				result="wrong";
				if(APP.configObj.tracking.complianceType == "2"){
					result="incorrect";
				}
			}
			
			scormApi.set("cmi.interactions." + InteractionIndex + ".id", qId);
			//for scorm 2004
			if(APP.configObj.tracking.complianceType == "2"){
				scormApi.set("cmi.interactions." + InteractionIndex + ".description", descrText);	
			}			
			scormApi.set("cmi.interactions." + InteractionIndex + ".objectives.0.id", questionText);
			scormApi.set("cmi.interactions." + InteractionIndex + ".type", qType);
			scormApi.set("cmi.interactions." + InteractionIndex + Selector.USER_RESPONCE, learnerResponse);			
			scormApi.set("cmi.interactions." + InteractionIndex + ".correct_responses.0.pattern", correctAnswer);			
			scormApi.set("cmi.interactions." + InteractionIndex + ".weighting", qPoint);
			scormApi.set("cmi.interactions." + InteractionIndex + ".result", result);
			// to remove miliseconds and Z format is 2019-05-03T13:15:01.034Z 
			//for scorm 2004
			if(APP.configObj.tracking.complianceType == "2"){
				var st= startTime.toISOString().split('.')[0];
				scormApi.set("cmi.interactions." + InteractionIndex + Selector.TIME, st);		
				//scorm 1.2 format is hh:mm:ss
				//scorm 2004 format is P49Y4MT13H15M1.87S			
				scormApi.set("cmi.interactions." + InteractionIndex + ".latency", getSessionTime(endTime));		
			}else{
				//---scorm 1.2 not supported cmiTime well in IE so disabled
				//"‎1‎/‎20‎/‎2021‎ ‎15‎:‎53‎:‎43"
				/* var st= (startTime.toLocaleString('en-GB',{ hour12: false }).split(' ')[1]).trim();
				scormApi.set("cmi.interactions." + InteractionIndex + Selector.TIME, st);
				 */
			}
			var commit=scormApi.save();
			if(!commit){
				APP.commonFunObj.showNetworkFailPop();
			}
			
		}
	}
	//-----------		
		
	function getSessionTime(curr, hrVal) {
		var _hrVal = hrVal || 4;
		var dtm = new Date();
		var initalTime=curr;
		var n = dtm.getTime() - initalTime;
		if(APP.configObj.tracking.complianceType == "2"){
			return ConvertMilliSecondsIntoSCORM2004Time(n);
		}else{
			return MillisecondsToCMIDuration(n, _hrVal);
		}
	}

	function MillisecondsToCMIDuration(LessonDuration, hrVal) {
		var _hrVal = hrVal || 4;
		
		var hr = "000" + Math.floor(LessonDuration / (60 * 60 * 1000));
		var temp = (LessonDuration - (hr * 60 * 60 * 1000));
		var min = "0" + Math.floor(temp / (60 * 1000));
		var sec = temp - (min * 60 * 1000);
		temp = temp - (sec * 1000);
		var ms = "0" + Math.floor(temp / 1000);
		sec = "0" + Math.floor(sec / 1000);
		var LessonDurationFormat = hr.substr(hr.length - _hrVal) + ":" + min.substr(min.length - 2) + ":" + sec.substr(sec.length - 2) + "." + ms.substr(ms.length - 2);
		return LessonDurationFormat;
	}

	function ConvertMilliSecondsIntoSCORM2004Time(intTotalMilliseconds){	
		var ScormTime = "";
		var HundredthsOfASecond;
		var Seconds;
		var Minutes;
		var Hours;
		var Days;
		var Months;
		var Years;	
		var HUNDREDTHS_PER_SECOND = 100;
		var HUNDREDTHS_PER_MINUTE = HUNDREDTHS_PER_SECOND * 60;
		var HUNDREDTHS_PER_HOUR   = HUNDREDTHS_PER_MINUTE * 60;
		var HUNDREDTHS_PER_DAY    = HUNDREDTHS_PER_HOUR * 24;
		var HUNDREDTHS_PER_MONTH  = HUNDREDTHS_PER_DAY * (((365 * 4) + 1) / 48);
		var HUNDREDTHS_PER_YEAR   = HUNDREDTHS_PER_MONTH * 12;    	
		HundredthsOfASecond = Math.floor(intTotalMilliseconds / 10);    	
		Years = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_YEAR);
		HundredthsOfASecond -= (Years * HUNDREDTHS_PER_YEAR);    	
		Months = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_MONTH);
		HundredthsOfASecond -= (Months * HUNDREDTHS_PER_MONTH);    	
		Days = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_DAY);
		HundredthsOfASecond -= (Days * HUNDREDTHS_PER_DAY);
		Hours = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_HOUR);
		HundredthsOfASecond -= (Hours * HUNDREDTHS_PER_HOUR);
		Minutes = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_MINUTE);
		HundredthsOfASecond -= (Minutes * HUNDREDTHS_PER_MINUTE);
		Seconds = Math.floor(HundredthsOfASecond / HUNDREDTHS_PER_SECOND);
		HundredthsOfASecond -= (Seconds * HUNDREDTHS_PER_SECOND);
		if (Years > 0) {
			ScormTime += Years + "Y";
		}
		if (Months > 0){
			ScormTime += Months + "M";
		}
		if (Days > 0){
			ScormTime += Days + "D";
		}
		if ((HundredthsOfASecond + Seconds + Minutes + Hours) > 0 ){
			ScormTime += "T";
			if (Hours > 0){
				ScormTime += Hours + "H";
			}    		
			if (Minutes > 0){
				ScormTime += Minutes + "M";
			}    		
			if ((HundredthsOfASecond + Seconds) > 0){
				ScormTime += Seconds;
				
				if (HundredthsOfASecond > 0){
					ScormTime += "." + HundredthsOfASecond;
				}    			
				ScormTime += "S";
			}    		
		}    	
		if (ScormTime == ""){
			ScormTime = "0S";
		}    	
		ScormTime = "P" + ScormTime;
		return ScormTime;
	}
	
	
}

