function GlobalXmlData() {
	var _this = this;
	var xmlLoadingArr = [];
	_this.navigationXML = null;
	_this.globalXML = null;
	_this.assessmentXML = [];
	_this.glossaryXML = null;
	_this.allScreenDataXML = null;
	_this.loadNavigationXML = function () {
		//this.navigationXML
		$(document).trigger(APP.eventObj.ON_NAVIGATIONXML_LOADING);
		//-- for 1st time lang set default
		if(APP.configObj.language.lang == null || APP.configObj.language.lang==''){
			APP.configObj.language.lang = APP.configObj.language.defaultLang;
		}
		if(APP.configObj.language.dir == null || APP.configObj.language.dir==''){
			APP.configObj.language.dir = APP.configObj.language.defaultDir;
		}
		//--multi lang
		$('html').attr('lang', APP.configObj.language.lang);
		$('html').attr('dir', APP.configObj.language.dir);
		//--
		APP.loadFilesObj.loadXML(APP.configObj.filePath.dataPath + 'navigation.xml', function (_xml) {
			_this.navigationXML = _xml;
			filterNavigationXML();
		});
	}
	
	_this.loadGlobalXML = function () {
		$(document).trigger(APP.eventObj.ON_GLOBALXML_LOADING);
		var _path = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/" + "globalData.xml"
		APP.loadFilesObj.loadXML(_path, function (_xml) {
			_this.globalXML = _xml;
			xmlLoadingArr = [];		
			if(APP.configObj.assessment){
				var path = '';
				_this.assessmentXML = [];
				for(var i=0; i<APP.configObj.assessment.length; i++){
					var curr = APP.configObj.assessment[i];
					_this.assessmentXML[i] = null;
					if(curr.isAvailable){
						path = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/" + curr.dataFileName;
						xmlLoadingArr.push(0);
						loadAssessmentXML(i, path, xmlLoadingArr.length);
					}
				}
			}
			if(APP.configObj.glossary.isAvailable){
				xmlLoadingArr.push(0);
				loadGlossaryXML(xmlLoadingArr.length);
			}
			if(APP.configObj.isScreenDataXmlAvl){
				xmlLoadingArr.push(0);
				loadAllScreenDataXML(xmlLoadingArr.length);
			}
			checkXmlLoadStatus();
		});
	}
	function loadGlossaryXML (_arrLen) {
		var _path = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/" + APP.configObj.glossary.dataFileName;
		APP.loadFilesObj.loadXML(_path, function (_xml) {
			_this.glossaryXML = _xml;	
			xmlLoadingArr[(_arrLen - 1)] = 1;
			checkXmlLoadStatus();	
		});
	}
	function loadAllScreenDataXML (_arrLen) {
		var _path = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/screenData/screenData.xml";
		APP.loadFilesObj.loadXML(_path, function (_xml) {
			_this.allScreenDataXML = _xml;	
			xmlLoadingArr[(_arrLen - 1)] = 1;
			checkXmlLoadStatus();	
		});
	}
	function loadAssessmentXML (_index, _path, _arrLen) {
		//('start... '+_index, _path, _arrLen);		
		APP.loadFilesObj.loadXML(_path, function (_xml) {
			
			_this.assessmentXML[_index] = _xml;
			xmlLoadingArr[(_arrLen - 1)] = 1;
			checkXmlLoadStatus();			
		});
	}
	
	_this.createRandomizeQuizArray = function (id){
		
		var curr = APP.configObj.assessment[id];	
		if(curr.isAvailable){
			curr.dataRandomArr = [];
			var xmlObj = _this.assessmentXML[id];
			for (var i = 0; i < xmlObj.questionSet.length; i++) {
				var _qPoint = "1";
				var pickQues = parseInt(xmlObj.questionSet[i].pickQues);
				var start = 0;
				var len = xmlObj.questionSet[i].question.length;
				if (curr.randomization) {
					_qPoint = xmlObj.questionSet[i].pointEachQue || '1';
					curr.dataRandomArr[i] = APP.commonFunObj.getRandomArr(pickQues, start, len);
				} else {
					_qPoint = "1"
					curr.dataRandomArr[i] = APP.commonFunObj.getLinearArr(len);
				}
				for (var j = 0; j < len; j++) {
					var _id = "que_" + (i + 1) + "-" + (j + 1);
					xmlObj.questionSet[i].question[j].dataId = _id;
					xmlObj.questionSet[i].question[j].dataQuePoint = _qPoint;
				}
			}
			_this.applyXmlObjInFinalAssessment(id);
		}		
	}
	
	_this.applyXmlObjInFinalAssessment = function(id) {
		//--create randomizeQueObj
		var curr = APP.configObj.assessment[id];	
		if(curr.isAvailable){
			curr.dataFinalAssessmentObj = [];
			var count = 0;
			for (var i = 0; i < curr.dataRandomArr.length; i++) {
				for (var j = 0; j < curr.dataRandomArr[i].length; j++) {
					var q = curr.dataRandomArr[i][j];
					curr.dataFinalAssessmentObj[count] = _this.assessmentXML[id].questionSet[i].question[q];
					count++;
				}
			}
		}		
	}
	function filterNavigationXML(){
		var count=0;
		var relCount = 0;
		var modObj=APP.globalXmlsObj.navigationXML.module;
			
		for(var i=0; i<modObj.length; i++){
			var topicObj=APP.globalXmlsObj.navigationXML.module[i].topic;
			for(var j=0; j<topicObj.length; j++){
				var screenObj=APP.globalXmlsObj.navigationXML.module[i].topic[j].screen;
				for(var k=0; k<screenObj.length; k++){
					screenObj[k].screenIndex = count;
					count++;
					//--for last screen
					if(i == (modObj.length - 1)){
						if(j == (topicObj.length - 1)){
							if(k == (screenObj.length - 1)){
								screenObj[k].isEndScreen = "true";
							}
						}
					}
					//--
					//--for screen counter skip intro screens
					var type = modObj[i].moduleType || '';
					//skip logic for intro module
					if( type != 'intro'){
						screenObj[k].relScreenIndex = relCount;
						relCount++;
					}	
				}
			}
		}
		$(document).trigger(APP.eventObj.ON_NAVIGATIONXML_LOADCOMPLETE);
	}
	function checkXmlLoadStatus(){
		//checking all xml is loading or not....
		
		if(xmlLoadingArr.toString().indexOf('0') == -1){			
			$(document).trigger(APP.eventObj.ON_GLOBALXML_LOADCOMPLETE);
		}
	}
}