function Navigation() {
	var _this = this;
	_this.loadNextScreen = function () {
		var totScreens = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length;
		var totTopics = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic.length;
		var totModules = APP.globalXmlsObj.navigationXML.module.length;
		
		if (APP.navData.screenId < (totScreens - 1)) {
			APP.navData.screenId++;
			_this.loadScreen();
		}else if(APP.navData.topicId < (totTopics - 1)){
			//increase topic
			APP.navData.topicId++;
			APP.navData.screenId = 0;
			_this.loadScreen();					
		}else if(APP.navData.moduleId < (totModules - 1)){
			//increase module
			APP.navData.moduleId++;
			APP.navData.topicId = 0;
			APP.navData.screenId = 0;
			_this.loadScreen();	
		}else{
			//_this.loadMainMenuScreen();
			//_this.loadScreenByType('splashScreen');
		}
		
	}
	_this.loadBackScreen = function () {
		var totScreens = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length;
		var totTopics = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic.length;
		var totModules = APP.globalXmlsObj.navigationXML.module.length;
		
		if (APP.navData.screenId > 0) {
			APP.navData.screenId--;
			//for check skipInBack screen
			var avlScreenId = APP.courseDataObj.getPrevScreenIdforBackTopic(APP.navData);
			if(avlScreenId != null && avlScreenId!==''){
				APP.navData.screenId = avlScreenId;
			}
			_this.loadScreen();
		}else if(APP.navData.topicId > 0){
			//decrease topic
			APP.navData.topicId--;
			APP.navData.screenId = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length - 1;
			_this.loadScreen();
			
		}else if(APP.navData.moduleId > 0){
			//decrease module
			APP.navData.moduleId--;
			APP.navData.topicId = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic.length - 1;
			APP.navData.screenId = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen.length - 1;
			_this.loadScreen();
		} else{
			//_this.loadMainMenuScreen();
			//_this.loadScreenByType('splashScreen');
		}
		
	}
	
	_this.loadResultScreen=function(){
		var currObj=_this.getScreenIdByType("resultScreen");
		if(currObj.isAvl){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;
			_this.loadScreen();
		}else{
			console.warn('WARNNIG - result screen not found!')
		}
	} 
	_this.loadMainMenuScreen=function(_obj){
		var obj = _obj || {};
		var currObj=_this.getScreenIdByType("menuscreen");
		if(currObj.isAvl){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;			
			_this.loadScreen({dir: obj.dir || ''});
		}else{
			console.warn('WARNNIG - menu screen not found!')
		}
	} 
	_this.loadAssessmentScreen=function(){
		var currObj=_this.getScreenIdByType("assessmentscreen");
		if(currObj.isAvl){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;
			_this.loadScreen();
		}else{
			console.warn('WARNNIG - assessment screen not found!')
		}
	} 
	_this.loadCertificateScreen=function(){
		var _path="certificate.html";
		var wWd = 1014;
		//var wWd = screen.availWidth;
		var wHt = screen.availHeight;  
		
		var win = window.open(_path, 'certificate', 'width=' + wWd + ',height=' + wHt + ',scrollbars=1,screenX=0,screenY=0,resizable=yes,status=no');
		win.focus();	
	}
	_this.getScreenIdByType=function(_type){
		var modObj=APP.globalXmlsObj.navigationXML.module;
		var obj={isAvl: false};	
		for(var i=0; i<modObj.length; i++){
			var topicObj=APP.globalXmlsObj.navigationXML.module[i].topic;
			for(var j=0; j<topicObj.length; j++){
				var screenObj=APP.globalXmlsObj.navigationXML.module[i].topic[j].screen;
				for(var k=0; k<screenObj.length; k++){
					if(screenObj[k].screenType.toLowerCase() == _type.toLowerCase()){
						obj={
							moduleId:i,
							topicId:j,
							screenId:k,
							isAvl:true
						}
						break;
					}				
				}
				if(obj.isAvl===true){break;}
			}
			if(obj.isAvl===true){break;}
		}
		return obj;
	}
	_this.getModuleScreenIdBysubType=function(_obj){
		var mId = _obj.mId || APP.navData.moduleId;		
		var obj={isAvl: false};			
		var topicObj=APP.globalXmlsObj.navigationXML.module[mId].topic;
		for(var j=0; j<topicObj.length; j++){
			var screenObj=topicObj[j].screen;
			for(var k=0; k<screenObj.length; k++){
				if(screenObj[k].subScreenType)
				if(screenObj[k].subScreenType.toLowerCase() == _obj.type.toLowerCase()){
					obj={
						moduleId:mId,
						topicId:j,
						screenId:k,
						isAvl:true
					}
					break;
				}				
			}
			if(obj.isAvl===true){break;}
		}			
		return obj;
	}
	_this.getScreenById=function(_id){
		var modObj=APP.globalXmlsObj.navigationXML.module;
		var obj={isAvl:false};	
		for(var i=0; i<modObj.length; i++){
			var topicObj=APP.globalXmlsObj.navigationXML.module[i].topic;
			for(var j=0; j<topicObj.length; j++){
				var screenObj=APP.globalXmlsObj.navigationXML.module[i].topic[j].screen;
				for(var k=0; k<screenObj.length; k++){
					if(screenObj[k].screenId.toLowerCase() == _id.toLowerCase()){
						obj={
							moduleId:i,
							topicId:j,
							screenId:k,
							isAvl:true
						}
						break;
					}					
				}
				if(obj.isAvl===true){break;}
			}
			if(obj.isAvl===true){break;}
		}
		return obj;
	}
	_this.loadScreenByType = function(_type){
		var currObj=_this.getScreenIdByType(_type);
		if(currObj.isAvl){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;
			_this.loadScreen();
		}else{
			console.warn('WARNNIG - screen type: '+_type+' not found!')
		}		
	}
	_this.loadScreenById = function(_id){
		var currObj=_this.getScreenById(_id);
		if(currObj.isAvl === true){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;
			_this.loadScreen();
		}else{
			console.warn('WARNNIG - screen id: '+_id+' not found!')
		}
	}
	_this.loadScreenBysubType = function(_type){
		var currObj=_this.getModuleScreenIdBysubType({mId: APP.navData.moduleId, type:_type});
		if(currObj.isAvl === true){
			APP.navData.moduleId= currObj.moduleId;
			APP.navData.topicId= currObj.topicId;
			APP.navData.screenId= currObj.screenId;
			_this.loadScreen();
		}else{
			console.warn('WARNNIG - screen subType: '+_type+' not found!')
		}
	}
	
	_this.getComponentScreenId=function(_name){
		var modObj=APP.globalXmlsObj.navigationXML.module;
		var obj={};	
		for(var i=0; i<modObj.length; i++){
			var topicObj=APP.globalXmlsObj.navigationXML.module[i].topic;
			for(var j=0; j<topicObj.length; j++){
				var screenObj=APP.globalXmlsObj.navigationXML.module[i].topic[j].screen;
				for(var k=0; k<screenObj.length; k++){
					if(screenObj[k].componentName){
						if(screenObj[k].componentName.toLowerCase() == _name.toLowerCase()){
							return obj={
								moduleId:i,
								topicId:j,
								screenId:k
							}
							break;
						}
					}
				}
			}
		}
	}
	_this.loadScreen = function (_obj) {
		//--Kills all tweens and/or delayedCalls/callbacks, and/or timelines
		if(!APP.globalMessageOpen){
			if (TweenMax) {
				TweenMax.killAll();
			}	
		}
		APP.eventObj.removeBlinkNextButton();		
		var currObj = $('#main-div > .screen-modal-pop');				
		if(currObj.length){
			$('body').removeClass('modal-open');
			$('#alpha-bg').fadeOut('fast');
			currObj.remove();
		}					
		//--
		var obj = _obj || {};
		APP.commonFunObj.removeBgMusic1();
		APP.commonFunObj.removeScreenAudio();
		APP.eventObj.disabledNavButton();
		var bgImg = APP.courseDataObj.getScreenBgPath();
		var bgStyle = APP.courseDataObj.getScreenBgStyle();
		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView == 'mobile'){ 
			bgImg = ''; 			
			obj.transition = 'fadeIn'
		}
		var currScreenObj = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen[APP.navData.screenId];
		//--only fadeIn animation for 1st time OR show without animation...
		if(APP.isFirstTimeLoad){
			$('#global-bg-1').addClass('hide');
			$('#global-bg-0').attr('style', '');
			if(bgStyle != null && bgStyle !== ''){
				$('#global-bg-0').attr('style', bgStyle);
			}
			if(bgImg != null && bgImg !== ''){
				$('#global-bg-0')
				.css({
					'background-image':'url('+bgImg+')',
					'background-position': 'center'
				})
				.fadeIn();				
			}
			loadAniComplete();
			APP.isFirstTimeLoad = false;
			return false;
		}
		
		var startVal = 0;
		//--for horizontal
		var type = 'slide-x';		
		var plusEndVal = $('#app-body').width();
		var minusEndVal = -($('#app-body').width());
		//--for vertical animation
		/* var type = 'slide-y';		
		var plusEndVal = $('#app-body').height();
		var minusEndVal = -($('#app-body').height()); */
		//--for future development
		var prevScreenObj={
			moduleId: 0,
			topicId: 0,
			screenId: 0
		}
		if(APP.courseBookmark.indexOf('_') != -1){
			var t=APP.courseBookmark.split('_');
			prevScreenObj.moduleId = parseInt(t[0]);
			prevScreenObj.topicId = parseInt(t[1]);
			prevScreenObj.screenId = parseInt(t[2]);
		}
		
		if(currScreenObj.screenTransition != null && currScreenObj.screenTransition !==''){
			if(currScreenObj.screenTransition == 'fadeIn'){
				obj.transition = 'fadeIn';
			}
		}else if(prevScreenObj.moduleId == APP.navData.moduleId && prevScreenObj.topicId == APP.navData.topicId && prevScreenObj.screenId > APP.navData.screenId ){
			obj.dir = 'back';
		}else if(prevScreenObj.moduleId > APP.navData.moduleId || (prevScreenObj.moduleId == APP.navData.moduleId && prevScreenObj.topicId > APP.navData.topicId)){
			/* type = 'slide-y';		
			plusEndVal = $('#app-body').height();
			minusEndVal = -($('#app-body').height()); */
			obj.dir = 'back';
		}else if(prevScreenObj.moduleId < APP.navData.moduleId || (prevScreenObj.moduleId == APP.navData.moduleId && prevScreenObj.topicId < APP.navData.topicId)){
			/* type = 'slide-y';		
			plusEndVal = $('#app-body').height();
			minusEndVal = -($('#app-body').height()); */
			obj.dir = 'next';
		}
		//--
		var aniObjFirst={
			aniType: type,
			aniStartVal: startVal,
			aniEndVal: minusEndVal,
		}
		var aniObjSecond={
			aniType: type,
			aniStartVal: plusEndVal,
			aniEndVal: startVal,
		}

		if(obj && obj.dir === 'back'){
			aniObjFirst={
				aniType: type,
				aniStartVal: startVal,
				aniEndVal: plusEndVal,
			}
			aniObjSecond={
				aniType: type,
				aniStartVal: minusEndVal,
				aniEndVal: startVal,
			}
		}
		$('#global-bg-0').removeClass('hide');
		$('#global-bg-1').removeClass('hide');
		if(currentView == 'mobile'){ 
			$('#global-bg-0').addClass('hide');
			$('#global-bg-1').addClass('hide');
		}
		if(type == 'slide-y'){
			TweenMax.to($('#global-bg-0'), 0, 
			{x: 0, opacity: 1
			});	
			TweenMax.to($('#global-bg-1'), 0, 
			{x: 0, opacity: 1
			});	
			TweenMax.to($('#screen-container'), 0, 
			{x: 0, opacity: 1
			});	
		}else{
			TweenMax.to($('#global-bg-0'), 0, 
			{y: 0, opacity: 1
			});	
			TweenMax.to($('#global-bg-1'), 0, 
			{y: 0, opacity: 1
			});	
			TweenMax.to($('#screen-container'), 0, 
			{y: 0, opacity: 1
			});
		}
		if(obj.transition === 'fadeIn'){
			TweenMax.to($('#global-bg-0'), 0, 
			{x:0, y: 0, opacity: 1
			});	
			TweenMax.to($('#global-bg-1'), 0, 
			{x:0, y: 0, opacity: 1
			});	
			TweenMax.to($('#screen-container'), 0, 
			{x:0, y: 0, opacity: 1
			});
		}
		if(APP.gbBgIndex == 0){
			$('#global-bg-1').attr('style', '');
			if(bgStyle != null && bgStyle !== ''){
				$('#global-bg-1').attr('style', bgStyle);
			}
			var _delay = 0.5;
			if(bgImg != null && bgImg !== ''){
				$('#global-bg-1').css({
					'background-image':'url('+bgImg+')',
					'background-position': 'center'
				});	
				_delay = 0.5;
			}else{
				$('#global-bg-1').css({
					'background-image': 'none'					
				});	
				_delay = 0.5;
			}
			if(obj.transition === 'fadeIn'){
				APP.animationObj.animate({
					EL: $('#global-bg-0'),
					TYPE: 'fade-out',
					START_VAL: '1',
					END_VAL: '0',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){							
						$('#global-bg-0').css({
							'background-image':'none',							
						});	
					}
				});
				APP.animationObj.animate({
					EL: $('#screen-container'),
					TYPE: 'fade-out',
					START_VAL: '1',
					END_VAL: '0',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){							
						
					}
				});
				APP.animationObj.animate({
					EL: $('#global-bg-1'),
					TYPE: 'fade-in',
					START_VAL: '0',
					END_VAL: '1',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){
											
						loadAniComplete();
					}
				});
			}else{
				APP.animationObj.animate({
					EL: $('#global-bg-0'),
					TYPE: aniObjFirst.aniType,
					START_VAL: aniObjFirst.aniStartVal,
					END_VAL: aniObjFirst.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						
					}
				});
				APP.animationObj.animate({
					EL: $('#screen-container'),
					TYPE: aniObjFirst.aniType,
					START_VAL: aniObjFirst.aniStartVal,
					END_VAL: aniObjFirst.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						
					}
				});
				APP.animationObj.animate({
					EL: $('#global-bg-1'),
					TYPE: aniObjSecond.aniType,
					START_VAL: aniObjSecond.aniStartVal,
					END_VAL: aniObjSecond.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						loadAniComplete();
					}
				});
			}					
			APP.gbBgIndex = 1;
		}else{
			$('#global-bg-0').attr('style', '');
			if(bgStyle != null && bgStyle !== ''){
				$('#global-bg-0').attr('style', bgStyle);
			}
			var _delay = 0.5;
			if(bgImg != null && bgImg !== ''){
				$('#global-bg-0').css({
					'background-image':'url('+bgImg+')',
					'background-position': 'center'
				});
				_delay = 0.5;	
			}else{
				$('#global-bg-0').css({
					'background-image': 'none'					
				});
				_delay = 0.5;
			}
			if(obj.transition === 'fadeIn'){
				APP.animationObj.animate({
					EL: $('#global-bg-1'),
					TYPE: 'fade-out',
					START_VAL: '1',
					END_VAL: '0',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){							
						$('#global-bg-1').css({
							'background-image':'none',							
						});	
					}
				});
				APP.animationObj.animate({
					EL: $('#screen-container'),
					TYPE: 'fade-out',
					START_VAL: '1',
					END_VAL: '0',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){							
						
					}
				});	
				APP.animationObj.animate({
					EL: $('#global-bg-0'),
					TYPE: 'fade-in',
					START_VAL: '0',
					END_VAL: '1',
					EASE: 'Power1.baseOut',
					DURATION: _delay,
					ON_COMPLETE: function(){
											
						loadAniComplete();
					}
				});
			}else{
				APP.animationObj.animate({
					EL: $('#global-bg-1'),
					TYPE: aniObjFirst.aniType,
					START_VAL: aniObjFirst.aniStartVal,
					END_VAL: aniObjFirst.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						
					}
				});
				APP.animationObj.animate({
					EL: $('#screen-container'),
					TYPE: aniObjFirst.aniType,
					START_VAL: aniObjFirst.aniStartVal,
					END_VAL: aniObjFirst.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						
					}
				});	
				APP.animationObj.animate({
					EL: $('#global-bg-0'),
					TYPE: aniObjSecond.aniType,
					START_VAL: aniObjSecond.aniStartVal,
					END_VAL: aniObjSecond.aniEndVal,
					EASE: 'Power1.baseOut',
					DURATION: 1,
					ON_COMPLETE: function(){							
						loadAniComplete();
					}
				});
			}
			APP.gbBgIndex = 0;
		}
	}
	function loadAniComplete(){	
		$('#screen-container').attr('style','').html('');
		$("html, body").scrollTop(0);	
			
		updateNavCurrentScreenObj();
		APP.isMenuOpen = false;
		//-- destroying screen level vue instant
		screenVue = null;
		//--
		
		$(document).trigger(APP.eventObj.ON_SCREEN_LOADING);
		$('#screen-container').html('');
		$("html, body").scrollTop(0);

		var bgVid = APP.courseDataObj.getScreenBgVideoPath();
		//console.log('bgVid: '+bgVid)
		if(bgVid != null && bgVid !== ''){
			APP.commonFunObj.applyBgVidSource({src: bgVid});
		}else{
			$('#bg-video').addClass('hide');
		}

		var screenData = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/" + APP.navData.currentScreenObj.screenData;
		var screenView = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/" + APP.navData.currentScreenObj.screenView;

		if(APP.configObj.debugMode){
			$('#debug-screener').find('.txt').html(APP.navData.currentScreenObj.screenData);
		}
		
		var isComponent = APP.navData.currentScreenObj.isComponent || 'false';
		if(isComponent == 'false'){
			if(APP.globalXmlsObj.allScreenDataXML){
				APP.navData.currentScreenObj.xmlData = APP.commonFunObj.getScreenDataFromAllScreenDataXML({name: APP.navData.currentScreenObj.screenData});
				loadHtmlView(screenView);
			}else{
				APP.loadFilesObj.loadXML(screenData, function (_xml) {					
					//templateStarter(_xml);
					APP.navData.currentScreenObj.xmlData = _xml;
					loadHtmlView(screenView);
				});
			}
			
		}
	}
	function loadHtmlView(screenView){
		//load html view
		$('#screen-container').load(screenView, function (responseTxt, statusTxt, xhr) {
			if (statusTxt == "success") {
				$(document).trigger(APP.eventObj.ON_SCREEN_HTML_LOAD);
			}
			if (statusTxt == "error") {
				alert("An error occured: " + xhr.status + ": " + xhr.statusText+" : "+screenView);
				
			}
		});
	}
	_this.addOrRemoveNextBtnClass = function(_class, _status){
		if(_status){
			$('.btn-next').removeClass('disabled').addClass(_class);
		}else{
			$('.btn-next').removeClass(_class);
		}
	}
	_this.addOrRemoveBackBtnClass = function(_class, _status){		
		if(_status){
			$('.btn-back').removeClass('disabled').addClass(_class);
		}else{
			$('.btn-back').removeClass(_class);
		}
	}
	_this.getActualModuleCount = function(){
		//remove intro module count;
		return (_this.getModuleCount() - 1);

	}
	_this.getModuleCount = function() {
		return APP.globalXmlsObj.navigationXML.module.length;
	}

	_this.getTopicCount = function(_modId) {
		if (APP.globalXmlsObj.navigationXML.module[_modId].topic != null) {
			return APP.globalXmlsObj.navigationXML.module[_modId].topic.length;
		} else {
			return null;
		}
	}

	_this.getScreenCount = function(_modId, _topicId) {
		if (_modId >= _this.getModuleCount()) {
			return null;
		}
		return APP.globalXmlsObj.navigationXML.module[_modId].topic[_topicId].screen.length;
	}
	_this.getCourseTotScreenCount = function(){
		if(APP.globalXmlsObj.navigationXML == null){return null;}
		var modObj = APP.globalXmlsObj.navigationXML.module;
		var total = 0;
		for(var i=0; i<modObj.length; i++){
			var topicObj= modObj[i].topic;
			var type = modObj[i].moduleType || '';
			//skip logic for intro module
			if( type == 'intro'){
				continue;
			}					
			for(var j=0; j<topicObj.length; j++){
				total += topicObj[j].screen.length;			
			}
		}
		return total;
	}
	function updateNavCurrentScreenObj() {
		if(APP.globalXmlsObj.navigationXML){
			APP.navData.currentScreenObj = APP.globalXmlsObj.navigationXML.module[APP.navData.moduleId].topic[APP.navData.topicId].screen[APP.navData.screenId];
		}		
	}	
}