function ProgressBar(){
	var _this = this;
	var elementDiv = $('.circle-progress-bar');
	var horizontalProgressDiv = $('.horizontal-progress-div');

	_this.createHtml = function(_el){
		var el = _el || elementDiv;
		
		var str = '';

		str += '<div class="progress-content">';
			str += '<div class="radial">';
				str += '<span class="txt strong">0%</span>';
				str += '<div class="radial-initial-clip radial-clip" style="clip: rect(0em, 1em, 1em, 0.5em);">';
					str += '<div class="radial-bar"></div>';
					str += '<div class="radial-fill"></div>';
				str += '</div>';
			str += '</div>';
		str += '</div>';

		el.html(str);
		
	}
	_this.update = function(){
		var percentage = APP.courseDataObj.getCourseComPercentage();
		var angle = Math.round(percentage * 3.6);
		elementDiv = $('.circle-progress-bar');
		rotationUpdate(percentage, angle);
	}
	_this.rotationUpdate = function(_percentage, _angle, _el){
		var el = _el || elementDiv;	
		rotationUpdate(_percentage, _angle, el);
	}
	function rotationUpdate( _percentage, _angle, _el){	
		var el = _el || elementDiv;	
		el.find('.txt').html(_percentage + '%');
		if (_percentage > 50) {
			el.find(".radial-fill").addClass("over-50"); 
			el.find(".radial-clip").css("clip", "rect(auto, auto, auto, auto)");
		}else{
			el.find(".radial-fill").removeClass("over-50");
			el.find(".radial-clip").css("clip", "rect(0em, 1em, 1em, 0.5em)");
		}	
		var $rotate = el.find('.radial-bar');
		setTimeout(function () {	
			$rotate.css({
				'transition': 'transform 1000ms linear',
				'transform': '-webkit-rotate(' + _angle + 'deg)',
				'transform': '-ms-rotate(' + _angle + 'deg)',
				'transform': '-moz-rotate(' + _angle + 'deg)',
				'transform': 'rotate(' + _angle + 'deg)'
			});
		},1);
	}

	/* ----------------Horizontal progressbar funtions ----------------------------*/

	_this.revertHorizontalProgressBar = function(){		
		$('.horizontal-progress-panel').append(horizontalProgressDiv);
	}
	_this.addHorizontalProgressBar = function(){
		if(APP.navData.moduleId != 0){			
			var pgObj = $('#screen-container').find('.screen-data');
			if(pgObj.length){
				pgObj.append(horizontalProgressDiv);
				_this.updateHorizontalProgressBar();
			}
		}
	}
	_this.updateHorizontalProgressBar = function(){		
		//var val = APP.courseDataObj.getTopicProgress(APP.navData.moduleId,APP.navData.topicId);
    	var val = APP.courseDataObj.getCourseComPercentage();
		horizontalProgressDiv.find('.curr-strip').css('width',val+'%');
		var wd = horizontalProgressDiv.find('.highlighter').width();
		//var vleft = 'calc('+val+'% - '+wd+'px)';
		
		horizontalProgressDiv.find('.highlighter').css('left',(val - 1)+'%');
		//horizontalProgressDiv.find('.highlighter').animate({left: "'"+vleft+"'"});
	}
	_this.resetHorizontalProgressBar = function(){		
		horizontalProgressDiv.find('.curr-strip').css('width','0%');
		horizontalProgressDiv.find('.highlighter').css('left','0%');
		
	}
	
}	
