function AccordionScreen() {
	var _this = this;
	var Selector = {};
	var preloadImgArr=[];
	var popupAudio = '';
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'accordion-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_TAB_CLASS: 'tab-panel',	
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},		
			CLICK_ARRAY: [],
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			isCompleted: false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.closeAllPopup = function(_activity_container){			
		var activity_container	= _activity_container || Selector.ACTIVITY_CONTAINER;
		$(activity_container).find('.panel-group').collapse('hide');
		$(activity_container).find('.accordion-btn-panel').removeClass('current');
		$(activity_container).find('.panel-collapse').removeClass('in');
		$(activity_container).find('.click-btn').find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
	}	
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		//-- for multiple accordion in same screen.....
		accordionIndex = $(Selector.ACTIVITY_CONTAINER).data('accordion-index') || '0';
		
		$(Selector.ACTIVITY_CONTAINER).find('.accordion-panel').addClass('accordion-panel-'+accordionIndex);
		
		var panelGroup = $(Selector.ACTIVITY_CONTAINER).find('.panel-group');
		panelGroup.attr('id', 'activity-accordion-'+accordionIndex);		
		var panelId = panelGroup.attr('id');

		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_TAB_CLASS).each(function(inx){
			$(this).addClass(Selector.ACTIVITY_TAB_CLASS+'-'+accordionIndex+'_'+inx);	
			$(this).find('.accordion-btn-panel')
			.addClass('accordion-btn-panel-'+accordionIndex+'_'+inx)
			.attr('data-id', inx)
			.attr('id', 'accordion-heading-'+accordionIndex+'_'+inx);

			$(this).find('.click-btn')
			.attr('data-parent', '#'+panelId)
			.attr('href', '#accordion-collapse-'+accordionIndex+'_'+inx)
			.attr('aria-controls', 'accordion-collapse-'+accordionIndex+'_'+inx);

			$(this).find('.click-btn').find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			
			$(this).find('.panel-collapse')
			.attr('id', 'accordion-collapse-'+accordionIndex+'_'+inx)
			.attr('aria-labelledby', 'accordion-heading-'+accordionIndex+'_'+inx);
			
		});
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
	}
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_TAB_CLASS).each(function(inx){
				var btnObj = $(this).find( ".accordion-btn-panel" );
				var id = $(btnObj).data('id');
				if(Selector.userData[id] == 1){
					$(btnObj).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_TAB_CLASS).each(function(inx){
				Selector.userData.push(0);
			});
		}		
		updateStatus();
	}
	
	function addTemplateEvent() {
		
		//--for accordion minus icon
		$(Selector.ACTIVITY_CONTAINER).find('.panel-group').on('show.bs.collapse', function (e) {
			var curr = '#'+e.target.id;
			var btnObj = $(curr).siblings( ".accordion-btn-panel" )
			var id = parseInt(btnObj.data('id'));
			
			$(curr).siblings( ".accordion-btn-panel" ).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
			btnObj.addClass('visited current');
			Selector.userData[id] = 1;
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr: Selector.userData});
			}
			updateStatus();
		})
		//--for accordion plus icon
		$(Selector.ACTIVITY_CONTAINER).find('.panel-group').on('hide.bs.collapse', function (e) {			
			var curr = '#'+e.target.id;
			var btnObj = $(curr).siblings( ".accordion-btn-panel" )
			var id = parseInt(btnObj.data('id'));
			$(curr).siblings( ".accordion-btn-panel" ).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			btnObj.removeClass('current');
			//--for popup el animation
			var aniEl = $(curr).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).addClass('visibility-hidden').css('opacity', '0'); 					
				})
			}
			//--
		})
		//-- for autoscroll
		$(Selector.ACTIVITY_CONTAINER).find('.panel-group').on('shown.bs.collapse', function (e) {
			var curr = '#'+e.target.id;
			//--for pop audio
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.removeScreenAudio();
			}
			//--
			if($('body').hasClass('responsive')){
				//--check only when responsive 
				isInView = APP.commonFunObj.isElementInView($(curr));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(curr), true, 'top', -200);
				}
				
			}
			//--for popup el animation
			var aniEl = $(curr).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			//--for pop audio
			popupAudio = $(curr).data('audioPath') || '';
			//console.log('popupAudio: '+popupAudio);
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: popupAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}
			//--
		});
	}
	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
}