function FlipCardScreen() {
	var _this = this;
	var Selector = {};
	var popupAudio = '';
	var cardAniArr=[];
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'flipcard-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_CARD_CLASS: 'card',	
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},		
			CLICK_ARRAY: [],
			FLIP_TYPE:'y',
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			isCompleted: false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
		
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		//
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).each(function(inx, element){

			$(this).addClass(Selector.ACTIVITY_CARD_CLASS+'-'+inx);
			$(this).attr('data-id', inx);
			var frontCard = $(this).find(".card-front");
			var backCard = $(this).find(".card-back");
			
			//--for icons
			frontCard.find('.card-icon').addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			backCard.find('.card-icon').addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
			

		});
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
	}
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).each(function(inx){
				var btnObj = $(this);
				var id = btnObj.data('id');
				if(Selector.userData[id] == 1){
					btnObj.addClass('visited');
					
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).each(function(inx){
				Selector.userData.push(0);
			});
		}		
		updateStatus();
	}
	
	function addTemplateEvent() {	
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).hover(function(){
			if($(this).hasClass('disabled')){return false;};
				$(this).addClass('hover');
			}, function(){
				$(this).removeClass('hover');
		});
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).on('click', function(){
			APP.commonFunObj.playSoundEffect({name: 'cardFlip'});
		})
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).flip({
			axis: Selector.FLIP_TYPE,
			trigger:"click"
		});	
		
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_CARD_CLASS).on('flip:done',function(){
			var btnObj = $(this);
			var id = btnObj.data('id');
			btnObj.addClass('visited');	
			
			Selector.userData[id] = 1;
      btnObj.find('.scroll-parent').scrollTop(0);
			//--for pop audio
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.removeScreenAudio();
			}
			//--
			//--for pop audio
			popupAudio = $(btnObj).data('audioPath') || '';
			//console.log('popupAudio: '+popupAudio);
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: popupAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}
			//--
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr:Selector.userData});
			}
			updateStatus();
		});	
		
		
	}
		
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
}