function DragNDropCategoryQuestion() {
	var _this = this;
	var Selector = {};	
	var feedbackAudio = '';
	var defaultValue = -1;
	var time = new Date();
	var startTime;
	var scalex = APP.scalex || 1;
	
	APP.prevView = APP.commonFunObj.getCurrentView();

	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'dnd-category-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',						
			DRAG_ITEM_CLASS: 'drag-item',
			DROP_ITEM_CLASS: 'drop-item',	
			MOB_DRAG_ITEM_CLASS: 'mob-drag-option',		
			MOB_SEG_CONTROL_BTN_CLASS: 'seg-control-btn',		
			IS_ASSESSMENT: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			ANIMATE_INCORR_OPTION: true,
			THRESHOLD: '50%',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark',
				cross: 'icon-cross'
			},
			SUB_TYPE: '',
     		ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,
     		ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			isCompleted:false,
			queObj:null,
			dropAreaArr:[]
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
  _this.EnabledDisableDrag = function(_str){
		EnabledDisableDrag(_str);
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	function initTemplate() {		
		APP.preloaderObj.show();
		Selector.initialUserArr = [];
		Selector.isCompleted = false;
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}			
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			initialRender();
		}
	}
	function getHTML() {
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		var _className = Selector.queObj.className || "";
		var _subType = Selector.queObj.subType || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		var _colWidth = Selector.queObj.colWidth || "col-60";
		
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _subType + ' ' + _id + ' " style="' + _style + '">';	
			/* 2 */ str += '<div class="col col-text '+_colWidth+' white-alpha-bg ani-box-left">';
				str += '<div class="sb-que-ref"></div>';
				str += '<span class="ans-value-txt"></span>';
				str += '<div class="screen-title-div">';
					str += '<span class="icon font-icon icon-exercise"></span>';
					str += '<span class="title"></span>';
				str += '</div>';		
			/* 3 */str += '<div class="que-txt-panel">';
				str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);	
			/* 3 */str += '</div>';
			/* 4 */str += '<div class="option-panel">';
				var dropOptObj = Selector.queObj.dropOptions;
				var dragPanelObj = Selector.queObj.options;

				var _dpClassName = dragPanelObj[0].className || "";
				var _dpStyle = dragPanelObj[0].style || "";
				/* 4a */str += '<div class="drag-panel '+_dpClassName+'" style="'+_dpStyle+'">';			var dragObj = dragPanelObj[0].option;
					for (var k = 0; k < dragObj.length; k++) {
						var _className = dragObj[k].className || "";
						var _style = dragObj[k].style || "";
						var _txt = dragObj[k].Text;						
						var _correctId = dragObj[k].correctId.toLowerCase();						
						if (_correctId != "na") {								
							//--logic for multiple correct option
							//Selector.CORRECT_ANS_ARRAY
							var arr =_correctId.split(',');					
							for(var m=0; m<arr.length; m++){									
								if(Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])] != null && Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].constructor === Array){		
									
								}else{
									Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])]=[];							
								}
								Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].push(k);
							}
						}		
						str += '<div class="drag-item '+_className+' " style="' + _style + '">';
							str += '<div class="display-table drag-txt-panel">';
								str += '<span class="drag-txt display-cell v-center center" >'+_txt+'</span>';
								str += '<div class="btn-icon font-icon status"></div>';
							str += '</div>';
						str += '</div>';
					}
					
				/* 4a */str += '</div>';
					var _doClassName = dropOptObj[0].className || "";
					var _doStyle = dropOptObj[0].style || "";
				/* 4b */str += '<div class="drop-panel '+_doClassName+'" style="'+_doStyle+'">';	
					var dropObj = dropOptObj[0].option;	
					for (var i = 0; i < dropObj.length; i++) {						
						var _className = dropObj[i].className || "";
						var _style = dropObj[i].style || "";	
						var _maxDrop = dropObj[i].maxDrop || dragObj.length;			
						
						str += '<div class="drop-item '+_className+'" style="'+_style+'" data-max-drop="'+_maxDrop+'">';
							var txtBlockObj = dropObj[i].titleText;
							if(txtBlockObj != null){								
								str += '<div class="option-data">';
									var _cclassName = txtBlockObj[0].className || "";
									var _cstyle = txtBlockObj[0].style || "";
									var _ctxt = txtBlockObj[0].Text;
									var _ctype = txtBlockObj[0].type;
									if (_ctype == "custom") {
										str += '<div class="txt ' + _cclassName + ' custom" style="' + _cstyle + '">' + _ctxt + '</div>';
									} else {
										str += '<p class="txt ' + _cclassName + '" style="' + _cstyle + '">' + _ctxt + '</p>';
									}									
								str += '</div>';								
							}														
							str += '<div class="drag-area-panel">';	
							str += '</div>';								
						str += '</div>';
					}
				/* 4b */str += '</div>';
			/* 4 */str += '</div>';	
			/* 5 */str += '<div class="display-block submit-panel bottom-align">';			
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn " href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn additional-hint-btn " href="javascript:void(0);" >';
							str += '<span class="btn-icon font-icon icon-hint display-cell v-center center" ></span>';
							str += '<span class="btn-txt display-cell v-center center" >'+APP.globalXmlsObj.globalXML.commonText[0].getAddHintsBtnText[0].Text+'</span>';
						str += '</a>';
					str += '</div>';						
			/* 5 */str += '</div>';	
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partlycorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';
			}				
			/* 2 */str += '</div>';
			if(_colWidth != 'full'){			
				if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
					var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
					str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
				}else{
					str += '<div class="col col-blank"><p></p></div>';
				}
			}
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}

	function initialRender() {	
			
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.SUB_TYPE);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//validate CORRECT_ANS_ARRAY
		var totDrag = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).length;
		var totDrop = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).length;
		if(Selector.CORRECT_ANS_ARRAY.length != totDrop){			
			//console.error('Answer are not matched with option(s)...');
			//alert('Answer are not matched with option(s)...');
			//return false;
		}
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){	
			$(this).attr('id', Selector.DRAG_ITEM_CLASS+'_'+inx)
			.attr('data-index', inx)	
			.addClass(Selector.DRAG_ITEM_CLASS+'_'+inx);			
		});
		
		Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).each(function(inx){	
			$(this).attr('id', Selector.DROP_ITEM_CLASS+'_'+inx)
			.attr('data-index', inx)
			.addClass(Selector.DROP_ITEM_CLASS+'_'+inx);			
			Selector.initialUserArr.push(defaultValue);	
			//--create drag-area <div class="drag-area"></div>
				var len = $(this).data('max-drop') || (totDrag);
				for(var m = 0; m<len; m++){
					var temp = '<div class="drag-area drag-area_'+inx+'-'+m+'" data-drop-index="'+inx+'" data-area-index="'+m+'"></div>';
					$(temp).appendTo($(this).find('.drag-area-panel'));
				}
			//--
		});
		//for mobile
		//MOB_DRAG_ITEM_CLASS: 'mob-drag-option',		
		//MOB_SEG_CONTROL_BTN_CLASS: 'seg-control-btn',
		Selector.queDivObj.find('.'+Selector.MOB_DRAG_ITEM_CLASS).each(function(inx){	
			$(this).attr('id', Selector.MOB_DRAG_ITEM_CLASS+'_'+inx);
			$(this).addClass(Selector.MOB_DRAG_ITEM_CLASS+'_'+inx);
			$(this).attr('data-index', inx);	
			var segmentedObj = $(this).find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS);
			$(this).find('.highlighter').addClass('len-'+segmentedObj.length);						
			if(segmentedObj.length){
				segmentedObj.each(function (cnx){
					$(this).addClass(Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+inx+'-'+cnx).attr('data-row-id', inx).attr('data-col-id', cnx);					
				})
			}		
		});

		//--
		Selector.answerArray = Selector.CORRECT_ANS_ARRAY.slice();
		
		initOptionData();
		//-- for better animation when SHOW_PREVIOUS_SELECTION is true
		if (!Selector.IS_ASSESSMENT) {
			loadPrevUserData();
			updateTemplateLayout();
			addTemplateEvent();	
		}else{
			//listen APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE event below
		}
		APP.preloaderObj.hide();	
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}	
	}
	function initOptionData(){
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
			Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).shuffle();
			Selector.queDivObj.find('.'+Selector.MOB_DRAG_ITEM_CLASS).shuffle();
		}
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){				
			$(this).data({
                'refId': $(this).data('index'),
				'dropBoxId': null,
				'dropAreaId': null,
				'origLeft': 0,
                'origTop': 0                
            });
			$(this).css('z-index', (inx+1));
		});		
		Selector.dropAreaArr = [];
		Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).each(function(inx){				
			$(this).data({
                'refId': inx						
			});
			Selector.dropAreaArr[inx] = [];
			$(this).find('.drag-area').each(function(jnx){				
				Selector.dropAreaArr[inx][jnx] = {
					'dropId': inx,
					'areaId': jnx,
					'isOccupied': false,
					'el': null,
					'elId': defaultValue
				}
			});
						
		});	
		
		showAnsValue();
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;
		var $ansTxt=Selector.queDivObj.find('.ans-value-txt');
		
		if(cheatMode){			
			var showAns = '';	
			for(var i =0; i<Selector.answerArray.length; i++){
				var currArr = Selector.answerArray[i];				
				for(var j =0; j<currArr.length; j++){
					var te = currArr[j];					
					Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){
						
						if($(this).data('index') == te){							
							showAns+= inx;							
						}					
					})
					if(j != currArr.length - 1){
						showAns+= ',';
					}
					//for mobile
					Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+te+'-'+i).addClass('ref-corr');					
				}
				if(i != Selector.answerArray.length - 1){
					showAns+= '::';
				}				
			}		
			//$ansTxt.show();
			$ansTxt.html(showAns);
		}else{			
			$ansTxt.hide();
		}
	}
	function loadPrevUserData(){
		var $dropBox = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS);
		if (Selector.IS_ASSESSMENT && assessmentQuizObj.dataReviewMode) {			
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					newArr.push(tempAnsArr[i].split(','));					
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			if (Selector.queObj.dataUserArray != null) {	
				// for multi multidimensional array					
				var tempUsArr = Selector.queObj.dataUserArray.split('^');
				var newArr1 = [];
				for(var i=0; i<tempUsArr.length; i++){
					newArr1.push(tempUsArr[i].split(','));
				}
				Selector.userArray = newArr1;		
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		//--previous position not shown due to animation...
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !=''){
			applySelection();
			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}	
		initQuestion();		
	}
	function applySelection(){
		for(var i=0; i<Selector.userArray.length; i++){		
			var currUa = Selector.userArray[i];				
			for(var j=0; j<currUa.length; j++){						
				if (currUa[j] != defaultValue) {
					Selector.dropAreaArr[i][j].isOccupied = true;
					Selector.dropAreaArr[i][j].el = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+currUa[j]);
					Selector.dropAreaArr[i][j].elId = currUa[j];
					//for mobile
					var segBtn = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+currUa[j]+'-'+i)
					selectSegmentedBtn(segBtn);								
				}
			}	
			animateDroppedElement(i);			
		}
	}
	function initQuestion(){		
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.reset-btn', false);
		updateValue();		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			applySelection();
			processSubmit({feedbackAni:true});			
		}
	}); 
	function addTemplateEvent() {
		
		var dragBox = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS);
		var dropBox = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS);
		dragBox.hover(function(){
			if($(this).hasClass('disabled')){return false;};
				$(this).addClass('hover');
				
			}, function(){
				$(this).removeClass('hover');
		});
		dragBox.on('click',function(){
			if($(this).hasClass('disabled')){return false;};
			//$(this).addClass('hover');
			
		});
		var animation = null;
		 Selector.draggables = Draggable.create(dragBox, {
			type:"x,y",
			bounds: Selector.queDivObj,
			cursor:"grab",
			zIndexBoost: true,
			throwProps:true,
			//--for mobile autoScroll
			autoScroll:1,
			onDragStart: function() {	
				animation = TweenMax.to($(this.target), 0.3, {
					boxShadow: "rgba(0,0,0,0.2) 0px 16px 32px 0px",
					force3D: true,
					scale: 1.0,
					paused: true
				  });
				  animation.play();	
				$(this.target).css('cursor','grabbing');		
				var dropBoxId = $(this.target).data('dropBoxId');				
				var dropAreaId = $(this.target).data('dropAreaId');				
				$(this.target).removeClass('dropped');
				$(this.target).data('dropBoxId', null);    
				$(this.target).data('dropAreaId', null);  
                if (dropBoxId != null && dropAreaId != null )
                {
					rearrangeDroppedElement(dropBoxId, dropAreaId);					
                }				           
			},
			onDrag: function() {
				for (var i = 0; i < dropBox.length; i++) { 					
					if (this.hitTest(dropBox[i], Selector.THRESHOLD)) {		
						$(this.target).data('dropBoxId', $(dropBox[i]).data('refId'));
						return;
					}else{
						$(this.target).removeClass('dropped');
						$(this.target).data('dropBoxId', null);
						$(this.target).data('dropAreaId', null);
					}
					
				}
				
			},
			onRelease: function() {
				if(animation){animation.reverse();}				
			},			
			onDragEnd:function() {				
				var dataDropBoxId = $(this.target).data('dropBoxId');				
				var x = 0;
				var y = 0;
				APP.commonFunObj.playSoundEffect({name: 'dragNDrop'});
				var dropAreaId = findAvlDropAreaIndex(dataDropBoxId);
				if (dataDropBoxId != null && dropAreaId != null){	
					Selector.dropAreaArr[dataDropBoxId][dropAreaId].isOccupied = true
					Selector.dropAreaArr[dataDropBoxId][dropAreaId].el = $(this.target)
					Selector.dropAreaArr[dataDropBoxId][dropAreaId].elId = $(this.target).data('refId')
					animateDroppedElement(dataDropBoxId);									
				}else {					
					TweenMax.to(this.target,0.3,{
						x:$(this.target).data('origLeft'),
						y:$(this.target).data('origTop')
					});
					
                    $(this.target).removeClass('dropped');					
					$(this.target).data('dropBoxId', null);
					$(this.target).data('dropAreaId', null);
				}
				
				updateValue();
			}
		});
		//for mobile
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).on('click', function(){
			if($(this).hasClass('selected') || $(this).hasClass('disabled')){return false;};
			selectSegmentedBtn($(this));
			updateValue();		
		});
		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			Selector.IS_SUBMIT_CLICK = 'cl';
			processSubmit({feedbackAni:true});				
			
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.reset-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetDragItem();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function selectSegmentedBtn(_btnObj){
		if($(_btnObj).hasClass('selected') || $(_btnObj).hasClass('disabled')){return false;}
		var rowId = parseInt($(_btnObj).data('row-id'));
		var colId = parseInt($(_btnObj).data('col-id'));
		var parentObj = $(_btnObj).parents('.'+Selector.MOB_DRAG_ITEM_CLASS);
		var trasVal = (colId)+'00%';
		parentObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).removeClass('selected');
		$(_btnObj).addClass('selected');
		
		parentObj.find('.highlighter').show().css({
			'-webkit-transform' : 'translateX('+trasVal+')',
			'-moz-transform'    : 'translateX('+trasVal+')',
			'-ms-transform'     : 'translateX('+trasVal+')',
			'-o-transform'      : 'translateX('+trasVal+')',
			'transform'         : 'translateX('+trasVal+')'
		});
	}
	 
	function rearrangeDroppedElement(_dropBoxId, _dropAreaId){		
		if(_dropBoxId != null && _dropAreaId != null){
			//remove entry
			Selector.dropAreaArr[_dropBoxId].splice(_dropAreaId, 1);
			//add null entry to end
			var lst = Selector.dropAreaArr[_dropBoxId].length;
			Selector.dropAreaArr[_dropBoxId][lst]={
				'dropId': _dropBoxId,
				'areaId': lst,
				'isOccupied': false,
				'el': null,
				'elId': defaultValue
			}	
			for(var i=0; i<Selector.dropAreaArr[_dropBoxId].length; i++){
				var curr = 	Selector.dropAreaArr[_dropBoxId][i];
				curr.areaId = i;
			}
			animateDroppedElement(_dropBoxId);		
		}

	}

	function animateDroppedElement(_dropBoxId){		
		for(var i=0; i<Selector.dropAreaArr[_dropBoxId].length; i++){				
			var curr = 	Selector.dropAreaArr[_dropBoxId][i];			
			var el = curr.el;
			if(el != null){
				$(el).addClass('dropped');
				$(el).data('dropBoxId', curr.dropId);
				$(el).data('dropAreaId', curr.areaId);
				var dropArea = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).eq(curr.dropId).find('.drag-area').eq(curr.areaId);
				
				var rect1 = $(el).get(0).getBoundingClientRect();			
				var rect2 = $(dropArea).get(0).getBoundingClientRect();			
				x = "+=" + (rect2.left/scalex - rect1.left/scalex);
				y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
			
				TweenMax.to($(el), 0.3, {
					x: x,
					y: y
				});
			}
		}
	}
	function findAvlDropAreaIndex(_dropBoxId){
		var avl = null;
		if(_dropBoxId == null){
			return avl;
		}		
		for(var i=0; i<Selector.dropAreaArr[_dropBoxId].length; i++){				
			var isOccupied = Selector.dropAreaArr[_dropBoxId][i].isOccupied;
			if(isOccupied == false){
				avl = i;
				break;
			}
		}
		return avl;
	}
	function updateUserArray(){
		Selector.userArray = Selector.initialUserArr.slice();

		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView == 'mobile'){
			btnObj = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS);
			btnObj.each(function(inx){
				if($(this).hasClass('selected')){
					var rowId = parseInt($(this).data('row-id'));
					var colId = parseInt($(this).data('col-id'));
					if(Selector.userArray[colId] != null && Selector.userArray[colId].constructor === Array){		
							
					}else{
						Selector.userArray[colId]=[];							
					}					
					Selector.userArray[colId].push(rowId);
				}
			})
		}else{		
			for(var i=0; i<Selector.dropAreaArr.length; i++){
				Selector.userArray[i] = [];
				for(var j=0; j<Selector.dropAreaArr[i].length; j++){
					var curr = Selector.dropAreaArr[i][j];		
					//put initial - 1
					if(j == 0){
						Selector.userArray[i][j] = curr.elId;
					}		
					if(curr.isOccupied === true){
						Selector.userArray[i][j] = curr.elId;
					}				
				}
			}
		}
		
	}
	function updateValue(){	
		updateUserArray();	
		removeDropAction();
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){	
		var selectedItemLen = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS+'.dropped').length;	
		var totalItemLen = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).length;

		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView == 'mobile'){
			selectedItemLen = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'.selected').length;	
			totalItemLen = Selector.queDivObj.find('.'+Selector.MOB_DRAG_ITEM_CLASS).length;
			
		}		
		if(selectedItemLen >= totalItemLen){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
		if(selectedItemLen >= 1){
			EnabledDisabledBtn('.reset-btn', true);
		}
		
	}	
	function EnabledDisabledBtn(_div, _val, _state){
		var state = '';
		if(_state){
			state = _state;
		}
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn' && state == ''){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function EnabledDisableDrag (_val){
		if(Selector.draggables){
			for(var i =0; i<Selector.draggables.length; i++){
				var curr = Selector.draggables[i];
				if(_val){
					curr.enable();
					$(curr.target).removeClass('disabled');
				}else{					
					curr.disable();
					$(curr.target).addClass('disabled');
				}
			}
		}		
	}
	function removeDropAction(){
		if(Selector.SUB_TYPE == 'single-drag'){
			if(Selector.draggables){
				for(var i =0; i<Selector.draggables.length; i++){
					var curr = Selector.draggables[i];
					if($(curr.target).hasClass('dropped')){
						curr.disable();
					}										
									
				}
			}
		}		
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: 0
		}
		
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			obj.totalCorrCount += crrArr.length;
			for (var j = 0; j < currUa.length; j++) {
				var found = false;				
				for (var m = 0; m < crrArr.length; m++) {					
					if (currUa[j].toString() == crrArr[m].toString()) {						
						obj.corrCount += 1;	
						found = true;
						break;
					}
				}
				if(!found){					
					if (currUa[j].toString().indexOf(defaultValue) == -1) {
						obj.inCorrCount += 1;
					}
				}
			}			
		}		
	
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisabledBtn('.reset-btn', false);
		EnabledDisableDrag(false);
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).addClass('disabled');
		//for mobile
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).addClass('disabled');
		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			showFeedback(_obj.feedbackAni);	
		}else{
			//no feedback
		}	
		
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
		updateStatus();
	}
	function showFeedback(isAni){
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.FEEDBACK_STATE == 'corr'){
			soundName ='correct'
			Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
		}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
			soundName ='incorrect'			
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
		}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
			soundName ='incorrect'				
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
			if(plfObj.length){
				currFeedback = plfObj;
			}else if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}					
			
		}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){
			soundName ='incorrect'					
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
			if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}								
			
		}else{
			soundName ='incorrect'	
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
		}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		aniObj.ON_COMPLETE = function(){
			$(currFeedback).find('.scroll-parent').scrollTop(0);
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}
		}
		
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}			
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}		
			APP.eventObj.applyGbPopCloseEvent();							
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			
			if($('body').hasClass('responsive')){	
				//--check only when responsive 	
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}		
				
			}			
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
		
		
	}
	
	function resetQuestion(){
		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).removeClass('selected corr-ans tick cross disabled dropped');
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');
		$(Selector.FEEDBACK_CONTAINER).hide();
		//for mobile
		Selector.queDivObj.find('.'+Selector.MOB_DRAG_ITEM_CLASS).find('.highlighter').hide().css({
			'-webkit-transform' : 'translateX(-100%)',
			'-moz-transform'    : 'translateX(-100%)',
			'-ms-transform'     : 'translateX(-100%)',
			'-o-transform'      : 'translateX(-100%)',
			'transform'         : 'translateX(-100%)'
		});
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).removeClass('selected corr-ans tick cross disabled');
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');

		EnabledDisableDrag(true);
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		Selector.userArray = Selector.initialUserArr.slice();
		
			Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){
				TweenMax.to($(this),0.3,{
					x:$(this).data('origLeft'),
					y:$(this).data('origTop'),
					onComplete: function(){
						initOptionData();		
						initQuestion();	
					}
				});
			})	
			if (Selector.ON_TRY_AGAIN) {
				Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
			}	
	}
	function resetDragItem(){
		
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).removeClass('selected corr-ans tick cross disabled dropped');
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');
		
		Selector.queDivObj.find('.'+Selector.MOB_DRAG_ITEM_CLASS).find('.highlighter').hide().css({
			'-webkit-transform' : 'translateX(-100%)',
			'-moz-transform'    : 'translateX(-100%)',
			'-ms-transform'     : 'translateX(-100%)',
			'-o-transform'      : 'translateX(-100%)',
			'transform'         : 'translateX(-100%)'
		});
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).removeClass('selected corr-ans tick cross disabled');
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');

		EnabledDisableDrag(true);		
		Selector.userArray = Selector.initialUserArr.slice();
		
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){
			TweenMax.to($(this),0.3,{
				x:$(this).data('origLeft'),
				y:$(this).data('origTop'),
				onComplete: function(){
					initOptionData();		
					initQuestion();	
				}
			});
		})	
		if (Selector.ON_RESET) {
			Selector.ON_RESET({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
	}
	function showAnswer(){	
		
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView=='mobile'){
			for(var i=0; i<Selector.answerArray.length; i++){	
				var crrArr = Selector.answerArray[i];	
				for (var j = 0; j < crrArr.length; j++) {
					//for mobile
					var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+crrArr[j]+'-'+i;
					Selector.queDivObj.find(segBtn).addClass('corr-ans tick');
					Selector.queDivObj.find(segBtn).find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.removeClass('i-cross')
					.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.addClass('i-tick');	
				}
			}
		}else{
			//to hide status icon
			Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').addClass('visibility-hidden');

			var $dropBox = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS);
			//revert incorrect drag to original position	
			for(var i=0; i<Selector.userArray.length; i++){
				for(var j=0; j<Selector.userArray[i].length; j++){
					if(Selector.userArray[i][j] != defaultValue){
						if (Selector.answerArray.toString().indexOf(Selector.userArray[i][j].toString()) ==  -1) {
							var incorrDrag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+Selector.userArray[i][j]);
							TweenMax.to($(incorrDrag),0.3,{
								x:$(incorrDrag).data('origLeft'),
								y:$(incorrDrag).data('origTop'),							
							});
						}
					}
				}			
			}	
			//--change position for correct drop and also as difficult to rearrange others
			for(var i=0; i<Selector.answerArray.length; i++){	
				var crrArr = Selector.answerArray[i];	
				for (var j = 0; j < crrArr.length; j++) {				
					var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+crrArr[j]);
					var drop = $dropBox.eq(i);
					var x=0;
					var y=0;
					
					var rect1 = $(drag).get(0).getBoundingClientRect();					
					var rect2 = $(drop).find('.drag-area').get(j).getBoundingClientRect();
					
					x = "+=" + (rect2.left/scalex - rect1.left/scalex);
					y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
					
					TweenMax.to(drag, 0.3, {
						x: x,
						y: y
					});		
					
				}			
			}		
		}
	}
	function showUserSelection(){
		
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);
		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView=='mobile'){
			//for mobile
			var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS;
			Selector.queDivObj.find(segBtn).removeClass('corr-ans tick cross');
			Selector.queDivObj.find(segBtn).find('.status')
			.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
			.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
			.removeClass('i-tick i-cross visibility-hidden');
			showTickCorss();
		}else{
			var $dropBox = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS);	
			//revert correct drag to original position
			for(var i=0; i<Selector.answerArray.length; i++){
				var crrArr = Selector.answerArray[i];				
				for(var j=0; j<crrArr.length; j++){
					var found = false;
					for(var k=0; k<Selector.userArray.length; k++){	
						var currUa = Selector.userArray[k];
						for(var m=0; m<currUa.length; m++){	
							if (currUa[m] != defaultValue) {	
								if (currUa[m] == crrArr[j]) {
									found = true;
									break
								}
							}
						}
						if(found){
							break;
						}
					}
					if(!found){					
						var corrDrag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+crrArr[j]);
						TweenMax.to($(corrDrag),0.3,{
							x:$(corrDrag).data('origLeft'),
							y:$(corrDrag).data('origTop'),
							
						});
					}				
				}			
			}		
					
			for(var i=0; i<Selector.userArray.length; i++){		
				var currUa = Selector.userArray[i];
				for(var j=0; j<currUa.length; j++){	
					if (currUa[j] != defaultValue) {	
						var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+currUa[j]);
						var drop = $dropBox.eq(i);
						var x=0;
						var y=0;
						
						var rect1 = $(drag).get(0).getBoundingClientRect();					
						var rect2 = $(drop).find('.drag-area').get(j).getBoundingClientRect();
						
						x = "+=" + (rect2.left/scalex - rect1.left/scalex);
						y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
						
						TweenMax.to(drag, 0.3, {
							x: x,
							y: y,
							onComplete: function(){
								//to show status icon
								Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').removeClass('visibility-hidden');			
							}
						});	
						
					}
				}				
			}
		}	
	}
	function showTickCorss(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			for (var j = 0; j < currUa.length; j++) {
				var found = false;				
				for (var m = 0; m < crrArr.length; m++) {					
					if (currUa[j].toString() == crrArr[m].toString()) {						
						var curr = Selector.queDivObj.find('.drag-item[data-index="'+currUa[j]+'"]');
						curr.addClass('tick')
						curr.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.removeClass('i-cross')
						.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
						.addClass('i-tick');
						//for mobile
						var segBtn = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+currUa[j]+'-'+i);
						segBtn.addClass('tick')
						segBtn.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.removeClass('i-cross')
						.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
						.addClass('i-tick');

						found = true;
						break;
					}
				}
				if(!found){					
					if (currUa[j].toString().indexOf(defaultValue) == -1) {
						var curr = Selector.queDivObj.find('.drag-item[data-index="'+currUa[j]+'"]');
						curr.addClass('cross')
						curr.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
						.removeClass('i-tick')
						.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.addClass('i-cross');

						//for mobile
						var segBtn = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+currUa[j]+'-'+i);
						segBtn.addClass('cross')
						segBtn.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
						.removeClass('i-tick')
						.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.addClass('i-cross');
					}
				}
			}	
		}		
		
	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			for (var j = 0; j < currUa.length; j++) {
				var found = false;				
				for (var m = 0; m < crrArr.length; m++) {					
					if (currUa[j].toString() == crrArr[m].toString()) {						
						
						found = true;
						break;
					}
				}
				if(!found){					
					if (currUa[j].toString().indexOf(defaultValue) == -1) {
						var incorrOpt = Selector.queDivObj.find('.drag-item[data-index="'+currUa[j]+'"]');
						
						APP.animationObj.animate({
							EL: incorrOpt,
							TYPE: 'shake-x',
							START_VAL: '+=10',						
							YOYO:true,
							REPEAT:3,
							STAGGER: false,
							DURATION: 0.1,
							ON_COMPLETE: function(){
								
							}
						});
						//for mobile
						var segBtn = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+currUa[j]+'-'+i);
						
					}
				}
			}	
		}	
	}
	function updateStatus() {
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode && !Selector.queObj.dataIsUserOptionSelected) {
			Selector.queObj.dataUserArray = Selector.userArray.join("^");
			Selector.queObj.dataAnswerArray = Selector.answerArray.join("^");
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				for (var j = 0; j < Selector.userArray[i].length; j++) {
					if (Selector.userArray[i][j] != defaultValue) {
						anySelect = true;
						break;
					}
				}
				if(anySelect){
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			/* var obj = {
				corrCount: 0,
				inCorrCount: 0,
				allCorrected: false,
				totalCorrCount: 0
			   } */
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partlyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
					
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
	
	function updateTemplateLayout() {
		scalex = APP.scalex || 1;	
	}	
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
		//reload screen as difficult to maintain 2 view
		/* var currentView = APP.commonFunObj.getCurrentView();
		
		if(APP.prevView != currentView){
			if(APP.globalModalObj){
				var currClass = APP.globalModalObj.getClassName();
				if(currClass == 'additional-hints-pop'){
					//--for responsive
					$('body').removeClass('modal-open');
					//--
					APP.globalMessageOpen = false;				
					$('#global-modal-pop').attr('class', 'global-modal-pop');
					$('#global-modal-pop').attr('style', '');
					$('#global-modal-pop').html('');
					APP.globalModalObj = null;					
				}
			}
			APP.navigationObj.loadScreen(true);
		} */
	});
		
	$(document).one(APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE, function (e) {
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
	});
}