function McqMrqQuestion() {
	var _this = this;
	var Selector = {};
	var feedbackAudio = '';
	var time = new Date();
	var startTime;
	var mcqIconObj = {
		optNormal: "icon-radio-unchecked",
		optSelected: "icon-radio-checked"
	}
	var mrqIconObj = {
		optNormal: "icon-checkbox-unchecked",
		optSelected: "icon-checkbox-checked"
	}
	var imgIcon = {
		tick: 'content/images/'+APP.configObj.language.dir+'/icon_tick.svg',
		cross: 'content/images/'+APP.configObj.language.dir+'/icon_cross.svg'
		
	}
	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {			
			CLASS_NAME: 'mcq-mrq-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',			
			TYPE: 'mcq',
			SUBTYPE: '',
			IS_ASSESSMENT: false,
			IS_PRE_TEST: false,
			COMMON_SFX: false,
			CURRENT_QUESTION: 0,
			ENABLE_SUBMIT_COUNT: null,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			SHOW_CORR_ANS_ON_SUBMIT: false,
			IS_OPTIONWISE_FEEDBACK: false,
			ANIMATE_INCORR_OPTION: true,
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark',
				cross: 'icon-cross'
			},
			QUE_IMAGES_PRE_PATH: '',
			QUE_SVG_IMG_PRE_PATH: '',
			SUBMIT_ON_OPTION_CLICK: false,
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_SHOW_ME: null,
			ON_CLICK: null,
			ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			QUE_INTRACTION_OBJ: {},
			SEND_INTRACTION: false,
			isCompleted:false,
			queObj:null,
			

		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	_this.processSubmit = function(){
		processSubmit({feedbackAni:true, autoOpen:false});
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];		
		Selector.isCompleted = false;	
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}
				
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			//-- for inline cmi intraction
			startTime = time;
			initialRender();
		}		
	}
	
	function getHTML() {
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		//this is for global images
	/* 	if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
			var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
			$('#global-bg').css({
				'background-image':'url('+path+')',
				'background-position': 'center'
			});
		} */
		var _className = Selector.queObj.className || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;	
		var _colWidth = Selector.queObj.colWidth || "col-60";	
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _id + ' " style="' + _style + '">';
		/* 2 */ str += '<div class="col col-text white-alpha-bg '+_colWidth+' ani-box-left" >';
		/* 2a */ str += '<div class="text-box padding " >';
				str += '<div class="sb-que-ref"></div>';
				str += '<div class="screen-title-div">';
					str += '<span class="title"></span>';
				str += '</div>';				
		/* 3 */str += '<div class="que-txt-panel">';		
					str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);
			/* 3 */str += '</div>';
			/* 4 */str += '<div class="que-options">';		
				var optObj = Selector.queObj.options[0].option;
				var optLen = optObj.length;
				for (var i = 0; i < optLen; i++) {					
					var _className = optObj[i].className || "";
					var _style = optObj[i].style || "";
					var _txt = optObj[i].Text;
					var isCorrect = optObj[i].isCorrect == "true" ? 1 : 0;
					Selector.CORRECT_ANS_ARRAY.push(isCorrect);
					//check if img option
					//--for normal image
					var _optImgPath = optObj[i].optImgPath;
					//--for text svg
					var _optImgPath_Svg = optObj[i].optImgPath_Svg;
					var _optImg = '';
					var _classObj = {
						firstClass: "",
						secondClass: "",
						magnifyClass: "",
					}
					if(_optImgPath != null && _optImgPath != ''){
						_optImg = Selector.QUE_IMAGES_PRE_PATH + _optImgPath;
						_classObj.firstClass = 'img-box';						
						_classObj.secondClass = 'normal-img';						
					}
					if(_optImgPath_Svg != null && _optImgPath_Svg != ''){
						_optImg = Selector.QUE_SVG_IMG_PRE_PATH + _optImgPath_Svg;
						_classObj.firstClass = 'svg-img-box';
						_classObj.secondClass = 'svg-img';
					}
					var _showMagnify = optObj[i].showMagnify;
					if(_showMagnify === 'true'){
						_classObj.magnifyClass = 'magnify';
					}
					if(_optImg != null && _optImg != ''){
						str += '<a class="btn option-item opt-with-img ' + _className + ' ' + _classObj.firstClass + ' ' + _classObj.magnifyClass + '" style="' + _style + '"  href="javascript:void(0)">';
							if(_showMagnify === 'true'){
								str += '<div class="top-div">';
									str += '<div class="magnify-box" data-id="mgp_'+i+'">';
										str += '<span class="magnify-icon font-icon icon-magnify "></span>';
									str += '</div>';	
								str += '</div>';
							}
							str += '<img class="img-tag '+ _classObj.secondClass +'" src="'+_optImg+'" alt="">';
							str += '<div class="bottom-div">';
								str += '<div class="status-cell">';
									str += '<span class="btn-icon font-icon status"></span>';
								str += '</div>'; 
								str += '<div class="opt-cell">';
									str += '<div class="btn-icon font-icon icon"></div>';
								str += '</div>';	
							str += '</div>';
							if(_txt != null && _txt != ''){
								str += '<div class="btn-text" >' + _txt + '</div>';
							}							
						str += '</a>';
					}else{
						str += '<a class="btn option-item display-table ' + _className + '" style="' + _style + '"  href="javascript:void(0)">';
						str += '<div class="display-cell status-cell v-center">';
							str += '<span class="btn-icon font-icon status"></span>';
						str += '</div>'; 
							str += '<div class="display-cell opt-cell v-center">';
								str += '<div class="btn-icon font-icon icon"></div>';
							str += '</div>';
							str += '<div class="display-cell btn-text v-center left" >' + _txt + '</div>';
						str += '</a>';
					}
				}
				
			/* 4 */str += '</div>';
			str += '<p class="instr-txt screen-comp-instr-txt hide" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].nextQueInstr[0].Text+'</p>';
			/* 5 */str += '<div class="display-block submit-panel bottom-align">';			
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn " href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';
											
			/* 5 */str += '</div>';	
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);	
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partlycorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';	
			}	
			//--for magnify popup			
			for (var j = 0; j < optLen; j++) {
				var _showMagnify = optObj[j].showMagnify;
				var _magnifyPopClass = optObj[j].magnifyPopClass || '';
				//check if img option
				//--for normal image
				var _optImgPath = optObj[j].optImgPath;
				//--for text svg
				var _optImgPath_Svg = optObj[j].optImgPath_Svg;
				var _optImg = '';
				
				if(_optImgPath != null && _optImgPath != ''){
					_optImg = Selector.QUE_IMAGES_PRE_PATH + _optImgPath;
				}
				if(_optImgPath_Svg != null && _optImgPath_Svg != ''){
					_optImg = Selector.QUE_SVG_IMG_PRE_PATH + _optImgPath_Svg;
				}
				if(_showMagnify === 'true' && _optImg !=null && _optImg !=''){				
					/* 7 */str += '<div class="popup screen-modal-pop magnify-pop magnify-pop_'+j+' '+_magnifyPopClass+'" data-id="mgp_'+j+'" data-animate-type="fade-in-bottom" data-animate-val="20px">';
						/* 8 */str += '<div class="modal-box">';
							/* 9 */str += '<div class="modal-alert " >';
								/* 10 */str += '<div class="popup-titlebar" >';
									str += '<a class=" btn popup-btn close-popup-btn" href="javascript:void(0);" >';
										str += '<span class="btn-icon font-icon icon-cross display-cell v-center"></span>';
									str += '</a>';												
								/* 10 */str += '</div>';
								/* 11 */str += '<div class="popup-content-box ">';
									str += '<div class="pop-col pop-col-text full titlebar-space" >';
										str += '<div class="scroll-parent ">';
											str += '<div class="scrollable">';
												str += '<div class="svg-img-box">';
													str += '<img class="svg-img" src="'+_optImg+'" alt="">';
												str += '</div>';	
											str += '</div>';
										str += '</div>';
									str += '</div>';											
								/* 11 */str += '</div>';									
							/* 9 */str += '</div>';
						/* 8 */str += '</div>';
					/* 7 */str += '</div>';
				}
			}
		/* 2a */str += '</div>';
		/* 2 */str += '</div>';
		if(_colWidth != 'full'){			
			if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
				var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
				str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
			}else{
				str += '<div class="col col-blank"><p></p></div>';
			}
		}			
		/* 1 */str += '</div>';
		
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}
	function initialRender(){
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//validate CORRECT_ANS_ARRAY
		var totOpt = Selector.queDivObj.find('.option-item').length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		//check type
		var corrCount = 0;
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){
			var curr = Selector.CORRECT_ANS_ARRAY[i];
			if(curr == 1){
				corrCount++;
			}
		}
		if(corrCount > 1){
			Selector.TYPE = 'mrq';
			Selector.FONT_ICON_CLASS_OBJ.optNormal = mrqIconObj.optNormal;
			Selector.FONT_ICON_CLASS_OBJ.optSelected = mrqIconObj.optSelected;
		}else{
			Selector.TYPE = 'mcq';
			Selector.FONT_ICON_CLASS_OBJ.optNormal = mcqIconObj.optNormal;
			Selector.FONT_ICON_CLASS_OBJ.optSelected = mcqIconObj.optSelected;	
		}
		Selector.queDivObj.addClass(Selector.TYPE);
		//options
		//-- for inline cmi intraction
		Selector.QUE_INTRACTION_OBJ.type = Selector.TYPE; 
		Selector.QUE_INTRACTION_OBJ.options = [];
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		//--
		Selector.queDivObj.find('.option-item').each(function(inx){	
			Selector.initialUserArr[inx] = 0;
			$(this).attr('data-id', inx).addClass('option-item_'+inx);
			//set normal icon
			$(this).find('.opt-cell').find('.icon').addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
			//-- for inline cmi intraction
			Selector.QUE_INTRACTION_OBJ.options[inx] = $(this).find('.btn-text').text();
			//--
		});
		//apply ref-corr class
		var cheatMode = APP.configObj.cheatMode;
		if(cheatMode){
			var corrClass = 'ref-corr';
			Selector.queDivObj.find('.option-item').each(function(inx){	
				if(Selector.CORRECT_ANS_ARRAY[inx] == 1){
					$(this).addClass(corrClass);
				}
			});
		}
		//-- for better animation when SHOW_PREVIOUS_SELECTION is true
		//if (!Selector.IS_ASSESSMENT) {
			loadPrevUserData();
			updateTemplateLayout();
			addTemplateEvent();	
		/* }else{
			//listen APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE event below
		} */
		
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}
	}
	function loadPrevUserData(){
		
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			if (Selector.queObj.dataAnswerArray != null) {
				Selector.CORRECT_ANS_ARRAY = Selector.queObj.dataAnswerArray;
			}
			if (Selector.queObj.dataUserArray != null) {
				Selector.userArray = Selector.queObj.dataUserArray;				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){			
			Selector.queDivObj.find('.option-item').each(function(inx){	
				var _id = parseInt($(this).data('id'));					
				var currVal = Selector.userArray[_id];				
				if(currVal == 1){
					$(this).addClass('selected');				
					$(this).find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);	
				}				
			});			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}
		
		initQuestion();
		
	}
	function initQuestion(){
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
			Selector.queDivObj.find('.option-item').shuffle();
		}		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.view-feedback-btn', false);
		updateValue();

		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:false});
			}
		} */
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;
			processSubmit({feedbackAni:true});	
					
		} */
		
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;	
			if(Selector.IS_PRE_TEST){
				processSubmit({feedbackAni:true, autoOpen:true});
			}else{
				processSubmit({feedbackAni:true, autoOpen:true});
			}
				
			
		}
	});
	function addTemplateEvent() {
		Selector.queDivObj.find('.option-item').on('click', function(){
			if($(this).hasClass('disabled')){return false;};				
			selectOption($(this));					
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};
			Selector.IS_SUBMIT_CLICK = 'cl';					
			processSubmit({feedbackAni:true, autoOpen:true});		
			
		})
		Selector.queDivObj.find('.view-feedback-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};					
			showFeedback({isAni: true, playSfx: false});
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})

		Selector.queDivObj.find('.restart-quiz-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			//back to intro screen;
			APP.navData.screenId -= 1; 
			APP.navigationObj.loadScreen();
		})
		
		Selector.queDivObj.find('.magnify-box').on('click', function(e){	
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			$(this).removeClass('hover');					
			var id = $(this).data('id');		
			var currPop = $(Selector.ACTIVITY_CONTAINER).find('.magnify-pop[data-id="'+id+'"]');
			//for animation				
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			aniObj.ON_COMPLETE = function(){
				
			};
			
			var isModalPop = currPop.hasClass('screen-modal-pop');
			if(isModalPop){
				//--for responsive
				$('body').addClass('modal-open');
				//--
				$('#alpha-bg').fadeIn();
				//IE hack placing pop on root level
				currPop.clone(true)
				.appendTo("#main-div")
				.fadeIn()
					
				APP.commonFunObj.updateScreenModalPopLayout();
				aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
				aniObj.ON_COMPLETE = function(){
					APP.commonFunObj.updateScreenModalPopLayout();
				}	
				APP.animationObj.animate(aniObj);
				APP.eventObj.applyGbPopCloseEvent();					
			}else{			
				currPop.show();
				if($('body').hasClass('responsive')){	
					//--check only when responsive 			
					isInView = APP.commonFunObj.isElementInView($(currPop));
					if(!isInView){
						APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
					}
				}
				APP.animationObj.animate(aniObj);	
				applyPopCloseEvent();			
			}
					
		});
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function selectOption(_currOpt){
		var $options = Selector.queDivObj.find('.option-item');
		var $currentOption = _currOpt;
		var _id = parseInt($currentOption.data('id'));

		if (Selector.TYPE == "mcq") {			
			//-- for deselect
			if ($currentOption.hasClass('selected')) {
				$currentOption.removeClass('selected');
				$currentOption.find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
				Selector.userArray[_id] = 0;
			} else {
				$options.each(function (idx) {
					$(this).removeClass('selected');
					$(this).find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
					Selector.userArray[idx] = 0;
				});
				$currentOption.addClass('selected');
				$currentOption.find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);
				Selector.userArray[_id] = 1;
				if(Selector.SUBMIT_ON_OPTION_CLICK){
					processSubmit({feedbackAni:true, autoOpen:true});
				}
			}
		} else if (Selector.TYPE == "mrq") {					
			if ($currentOption.hasClass('selected')) {					
				$currentOption.removeClass('selected');
				$currentOption.find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
				Selector.userArray[_id] = 0;
			} else {
				$currentOption.addClass('selected');
				$currentOption.find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);
				Selector.userArray[_id] = 1;
			}				
		}
		submitBtnStatus();		
	}
	function updateValue(){
		Selector.userArray = Selector.initialUserArr.slice();		
		Selector.queDivObj.find('.option-item').each(function(inx){
			if($(this).hasClass('selected')){
				var id = $(this).data('id');				
				Selector.userArray[id] = 1;
			}
		})
		
		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){
		var isAnySelect = false;
		var selectedOptionCnt = 0;
		for(var i=0; i<Selector.userArray.length; i++){
			var curr = Selector.userArray[i];
			if(curr == 1){
				selectedOptionCnt++;
				isAnySelect = true;
				//break;
			}
		}
		//added for minimum option selection to enable submit
		if(Selector.ENABLE_SUBMIT_COUNT != null && Selector.ENABLE_SUBMIT_COUNT != '') {
			if(Selector.ENABLE_SUBMIT_COUNT <= selectedOptionCnt){
				EnabledDisabledBtn('.submit-btn', true);			
			}else{
				EnabledDisabledBtn('.submit-btn', false);
			}
		} else {
			if(isAnySelect){
				EnabledDisabledBtn('.submit-btn', true);			
			}else{
				EnabledDisabledBtn('.submit-btn', false);
			}
		}

		if(Selector.SUBTYPE == 'profiler'){
			EnabledDisabledBtn('.submit-btn', true);	
		}
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: 0
		}
					
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){	
			if (Selector.userArray[i] == 1 && Selector.CORRECT_ANS_ARRAY[i] == 1) {			
				obj.corrCount += 1;				
			}
			if (Selector.userArray[i] == 1 && Selector.CORRECT_ANS_ARRAY[i] == 0) {
				obj.inCorrCount += 1;	
			}
			if(Selector.CORRECT_ANS_ARRAY[i] == 1){
				obj.totalCorrCount += 1;
			}
		}
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		$(Selector.FEEDBACK_CONTAINER).find('.question-photo').hide();
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		Selector.queDivObj.find('.option-item').addClass('disabled');

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				//Selector.SHOW_CORR_ANS_ON_SUBMIT = true;
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else{
			//Selector.SHOW_CORR_ANS_ON_SUBMIT = true;
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			if(_obj.autoOpen){
				showFeedback({isAni: _obj.feedbackAni, playSfx:true});
			}				
		}else{
			//no feedback
		}	
		
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
		updateStatus();
	}
	function showFeedback(_obj){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.IS_OPTIONWISE_FEEDBACK === true && Selector.TYPE == "mcq"){
			//work only for mcq
			var selOpt = null;
			for(var i=0; i<Selector.userArray.length; i++){
				var curr = Selector.userArray[i];
				if(curr == 1){
					selOpt = i;
					break;
				}
			}
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName ='correct';
				if(Selector.IS_PRE_TEST){
					soundName ='correct1';
				}
			}else{
				soundName ='incorrect';		
			}
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.option-feedback-'+selOpt);
		}else{
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName ='correct';
				if(Selector.IS_PRE_TEST){
					soundName ='correct1';
				}
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){
				soundName ='incorrect'			
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
				soundName ='incorrect'				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){	
				soundName ='incorrect'			
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
				soundName ='incorrect'
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		}
		if(Selector.COMMON_SFX){
			soundName ='blank'
		}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		aniObj.ON_COMPLETE = function(){
			$(currFeedback).find('.scroll-parent').scrollTop(0);
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				if(_obj.playSfx){
					APP.commonFunObj.playSoundEffect({name: soundName});	
				}	
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{
					if(_obj.playSfx){
						APP.commonFunObj.playSoundEffect({name: soundName});	
					}	
        		}				
			}		
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}		
			APP.eventObj.applyGbPopCloseEvent();					
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(_obj){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		
		}
		
	}
	
	function resetQuestion(){
		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		Selector.queDivObj.find('.option-item').removeClass('selected corr-ans tick cross disabled animated headShake');
		Selector.queDivObj.find('.option-item').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
		Selector.queDivObj.find('.option-item').find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross');
		Selector.queDivObj.find('.option-item').find('.img-status')
		.attr('src', '')
		.removeClass('i-tick i-cross');

		$(Selector.FEEDBACK_CONTAINER).hide();
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();			
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){		
			if(Selector.CORRECT_ANS_ARRAY [i] == 1){
				var curr = Selector.queDivObj.find('.option-item[data-id="'+i+'"]')
				curr.addClass('corr-ans tick');
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
				curr.find('.status')
				.attr('src',imgIcon.tick)
				.addClass('i-tick');
			}			
		}
		if (Selector.ON_SHOW_ME) {
			Selector.ON_SHOW_ME({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
		
	}
	function showTickCorss(){
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){	
			if(Selector.SHOW_CORR_ANS_ON_SUBMIT){
				if(Selector.CORRECT_ANS_ARRAY [i] == 1){
					var curr = Selector.queDivObj.find('.option-item[data-id="'+i+'"]')
					curr.addClass('corr-ans tick');
					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.addClass('i-tick');
					curr.find('.img-status')
					.attr('src',imgIcon.tick)
					.addClass('i-tick');
				} 
			}			
			if (Selector.userArray[i] == 1 && Selector.CORRECT_ANS_ARRAY[i] == 1) {			
				var curr = Selector.queDivObj.find('.option-item[data-id="'+i+'"]');
				curr.addClass('tick');
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
				curr.find('.img-status')
				.attr('src',imgIcon.tick)
				.addClass('i-tick');
			}
			if (Selector.userArray[i] == 1 && Selector.CORRECT_ANS_ARRAY[i] == 0) {
				var curr = Selector.queDivObj.find('.option-item[data-id="'+i+'"]');
				curr.addClass('cross');
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass('i-cross');
				curr.find('.img-status')
					.attr('src',imgIcon.cross)
					.addClass('i-cross');
			}					
		}
	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){				
			if (Selector.userArray[i] == 1 && Selector.CORRECT_ANS_ARRAY[i] == 0) {
				var incorrOpt = Selector.queDivObj.find('.option-item[data-id="'+i+'"]');
				incorrOpt.addClass('animated headShake');	
				/* TweenMax.to(incorrOpt, 0.1, {
					x: '+=10',
					yoyo: true,
					repeat: 3,
					clearProps: "all"							
				});	 */
					
			}					
		}
	}
		
	function updateStatus() {
		if(Selector.SEND_INTRACTION && Selector.QUE_INTRACTION_OBJ.dataTobeSend){	
			Selector.QUE_INTRACTION_OBJ.dataUserArray = Selector.userArray;
			Selector.QUE_INTRACTION_OBJ.dataAnswerArray = Selector.CORRECT_ANS_ARRAY;
			Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
			Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
			
			if (Selector.userArray.indexOf(1) != -1) {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = true;
			} else {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.QUE_INTRACTION_OBJ.dataStatus = "correct";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 1;
			}else{
				Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
				if (Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected) {
					Selector.QUE_INTRACTION_OBJ.dataStatus = "incorrect";
				}
			}
						
			Selector.QUE_INTRACTION_OBJ.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInlineInteractionData(Selector.QUE_INTRACTION_OBJ);
			
		}
		//--prevent to send attempted que data 
		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode && !Selector.queObj.dataIsUserOptionSelected) {
			Selector.queObj.dataUserArray = Selector.userArray;
			Selector.queObj.dataAnswerArray = Selector.CORRECT_ANS_ARRAY;
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			
			if (Selector.userArray.indexOf(1) != -1) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else{
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				if (Selector.queObj.dataIsUserOptionSelected) {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
			if (Selector.TYPE == "mrq") {
				if (Selector.queObj.dataStatus == "incorrect") {
					if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
						if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
							var qPoint = parseInt(Selector.queObj.dataQuePoint);
							var perOptionPoint = qPoint / corrObj.totalCorrCount;
							var num = perOptionPoint * corrObj.corrCount;
							var n = num.toFixed(2);
							var earnPoint = parseFloat(n);
							Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
						} else {
							Selector.queObj.dataEarnPoint = 0;
						}
						Selector.queObj.dataStatus = "partlyCorrect";
					} else {
						Selector.queObj.dataStatus = "incorrect";
					}
				}
			}			
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		} */
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	/* $(document).one(APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE, function (e) {
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
	}); */
}