function MultiColOptQuestion() {
	var _this = this;
	var Selector = {};
	var feedbackAudio = '';
	var defaultValue = -1;
	var time = new Date();
	var startTime;

	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {			
			CLASS_NAME: 'multi-col-opt-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			MOB_SEG_CONTROL_BTN_CLASS: 'seg-control-btn',
			IS_ASSESSMENT: false,
			IS_PRE_TEST: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			SHOW_CORR_ANS_ON_SUBMIT: false,
			ANIMATE_INCORR_OPTION: true,
			TYPE:'',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: 'icon-radio-unchecked',
				optSelected: 'icon-radio-checked',
				tick: 'icon-checkmark',
				cross: 'icon-cross'
			},
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_SHOW_ME: null,
			ON_CLICK: null,
			ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			QUE_INTRACTION_OBJ: {},
			SEND_INTRACTION: false,
			isCompleted:false,
			queObj:null,
			

		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	_this.processSubmit = function(){
		processSubmit({feedbackAni:true, autoOpen:false});
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];		
		Selector.isCompleted = false;	
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}
				
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			//-- for inline cmi intraction
			startTime = time;
			initialRender();
		}
	}
	function getHTML() {
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		var _className = Selector.queObj.className || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;	
		var _colWidth = Selector.queObj.colWidth || "col-60";	
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _id + ' " style="' + _style + '">';
		/* 2 */ str += '<div class="col col-text '+_colWidth+' white-alpha-bg ani-box-left">';
				str += '<div class="sb-que-ref"></div>';
				str += '<div class="screen-title-div">';
					str += '<span class="icon font-icon icon-exercise"></span>';
					str += '<span class="title"></span>';
				str += '</div>';				
		/* 3 */str += '<div class="que-txt-panel">';		
					str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);
			/* 3 */str += '</div>';
			/* 4 */str += '<div class="table-div">';	
				str += '<table style="width:100%">';
					str += '<tbody>';
						//create header
						str += '<tr class="header-row " >';						
							str += '<th class="header-cell " data-type="optionText"></th>';
							var headerObj = Selector.queObj.header[0].headerText;
							for (var i = 0; i < headerObj.length; i++) {					
								var _className = headerObj[i].className || "";
								var _style = headerObj[i].style || "";
								var _txt = headerObj[i].Text;
								str += '<th class="header-cell '+_className+' " style="' + _style + '" data-type="optionBtn" >'+_txt+'</th>';
							}	
						str += '</tr>';					
						//end header
						//create option row
						var optionObj = Selector.queObj.options[0].option;
						for (var j = 0; j < optionObj.length; j++) {					
							var _className = optionObj[j].className || "";
							var _style = optionObj[j].style || "";
							var _txt = optionObj[j].Text;
							var _correctId = optionObj[j].correctId;
							Selector.CORRECT_ANS_ARRAY.push(_correctId);
							str += '<tr class="option-row ">';
								str += '<td class="txt-cell '+_className+' " style="' + _style + '" >'+_txt+'</td>';
								for (var k = 0; k < headerObj.length; k++) {
									str += '<td class=" option-cell btn-cell">';
										str += '<div class="btn-panel">';
											str += '<a class="btn radio-btn" href="javascript:void(0); " ><span class="display-cell v-center btn-icon font-icon"><span class="display-cell v-center font-icon  status"></span></span></a>';
										str += '</div>';
									str += '</td>';
								}
							str += '</tr>';
						}									
						//end option row					
					str += '</tbody>';
				str += '</table>';	
			/* 4 */str += '</div>';
			/* 5 */str += '<div class="display-block submit-panel bottom-align">';			
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn " href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn additional-hint-btn " href="javascript:void(0);" >';
							str += '<span class="btn-icon font-icon icon-hint display-cell v-center center" ></span>';
							str += '<span class="btn-txt display-cell v-center center" >'+APP.globalXmlsObj.globalXML.commonText[0].getAddHintsBtnText[0].Text+'</span>';
						str += '</a>';
					str += '</div>';									
			/* 5 */str += '</div>';	
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);	
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partlycorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';	
			}		
		/* 2 */str += '</div>';
		if(_colWidth != 'full'){			
			if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
				var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
				str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
			}else{
				str += '<div class="col col-blank"><p></p></div>';
			}
		}			
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}
	function initialRender(){
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		
		//-- for inline cmi intraction
		Selector.QUE_INTRACTION_OBJ.type = 'multiColOption'; 
		Selector.QUE_INTRACTION_OBJ.options = [];
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		//--
		
		var curr = 0;
		Selector.tableDivObj = Selector.queDivObj.find('.table-div');
		Selector.tableDivObj.find('th').each(function(inx){			
			$(this).addClass('header-cell_'+inx);
			var type = $(this).attr('data-type') || '';
			if(type == 'optionBtn'){
				//-- for inline cmi intraction
				Selector.QUE_INTRACTION_OBJ.options[curr] = $(this).text();
				//--
				//-- mapped with correct answer
				$(this).attr('data-id', curr);
				curr++;
			}
		});
		
		Selector.tableDivObj.find('.option-row').each(function(inx){	
			Selector.initialUserArr[inx] = defaultValue;
			var row = $(this);
			var curr1 = 0;			
			$(row).find('td').each(function (jnx){
				$(this).addClass('option-cell_'+inx+'-'+jnx).attr('data-row-id', inx).attr('data-col-id', 'na');
				if($(this).hasClass('btn-cell')){
					$(this).attr('data-col-id', curr1);
					$(this).find('.radio-btn').addClass('radio-btn_'+inx+'-'+curr1).attr('data-row-id', inx).attr('data-col-id', curr1);
					//set normal icon
					$(this).find('.radio-btn').find('.btn-icon').addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal)
					curr1++;
				}
				//for mobile controls				
				if($(this).hasClass('txt-cell')){
					var segmentedObj = $(this).find('.segmented-options');
					if(segmentedObj.length){
						var segBtnObj = segmentedObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS);
						
						segmentedObj.find('.highlighter').addClass('len-'+segBtnObj.length);
						
						segBtnObj.each(function (cnx){
							$(this).addClass(Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+inx+'-'+cnx).attr('data-row-id', inx).attr('data-col-id', cnx);					
						})
					}					
				}
				
			})
		});
		//validate CORRECT_ANS_ARRAY
		var totOpt = Selector.tableDivObj.find('.option-row').length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		
		var cheatMode = APP.configObj.cheatMode;
		if(cheatMode){
			var corrClass = 'ref-corr';
			Selector.tableDivObj.find('.option-row').each(function(inx){	
				var colIndex = Selector.CORRECT_ANS_ARRAY[inx];
				$(this).find('.radio-btn_'+inx+'-'+colIndex).parents('.btn-cell').addClass(corrClass);
				//for mobile
				$(this).find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+inx+'-'+colIndex).addClass(corrClass);
			});
		}
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}
	}

	function loadPrevUserData(){
		
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			if (Selector.queObj.dataAnswerArray != null) {
				Selector.CORRECT_ANS_ARRAY = Selector.queObj.dataAnswerArray;
			}
			if (Selector.queObj.dataUserArray != null) {
				Selector.userArray = Selector.queObj.dataUserArray;				
			
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		//('Selector.userArray00: '+Selector.userArray)
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){
			Selector.tableDivObj.find('.option-row').each(function(inx){	
				var colIndex = Selector.userArray[inx];
				if(colIndex != defaultValue){
					$(this).find('.radio-btn_'+inx+'-'+colIndex).addClass('selected');		
					$(this).find('.radio-btn_'+inx+'-'+colIndex).parents('.btn-cell').addClass('selected');				
					$(this).find('.radio-btn_'+inx+'-'+colIndex).find('.btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);
					//for mobile
					var segBtn = $(this).find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+inx+'-'+colIndex)
					selectSegmentedBtn(segBtn);	
				}				
			});			
		}else{
			Selector.userArray = [];
			Selector.tableDivObj.find('.option-row').each(function(inx){	
				Selector.userArray.push(defaultValue);
			});
		}
		
		initQuestion();
	}
	function initQuestion(){
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
			Selector.tableDivObj.find('.option-row ').shuffle();
			//--move header row always top
			Selector.tableDivObj.find('.header-row').parent().prepend($('.header-row'));
		}
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();
		
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.view-feedback-btn', false);
		updateValue();

		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:false});
			}
		} */
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;
			processSubmit({feedbackAni:true});	
					
		} */
		
	}
//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;	
			if(Selector.IS_PRE_TEST){
				processSubmit({feedbackAni:true, autoOpen:true});
			}else{
				processSubmit({feedbackAni:true, autoOpen:true});
			}
		}
	});
	function addTemplateEvent() {
		Selector.queDivObj.find('.radio-btn').on('click', function(){
			if($(this).hasClass('selected') || $(this).hasClass('disabled')){return false;};
			
			$(this).parents('.option-row').find('.radio-btn').removeClass('selected');
			$(this).parents('.option-row').find('.btn-cell').removeClass('selected');
			$(this).parents('.option-row').find('.radio-btn .btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);

			$(this).addClass('selected');	
			$(this).parents('.btn-cell').addClass('selected');				
			$(this).find('.btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);	
			//for mobile
			var rowInx =$(this).data('row-id');
			var ColInx = $(this).data('col-id');
			var segBtn = Selector.tableDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+rowInx+'-'+ColInx);
			selectSegmentedBtn(segBtn);
			
			updateValue();	
					
		});
		//for mobile
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).on('click', function(){
			if($(this).hasClass('selected') || $(this).hasClass('disabled')){return false;};
			selectSegmentedBtn($(this));
			//for desktop
			var rowInx =$(this).data('row-id');
			var ColInx = $(this).data('col-id');

			$(this).parents('.option-row').find('.radio-btn').removeClass('selected');
			$(this).parents('.option-row').find('.btn-cell').removeClass('selected');
			$(this).parents('.option-row').find('.radio-btn .btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);

			var currRadioBtn = Selector.tableDivObj.find('.radio-btn_'+rowInx+'-'+ColInx);
			currRadioBtn.addClass('selected');	
			currRadioBtn.parents('.btn-cell').addClass('selected');					
			currRadioBtn.find('.btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);

			updateValue();	
					
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};
			Selector.IS_SUBMIT_CLICK = 'cl';					
			processSubmit({feedbackAni:true, autoOpen:true});		
			
		})
		Selector.queDivObj.find('.view-feedback-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};					
			showFeedback({isAni: true, playSfx: false});
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function selectSegmentedBtn(_btnObj){
		if($(_btnObj).hasClass('selected') || $(_btnObj).hasClass('disabled')){return false;}
		var rowId = parseInt($(_btnObj).data('row-id'));
		var colId = parseInt($(_btnObj).data('col-id'));
		var parentObj = $(_btnObj).parents('.segmented-options');
		var trasVal = (colId)+'00%';
		parentObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).removeClass('selected');
		$(_btnObj).addClass('selected');
		if(parentObj.find('.highlighter').hasClass('opt-0')) {
			parentObj.find('.highlighter').removeClass('opt-0');
		} else if(parentObj.find('.highlighter').hasClass('opt-1')) {
			parentObj.find('.highlighter').removeClass('opt-1');
		} 
		parentObj.find('.highlighter').addClass('opt-'+colId);
		parentObj.find('.highlighter').show().css({
			'-webkit-transform' : 'translateX('+trasVal+')',
			'-moz-transform'    : 'translateX('+trasVal+')',
			'-ms-transform'     : 'translateX('+trasVal+')',
			'-o-transform'      : 'translateX('+trasVal+')',
			'transform'         : 'translateX('+trasVal+')'
		});
	}
	function updateValue(){
		Selector.userArray = Selector.initialUserArr.slice();
		var currentView = APP.commonFunObj.getCurrentView();
		var btnObj = Selector.queDivObj.find('.radio-btn');
		if(currentView == 'mobile'){
			btnObj = Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS);
			if(btnObj.length == 0){
				btnObj = Selector.queDivObj.find('.radio-btn');
			}
		}		
		btnObj.each(function(inx){
			if($(this).hasClass('selected')){
				var rowId = $(this).data('row-id');
				var colId = $(this).data('col-id');
				Selector.userArray[rowId] = colId;
			}
		})
		
		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){
		var allSelected = true;
		for(var i=0; i<Selector.userArray.length; i++){
			var curr = Selector.userArray[i];
			if(curr == defaultValue){
				allSelected = false;
				break;
			}
		}
		if(allSelected){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.CORRECT_ANS_ARRAY.length
		}
				
		for(var i=0; i<Selector.userArray.length; i++){			
			if(Selector.userArray[i] == Selector.CORRECT_ANS_ARRAY[i]){	
				obj.corrCount += 1;				
			}else{
				obj.inCorrCount += 1;	
			}
		}
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		Selector.queDivObj.find('.radio-btn').addClass('disabled');
		//for mobile
		Selector.queDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).addClass('disabled');
		
		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				//Selector.SHOW_CORR_ANS_ON_SUBMIT = true;
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				//Selector.SHOW_CORR_ANS_ON_SUBMIT = true;
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else{
			//Selector.SHOW_CORR_ANS_ON_SUBMIT = true;
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			if(_obj.autoOpen){
				showFeedback({isAni: _obj.feedbackAni, playSfx:true});
			}				
		}else{
			//no feedback
		}	
		
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
		updateStatus();
	}
	function showFeedback(_obj){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.FEEDBACK_STATE == 'corr'){
			soundName ='correct'
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){
				soundName ='incorrect'				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
				soundName ='incorrect'				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){		
				soundName ='incorrect'			
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
				soundName ='incorrect'	
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		aniObj.ON_COMPLETE = function(){
			$(currFeedback).find('.scroll-parent').scrollTop(0);
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}	
			
		}
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true,true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			APP.eventObj.applyGbPopCloseEvent();							
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(_obj){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
	}
	
	function resetQuestion(){
		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
    //--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.tableDivObj.find('.option-row').find('.radio-btn').removeClass('selected corr-ans tick cross disabled');
		Selector.tableDivObj.find('.option-row').find('.btn-cell').removeClass('selected animated headShake');
		Selector.tableDivObj.find('.option-row').find('.radio-btn .btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
		Selector.tableDivObj.find('.option-row').find('.status').removeClass(Selector.FONT_ICON_CLASS_OBJ.tick).removeClass(Selector.FONT_ICON_CLASS_OBJ.cross).removeClass('tick cross');
		//for mobile
		Selector.tableDivObj.find('.option-row').find('.segmented-options .highlighter').hide().css({
			'-webkit-transform' : 'translateX(-100%)',
			'-moz-transform'    : 'translateX(-100%)',
			'-ms-transform'     : 'translateX(-100%)',
			'-o-transform'      : 'translateX(-100%)',
			'transform'         : 'translateX(-100%)'
		});
		Selector.tableDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).removeClass('selected corr-ans disabled');
		Selector.tableDivObj.find('.'+Selector.MOB_SEG_CONTROL_BTN_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross');

		$(Selector.FEEDBACK_CONTAINER).hide();
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();			
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){							
			var rbtn = '.radio-btn_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
			Selector.tableDivObj.find('.option-row').find(rbtn).addClass('corr-ans');
			Selector.tableDivObj.find('.option-row').find(rbtn).find('.status')
			.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
			.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
			.addClass('tick');	
			//for mobile
			var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
			Selector.tableDivObj.find('.option-row').find(segBtn).addClass('corr-ans');
			Selector.tableDivObj.find('.option-row').find(segBtn).find('.status')
			.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
			.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
			.addClass('i-tick');
		}
		if (Selector.ON_SHOW_ME) {
			Selector.ON_SHOW_ME({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
		
	}
	function showTickCorss(){
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){	
			if(Selector.SHOW_CORR_ANS_ON_SUBMIT){
				var rbtn = '.radio-btn_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
				Selector.tableDivObj.find('.option-row').find(rbtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
				//for mobile
				var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
				Selector.tableDivObj.find('.option-row').find(segBtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
			}			
			if(Selector.userArray[i] == Selector.CORRECT_ANS_ARRAY[i]){	
				var rbtn = '.radio-btn_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
				Selector.tableDivObj.find('.option-row').find(rbtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
				//for mobile
				var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+i+'-'+Selector.CORRECT_ANS_ARRAY[i];
				Selector.tableDivObj.find('.option-row').find(segBtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');				
			}else{
				var rbtn = '.radio-btn_'+i+'-'+Selector.userArray[i];
				Selector.tableDivObj.find('.option-row').find(rbtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass('i-cross');
				//for mobile
				var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+i+'-'+Selector.userArray[i];
				Selector.tableDivObj.find('.option-row').find(segBtn).find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass('i-cross');
			}				
		}

	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){						
			if(Selector.userArray[i] == Selector.CORRECT_ANS_ARRAY[i]){	
								
			}else{
				var rbtn = '.radio-btn_'+i+'-'+Selector.userArray[i];
				Selector.tableDivObj.find('.option-row').find(rbtn).parents('.btn-cell').addClass('animated headShake')
				
				//for mobile
				//var segBtn = '.'+Selector.MOB_SEG_CONTROL_BTN_CLASS+'_'+i+'-'+Selector.userArray[i];
				//Selector.tableDivObj.find('.option-row').find(segBtn);
			}				
		}
	}
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
		
	function updateStatus() {
		if(Selector.SEND_INTRACTION && Selector.QUE_INTRACTION_OBJ.dataTobeSend){	
			Selector.QUE_INTRACTION_OBJ.dataUserArray = Selector.userArray;
			Selector.QUE_INTRACTION_OBJ.dataAnswerArray = Selector.CORRECT_ANS_ARRAY;
			Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
			Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = true;
			} else {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.QUE_INTRACTION_OBJ.dataStatus = "correct";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 1;
			}else{
				Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
				if (Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected) {
					Selector.QUE_INTRACTION_OBJ.dataStatus = "incorrect";
				}
			}
			
			Selector.QUE_INTRACTION_OBJ.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInlineInteractionData(Selector.QUE_INTRACTION_OBJ);
			
		}	
		
		/*if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			Selector.queObj.dataUserArray = Selector.userArray;
			Selector.queObj.dataAnswerArray = Selector.CORRECT_ANS_ARRAY;
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partlyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}		
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}*/
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
}