function WordSortQuestion() {
	var _this = this;
	var Selector = {};
	var defaultValue = -1;
	var coverflowTemplate = null;
	var mrqIconObj = {
		optNormal: "icon-checkbox-unchecked",
		optSelected: "icon-checkbox-tick-checked"
	}
	_this.start = function (_obj) {
		Selector = {			
			CLASS_NAME: 'word-sort-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			SHOW_PREVIOUS_SELECTION: false,	
			USER_ARRAY:[],
			CURRENT_STEP: 0,
			TOTAL_STEPS: 0,
			STEPWISE_SELECTION: [],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark',
				cross: 'icon-cross'
			},
			ON_INIT: null,
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,			
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW: null,
			
			isCompleted:false,
			queObj:null,
			

		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentStep= function(){
		return Selector.CURRENT_STEP;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];		
		Selector.isCompleted = false;	
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_STEP = 0;			
		}
		Selector.userArray = [];
		initialRender();			
	}

	function initialRender(){
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		Selector.FONT_ICON_CLASS_OBJ.optNormal = mrqIconObj.optNormal;
		Selector.FONT_ICON_CLASS_OBJ.optSelected = mrqIconObj.optSelected;
		var wordEls = Selector.queDivObj.find('.word');
		//--create user array 
		if(Selector.STEPWISE_SELECTION.length){
			
		}else{
			console.error('STEPWISE_SELECTION array is blank');
			Selector.STEPWISE_SELECTION = [wordEls.length];
		}
		//console.log("Selector.STEPWISE_SELECTION: "+Selector.STEPWISE_SELECTION)
		Selector.TOTAL_STEPS = Selector.STEPWISE_SELECTION.length;
		for(var i=0; i<Selector.STEPWISE_SELECTION.length; i++){
			Selector.initialUserArr[i] = [];
			var curr = Number(Selector.STEPWISE_SELECTION[i]);
			if(i > 0){
				//console.log(i, curr, Selector.STEPWISE_SELECTION[i - 1])
				if(curr > Number(Selector.STEPWISE_SELECTION[i - 1])){
					console.error('Number of selection is greater than previous Step selection');
					curr = Number(Selector.STEPWISE_SELECTION[i - 1]);
				}
			}
			for(var j=0; j<curr; j++){
				Selector.initialUserArr[i].push(defaultValue);
			}
		}
		//console.log('Selector.initialUserArr: '+JSON.stringify(Selector.initialUserArr));

		//-- create correct_ans_array
		var cheatMode = APP.configObj.cheatMode;
		

		Selector.queDivObj.find('.word').each(function(inx){			
			$(this).data('selected', false);
			//set normal icon
			$(this).find('.opt-cell').find('.icon').addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
		})
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}
	}
	function loadPrevUserData(){
		Selector.userArray = Selector.USER_ARRAY;
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){	
			for(var i =0; i<Selector.userArray.length; i++){
				var curr = Selector.userArray[i];
				for(var j =0; j<curr.length; j++){
					if(curr[j] != defaultValue){
						var el = Selector.queDivObj.find('.word-'+curr[j]);
						el.addClass('selected hide');
						el.data('selected', false);
						el.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);
						if(i == Selector.CURRENT_STEP){
							el.removeClass('hide').addClass('selected');
							el.data('selected', true);
						}
					}					
				}
				
			}			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}
		
		initQuestion();		
	}
	function initQuestion(){		
		EnabledDisabledBtn('.try-again-btn', false);		
		updateValue();
		if(Selector.ON_INIT){
			Selector.ON_INIT();
		}
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.CURRENT_STEP > 0 ) {
			processSubmit({feedbackAni:true});			
		}
	});

	function addTemplateEvent() {
		Selector.queDivObj.find('.word').hover(function(){
				if($(this).hasClass('disabled') || $(this).hasClass('selected')){return false;};
				$(this).addClass('hover');
			}, function(){
				$(this).removeClass('hover');
		});					
		
		Selector.queDivObj.find('.word').on('click', function(){
			if($(this).hasClass('disabled') || $(this).hasClass('no-select')){return false;};				
			selectOption($(this));					
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};					
			processSubmit({feedbackAni:true});		
			
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		
	}
	
	function selectOption(_currOpt){		
		var currentOptionEl = _currOpt;
		var _id = parseInt(currentOptionEl.data('word-id'));	
		
		currentOptionEl.removeClass('hover');						
		if (currentOptionEl.hasClass('selected')) {					
			currentOptionEl.removeClass('selected');
			currentOptionEl.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);	
			currentOptionEl.data('selected', false);
			updateUserArrayVal('remove', _id);
		} else {
			currentOptionEl.addClass('selected');
			currentOptionEl.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);	
			currentOptionEl.data('selected', true);
			updateUserArrayVal('add', _id);
		}	
		updateValue();		
	}
	function updateUserArrayVal(_sts, _wordId){
		var currArr = Selector.userArray[Selector.CURRENT_STEP];
		
		for(var i=0; i<currArr.length; i++){			
			if(_sts == 'remove'){
				if(_wordId != null || _wordId !== ''){
					if(currArr[i] == _wordId){					
						currArr[i] = defaultValue;
						break;
					}
				}
			}else{
				if(_wordId != null || _wordId !== ''){
					if(currArr[i] == defaultValue){					
						currArr[i] = _wordId;
						break;
					}
				}
			}
		}		
		//console.log('Selector.userArray: '+JSON.stringify(Selector.userArray));
	}
	function updateValue(){
		var currArr = Selector.userArray[Selector.CURRENT_STEP];
		if(currArr.toString().indexOf(defaultValue) == -1){
			//all selected
			Selector.queDivObj.find('.word:not(.selected, .no-select)').addClass('no-select').addClass('no-select-'+Selector.CURRENT_STEP);
		}else{
			Selector.queDivObj.find('.word.no-select-'+Selector.CURRENT_STEP).removeClass('no-select').removeClass('no-select-'+Selector.CURRENT_STEP);
		}
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, cstp:Selector.CURRENT_STEP});
		}
	}
	function submitBtnStatus(){	
		var currArr = Selector.userArray[Selector.CURRENT_STEP];
		if(currArr.toString().indexOf(defaultValue) == -1){
			EnabledDisabledBtn('.submit-btn', true);
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
		
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}

	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		EnabledDisabledBtn('.submit-btn', false);
		
		var wordObj = Selector.queDivObj.find('.word:not(.selected, .hide)');
		
		APP.animationObj.animate({
			EL: wordObj,
			TYPE: 'fade-out-top',
			END_VAL: '10px',			
			STAGGER: true,
			DURATION: 0.1,
			DELAY: 0.1,
			ON_COMPLETE: function(){			
				wordObj.addClass('hide');
				gotoNextStep();
				
			}
		});		
	}
	function gotoNextStep(){
		//console.log("00Selector.CURRENT_STEP: "+Selector.CURRENT_STEP+" :Selector.TOTAL_STEPS: "+Selector.TOTAL_STEPS);
		if(Selector.CURRENT_STEP < (Selector.TOTAL_STEPS - 1)){
			//--deselect prev selection
			var currArr = Selector.userArray[Selector.CURRENT_STEP];			
			for(var i=0; i<currArr.length; i++){	
				var el = Selector.queDivObj.find('.word-'+currArr[i]);	
				el.removeClass('selected');				
				el.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);	
				el.data('selected', false);
			}		
			Selector.CURRENT_STEP++;
			
		}else{
			//console.log('Done....');
			EnabledDisabledBtn('.submit-btn', false);
			Selector.queDivObj.find('.word').addClass('disabled');
			Selector.isCompleted = true;
			updateStatus();
			Selector.CURRENT_STEP++;
			
		}
		//show stepwise div
		$(Selector.ACTIVITY_CONTAINER).find('.step-div').addClass('hide');
		var currStepDiv = $(Selector.ACTIVITY_CONTAINER).find('.step-'+(Selector.CURRENT_STEP));
		if(currStepDiv.length){
			currStepDiv.removeClass('hide');
			var aniObj = APP.animationObj.generateAniObj($(currStepDiv));
			aniObj.ON_COMPLETE = function(){
				$(currStepDiv).find('.scroll-parent').scrollTop(0);
			}
			APP.animationObj.animate(aniObj);
		}	
		EnabledDisabledBtn('.try-again-btn', true);	
		
		//console.log("11Selector.CURRENT_STEP: "+Selector.CURRENT_STEP+" :Selector.TOTAL_STEPS: "+Selector.TOTAL_STEPS);
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, cstp:Selector.CURRENT_STEP});
		}
	}
		
	function resetQuestion(){
		//console.log("in reset: "+Selector.CURRENT_STEP+" :Selector.TOTAL_STEPS: "+Selector.TOTAL_STEPS);
		
    	if(Selector.CURRENT_STEP < (Selector.TOTAL_STEPS)){
			var currArr = Selector.userArray[Selector.CURRENT_STEP];
			//console.log('reset currArr: '+currArr)
			for(var i=0; i<currArr.length; i++){
				if(currArr[i] != defaultValue){
					var el = Selector.queDivObj.find('.word-'+currArr[i]);
					el.removeClass('selected disabled');
					el.data('selected', false);
					el.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optSelected).addClass(Selector.FONT_ICON_CLASS_OBJ.optNormal);
					currArr[i] = defaultValue;
				}
			}
		}
		Selector.CURRENT_STEP--;
		//console.log('---: '+Selector.CURRENT_STEP)
		var currArr = Selector.userArray[Selector.CURRENT_STEP];
		//console.log('--reset currArr: '+currArr)
		for(var i=0; i<currArr.length; i++){
			if(currArr[i] != defaultValue){
				var el = Selector.queDivObj.find('.word-'+currArr[i]);
				el.removeClass('no-select hide disabled');
				el.removeClass('no-select-'+(Selector.CURRENT_STEP + 1));
				el.addClass('selected');
				el.data('selected', true);
				el.find('.opt-cell').find('.icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.optNormal).addClass(Selector.FONT_ICON_CLASS_OBJ.optSelected);				
			}
		}
		var wordObj = Selector.queDivObj.find('.word.no-select-'+Selector.CURRENT_STEP);
		wordObj.removeClass('hide disabled');
		APP.animationObj.animate({
			EL: wordObj,
			TYPE: 'fade-in-top',
			START_VAL: '10px',			
			STAGGER: true,
			DURATION: 0.1,
			DELAY: 0.1,
			ON_COMPLETE: function(){			
				updateValue();
			}
		});
		//show stepwise div
		$(Selector.ACTIVITY_CONTAINER).find('.step-div').addClass('hide');
		var currStepDiv = $(Selector.ACTIVITY_CONTAINER).find('.step-'+Selector.CURRENT_STEP);
		if(currStepDiv.length){
			currStepDiv.removeClass('hide');
			var aniObj = APP.animationObj.generateAniObj($(currStepDiv));
			aniObj.ON_COMPLETE = function(){
				$(currStepDiv).find('.scroll-parent').scrollTop(0);
			}
			APP.animationObj.animate(aniObj);
		}
		if(Selector.CURRENT_STEP <= 0){
			EnabledDisabledBtn('.try-again-btn', false);	
		}
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, cstp:Selector.CURRENT_STEP});
		}
	}

	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_SCREEN_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	function updateStatus() {
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
}