function TabScreen() {
	var _this = this;
	var Selector = {};
	var popupAudio = '';
	var videoTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'tab-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_BTN_CLASS: 'tab-btn',
			ACTIVITY_POP_CLASS: 'tab-pop',
			SHOW_MULTI_POP: false,
			TYPE: 'regular',
			IS_ACCORDION_ON_MOBILE: false,
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},
			ON_CLICK: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW: null,
			ON_POP_CLOSE: null,
			CLICK_ARRAY: [],
			isCompleted:false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.closeAllPopup = function(_activity_container){		
		var activity_container	= _activity_container || Selector.ACTIVITY_CONTAINER;
		$(activity_container).find('.collapse-pop').removeClass('on').hide();				
		$(activity_container).find('.clickable').removeClass('current');
		$(activity_container).find('.'+Selector.ACTIVITY_POP_CLASS).hide();
				
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);

		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).each(function(inx){		
			$(this).attr('data-id', inx);
			$(this).addClass(Selector.ACTIVITY_BTN_CLASS+'-'+inx);	
			$(this).parents('.clickable').addClass('clickable'+'-'+inx);	
			
		});
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS).each(function(inx){		
			$(this).attr('data-id', inx);	
			$(this).addClass(Selector.ACTIVITY_POP_CLASS+'-'+inx);	
		});
		//--for responsive template will show as accordion
		if(Selector.IS_ACCORDION_ON_MOBILE){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).each(function(inx){	
				var id= $(this).data('id');
				//to check if mobile view is available 
				if($(Selector.ACTIVITY_CONTAINER).find('.collapse-pop-'+id).length <= 0){			
					var popObj = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS+'-'+id);
					var str = '<div class="collapse-pop collapse-pop-'+id+'" data-id="'+id+'">';
						str += popObj.html();
					str += '</div>';
					$(this).parents('.clickable').after(str);
				}
				$(this).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			});
		}		
		//--
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();		
		/* if(Selector.TYPE == 'folder-view'){			
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS+'[data-id="0"]').trigger('click');
			
		} */
	}
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).each(function(inx){
				var id = $(this).data('id');
				if(Selector.userData[id] == 1){
					$(this).parents('.clickable').addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).each(function(inx){
				//--for optional
				if($(this).hasClass('js-optional')){
					Selector.userData.push(1);
				}else{
					Selector.userData.push(0);
				}				
				//--				
			});
		}
		
		updateStatus();
		//--for folder-view default open 1st popup
		
	}

	function addTemplateEvent() {
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).on('click', function(e){
			if($(this).parents('.clickable').hasClass('disabled')){return false;};
			var currBtn = $(this);
			var currentView = APP.commonFunObj.getCurrentView();
			if(currentView == 'desktop'){
				//--for desktop prevent to close current btn click
				if($(this).parents('.clickable').hasClass('current')){return false;};
			}
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			var id = parseInt($(this).data('id'));

			var parentBlock = $(this).parents('.clickable');		

			//-- for mobile accordion 		
			if(currentView == 'mobile' && Selector.IS_ACCORDION_ON_MOBILE){
				$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS).hide();
				var collapseObj = parentBlock.siblings('.collapse-pop-'+id);				
				if(parentBlock.hasClass('current')){
					
					parentBlock.find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);						
					collapseObj.slideUp('slow', function(){					
						
					});
					collapseObj.removeClass('on');
					parentBlock.removeClass('current');
					$(Selector.ACTIVITY_CONTAINER).data('current-pop', null);
				}else{
					//to close others
					if(!Selector.SHOW_MULTI_POP){
						
						$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).each(function(inx){
							if($(this).parents('.clickable').hasClass('current')){
								var _id = $(this).data('id');
								
								var _collapseObj = $(this).parents('.clickable').siblings('.collapse-pop-'+_id);
								$(this).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
								_collapseObj.slideUp('slow', function(){
								});
								collapseObj.removeClass('on');
								$(this).parents('.clickable').removeClass('current');
							}
						})
					}
					parentBlock.find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
					collapseObj.slideDown('slow', function(){
						if($('body').hasClass('responsive')){
							//--check only when responsive 
							isInView = APP.commonFunObj.isElementInView($(currBtn));
							if(!isInView){
								APP.commonFunObj.scrollToElement($(currBtn), true, 'top', -200);
							}
							
						}
					});	
					collapseObj.addClass('on');
					parentBlock.addClass('visited current');
					
					Selector.userData[id] = 1;					
					$(Selector.ACTIVITY_CONTAINER).data('current-pop', id);		
				}
				if(collapseObj.find('.video-activity').length){
					if(APP.vidPlayer){
						APP.vidPlayer.destroy();
						APP.vidPlayer = null;
					} 
					videoTemplate = new VideoScreen();	
					videoTemplate.start({					
						CLASS_NAME: 'video-screen',
						VIDEO_PANEL: '.video-block',
						ACTIVITY_CONTAINER: $(collapseObj).find('.video-activity'),						
						ON_VIDEO_ENDED: function(_obj){						
							//$(currPop).find('.close-popup-btn').trigger('click');
						},					
						ON_COMPLETE: function(){						
							
						}					
					})
					//for autoplay
					try {
						if(APP.vidPlayer){
							APP.vidPlayer.play();
						}
					}
					catch(err) {
					
					} 
					
				}
			}else{
				//for desktop
				$(Selector.ACTIVITY_CONTAINER).find('.collapse-pop').removeClass('on').hide();
				if(!Selector.SHOW_MULTI_POP){
					$(Selector.ACTIVITY_CONTAINER).find('.clickable').removeClass('current');
					$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS).hide();
				}
				parentBlock.addClass('visited current');
				Selector.userData[id] = 1;
				var t = $(this).attr('data-link');
				//to open transcript pdf 
				if(t){
					var transWin = window.open(t,'_blank');
					transWin.focus();
					if (Selector.ON_CLICK) {
						Selector.ON_CLICK({id: id, arr:Selector.userData});
					}	
					updateStatus();	
					return false;
				}
				$(Selector.ACTIVITY_CONTAINER).data('current-pop', id);	
				var currPop = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS+'[data-id="'+id+'"]');
				//for animation	
				var aniObj = APP.animationObj.generateAniObj($(currPop));
				//--for pop audio
				if(popupAudio != null && popupAudio != ''){
					APP.commonFunObj.removeScreenAudio();
				}
				//--
				//--for pop audio
				popupAudio = $(currPop).data('audioPath') || '';
				//console.log('popupAudio: '+popupAudio);
				aniObj.ON_COMPLETE = function(){
					$(currPop).find('.scroll-parent').scrollTop(0);	
					//--for pop audio
					popupAudio = $(currPop).data('audioPath') || '';
					//console.log('popupAudio: '+popupAudio);
					if(popupAudio != null && popupAudio != ''){
						APP.commonFunObj.playScreenAudio({
							path: popupAudio,
							onPlay: function(){
							},
							onEnd: function(){								
							}
						});
					}
					//--		
				};	
							
				var isModalPop = currPop.hasClass('screen-modal-pop');
				if(isModalPop){
					//--have problem to access btn on event js
					parentBlock.removeClass('current');
					//--for responsive
					$('body').addClass('modal-open');
					//--
					$('#alpha-bg').fadeIn();
					//IE hack placing pop on root level
					currPop.clone(true)
					.appendTo("#main-div")
					.fadeIn()
					//--for init modal window templates...
					if (Selector.ON_MODAL_POP_SHOW) {
						Selector.ON_MODAL_POP_SHOW();
					}	
					APP.commonFunObj.updateScreenModalPopLayout();
					aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
					aniObj.ON_COMPLETE = function(){
						APP.commonFunObj.updateScreenModalPopLayout();
						//--for popup el animation			
						var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
						if(aniEl.length){
							aniEl.each(function(inx){
								$(this).removeClass('visibility-hidden'); 
								var aniObj = APP.animationObj.generateAniObj($(this));
								aniObj.ON_COMPLETE = function(){
									
								}
								APP.animationObj.animate(aniObj);
							})
						}
						//--						
						if(popupAudio != null && popupAudio != ''){
							APP.commonFunObj.playScreenAudio({
								path: popupAudio,
								onPlay: function(){
								},
								onEnd: function(){								
								}
							});
						}
						//--
					}	
					APP.animationObj.animate(aniObj);	
					APP.eventObj.applyGbPopCloseEvent();				
				}else{			
					currPop.show();
					
					if(currPop.find('.video-activity').length){
						if(APP.vidPlayer){
							APP.vidPlayer.destroy();
							APP.vidPlayer = null;
						} 
						videoTemplate = new VideoScreen();	
						videoTemplate.start({					
							CLASS_NAME: 'video-screen',
							VIDEO_PANEL: '.video-block',
							ACTIVITY_CONTAINER: $(currPop).find('.video-activity'),						
							ON_VIDEO_ENDED: function(_obj){						
								//$(currPop).find('.close-popup-btn').trigger('click');
							},					
							ON_COMPLETE: function(){						
								
							}					
						})
						//for autoplay
						try {
							if(APP.vidPlayer){
								APP.vidPlayer.play();
							}
						}
						catch(err) {
						
						} 
						
					}
					
					if($('body').hasClass('responsive')){	
						//--check only when responsive 		
						isInView = APP.commonFunObj.isElementInView($(currPop));
						if(!isInView){
							APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
						}
						
					}
					APP.animationObj.animate(aniObj);		
					//--for popup el animation
					var aniEl = $(currPop).find('.pop-ani-el');
					if(aniEl.length){
						aniEl.each(function(inx){
							$(this).removeClass('visibility-hidden'); 
							var aniObj = APP.animationObj.generateAniObj($(this));
							aniObj.ON_COMPLETE = function(){
								
							}
							APP.animationObj.animate(aniObj);
						})
					}
					//--
					applyPopCloseEvent();			
				}
			
			}
			//--
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr:Selector.userData});
			}	
			updateStatus();			
		})		
	}
	function applyPopCloseEvent(){
		//$('#main-div').find('.close-popup-btn').off('click');
		$(Selector.ACTIVITY_CONTAINER).find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_BTN_CLASS).parents('.clickable').removeClass('current');
		
			var currObj = _this.parents('.'+Selector.ACTIVITY_POP_CLASS);
			var isModalPop = currObj.hasClass('screen-modal-pop');
			
			var aniObj1 = APP.animationObj.generateAniObj($(currObj));
			aniObj1.REVERSED = true;
			if(APP.vidPlayer){
				APP.vidPlayer.pause();
			}			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');				
				aniObj1.EL = $(currObj).find('.modal-alert');
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					if (Selector.ON_POP_CLOSE) {
						Selector.ON_POP_CLOSE({arr:Selector.userData, allClicked: Selector.isCompleted});
					}	
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){
						
						APP.navigationObj.loadNextScreen();
					}
				}					
				APP.animationObj.animate(aniObj1);			

			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					if (Selector.ON_POP_CLOSE) {
						Selector.ON_POP_CLOSE({arr:Selector.userData, allClicked: Selector.isCompleted});
					}	
					var dn = _this.data('load-next');
					if(dn){
						
						APP.navigationObj.loadNextScreen();
					}
				}				
				APP.animationObj.animate(aniObj1);
			}	
			
		});
	}	
	function updateTemplateLayout() {
		
		if(Selector.IS_ACCORDION_ON_MOBILE){
			var activityContainer = $(Selector.ACTIVITY_CONTAINER);
			var currentPop = $(activityContainer).data('current-pop');
			
			if(currentPop != null && currentPop !== ''){						
				var btnBLockObj = $(activityContainer).find('.'+Selector.ACTIVITY_BTN_CLASS+'-'+currentPop);
				var id = parseInt(btnBLockObj.data('id'));
				var parentBlock = btnBLockObj.parents('.clickable');
								
				$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS).hide(); 
				$(Selector.ACTIVITY_CONTAINER).find('.collapse-pop').removeClass('on').hide(); 
				$(activityContainer).find('.'+Selector.ACTIVITY_BTN_CLASS).parents('.clickable').removeClass('current');
				var currentView = APP.commonFunObj.getCurrentView();
				if(currentView == 'mobile'){									
					var collapseObj = parentBlock.siblings('.collapse-pop-'+id);		
					parentBlock.addClass('visited current');
					parentBlock.find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
					collapseObj.show().addClass('on');
				}else{
					var currPop = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_POP_CLASS+'[data-id="'+id+'"]');
					currPop.show();
					parentBlock.addClass('visited current');
				}			
						
			}
		}
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
}