function SystemDetector() {
    var _this = this;
    var UA = (navigator.userAgent || navigator.vendor || window.opera).toLowerCase().replace(/_/g, '.');
    _this.deviceType = '';
    _this.deviceModel = '';
    _this.deviceOrientation = '';
    _this.osName = '';
    _this.osVersion = '';
    _this.browserName = '';
    _this.browserVersion = '';
    _this.browserEngine = '';
    _this.screenWidth = '';
    _this.screenHeight = '';
    _this.plugins = [];
    _this.init = init;
    _this.videoSupport = videoSupport;
    _this.androidBrowser = androidStockBrowser;
    var deviceTypes = ["tv", "tablet", "mobile", "desktop"];
    var plugins2find = {
        
        mediaplayer: {
            substrs: ['Windows Media'],
            progIds: ['MediaPlayer.MediaPlayer']
        },
        quicktime: {
            substrs: ['QuickTime'],
            progIds: ['QuickTime.QuickTime']
        }
    };

    function init() {
        _this.screenWidth = window.screen.width;
        _this.screenHeight = window.screen.height;
        findDevice();
        findOS();
        findBrowser();
        findOrientation();
        findPlugins();
    }
    function androidStockBrowser() {

        var isAndroidMobile = UA.indexOf('android') > -1 && UA.indexOf('mozilla/5.0') > -1 && UA.indexOf('applewebkit') > -1;

        var regExAppleWebKit = new RegExp(/applewebkit\/([\d.]+)/);
        var resultAppleWebKitRegEx = regExAppleWebKit.exec(UA);
        var appleWebKitVersion = (resultAppleWebKitRegEx === null ? null : parseFloat(regExAppleWebKit.exec(UA)[1]));
        var isAndroidBrowser = isAndroidMobile && appleWebKitVersion !== null && appleWebKitVersion < 537;
        return isAndroidBrowser;
    }
    function findDevice() {
		//alert('test(/ip(a|ro)d/): '+test(/ip(a|ro)d/))
        if (test(/googletv|smarttv|smart-tv|internet.tv|netcast|nettv|appletv|boxee|kylo|roku|dlnadoc|roku|pov.tv|hbbtv|ce\-html/)) {
            // Check if user agent is a smart tv
            _this.deviceType = deviceTypes[0];
            _this.deviceModel = "smartTv";
        } else if (test(/xbox|playstation.3|wii/)) {
            // Check if user agent is a game console
            _this.deviceType = deviceTypes[0];
            _this.deviceModel = "gameConsole";
        } else if (test(/ip(a|ro)d/)) {
			//console.log('test(/ip(a|ro)d/): '+test(/ip(a|ro)d/))
            // Check if user agent is a iPad
            _this.deviceType = deviceTypes[1];
            _this.deviceModel = "ipad";
        } else if (test(/linux/) && test(/android/) && !test(/fennec|mobi|htc.magic|htcX06ht|nexus.one|sc-02b|fone.945/)) {
            // Check if user agent is an Android Tablet
            _this.deviceType = deviceTypes[1];
            _this.deviceModel = "android";
        } else if (test(/kindle/) || (test(/mac.os/) && test(/silk/))) {
            // Check if user agent is a Kindle or Kindle Fire
            _this.deviceType = deviceTypes[1];
            _this.deviceModel = "kindle";
        } else if (test(/gt-p10|sc-01c|shw-m180s|sgh-t849|sch-i800|shw-m180l|sph-p100|sgh-i987|zt180|htc(.flyer|\.flyer)|sprint.atp51|viewpad7|pandigital(sprnova|nova)|ideos.s7|dell.streak.7|advent.vega|a101it|a70bht|mid7015|next2|nook/) || (test(/mb511/) && test(/rutem/))) {
            // Check if user agent is a pre Android 3.0 Tablet
            _this.deviceType = deviceTypes[1];
            _this.deviceModel = "android";
        } else if (test(/bb10/)) {
            // Check if user agent is a BB10 device
            _this.deviceModel = "blackberry";
            if (test(/tablet/))
                _this.deviceType = deviceTypes[1];
            else
                _this.deviceType = deviceTypes[2];
        } else {
            // Check if user agent is one of common mobile types
            _this.deviceModel = exec(/ipad|iphone|ipod|android|blackberry|opera mini|opera mobi|skyfire|maemo|windows phone|palm|iemobile|symbian|symbianos|fennec|j2me/);
			//alert('in deviceModel: '+_this.deviceModel);
            if (_this.deviceModel !== null) {
                if (test(/tablet/) || String(_this.deviceModel).toLowerCase()=='ipad')
                    _this.deviceType = deviceTypes[1];
                else
                    _this.deviceType = deviceTypes[2];
                _this.deviceModel = String(_this.deviceModel);
            } else {
                _this.deviceModel = "";
                if (test(/bolt|fennec|iris|maemo|minimo|mobi|mowser|netfront|novarra|prism|rx-34|skyfire|tear|xv6875|xv6975|google.wireless.transcoder/)) {
                    // Check if user agent is unique Mobile User Agent
                    _this.deviceType = deviceTypes[2];
                } else if (test(/opera/) && test(/windows.nt.5/) && test(/htc|xda|mini|vario|samsung\-gt\-i8000|samsung\-sgh\-i9/)) {
                    // Check if user agent is an odd Opera User Agent - http://goo.gl/nK90K
                    _this.deviceType = deviceTypes[2];
                } else if (test(/windows.(nt|xp|me|9)/) && test(/touch/) && test(/tablet/)) {
                    // Check if user agent is Windows tablet PC
                    _this.deviceType = deviceTypes[3];
                    _this.deviceModel = 'windows tablet';
                } else if (test(/windows.(nt|xp|me|9)/) && test(/wpdesktop/) && test(/touch/)) {
                    // Check if user agent is Windows phone desktop mode
                    _this.deviceType = deviceTypes[2];
                    _this.deviceModel = 'windows phone';
                } else if ((test(/windows.(nt|xp|me|9)/) && !test(/phone/)) || test(/win(9|.9|nt)/) || test(/\(windows 8\)/)) {
                    // Check if user agent is Windows Desktop, "(Windows 8)" Chrome extra exception
                    _this.deviceType = deviceTypes[3];
                } else if (test(/macintosh|powerpc/) && !test(/silk/)) {
                    // Check if agent is Mac Desktop
                    _this.deviceType = deviceTypes[3];
                    _this.deviceModel = "mac";
                } else if (test(/linux/) && test(/x11/)) {
                    // Check if user agent is a Linux Desktop
                    _this.deviceType = deviceTypes[3];
                } else if (test(/solaris|sunos|bsd/)) {
                    // Check if user agent is a Solaris, SunOS, BSD Desktop
                    _this.deviceType = deviceTypes[3];
                } else if (test(/cros/)) {
                    // Check if user agent is a Chromebook
                    _this.deviceType = deviceTypes[3];
                } else if (test(/bot|crawler|spider|yahoo|ia.archiver|covario-ids|findlinks|dataparksearch|larbin|mediapartners-google|ng-search|snappy|teoma|jeeves|tineye/) && !test(/mobile/)) {
                    // Check if user agent is a Desktop BOT/Crawler/Spider
                    _this.deviceType = deviceTypes[3];
                    _this.deviceModel = "crawler";
                } else {
                    // Otherwise assume it is a Mobile Device
                    _this.deviceType = deviceTypes[2];
                }
            }
        }
    }
    function findOS() {
        /** OS finder **/
        if (_this.deviceModel !== "") {
            if (_this.deviceModel === "ipad" || _this.deviceModel === "iphone" || _this.deviceModel === "ipod") {
                _this.osName = "ios";
                _this.osVersion = (test(/os\s([\d.]+)/) ? RegExp.$1 : "").replace(/_/g, ".");
            } else if (_this.deviceModel === "android") {
                _this.osName = "android";
                _this.osVersion = (test(/android\s([\d\.]+)/) ? RegExp.$1 : "");
            } else if (_this.deviceModel === "blackberry") {
                _this.osName = "blackberry";
                _this.osVersion = (test(/version\/([^\s]+)/) ? RegExp.$1 : "");
            } else if (_this.deviceModel === "playbook") {
                _this.osName = "blackberry";
                _this.osVersion = (test(/os ([^\s]+)/) ? RegExp.$1.replace(";", "") : "");
            }
        }

        if (!_this.osName) {
            if (is("win") || is("16bit")) {
                _this.osName = "windows";
                if (is('wpdesktop') && is("windows nt 6.2")) {
                    _this.osName = "windows phone";
                    _this.deviceModel = 'windows phone';
                    _this.osVersion = "8";
                } else if (is("windows nt 6.2") && is("arm")) {
                    _this.osName = "windows rt";
                    _this.deviceModel = 'windows tablet';
                    _this.osVersion = "8";
                } else if (is('wpdesktop') && is("windows nt 6.3")) {
                    _this.osName = "windows phone";
                    _this.deviceModel = 'windows phone';
                    _this.osVersion = "8.1";
                } else if (is("windows nt 6.3") && is("arm")) {
                    _this.osName = "windows rt";
                    _this.deviceModel = 'windows tablet';
                    _this.osVersion = "8.1";
                } else if (is("windows nt 6.2") || test(/\(windows 8\)/)) { //windows 8 chrome mac fix
                    //_this.osVersion = "8";
                    _this.osVersion = "6.2";
                } else if (is("windows nt 10")) {
                 //_this.osVersion = "8.1";
                 _this.osVersion = "10";
                 } else if (is("windows nt 6.3")) {
                 //_this.osVersion = "8.1";
                 _this.osVersion = "6.3";
                 } else if (is("windows nt 6.1")) {
                 //_this.osVersion = "7";
                 _this.osVersion = "6.1";
                 } else if (is("windows nt 6.0")) {
                 //_this.osVersion = "vista";
                 _this.osVersion = "6.0";
                 } else if (is("windows nt 5.2") || is("windows nt 5.1") || is("windows xp")) {
                    //_this.osVersion = "xp";
                    _this.osVersion = "5.2";
                } else if (is("windows nt")) {
                    _this.osVersion = (test(/windows\snt\s([\d.]+)/) ? RegExp.$1 : "").replace(";", "");
                } else if (is('windows phone')) {
                    _this.osName = "windows phone";
                    _this.deviceModel = 'windows phone';
                    _this.osVersion = (test(/windows\sphone\s([\d.]+)/) ? RegExp.$1 : "").replace(/_/g, ".");
                } else if (is('windows phone os')) {
                    _this.osName = "windows phone";
                    _this.deviceModel = 'windows phone';
                    _this.osVersion = (test(/windows\sphone\sos\s([\d.]+)/) ? RegExp.$1 : "").replace(/_/g, ".");
                }
            } else if (is("mac") || is("darwin")) {
                _this.osName = "mac";
                if (is("68k") || is("68000")) {
                    _this.osVersion = "68k";
                } else if (is("ppc") || is("powerpc")) {
                    _this.osVersion = "ppc";
                } else if (is("os x")) {
                    _this.osVersion = (test(/os\sx\s([\d.]+)/) ? RegExp.$1 : "os x").replace(/_/g, ".");
                }
            } else if (is("webtv")) {
                _this.osName = "webtv";
            } else if (is("x11") || is("inux")) {
                _this.osName = "linux";
            } else if (is("sunos")) {
                _this.osName = "sun";
            } else if (is("irix")) {
                _this.osName = "irix";
            } else if (is("freebsd")) {
                _this.osName = "freebsd";
            } else if (is("bsd")) {
                _this.osName = "bsd";
            }
        }
    }

    function findBrowser() {
        /** Browser finder **/
        if (_this.osName === 'blackberry') {
            _this.browserEngine = "gecko";
            _this.browserName = "blackberry";
            _this.browserVersion = (test(/version\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (!test(/opera|webtv/) && (test(/msie\s([\d\w\.]+)/) || is("trident"))) {
            _this.browserEngine = "trident";
            _this.browserName = "ie";
            if (!window.addEventListener && document.documentMode && document.documentMode === 7) {
                _this.browserVersion = "8.compat";
            } else if (test(/trident.*rv[ :](\d+)\./)) {
                _this.browserVersion = RegExp.$1;
            } else {
                _this.browserVersion = (test(/trident\/4\.0/) ? "8" : RegExp.$1);
            }
        } else if (is("firefox")) {
            _this.browserEngine = "gecko";
            _this.browserName = "firefox";
            _this.browserVersion = (test(/firefox\/([\d\w\.]+)/) ? RegExp.$1 : "");
        } else if (is("gecko/")) {
            _this.browserEngine = "gecko";
        } else if (is("opera")) {
            _this.browserName = "opera";
            _this.browserEngine = "presto";
            _this.browserVersion = (test(/version\/([\d\.]+)/) ? RegExp.$1 : (test(/opera(\s|\/)([\d\.]+)/) ? RegExp.$2 : ""));
        } else if (is("opr")) {
            _this.browserName = "opera";
            _this.browserEngine = "presto";
            _this.browserVersion = (test(/version\/([\d\.]+)/) ? RegExp.$1 : (test(/opr(\s|\/)([\d\.]+)/) ? RegExp.$2 : ""));
        } else if (is("konqueror")) {
            _this.browserName = "konqueror";
        } else if (is("edge")) {
            _this.browserEngine = "webkit";
            _this.browserName = "edge";
            _this.browserVersion = (test(/edge\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (is("chrome")) {
            _this.browserEngine = "webkit";
            _this.browserName = "chrome";
            _this.browserVersion = (test(/chrome\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (is("iron")) {
            _this.browserEngine = "webkit";
            _this.browserName = "iron";
			_this.browserVersion = (test(/mobileiron\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (is("crios")) {
            _this.browserName = "chrome";
            _this.browserEngine = "webkit";
            _this.browserVersion = (test(/crios\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (is("applewebkit/")) {
            _this.browserName = "safari";
            _this.browserEngine = "webkit";
            _this.browserVersion = (test(/version\/([\d\.]+)/) ? RegExp.$1 : "");
        } else if (is("mozilla/")) {
            _this.browserEngine = "gecko";
        }
    }

    function findOrientation() {
        /** find orientation **/
        if (_this.deviceType !== deviceTypes[0] && _this.deviceType !== deviceTypes[3]) {
            if (window.innerHeight > window.innerWidth) {
                _this.deviceOrientation = "portrait";
            } else {
                _this.deviceOrientation = "landscape";
            }
        }
    }

    function findPlugins() {
        for (var alias in plugins2find) {
            if (plugins2find.hasOwnProperty(alias)) {
                var plugin = plugins2find[alias];
                if (findPlugin(plugin.substrs) || findObject(plugin.progIds, plugin.fns)) {
                    _this.plugins.push(alias);
                }
            }
        }
    }

    function findPlugin(substrs) {
        if (navigator.plugins) {
            for (i = 0, j = navigator.plugins.length; i < j; i += 1) {
                var plugin = navigator.plugins[i],
                        haystack = plugin.name + plugin.description,
                        found = 0;
                for (k = 0, l = substrs.length; k < l; k += 1) {
                    if (haystack.indexOf(substrs[k]) !== -1) {
                        found += 1;
                    }
                }
                if (found === substrs.length) {
                    return true;
                }
            }
        }
        return false;
    }
    function findObject(progIds, fns) {
        if (window.ActiveXObject) {
            for (i = 0, j = progIds.length; i < j; i += 1) {
                try {
                    var obj = new ActiveXObject(progIds[i]);
                    if (obj) {
                        return fns && fns[i] ? fns[i].call(obj) : true;
                    }
                } catch (e) {
                   
                }
            }
        }
        return false;
    }
    function videoSupport() {
        if (!!document.createElement('video').canPlayType)
        {
            var vidTest = document.createElement("video");
            oggTest = vidTest.canPlayType('video/ogg; codecs="theora, vorbis"');
            if (!oggTest)
            {
                h264Test = vidTest.canPlayType('video/mp4; codecs="avc1.42E01E, mp4a.40.2"');
                if (!h264Test)
                {
                    return false;//"Sorry. No video support."
                }
                else
                {
                    if (h264Test == "probably")
                    {
                        return true;//"Yeah! Full support!";
                    }
                    else
                    {
                        return true;//"Meh. Some support.";
                    }
                }
            }
            else {
                if (oggTest == "probably")
                {
                    return true;//"Yeah! Full support!";
                }
                else
                {
                    return true;////"Meh. Some support.";
                }
            }
        }
        else
        {
            return false;//"Sorry. No video support."
        }
    }
	function test(regex) {
        return regex.test(UA);
    }
    function exec(regex) {
        return regex.exec(UA);
    }
    function is(key) {
        return UA.indexOf(key) > -1;
    }
}