function DatabaseConnection() {
	var _this = this;
	
	_this.serverData = {
		
	};
	_this.initialLearnerTimeZone = '';
	_this.initialLearnerDateTime = '';


	_this.get = function (_url, _data, _callbackFunction) {	
		if(!APP.configObj.webHook.isActive){return false;}		
		$.ajax({
			type: "GET",
			url: _url,
            data: _data || '',
			dataType: "json",
			contentType:"application/json; charset=utf-8",
			success: function (data) {
				_callbackFunction(data);
			},
			error: function (err) {
				//console.log(err);
				console.log("An error occured: " + err.status + " " + err.statusText +" while loading: " +_url)
				//alert("An error occured: " + err.status + " " + err.statusText +" while loading: " +_url);
				/* if(err.responseText){
					alert(JSON.parse(err.responseText).message);
				} */
			}
		});
		/* let request = $.ajax({
			url: _url,
			method: "GET",
			data: _data || '',
			dataType: "json",
		});
		   
		request.done(function( msg ) {
			_callbackFunction(msg);
		}); */
		   
		/* request.fail(function( jqXHR, textStatus ) {
			console.log( "Request failed: " + textStatus );
		}); */
	}
    _this.post = function (_url, _data, _callbackFunction) {
		if(!APP.configObj.webHook.isActive){return false;}	
		$.ajax({
			type: "POST",
			url: _url,
			data: JSON.stringify(_data),
			dataType: "json",
			contentType:"application/json; charset=utf-8",
			success: function(data){
				//console.log('SUCCESS');
				//console.log(data);
				_callbackFunction(data);
			},
			error: function(err){
				//console.log('ERROR');
				//console.log(err);
				console.log("An error occured: " + err.status + " " + err.statusText +" while loading: " +_url)
				/* if(err.responseText){
					alert(JSON.parse(err.responseText).message);
				} */
			},
			
		});
		
	}
    _this.registerUser = function (_obj){  
		if(!APP.configObj.webHook.isActive){return false;}
		//console.log('----\nregisterUser...'); 

		var dataObj = {
			'registration_id': crypto.randomUUID(),
			'test_mode': APP.configObj.webHook.testMode,
			'course_id': APP.configObj.webHook.courseId,
			'student_id': APP.dataComObj.getStudentId() || 'test01',        
			'student_name': APP.dataComObj.getStudentId() || 'test01',
			'lang': APP.configObj.language.lang.toUpperCase(),
			'learner_timezone': _this.initialLearnerTimeZone,
			'registration_datetime_utc': _this.initialLearnerDateTime,
		}
		//console.log(dataObj);
		for(let i=0; i<APP.hooksList.length; i++){

			let curr = APP.hooksList[i];
			let name = curr.name;
			let url = curr.urls.registrationURL;

			if(curr.token != null && curr.token != ''){
				var headers = {"Authorization": "Bearer " + curr.token};
			}else{
				var headers = {};	
			}
			
			$.ajax({
				type: "POST",
				url: url,
				headers: headers,
				data: JSON.stringify(dataObj),
				dataType: "json",
				contentType:"application/json; charset=utf-8",
				success: function(data){
					
					/* if(data.newRecord){
						var regId = JSON.parse(data.newRecord)[0].registration_id;
						if(regId){_this.serverData.registration_id = regId;}
						
						if(_obj.onComplete){
							_obj.onComplete();
						}
					} */
					
					if(data.success === true || data.published === 1){
						//console.log('SUCCESS in '+name+' ::url: '+url);
						let msg ='<p class="pass">DATA '+(i+1)+': PASS</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);						
						_this.serverData.registration_id = dataObj.registration_id;
						if(_obj.onComplete){
							_obj.onComplete();
						}
					}else{
						console.log('registerUser ERROR in '+name+' ::url: '+url);
						//console.log(data);	
						let msg ='<p class="failed">DATA '+(i+1)+': FAILED</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);
					}	
				},
				error: function(err){
					let msg ='<p class="failed">DATA '+(i+1)+': ERROR</p>'
					$('#debug-screener').find('.hook-'+i).html(msg);
					console.log('registerUser ERROR in '+name+' ::url: '+url);					
					//console.warn("An error occured: " + err.status + " " + err.statusText +" while loading: " +url)
					/* if(err.responseText){
						alert(JSON.parse(err.responseText).message);
					} */
				},			
			});	
		}
			
    }
	_this.sendQuestionData = function (_obj){  
		if(APP.databaseConnObj.serverData.registration_id == null || APP.databaseConnObj.serverData.registration_id == undefined || APP.databaseConnObj.serverData.registration_id == 'undefined'){									
			APP.databaseConnObj.registerUser({
				onComplete: function(){					 
					_obj.data.registration_id = APP.databaseConnObj.serverData.registration_id;
					postQuestionData({data: _obj.data});
				}
			});
		}else{
			postQuestionData({data: _obj.data});
		}
		
	}
	postQuestionData = function(_obj){
		if(!APP.configObj.webHook.isActive){return false;}
		//console.log('----\npostQuestionData: ');
		//console.log(_obj.data);	
		
		var dataObj = _obj.data;
		for(let i=0; i<APP.hooksList.length; i++){

			let curr = APP.hooksList[i];
			let name = curr.name;
			let url = curr.urls.questionResponseURL;

			if(curr.token != null && curr.token != ''){
				var headers = {"Authorization": "Bearer " + curr.token};
			}else{
				var headers = {};	
			}
			
			$.ajax({
				type: "POST",
				url: url,
				headers: headers,
				data: JSON.stringify(dataObj),
				dataType: "json",
				contentType:"application/json; charset=utf-8",
				success: function(data){
					if(data.success === true || data.published === 1){
						//console.log('Question data SUCCESS in '+name+' ::url: '+url);
						//console.log(data);	
						let msg ='<p class="pass">DATA '+(i+1)+': PASS</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);
					}else{
						console.log('Question data ERROR in '+name+' ::url: '+url);
						//console.log(data);
						let msg ='<p class="failed">DATA '+(i+1)+': FAILED</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);
					}			
				},
				error: function(err){
					let msg ='<p class="failed">DATA '+(i+1)+': ERROR</p>'
					$('#debug-screener').find('.hook-'+i).html(msg);
					console.log('Question data ERROR in '+name+' ::url: '+url);
					//console.warn("An error occured: " + err.status + " " + err.statusText +" while loading: " +url)
					/* if(err.responseText){
						alert(JSON.parse(err.responseText).message);
					} */
				},			
			});
		}
	}
	_this.sendCompletionData = function (_obj){  
		if(APP.databaseConnObj.serverData.registration_id == null || APP.databaseConnObj.serverData.registration_id == undefined || APP.databaseConnObj.serverData.registration_id == 'undefined'){									
			APP.databaseConnObj.registerUser({
				onComplete: function(){					 
					_obj.data.registration_id = APP.databaseConnObj.serverData.registration_id;
					postCompletionData({data: _obj.data});
				}
			});
		}else{
			postCompletionData({data: _obj.data});
		}
		
	}
	postCompletionData = function(_obj){
		if(!APP.configObj.webHook.isActive){return false;}
		//console.log('----\npostCompletionData: ');
		//console.log(_obj.data);
		
		var dataObj = _obj.data;

		for(let i=0; i<APP.hooksList.length; i++){

			let curr = APP.hooksList[i];
			let name = curr.name;
			let url = curr.urls.completionURL;

			if(curr.token != null && curr.token != ''){
				var headers = {"Authorization": "Bearer " + curr.token};
			}else{
				var headers = {};	
			}
			
			$.ajax({
				type: "POST",
				url: url,
				headers: headers,
				data: JSON.stringify(dataObj),
				dataType: "json",
				contentType:"application/json; charset=utf-8",
				success: function(data){
					if(data.success === true || data.published === 1){
						//console.log('Completion data SUCCESS in '+name+' ::url: '+url);
						//console.log(data);
						let msg ='<p class="pass">DATA '+(i+1)+': PASS</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);		
					}else{
						//console.log('Completion data ERROR in '+name+' ::url: '+url);
						//console.log(data);	
						let msg ='<p class="failed">DATA '+(i+1)+': FAILED</p>'
						$('#debug-screener').find('.hook-'+i).html(msg);
					}			
				},
				error: function(err){
					let msg ='<p class="failed">DATA '+(i+1)+': ERROR</p>'
					$('#debug-screener').find('.hook-'+i).html(msg);
					console.log('Completion data ERROR in '+name+' ::url: '+url);
					//console.warn("An error occured: " + err.status + " " + err.statusText +" while loading: " +url)
					/* if(err.responseText){
						alert(JSON.parse(err.responseText).message);
					} */
				},			
			});
		}
	}
}