function CoverflowScreen() {
	var _this = this;
	var Selector = {};
	var popupAudio = '';
	_this.start = function (_obj) {
		Selector = {			
			CLASS_NAME: 'coverflow-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_SLIDE_CLASS: 'swiper-slide',			
			USE_SCREEN_LEVEL_NAV: true,
			PARAM_OBJ:{
				init: false,
				grabCursor: false,
				direction: 'horizontal',
				initialSlide: 0,
				effect: 'slide',
				mousewheel: { enabled: false},
				pagination: {
					el: $(Selector.ACTIVITY_CONTAINER).find('.swiper-pagination')[0],
					type: 'bullets',
					clickable: false,
				},
				navigation: {
					nextEl: $(Selector.ACTIVITY_CONTAINER).find('.swiper-next')[0],
					prevEl: $(Selector.ACTIVITY_CONTAINER).find('.swiper-back')[0],
					disabledClass: 'disabled',
					hiddenClass: 'hide'
				}
			},
			CLICK_ARRAY: [],
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			ON_REACH_END: null,
			isCompleted: false
		};
		$.extend(true, Selector, _obj);		
		//-- always set init false....
		Selector.PARAM_OBJ.init = false;
		initTemplate();
	}
	_this.updateSwiper = function(){
		if(Selector.scSwiper){
			Selector.scSwiper.update();
		}		
	}
	_this.destroySwiper = function(){
		if(Selector.scSwiper){
			Selector.scSwiper.destroy(true, true);
		}		
	}
	_this.gotoEndSlide = function(){
		if(Selector.scSwiper){
			
			Selector.scSwiper.slideTo(Selector.scSwiper.slides.length - 1);
		}		
	}
	_this.getSwiperObj = function(){
		if(Selector.scSwiper){			
			return Selector.scSwiper;
		}		
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER)
		.addClass(Selector.CLASS_NAME)
		.addClass('type-'+Selector.PARAM_OBJ.effect)
		.addClass('pagination-type-'+Selector.PARAM_OBJ.pagination.type);

		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){			
			$(this).attr('data-id', inx);
			$(this).addClass(Selector.ACTIVITY_SLIDE_CLASS+'_'+inx);
			$(this).attr('id', Selector.ACTIVITY_SLIDE_CLASS+'_'+inx);
		});
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
	}
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){
				var id = $(this).data('id');
				if(Selector.userData[id] == 1){
					$(this).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){
				Selector.userData.push(0);
			});
		}		
		updateStatus();
	}
	function addTemplateEvent() {
		
		var swiperContainer = $(Selector.ACTIVITY_CONTAINER).find('.swiper-container')[0];
		
		//-- to support multiple format we pass Parameter from screen
		//-- ref link - https://swiperjs.com/api/#parameters
		Selector.scSwiper = new Swiper(swiperContainer, Selector.PARAM_OBJ);
		
		Selector.scSwiper.on('init', function () {
			if (Selector.ON_INIT) {
				Selector.ON_INIT();
			}				
			//for 1st slide
			updateValue(this);
		});
		Selector.scSwiper.on('slideChange', function () {
			APP.commonFunObj.playSoundEffect({name: 'coverFlow'});
			updateValue(this);			
		});
		Selector.scSwiper.on('reachEnd', function () {
			//to complete all slide
			for(var i = 0; i<this.slides.length; i++){
				Selector.userData[i] = 1;
				$(this.slides[i]).addClass('visited');
			}
			if (Selector.ON_REACH_END) {
				Selector.ON_REACH_END();
			}
			
			updateValue(this);			
		});
		Selector.scSwiper.init();
	}
	
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	//code for global nav next back 
	$(document).on(APP.eventObj.ON_SWIPER_NEXT, function (e) {
		applySwiperNext();
	});
	$(document).on(APP.eventObj.ON_SWIPER_BACK, function (e) {
		applySwiperBack();
	});
	$(document).on(APP.eventObj.ON_SWIPER_SLIDE_TO, function (e, inx) {
		applySwiperSlideTo(inx);
	});
	function applySwiperNext(){
		if(Selector.scSwiper){
			Selector.scSwiper.slideNext();
		}
	}
	function applySwiperBack(){		
		if(Selector.scSwiper){			
			Selector.scSwiper.slidePrev();
		}
	}
	function applySwiperSlideTo(_inx){		
		if(Selector.scSwiper){			
			Selector.scSwiper.slideTo(_inx);
		}
	}
	
	//--
	function updateValue(_obj){
		Selector.userData[_obj.activeIndex] = 1;
		var currEl = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS+'[data-id="'+_obj.activeIndex+'"]')
		currEl.addClass('visited');
		currEl.find('.scroll-parent').scrollTop(0);
		ValidateBtnState(_obj.activeIndex);
		updateStatus();
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({id: _obj.activeIndex, arr: Selector.userData, el:currEl, swiObj:_obj });
		}
		//--for popup el animation			
		var aniEl = $(currEl).find('.pop-ani-el');
		if(aniEl.length){
			aniEl.each(function(inx){
				$(this).removeClass('visibility-hidden'); 
				var aniObj = APP.animationObj.generateAniObj($(this));
				aniObj.ON_COMPLETE = function(){
					
				}
				APP.animationObj.animate(aniObj);
			})
		}
		//--
		//--for pop audio
		if(popupAudio != null && popupAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		//--for pop audio
		popupAudio = $(currEl).data('audioPath') || '';
		//console.log('popupAudio: '+popupAudio);
		if(popupAudio != null && popupAudio != ''){
			APP.commonFunObj.playScreenAudio({
				path: popupAudio,
				onPlay: function(){
				},
				onEnd: function(){								
				}
			});
		}
		//--
	}
	function updateStatus() {	
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
	function ValidateBtnState(_curr){
		var curr = _curr || 0;
		var tot = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).length;
		
		if(Selector.USE_SCREEN_LEVEL_NAV == false){
			if(curr == 0){
				APP.navigationObj.addOrRemoveBackBtnClass('swiper-back-gb', false);
			}else{
				APP.navigationObj.addOrRemoveBackBtnClass('swiper-back-gb', true);
			}
			if(curr >= (tot - 1)){
				APP.navigationObj.addOrRemoveNextBtnClass('swiper-next-gb', false);
			}else{
				APP.navigationObj.addOrRemoveNextBtnClass('swiper-next-gb', true);
			}
		}
	}
}