function HorizontalAccordionScreen() {
	var _this = this;
	var Selector = {};
	var preloadImgArr=[];
	var popupAudio = '';
	var videoTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'horizontal-accordion-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_SLIDE_CLASS: 'slide',	
			ACTIVITY_BTN_CLASS: 'click-btn',	
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},		
			TYPE: '',
			OPEN_SLIDE_PERCENTAGE: 60,
			IS_ACCORDION_ON_MOBILE: false,
			DEFAULT_FIRST_OPEN: true,
			CLICK_ARRAY: [],
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			isCompleted: false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.closeAllPopup = function(_activity_container){			
		var activity_container	= _activity_container || Selector.ACTIVITY_CONTAINER;
		$(activity_container).find('.'+Selector.ACTIVITY_SLIDE_CLASS).removeClass('current');
		$(activity_container).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
	}	
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		var currentView = APP.commonFunObj.getCurrentView();
		if(currentView == 'mobile' && Selector.IS_ACCORDION_ON_MOBILE == true){
			Selector.DEFAULT_FIRST_OPEN = false;
		}
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);
		
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){
			$(this).addClass(Selector.ACTIVITY_SLIDE_CLASS+'-'+inx);	
			$(this).find('.click-btn')
			.addClass('click-btn-'+inx)
			.attr('data-id', inx)
			.attr('id', 'click-btn-'+inx);

			$(this).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			
		});
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		//-- to open 1st slide
		if(Selector.DEFAULT_FIRST_OPEN){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.click-btn-0').trigger('click');
		}
	}
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){
				var btnObj = $(this).find( ".click-btn" );
				var id = $(btnObj).data('id');
				if(Selector.userData[id] == 1){
					$(this).addClass('visited');
					$(btnObj).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).each(function(inx){
				Selector.userData.push(0);
			});
		}		
		updateStatus();
	}
	
	function addTemplateEvent() {
		
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.click-btn').on('click', function (e) {
			if($(this).parents('.'+Selector.ACTIVITY_SLIDE_CLASS).hasClass('current')){return false;};
			var currBtn = $(this);
			var parentBlock = $(this).parents('.'+Selector.ACTIVITY_SLIDE_CLASS);
			if(parentBlock.hasClass('current')){return false;};
			
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			var id = parseInt($(this).data('id'));

			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).css('width', '10%');
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).removeClass('current');
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.front-block').removeClass('hide');
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.inner-block').addClass('hide');
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.ACTIVITY_SLIDE_CLASS).find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			
			
			parentBlock.addClass('visited current');
			parentBlock.find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
			parentBlock.css('width', Selector.OPEN_SLIDE_PERCENTAGE+'%');			
			Selector.userData[id] = 1;
			var t = $(this).attr('data-link');
			//to open transcript pdf 
			if(t){
				var transWin = window.open(t,'_blank');
				transWin.focus();
				if (Selector.ON_CLICK) {
					Selector.ON_CLICK({id: id, arr:Selector.userData});
				}	
				updateStatus();	
				return false;
			}
			$(Selector.ACTIVITY_CONTAINER).data('current-pop', id);
			var currPop = parentBlock.find('.inner-block');
			currPop.removeClass('hide');
			//--for pop audio
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.removeScreenAudio();
			}
			//--
			
			//for animation	
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			
			//--for pop audio
			popupAudio = $(currPop).data('audioPath') || '';
			//console.log('popupAudio: '+popupAudio);
			$(currPop).find('.scroll-parent').scrollTop(0);	
			aniObj.ON_COMPLETE = function(){
				
				//--for pop audio
				popupAudio = $(currPop).data('audioPath') || '';
				//console.log('popupAudio: '+popupAudio);
				if(popupAudio != null && popupAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: popupAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}
				//--		
			};			
						
			currPop.show();
						
			if($('body').hasClass('responsive')){	
				//--check only when responsive 		
				isInView = APP.commonFunObj.isElementInView($(currPop));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
				}
				
			}
			APP.animationObj.animate(aniObj);		
			//--for popup el animation
			var aniEl = $(currPop).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			currPop.find('.scroll-parent').scrollTop(0);	
					
		
			//--
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr:Selector.userData});
			}	
			updateStatus();		
			

		});
		
	}
	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
}