function HotSpotScreen() {
	var _this = this;
	var Selector = {};
	var popupAudio = '';
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'hotspot-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			HOTSPOT_PANEL_CLASS: 'hotspot-panel',
			HOTSPOT_BTN_CLASS: 'hotspot-btn',
			HOTSPOT_POP_CLASS: 'hotspot-pop',
			TRIGGER: 'click',
			ON_CLICK: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			CLICK_ARRAY: [],
			isCompleted:false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.enableDisabledBtn = function(_val){
		enableDisabledBtn(_val);
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);

		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_PANEL_CLASS).each(function(inx){		
			$(this).attr('data-id', inx);
			$(this).addClass(Selector.HOTSPOT_PANEL_CLASS+'_'+inx);	
			$(this).find('.'+Selector.HOTSPOT_BTN_CLASS).attr('data-id', inx).addClass(Selector.HOTSPOT_BTN_CLASS+'_'+inx);
			
		});
		Selector.hotSpotPanel = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_PANEL_CLASS);

		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_POP_CLASS).each(function(inx){		
			$(this).attr('data-id', inx);	
			$(this).addClass(Selector.HOTSPOT_POP_CLASS+'_'+inx);	
		});

		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent(); 
		APP.preloaderObj.hide();
	}
	
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			Selector.hotSpotPanel.each(function(inx){
				var id = $(this).data('id');
				if(Selector.userData[id] == 1){
					$(this).find('.'+Selector.HOTSPOT_BTN_CLASS).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			Selector.hotSpotPanel.each(function(inx){
				Selector.userData.push(0);
			});
		}
		
		updateStatus();
	}

	function addTemplateEvent() {
		if(Selector.TRIGGER == 'click'){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_BTN_CLASS).on('click', function(e){
				if($(this).hasClass('disabled') ){return false;};
				e.stopPropagation();
				APP.commonFunObj.playSoundEffect({name: 'clicked'});
				ShowPop($(this));
			})
		}else{
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_BTN_CLASS)
			.mouseenter(function(e) {
				if($(this).hasClass('disabled') || $(this).hasClass('current')){return false;};
				e.stopPropagation();
				
				ShowPop($(this));
			})		
			.mouseleave(function(e) {
				if($(this).hasClass('disabled') ){return false;};
				$(Selector.ACTIVITY_CONTAINER).find('.tooltip-pop').hide();	
				$(this).removeClass('current');
				if(Selector.TYPE == '1'){
					$(Selector.ACTIVITY_CONTAINER).find('.line').css('background-color', '#B8B8B8');
				}	
			})
		}
	}
	
	function ShowPop(_btnObj){
		var id = parseInt($(_btnObj).data('id'));
		
		if($(_btnObj).hasClass('current')){			
			$(_btnObj).removeClass('current');
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_POP_CLASS+'_'+id).fadeOut();	
			return false;	
		}
		
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_BTN_CLASS).removeClass('current');
		$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_POP_CLASS).hide();		
		
		$(_btnObj).addClass('current');
		Selector.userData[id] = 1;			
		var currPop = $(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_POP_CLASS+'_'+id);
		//--for pop audio
		if(popupAudio != null && popupAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--	
		//for animation	
		var aniObj = APP.animationObj.generateAniObj($(currPop));
		aniObj.ON_COMPLETE = function(){
			
			
			//--for pop audio
			popupAudio = $(currPop).data('audioPath') || '';
			//console.log('popupAudio: '+popupAudio);
			if(popupAudio != null && popupAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: popupAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}
			//--		
		};
		currPop.show();
		currPop.find('.scroll-parent').scrollTop(0);	
		//--no need to scroll
		/* if($('body').hasClass('responsive')){	
			//--check only when responsive 			
			isInView = APP.commonFunObj.isElementInView($(currPop));
			if(!isInView){
				APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
			}
		} */
		APP.animationObj.animate(aniObj);
		
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({id: id, arr:Selector.userData});
		}	
		updateStatus();	
	}
	function enableDisabledBtn(_val){
		if(_val){
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_BTN_CLASS).removeClass('disabled');
		}else{
			$(Selector.ACTIVITY_CONTAINER).find('.'+Selector.HOTSPOT_BTN_CLASS).addClass('disabled');
		}
	}
	function updateTemplateLayout() {		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});

	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
}