function ModalPop() {
	var _this = this;
	var Selector = {};
	var isVidPlaying = false;
	var isVidEnded = false;
	var isAudPlaying = false;
	_this.start = function (_obj) {
		Selector = {			
			XML_NODE: null,
			CLASS_NAME: 'modal-pop',
			CONTAINER: '#global-modal-pop',
			VIEW_FILE: '',
			SHOW_ANIMATION: true,
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},
			ON_OK: null,
			ON_CLOSE: null,
			ALLOW_BG_CLICK_CLOSE: false,
			isLoaded: false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.getClassName = function(){
		return Selector.CLASS_NAME;
	}
	_this.closeModal = function(){
		processModal(true);
	}
	function initTemplate() {
		Selector.isLoaded = false;
		//-- for multi tutorial pop	
		var tuExtraClass="";	
		if(Selector.CLASS_NAME == 'tutorial-pop'){
			var popXmlObj = APP.globalXmlsObj.globalXML.tutorialPop;
			if(popXmlObj){
				if(popXmlObj[APP.navData.topicId]){
					Selector.XML_NODE = popXmlObj[APP.navData.topicId];
					tuExtraClass = 'tutorial-pop_'+APP.navData.topicId;
				}else{
					Selector.XML_NODE = popXmlObj[0];
					tuExtraClass = 'tutorial-pop_0'
				}
			}else{

			}
		}
		//--
		if(Selector.XML_NODE == null){
			console.warn('XML NOT FOUND...')
			return;
		}
		if(APP.globalMessageOpen){return false;}
		APP.preloaderObj.show();
		$(Selector.CONTAINER).addClass(Selector.CLASS_NAME).addClass(tuExtraClass);
		if(Selector.VIEW_FILE != null && Selector.VIEW_FILE !== ''){
			//load html view
			$(Selector.CONTAINER).load(Selector.VIEW_FILE, function (responseTxt, statusTxt, xhr) {
				if (statusTxt == "success") {
					applyAniObj();
					$(document).trigger(APP.eventObj.ON_MODAL_HTML_LOAD);
					loadComplete();					
				}
				if (statusTxt == "error") {
					alert("An error occured: " + xhr.status + ": " + xhr.statusText+" : "+Selector.VIEW_FILE);					
				}
			});
			
		}else{
			$(Selector.CONTAINER).html(getAlertWinHtml());		
			applyData();	
		}
			
		
	}
	function getAlertWinHtml(){
		var str="";
		str+='<div class="modal-box">';
			str+='<div class="modal-alert">';
				str+='<div class="modal-titlebar">';
						
				str+='</div>';
				str+='<div class="modal-content-box">';
					
				str+='</div>';
				str+='<div class="modal-btnpane">';
					str+='<div class="modal-btn"></div>';
				str+='</div>';
			str+='</div>';
		str+='</div>';
		return str;
	}
	function applyData(){
		var textObj = Selector.XML_NODE;
		var str ='';
		applyAniObj();
		if(textObj.headerBar){
			var headerObj = textObj.headerBar[0];
			if(headerObj.closeBtn){
				var _obj = headerObj.closeBtn[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str += '<a class=" btn modal-btn '+_className+' close-modal-btn" style ="'+_style+'" href="javascript:void(0);" >';
					/*str +='<span class="btn-txt display-cell v-center">'+_txt+'</span>';*/
					str +='<span class="btn-icon font-icon icon-cross display-cell v-center"></span>';
				str+='</a>';
			}
			if(headerObj.title){
				var _obj = headerObj.title[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str+='<span class="modal-title '+_className+'" style="'+_style+'">'+_txt+'</span>';	
			}
			if(headerObj.text){
				var _obj = headerObj.text[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str+='<span class="modal-title-txt '+_className+'" style="'+_style+'">'+_txt+'</span>';	
			}
			
			$(Selector.CONTAINER).find('.modal-titlebar').html(str);
		}else{
			$(Selector.CONTAINER).find('.modal-titlebar').remove();
		}
		str ='';
		if(textObj.ostPanel){
			var ostObj = textObj.ostPanel[0];
			var _className = ostObj.className || '';
			var _style = ostObj.style || '';
			str+='<div class="scroll-parent"><div class="scrollable">';
				str+='<div class="parent-box">';
				if(ostObj.text){
						str+='<div class="content-panel '+_className+'" style="'+_style+'">';
							str += APP.getHtmlStructObj.textPanelStruct(ostObj);					
						str+='</div>';				
				}
				//--for extra panel
				if(ostObj.extraPanel){
					var _eclassName = ostObj.extraPanel[0].className || '';
					var _estyle = ostObj.extraPanel[0].style || '';
					str+='<div class="extra-panel '+_eclassName+'" style="'+_estyle+'">';
					if(ostObj.extraPanel[0].text){
						str += APP.getHtmlStructObj.textPanelStruct(ostObj.extraPanel[0]);	
					}				
					str+='</div>';				
				}
				//--
				if($(Selector.CONTAINER).hasClass('tutorial-pop')){
					//add image
					if(ostObj.imgPath != null && ostObj.imgPath!=''){
						str+='<div class="col col-img right panel-img background" style="background-image:url('+ostObj.imgPath+');"></div>'
					}
				}
				str+='</div>';
				if($(Selector.CONTAINER).hasClass('tutorial-pop')){
					if(textObj.activityPanel){
						str+='<div class="line-spacer"><span class="line"></span></div>';
						if(textObj.activityPanel[0].instrText){
							var acInstrTxtObj = textObj.activityPanel[0].instrText[0];
							var _style = acInstrTxtObj.style || "";
							var _className = acInstrTxtObj.className || "";
							str+='<div class="instr-panel '+_className+'" style="'+_style+'">';
								str+='<p class="instr-txt" >'+acInstrTxtObj.Text+'</p>';
							str+='</div>';
						}
						if(textObj.activityPanel[0].accordion){
							var acAccoObj = textObj.activityPanel[0].accordion[0];
							var _style = acAccoObj.style || "";
							var _className = acAccoObj.className || "";
							/* 1 */str += '<div class="tut-accordion-panel '+_className+'" style="'+_style+'">';
								/* 2 */str += '<div class="panel-group " id="tuto-activty-accordion" role="tablist" aria-multiselectable="true">';
								for(var i=0; i<acAccoObj.tab.length; i++){
									var curr = acAccoObj.tab[i];			
									str += '<div class="panel panel-default tab-panel-'+i+'">';
										str += '<div class="clickable accordion-btn-panel clickable-'+i+'" data-id="'+i+'" role="tab" id="tut-accordion-heading_'+i+'">';
										var _btclass = curr.buttonTag[0].className || '';
										var _btstyle = curr.buttonTag[0].style || '';				
										var btnTextObj = curr.buttonTag[0].btnText;					
											str += '<a class="btn click-btn collapsed display-table '+_btclass+'" style="'+_btstyle+'" data-toggle="collapse" data-parent="#tuto-activty-accordion" href="#tut-accordion-collapse_'+i+'" aria-expanded="false" aria-controls="tut-accordion-collapse_'+i+'">';	
												if(btnTextObj){
													var _class = btnTextObj[0].className || '';
													var _style = btnTextObj[0].style || '';
													var _txt = btnTextObj[0].Text || '';
													str += '<span class="display-cell v-center btn-txt '+_class+' " style ="'+_style+'" >'+_txt+'</span>';
												}	
												str += '<span class="btn-icon font-icon v-center display-cell '+Selector.FONT_ICON_CLASS_OBJ.plus+'"></span>';	
											str += '</a>';
										str += '</div>';
										//--popup
										var popupObj = acAccoObj.tab[i].popup;
										var _class = popupObj[0].className || '';
										var _style = popupObj[0].style || '';
										str += '<div id="tut-accordion-collapse_'+i+'" class="panel-collapse collapse '+_class+'" style="'+_style+'" role="tabpanel" aria-labelledby="tut-accordion-heading_'+i+'">';
											str += '<div class="panel-body">';
												str+='<div class="text-box">';
													str += APP.getHtmlStructObj.textPanelStruct(popupObj[0].textBlock[0]);					
												str+='</div>';			 
											str += '</div>';
										str += '</div>';
									str += '</div>';
															
								}
								/* 2 */str += '</div>';		
							/* 1 */str += '</div>';	
						}
						if(textObj.activityPanel[0].instrText1){
							var acInstrTxt1Obj = textObj.activityPanel[0].instrText1[0];
							var _style = acInstrTxt1Obj.style || "";
							var _className = acInstrTxt1Obj.className || "";
							str+='<div class="instr-panel instr1-panel '+_className+'" style="'+_style+'">';
								str+='<p class="instr-txt" >'+acInstrTxt1Obj.Text+'</p>';
							str+='</div>';
						}
					}
				}
				//--for help pop
				if($(Selector.CONTAINER).hasClass('help-pop')){
					var helpObj = textObj.ostPanel[0].helpRow;
					if(helpObj){
						str+='<div class="help-panel">';
						for(var i=0; i<helpObj.length; i++){
							var currHelp = helpObj[i];
							var rClass = currHelp.className || '';
							var rStyle = currHelp.style || '';
							str+='<div class="help-row '+rClass+'" style="'+rStyle+'">';
								if(currHelp.buttonBlock){
									var bbClass = currHelp.buttonBlock[0].className || '';
									var bbStyle = currHelp.buttonBlock[0].style || '';
									str+='<div class="block block-button '+bbClass+'" style="'+bbStyle+'">';
										for(var j=0; j<currHelp.buttonBlock[0].btn.length; j++){
											var currBtn = currHelp.buttonBlock[0].btn[j];
											var bClass = currBtn.className || '';
											var bStyle = currBtn.style || '';
											str+='<div class="btn '+bClass+'" style="'+bStyle+'">';
												if(currBtn.icon){
													var iClass = currBtn.icon[0].className || '';
													var iStyle = currBtn.icon[0].style || '';
													str+='<span class="icon '+iClass+'" style="'+iStyle+'"></span>';
												}
												if(currBtn.text){												
													if(currBtn.text[0] != null && currBtn.text[0].Text !=""){													
														var tClass = currBtn.text[0].className || '';
														var tStyle = currBtn.text[0].style || '';	
														var tt = currBtn.text[0].Text;
														str+='<span class="txt '+tClass+'" style="'+tStyle+'">'+tt+'</span>';
													}
												}
											str+='</div>';
										}
									str+='</div>';
								}
								if(currHelp.textBlock){
									var tbClass = currHelp.textBlock[0].className || '';
									var tbStyle = currHelp.textBlock[0].style || '';
									str+='<div class="block block-text '+tbClass+'" style="'+tbStyle+'">';
										if(currHelp.textBlock[0].text){
											str += APP.getHtmlStructObj.textPanelStruct(currHelp.textBlock[0]);	
										}
									str+='</div>';
								}						
							str+='</div>';
						}
						str+='</div>';
					}
				}
				str+='</div></div>';	
			//--
			$(Selector.CONTAINER).find('.modal-content-box').html(str);
			//--for progressbar
			var prEl = $('.help-progress.circle-progress-bar');
			APP.progressBarObj.createHtml(prEl);
			APP.progressBarObj.rotationUpdate(50, 90, prEl);
			//--
		}else{
			$(Selector.CONTAINER).find('.modal-content-box').remove();
		}
		str ='';
		if(textObj.bottomBar){
			var btmObj = textObj.bottomBar[0];
			if(btmObj.buttonTag){
				for(var i=0; i<btmObj.buttonTag.length; i++){
					var btnTagObj = btmObj.buttonTag[i];
					var _class = btnTagObj.className || '';
					var _style = btnTagObj.style || '';
					
					str += '<div class="btn-panel"><a class=" btn modal-btn '+_class+' " style ="'+_style+'" href="javascript:void(0);" data-id="'+i+'">';
					var iconObj = btnTagObj.btnIcon;
					if(iconObj){
						var _class = iconObj[0].className || '';
						var _style = iconObj[0].style || '';
						var _txt = iconObj[0].Text || '';					
						str += '<span class="btn-icon display-cell v-center '+_class+' " style ="'+_style+'">'+_txt+'</span>';
					}
					
					var btnTextObj = btnTagObj.btnText;
					if(btnTextObj){
						var _class = btnTextObj[0].className || '';
						var _style = btnTextObj[0].style || '';
						var _txt = btnTextObj[0].Text || '';					
						str += '<span class="btn-txt display-cell v-center">'+_txt+'</span>';
					}
					str += '</a></div>';
				}				
			}
			$(Selector.CONTAINER).find('.modal-btnpane').html(str);
		}else{
			$(Selector.CONTAINER).find('.modal-btnpane').remove();
		}		
		loadComplete();		
	}
	function applyAniObj(){
		//--apply animation data
		var textObj = Selector.XML_NODE;
		if(textObj.dataAnimateType && textObj.dataAnimateType != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-type', textObj.dataAnimateType);
		}
		if(textObj.dataAnimateStartVal && textObj.dataAnimateStartVal != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-start-val', textObj.dataAnimateStartVal);
		}
		if(textObj.dataAnimateEndVal && textObj.dataAnimateEndVal != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-end-val', textObj.dataAnimateEndVal);
		}
		if(textObj.dataAnimateEase && textObj.dataAnimateEase != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-ease', textObj.dataAnimateEase);
		}
		if(textObj.dataAnimateDuration && textObj.dataAnimateDuration != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-duration', textObj.dataAnimateDuration);
		}
		if(textObj.dataAnimateDelay && textObj.dataAnimateDelay != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-delay', textObj.dataAnimateDelay);
		}
		if(textObj.dataAnimateRepeat && textObj.dataAnimateRepeat != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-repeat', textObj.dataAnimateRepeat);
		}
		if(textObj.dataAnimateYoyo && textObj.dataAnimateYoyo != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-yoyo', textObj.dataAnimateYoyo);
		}	
		if(textObj.dataAnimateReversed && textObj.dataAnimateReversed != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-reversed', textObj.dataAnimateReversed);
		}		
	
		//--
	}
	function loadComplete(){
		APP.preloaderObj.hide();		
		$(Selector.CONTAINER).find('.user-selected-dd-lang').html(APP.userSelectedlangDD.name);
		
		//--for responsive
		$('body').addClass('modal-open');
		//--
		//--apply dynamic value attempt popup
		if(APP.configObj.assessment[APP.globalQuizObj.currentQuizId].isAvailable){
			$(Selector.CONTAINER).find('.current-attempt').html(APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataCurrentAttempt);
			$(Selector.CONTAINER).find('.total-attempts').html(APP.configObj.assessment[APP.globalQuizObj.currentQuizId].noOfAttempts);
		}		
		//--pause video and audio
			if(APP.vidPlayer){
				isVidPlaying = !(APP.vidPlayer.paused);
				isVidEnded = (APP.vidPlayer.ended);
				if(isVidPlaying && !isVidEnded){
					//video is playing so stop them
					APP.vidPlayer.pause();
				}
			}			
			if(APP.screenAudio){isAudPlaying = APP.screenAudio.playing() || false;}		
			
			if(isAudPlaying){APP.screenAudio.pause();}
			
		//--

		$(Selector.CONTAINER).show();		
		var alertObj = $(Selector.CONTAINER).find('.modal-alert');
		APP.globalMessageOpen = true;
		if(Selector.SHOW_ANIMATION){			
			var aniObj = APP.animationObj.generateAniObj($(alertObj));
			$(Selector.CONTAINER).find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				
				updateModalPopLayout();
				
				Selector.isLoaded = true;
				//--for popup el animation 
				var aniEl = $(aniObj.EL).find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
			}
			APP.animationObj.animate(aniObj);
				
		}else{
			alertObj.show();
			
			updateModalPopLayout();
			$(Selector.CONTAINER).find('.scroll-parent').scrollTop(0);
			Selector.isLoaded = true;
			//--for popup el animation
			var aniEl = $(alertObj).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
		}
		
		addTemplateEvent();
	}
	function addTemplateEvent() {
		$(Selector.CONTAINER).find('.modal-btn').on('click', function(){
			if($(this).hasClass('yes-btn') || $(this).hasClass('ok-btn') || $(this).hasClass('continue-btn')){				
				processModal('true');
			}
			if($(this).hasClass('close-modal-btn') || $(this).hasClass('cancel-btn') || $(this).hasClass('hide-btn') || $(this).hasClass('no-btn')){				
				processModal('false');
			}
			
		})
		//--for accordion minus icon
		$(Selector.CONTAINER).find('.tut-accordion-panel .panel-group').on('show.bs.collapse', function (e) {
			var curr = '#'+e.target.id;
			var btnObj = $(curr).siblings( ".accordion-btn-panel" )
			var id = parseInt(btnObj.data('id'));
			
			$(curr).siblings( ".accordion-btn-panel" ).find('.btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);
			btnObj.addClass('visited current');			
			
		})
		//--for accordion plus icon
		$(Selector.CONTAINER).find('.tut-accordion-panel .panel-group').on('hide.bs.collapse', function (e) {			
			var curr = '#'+e.target.id;
			var btnObj = $(curr).siblings( ".accordion-btn-panel" )
			var id = parseInt(btnObj.data('id'));
			$(curr).siblings( ".accordion-btn-panel" ).find('.btn-icon').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);
			btnObj.removeClass('current');
		})
		//--
		$(Selector.CONTAINER).off('click');
		if(Selector.ALLOW_BG_CLICK_CLOSE){
			$(Selector.CONTAINER).on('click', function(e){
				if($(this).attr('class') == $(e.target).attr('class')){
					if(Selector.isLoaded){
						processModal('false');
					}
				};
				
			});
		}
		
	}
	
	function processModal(_state){
		Selector.isLoaded = false;
		var alertObj = $(Selector.CONTAINER).find('.modal-alert');
		//--for responsive
		$('body').removeClass('modal-open');
		//--
		if(Selector.SHOW_ANIMATION){
			var aniObj = APP.animationObj.generateAniObj($(alertObj));
			aniObj.REVERSED = true;
			aniObj.ON_COMPLETE = function(){					
				APP.globalMessageOpen = false;
				if(APP.modalVidPlayer){
					APP.modalVidPlayer.destroy();
					APP.modalVidPlayer = null;
				} 
				if(APP.vidPlayer){
					if(isVidPlaying && !isVidEnded){
						//video is playing so play them again 
						APP.vidPlayer.play();					
					}
				}
				if(isAudPlaying){APP.screenAudio.play();}	
					
				$(Selector.CONTAINER).attr('class', 'global-modal-pop');
				$(Selector.CONTAINER).attr('style', '');
				$(Selector.CONTAINER).html('');
				$(Selector.CONTAINER).fadeOut('fast');		
				if(_state == 'true'){
					if(Selector.ON_OK){
						Selector.ON_OK();
					}
				}else{
					if(Selector.ON_CLOSE){
						Selector.ON_CLOSE();
					}
				}
				APP.globalModalObj = null;
				APP.commonFunObj.checkScreenSizePop();	
			}
			APP.animationObj.animate(aniObj);

		}else{
			$(Selector.CONTAINER).find('.modal-alert').hide();
			APP.globalMessageOpen = false;				
			$(Selector.CONTAINER).attr('class', 'global-modal-pop');
			$(Selector.CONTAINER).attr('style', '');
			$(Selector.CONTAINER).html('');
			$(Selector.CONTAINER).fadeOut('fast');
			if(APP.modalVidPlayer){
				APP.modalVidPlayer.destroy();
				APP.modalVidPlayer = null;
			} 
			if(APP.vidPlayer){
				if(isVidPlaying && !isVidEnded){
					//video is playing so play them again 
					APP.vidPlayer.play();
				}
			}
			if(isAudPlaying){APP.screenAudio.play();}	
			
			if(_state == 'true'){
				if(Selector.ON_OK){
					Selector.ON_OK();
				}
			}else{
				if(Selector.ON_CLOSE){
					Selector.ON_CLOSE();
				}
			}
			APP.globalModalObj = null;
			APP.commonFunObj.checkScreenSizePop();
		}	
		
	}
	function updateTemplateLayout() {	
		updateModalPopLayout();
	}
	function updateModalPopLayout(){
		if(APP.globalModalObj){
			var contHt = $(Selector.CONTAINER).height();
			var boxHt = $(Selector.CONTAINER).find('.modal-box').outerHeight(true);
						
			if((boxHt!=null && contHt!=null) && (boxHt > contHt)){
				$(Selector.CONTAINER).find('.modal-box').addClass('top');
			}else{
				$(Selector.CONTAINER).find('.modal-box').removeClass('top');
			}
			//--for help larger popup mobile
			if($('body').hasClass('responsive')){ 
				/* if(Selector.CLASS_NAME == 'help-pop'){
					$(Selector.CONTAINER).find('.modal-box').addClass('top');
				} */
			}
		}	
	}
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
}