function DragNDropSortQuestion() {
	var _this = this;
	var Selector = {};	
	var feedbackAudio = '';
	var defaultValue = -1;
	var time = new Date();
	var startTime;
	var rowSize   = 150;
	var colSize   = 250;
	var totalRows = 3;
	var totalCols = 3;

	var cells = [];
	var container,listItems,sortables,total;

	var scalex = APP.scalex || 1;
	APP.prevView = APP.commonFunObj.getCurrentView();
	var coverflowTemplate = null;
	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var imgIcon = {
		tick: 'content/images/'+APP.configObj.language.dir+'/icon_tick.svg',
		cross: 'content/images/'+APP.configObj.language.dir+'/icon_cross.svg'
		
	}
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'dnd-sort-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',						
			DRAG_ITEM_CLASS: 'drag-item',
			DROP_ITEM_CLASS: 'drop-item',	
			DRAG_PANEL_CLASS: 'drag-panel',				
			DRAG_AXIS: 'y',	
			IS_ASSESSMENT: false,
			IS_PRE_TEST: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			ANIMATE_INCORR_OPTION: true,
			THRESHOLD: '50%',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
			SOUND_OBJ: {
				blank: 'blank',
				correct: 'correct',
				incorrect: 'incorrect',
				partialCorrect: 'incorrect'
			},
			SUB_TYPE: '',
     		ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,
     		ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			QUE_INTRACTION_OBJ: {},
			SEND_INTRACTION: false,
			isCompleted:false,
     		queObj:null,
			
		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
  _this.EnabledDisableDrag = function(_str){
		EnabledDisableDrag(_str);
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	_this.processSubmit = function(){
		processSubmit({feedbackAni:true, autoOpen:false});
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];
		Selector.isCompleted = false;			
    if(Selector.SHOW_PREVIOUS_SELECTION){

  	}else{
  		Selector.CURRENT_ATTEMPT = 0;
  		Selector.FEEDBACK_STATE = '';
  		Selector.IS_SUBMIT_CLICK = 'na';
  	}
  	if (Selector.IS_ASSESSMENT) {	
  		getHTML();
  		startTime = time; 
  	}else{
  		//-- for inline cmi intraction
  		startTime = time;
  		initialRender();
  	}
			
	}
	
	function initialRender() {		
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//-- for inline cmi intraction
		Selector.QUE_INTRACTION_OBJ.type = "dragNDrop"; 
		Selector.QUE_INTRACTION_OBJ.options = [];
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		//--
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){	
			$(this).attr('id', Selector.DRAG_ITEM_CLASS+'_'+inx);
			$(this).attr('data-index', inx);	
      //-- for inline cmi intraction
			Selector.QUE_INTRACTION_OBJ.options[inx] = $(this).find('.drag-txt').text();
      //--		
		});

		totalDrags = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).length;

		if(Selector.CORRECT_ANS_ARRAY.length != totalDrags){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		if(Selector.DRAG_AXIS == 'x'){
			$(Selector.ACTIVITY_CONTAINER).addClass('sort-x');
			$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
			rowSize   = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).outerHeight(true);
			colSize   = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).outerWidth(true);
			totalRows = 1;
			totalCols = totalDrags;
			var mw = colSize * totalCols;
			var mh = rowSize * totalRows;
			Selector.queDivObj.find('.'+Selector.DRAG_PANEL_CLASS).css('min-width',mw+'px');
			Selector.queDivObj.find('.'+Selector.DRAG_PANEL_CLASS).css('min-height',mh+'px');
		}else{
			$(Selector.ACTIVITY_CONTAINER).addClass('sort-y');
			rowSize   = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).outerHeight(true);
			colSize   = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).outerWidth(true);
			totalRows = totalDrags;
			totalCols = 1;
			var mw = colSize * totalCols;
			var mh = rowSize * totalRows;
			Selector.queDivObj.find('.'+Selector.DRAG_PANEL_CLASS).css('min-width',mw+'px');
			Selector.queDivObj.find('.'+Selector.DRAG_PANEL_CLASS).css('min-height',mh+'px');
		}
		
		// Map cell locations to array
		for (var row = 0; row < totalRows; row++) {
			for (var col = 0; col < totalCols; col++) {
			cells.push({
				row: row,
				col: col,
				x: col * colSize,
				y: row * rowSize
				
			});
			}
		}
		
		container = Selector.queDivObj.find('.'+Selector.DRAG_PANEL_CLASS);		
		
		//--
		Selector.answerArray = Selector.CORRECT_ANS_ARRAY.slice();
		
		initOptionData();
		//-- for better animation when SHOW_PREVIOUS_SELECTION is true
		if (!Selector.IS_ASSESSMENT) {
			loadPrevUserData();
			updateTemplateLayout();
			addTemplateEvent();	
		}else{
			//listen APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE event below
		}
		APP.preloaderObj.hide();	
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}	
	}
	function initOptionData(){
		//--added extra condition to rearrange again if arrange in correct order...
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){			
			reArrange();				
		}else{
			initSort();
		}
		
	}
	function reArrange(){		
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).shuffle();
		var ta= [];
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){				
			ta.push($(this).data('index'));
		});
		//console.log(Selector.answerArray.toString() +"::"+ta.toString()) 
		if(Selector.answerArray.toString() == ta.toString()){			
			//console.log('matched... recalled')
			reArrange();
		}else{
			initSort();
		}
	}
	function initSort(){
		sortables = [];
		listItems = Array.from(Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS)); // Array of elements
		sortables = listItems.map(Sortable); // Array of sortables
		dd = sortables;
		Selector.initialUserArr = [];
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){				
			Selector.initialUserArr.push(defaultValue);	
		});	
		showAnsValue();
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;
		var $ansTxt=Selector.queDivObj.find('.ans-value-txt');
		
		if(cheatMode){			
			var showAns = '';
			for(var j =0; j<Selector.answerArray.length; j++){
				var te = Selector.answerArray[j];					
				Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){						
					if($(this).data('index') == te){							
						showAns+= inx;							
					}					
				})
				if(j != Selector.answerArray.length - 1){
					showAns+= ',';
				}										
			}						
			//$ansTxt.show();
			$ansTxt.html(showAns);
		}else{			
			$ansTxt.hide();
		}
	}
	function loadPrevUserData(){
		var $dropBox = Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS);
		if (Selector.IS_ASSESSMENT && assessmentQuizObj.dataReviewMode) {			
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					newArr.push(tempAnsArr[i].split(','));					
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			if (Selector.queObj.dataUserArray != null) {	
				// for multi multidimensional array					
				var tempUsArr = Selector.queObj.dataUserArray.split('^');
				var newArr1 = [];
				for(var i=0; i<tempUsArr.length; i++){
					newArr1.push(tempUsArr[i].split(','));
				}
				Selector.userArray = newArr1;		
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		//console.log('prev-Selector.userArray: '+Selector.userArray);
		//--previous position not shown due to animation...
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !=''){
			applySelection();			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}	
		initQuestion();		
	}
	function applySelection(){
		
		for(var j=0; j<Selector.userArray.length; j++){	
			var currUa = Selector.userArray[j];
			if (currUa != defaultValue) {	
				var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+currUa);
				var tcell = sortables[j].cell;
				TweenMax.to(drag, 0.3, {
					x: tcell.x,
					y: tcell.y,
					onComplete: function(){
						
					}
				});
				sortables[j].element = drag.get(0);
				sortables[j].iniIndex = currUa;
			}
		}	
		
	}
	function initQuestion(){		
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		updateValue();
		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit();
			}
		} */
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;
			if(Selector.IS_PRE_TEST){
				processSubmit({feedbackAni:true, autoOpen:true});
			}else{
				processSubmit({feedbackAni:true, autoOpen:true});
			}
					
		}
	}); 
	function changeIndex(item, to, sameRow, sameCol) {
		
		// Check if adjacent to new position
		if ((sameRow && !sameCol) || (!sameRow && sameCol)) {
		  
		  // Swap positions in array
		  var temp = sortables[to];
		  sortables[to] = item;
		  sortables[item.index] = temp;
		  
		} else {
		  
		  // Change position in array
		  arrayMove(sortables, item.index, to);
		}
		  
		// Simple, but not optimized way to change element's position in DOM. Not always necessary. 
		//sortables.forEach(sortable => container.append(sortable.element)); 
		sortables.forEach(function(sortable){
			container.append(sortable.element);
		});
		  
		// Set index for each sortable
		//sortables.forEach((sortable, index) => sortable.setIndex(index));
		sortables.forEach(function(sortable, index){
			sortable.setIndex(index);
		});
	}
	  
	function Sortable(element, index) {		
		var iniInx = $(element).data('index'); 
		var animation = TweenMax.to(element, 0.3, {
		  boxShadow: "rgba(0,0,0,0.2) 0px 16px 32px 0px",
		  force3D: true,
		  scale: 1.0,
		  paused: true
		});
		
		var dragger = new Draggable(element, {        
		  onDragStart: downAction,
		  onRelease: upAction,
		  onDrag: dragAction,
		  cursor: "grab",
		  bounds: container
		});
		
		var position = element._gsTransform;
		
		// Public properties and methods
		var sortable = {
		  cell:     cells[index],
		  dragger:  dragger,
		  element:  element,
		  index:    index,
		  iniIndex: iniInx,
		  setIndex: setIndex
		};
		
		TweenMax.set(element, { 
		  x: sortable.cell.x, 
		  y: sortable.cell.y, 
		});  
		
		function setIndex(index) {
		  
		  var cell  = cells[index];
		  var dirty = position.x !== cell.x || position.y !== cell.y;
		  
		  sortable.cell = cell;
		  sortable.index = index;    
		  //order.textContent = index + 1;
			  
		  // Don't layout if you're dragging
		  if (!dragger.isDragging && dirty) layout();
		}
		  
		function downAction() {
			$(this.target).removeClass('dropped');
			$(this.target).css('cursor','grabbing');	
		 	animation.play();
		 	this.update();
		}
		
		function dragAction() {
		  
		  var col = clamp(Math.round(this.x / colSize), 0, totalCols - 1);
		  var row = clamp(Math.round(this.y / rowSize), 0, totalRows - 1);
			 
		  var cell = sortable.cell;    
		  var sameCol = col === cell.col;
		  var sameRow = row === cell.row;
		  
		  // Check if position has changed
		  if (!sameRow || !sameCol) {
			
			// Calculate the new index
			var index = totalCols * row + col;
			
			// Update the model
			changeIndex(sortable, index, sameRow, sameCol);
		  }
		}
		  
		function upAction() {
			$(this.target).addClass('dropped');
			APP.commonFunObj.playSoundEffect({name: 'dragNDrop'});
		  animation.reverse();
		  layout();
		  updateValue();
		}
		
		function layout() {    
		 TweenMax.to(element, 0.3, { 
			x: sortable.cell.x, 
			y: sortable.cell.y
		  });
		}
			
		return sortable;
	}
	  
	// Changes an elements's position in array
	function arrayMove(array, from, to) {
		array.splice(to, 0, array.splice(from, 1)[0]);
	}
	  
	 // Clamps a value to a min/max
	function clamp(value, a, b) {
		return value < a ? a : (value > b ? b : value);
	}
	function addTemplateEvent() {		
		var dragBox = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS);
		
		dragBox.hover(function(){
			if($(this).hasClass('disabled')){return false;};
				$(this).addClass('hover');
				
			}, function(){
				$(this).removeClass('hover');
		});
		dragBox.on('click',function(){
			if($(this).hasClass('disabled')){return false;};
			//$(this).addClass('hover');
			
		});
		 		
		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			Selector.IS_SUBMIT_CLICK = 'cl';
			processSubmit({feedbackAni:true, autoOpen:true});	
			
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){	
		updateUserArray();	
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
	}
	function updateUserArray(){
		Selector.userArray = Selector.initialUserArr.slice();
		if(sortables){
			for(var i=0; i<sortables.length; i++){
				var curr = sortables[i];
				Selector.userArray[i] = curr.iniIndex;
			}	
		}	
		
	}

	function submitBtnStatus(){	
		var selectedItemLen = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS+'.dropped').length;	
		var totalItemLen = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).length;
			
		if(selectedItemLen >= 1){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}		
	}	
	function EnabledDisabledBtn(_div, _val, _state){
		var state = '';
		if(_state){
			state = _state;
		}
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn' && state == ''){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function EnabledDisableDrag (_val){
		
		if(sortables){
			for(var i=0; i<sortables.length; i++){
				var curr = sortables[i].dragger;
				if(_val){
					curr.enable();
					$(curr.target).removeClass('disabled');
				}else{					
					curr.disable();
					$(curr.target).addClass('disabled');
				}
			}
		}
				
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.answerArray.length
		}
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			if (crrArr.toString() == currUa.toString()) {
				obj.corrCount += 1;
			}else{
				obj.inCorrCount += 1;
			}	
		}
	
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		//console.log('obj: '+JSON.stringify(obj))
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisableDrag(false);
		
		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			if(_obj.autoOpen){
				showFeedback({isAni: _obj.feedbackAni, playSfx:true});
			}
			
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
		
	}
	function showFeedback(_obj){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.FEEDBACK_STATE == 'corr'){	
			soundName = Selector.SOUND_OBJ.correct;			
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
		}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
			soundName = Selector.SOUND_OBJ.partialCorrect;			
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
		}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
			soundName = Selector.SOUND_OBJ.partialCorrect;				
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
			if(plfObj.length){
				currFeedback = plfObj;
			}else if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}					
			
		}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){
			soundName = Selector.SOUND_OBJ.incorrect;					
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
			if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}								
			
		}else{
			soundName = Selector.SOUND_OBJ.incorrect;
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
		}
		
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		$(currFeedback).find('.scroll-parent').scrollTop(0);
		aniObj.ON_COMPLETE = function(){
			
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.EL.find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}			
			APP.eventObj.applyGbPopCloseEvent();				
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			currFeedback.find('.scroll-parent').scrollTop(0);
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
		
	}
	
	function resetQuestion(){
		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		APP.commonFunObj.cleanHookMsg();
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).removeClass('selected corr-ans tick cross disabled dropped');
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.img-status')
		.attr('src', '')
		.removeClass('i-tick i-cross');
		$(Selector.FEEDBACK_CONTAINER).hide();
		
		EnabledDisableDrag(true);
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		Selector.userArray = Selector.initialUserArr.slice();
		
		initOptionData();		
		initQuestion();	

		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){		
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		
		//to hide status icon
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').addClass('visibility-hidden');
		//--change position for correct drop and also as difficult to rearrange others		
		for (var j = 0; j < Selector.answerArray.length; j++) {		
			var currInx = Selector.answerArray[j];
			var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+currInx);
			var tcell = sortables[j].cell;
			TweenMax.to(drag, 0.3, {
				x: tcell.x,
				y: tcell.y
			});
		}
	}
	function showUserSelection(){		
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);		
		
		for(var j=0; j<Selector.userArray.length; j++){	
			var currUa = Selector.userArray[j];
			if (currUa != defaultValue) {	
				var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+currUa);
				var tcell = sortables[j].cell;
				TweenMax.to(drag, 0.3, {
					x: tcell.x,
					y: tcell.y,
					onComplete: function(){
						//to show status icon
						Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').removeClass('visibility-hidden');			
					}
				});
			}
		}		
			
	}
	function showTickCorss(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			if (crrArr.toString() == currUa.toString()) {	
				var curr = Selector.queDivObj.find('.drag-item[data-index="'+currUa+'"]');
        		curr.addClass('tick')
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.removeClass('cross')
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
				curr.find('.img-status')
					.attr('src',imgIcon.tick)
					.addClass('i-tick');
			}else{
				var curr = Selector.queDivObj.find('.drag-item[data-index="'+currUa+'"]');
        		curr.addClass('cross')
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.removeClass('tick')
				.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass('i-cross');
				curr.find('.img-status')
					.attr('src',imgIcon.cross)
					.addClass('i-cross');
			}						
		}	
	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];	
			var currUa = Selector.userArray[i];
			if (crrArr.toString() == currUa.toString()) {	
				
			}else{
				var incorrOpt = Selector.queDivObj.find('.drag-item[data-index="'+currUa+'"]');        		
				APP.animationObj.animate({
					EL: incorrOpt,
					TYPE: 'shake-x',
					START_VAL: '+=10',						
					YOYO:true,
					REPEAT:3,
					STAGGER: false,
					DURATION: 0.1,
					ON_COMPLETE: function(){
						
					}
				});
			}						
		}	
	}
	function updateStatus() {
		if(Selector.SEND_INTRACTION && Selector.QUE_INTRACTION_OBJ.dataTobeSend){	
			Selector.QUE_INTRACTION_OBJ.dataUserArray = Selector.userArray;
			Selector.QUE_INTRACTION_OBJ.dataAnswerArray = Selector.answerArray.join("^");
			Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
			Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {				
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}				
			}
			if (anySelect) {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = true;
			} else {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			/* var obj = {
				corrCount: 0,
				inCorrCount: 0,
				allCorrected: false,
				totalCorrCount: 0
			   } */
			if(corrObj.allCorrected){
				Selector.QUE_INTRACTION_OBJ.dataStatus = "correct";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 1;
			}else{
				Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
				if (Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected) {
					Selector.QUE_INTRACTION_OBJ.dataStatus = "incorrect";
				}
			}
						
			Selector.QUE_INTRACTION_OBJ.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			//console.table(Selector.QUE_INTRACTION_OBJ)
			APP.dataComObj.sendInlineInteractionData(Selector.QUE_INTRACTION_OBJ);
			
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
	
	function updateTemplateLayout() {
		scalex = APP.scalex || 1;	
	}	
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
		//reload screen as difficult to maintain 2 view
		var currentView = APP.commonFunObj.getCurrentView();
		
	});
		
	$(document).one(APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE, function (e) {
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
	});
}