function MultiDropDownQuestion() {
	var _this = this;
	var Selector = {};
  var optArr = [];
	var defaultValue = '0'
	var time = new Date();
	var startTime;
	var questionPanelHt;
	var openMenuHt;
	var feedbackAudio = '';
	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	var removeSpacialCharPatt = /[\~\`\!\@\#\$\%\^\&\*\(\)\_\+\=\-\{\}\|\[\]\\:\"\;\'\<\>\?\,\.\—\–\¬\–\…\‘\’\“\”\/]/gim;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'dropdown-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			IS_ASSESSMENT: false,
			IS_PRE_TEST: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			ANIMATE_INCORR_OPTION: true,
			//--mainly used for responsive course to manage data with other template(drag n drop, matching lines)
			NO_REPEAT_OPT_SELECTION: false,
			QUE_OPT_PANEL: '.que-txt-panel',
			DROP_DOWN_PANEL: '.drop-down-panel',
			DROP_DOWN: '.drop-down',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: 'icon-triangle-bottom',
				optSelected: 'icon-triangle-top',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
			SOUND_OBJ: {
				blank: 'blank',
				correct: 'correct',
				incorrect: 'incorrect',
				partialCorrect: 'incorrect'
			},
     		ON_SHOW: null,
			ON_SUBMIT: null,
			ON_CHECK_BTN: null,
			ON_TRY_AGAIN: null,
			ON_SHOW_ME: null,
			ON_CLICK: null,
			ON_CHANGE: null,
     		ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
     		NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			QUE_INTRACTION_OBJ: {},
			SEND_INTRACTION: false,
			isCompleted:false,
     		queObj:null,
			
			
		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	_this.processSubmit = function(){
		processSubmit({feedbackAni:true, autoOpen:false});
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];
		Selector.answerArray = [];
		Selector.isCompleted = false;		
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			//-- for inline cmi intraction
			startTime = time;
			initialRender();
		}	
	}
	function getHTML() {
		/* WIP for assessment template... */
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		//this is for global images
		if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
			var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
			$('#global-bg-'+APP.gbBgIndex).css({
				'background-image':'url('+path+')',
				'background-position': 'center'
			});
		}
		var _className = Selector.queObj.className || "";
		var _subType = Selector.queObj.subType || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		var _colWidth = Selector.queObj.colWidth || "col-60";
		
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _subType + ' ' + _id + ' " style="' + _style + '">';
			/* 2 */ str += '<div class=" col-text '+_colWidth+' ani-box-left">';	
				/* 2a */ str += '<div class="text-box text-box-0 " >';	
						str += '<div class="sb-que-ref"></div>';
						str += '<div class="screen-title-div">';					
							str += '<span class="title"></span>';
						str += '</div>';				
					/* 3 */str += '<div class="que-txt-panel">';	
						str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);	
					/* 3 */str += '</div>';
					Selector.CORRECT_ANS_ARRAY[0] = []
					var optionsObj = Selector.queObj.options;
					for (var i = 0; i < optionsObj.length; i++) {
						Selector.CORRECT_ANS_ARRAY[0][i] = [];
						var ref = optionsObj[i].dataValRef || i;
						str += '<select class="placeholder-dropdown" data-val-ref="'+ref+'">';
						var optionObj = optionsObj[i].option;
						for (var j = 0; j < optionObj.length; j++) {					
							var _className = optionObj[j].className || "";
							var _style = optionObj[j].style || "";
							var _txt = optionObj[j].Text;
							var _isCorrect = optionObj[j].isCorrect.toLowerCase();
							if(_isCorrect == 'true'){
								//rearrange id's as 0 set for initial option 'select an anwer'
								Selector.CORRECT_ANS_ARRAY[0][i].push(j - 1);
							}
									
							str += '<option >'+_txt+'</option>';
						}	
						str += '</select>';
					}
								
					/* 5 */str += '<div class="display-block submit-panel bottom-btn-panel">';	
								str += '<div class="submit-panel">';				
								str += '<div class=" btn-panel clickable display-inline-block" >';
									str += '<a class="btn with-img type-1 size-5 click-btn submit-btn " href="javascript:void(0);" >';
										str += '<img class="img-tag normal-img" src="'+APP.globalBtnImgs.btnSize5Img+'" alt="">';
										str += '<img class="img-tag hover-img" src="'+APP.globalBtnImgs.btnSize5ImgHover+'" alt=""></img>';
										str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
									str += '</a>';
								str += '</div>';
							str += '</div>';						
					/* 5 */str += '</div>';	
				/* 2a */str += '</div>';
			/* 2 */str += '</div>';
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-left" data-animate-start-val="20px" data-animate-end-val="0px" data-animate-duration="0.5">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);	
									str += '<p class="instr-txt" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].nextQueInstr[0].Text+'</p>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-left" data-animate-start-val="20px" data-animate-end-val="0px" data-animate-duration="0.5">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
									str += '<p class="instr-txt" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].nextQueInstr[0].Text+'</p>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partiallyCorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-left" data-animate-start-val="20px" data-animate-end-val="0px" data-animate-duration="0.5">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
									str += '<p class="instr-txt" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].nextQueInstr[0].Text+'</p>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';	
			}				
			
			/* if(_colWidth != 'full'){			
				if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
					var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
					str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
				}else{
					str += '<div class="col col-blank"><p></p></div>';
				}
			} */
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}
	function initialRender() {	
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);

		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//-- for inline cmi intraction
		Selector.QUE_INTRACTION_OBJ.type = 'dropDown'; 
		Selector.QUE_INTRACTION_OBJ.ddValRef = [];
		Selector.QUE_INTRACTION_OBJ.userOptText = [];
		Selector.QUE_INTRACTION_OBJ.corrOptText = [];
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		//--
		Selector.queOptions = Selector.queDivObj.find(Selector.QUE_OPT_PANEL);	
		Selector.queOptions.each(function (inx) {
			$(this).addClass('que-txt-panel_'+inx).data('id', inx);
			Selector.initialUserArr[inx] = [];
			Selector.QUE_INTRACTION_OBJ.userOptText[inx] = [];	
			Selector.QUE_INTRACTION_OBJ.ddValRef [inx] = [];		
			$(this).find(Selector.DROP_DOWN_PANEL).each(function (jnx) {
				$(this).addClass('dd-panel_'+inx+'-'+jnx).data('quid', inx).data('ddid', jnx);
				Selector.initialUserArr[inx][jnx] = defaultValue;			
				Selector.QUE_INTRACTION_OBJ.userOptText[inx][jnx] = defaultValue;
				Selector.QUE_INTRACTION_OBJ.ddValRef[inx][jnx] = $(this).data('val-ref') || 0;
				
			})
		});
		
		Selector.dropDownPanel = Selector.queDivObj.find(Selector.DROP_DOWN_PANEL);	

		Selector.placeHolderDropDown = Selector.queDivObj.find('.placeholder-dropdown');
		Selector.optionObj = [];			
		if(Selector.placeHolderDropDown.length > 1){Selector.NO_REPEAT_OPT_SELECTION = false;}
		Selector.placeHolderDropDown.each(function (inx) {
			Selector.optionObj[inx] = $(this).find('option');
		});		
		Selector.placeHolderDropDown.hide();
		
		//validate CORRECT_ANS_ARRAY
		var totOpt = Selector.queOptions.length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		
		//--create answerArray
		//var tempArr = Selector.CORRECT_ANS_ARRAY.slice();
		var tempArr = Selector.CORRECT_ANS_ARRAY.map(function(arr) {
			return arr.slice();
		});
		//rearrange id's as 0 set for initial option 'select an answer'
		//for support multi drop down panel and multi option
		//que-option array
		for (var i=0; i<tempArr.length; i++){
			var currArr = tempArr[i];	
			Selector.answerArray[i] = [];
			//-- for inline cmi intraction
			Selector.QUE_INTRACTION_OBJ.corrOptText[i] = [];
			//--
			//drop-down array			
			for(var j =0; j<currArr.length; j++){
				var optArr = currArr[j];	
				Selector.answerArray[i][j] = [];
				Selector.QUE_INTRACTION_OBJ.corrOptText[i][j] = [];
				//drop-down multi option array
				for(var k =0; k<optArr.length; k++){
					_id = parseInt(optArr[k]) + 1;					
					Selector.answerArray[i][j][k] = _id;
					dVal = Selector.QUE_INTRACTION_OBJ.ddValRef[i][j];					
					dtxt = Selector.optionObj[dVal][_id].text;					
					Selector.QUE_INTRACTION_OBJ.corrOptText[i][j][k] = dtxt.replace(removeSpacialCharPatt,"");
				}
			}
		}		

		initOptionData();
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}		
	}
	function initOptionData(){
		optArr = [];
		
		for(var i=0; i<Selector.optionObj.length; i++){
			optArr[i] = [];
			
			if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
				Selector.NO_REPEAT_OPT_SELECTION = false;
				//--escape default value
				optArr[i] = APP.commonFunObj.getRandomArr((Selector.optionObj[i].length - 1), 1);
				//--add default value to 1st in array
				optArr[i].unshift(0);
			}else{
				optArr[i] = APP.commonFunObj.getLinearArr(Selector.optionObj[i].length);
			}
		}		
		
		//--create dropdown panel				
		var str = "";
		
		Selector.dropDownPanel.each(function (idx) {			
			str = "";
			var valRef = $(this).data('val-ref') || 0;
			var quid = $(this).data('quid');
			var ddid = $(this).data('ddid');	
			
			str += '<select class="drop-down select-drop-down drop-down_' +quid+'-'+ddid+'" id="drop-down_' +quid+'-'+ddid+'" data-quid="'+quid+'"  data-ddid="'+ddid+'" data-val-ref="'+valRef+'">';
			for (var i = 0; i < optArr[valRef].length; i++) {
				var _txt = Selector.optionObj[valRef].eq(optArr[valRef][i]).text();
				var _id = optArr[valRef][i];
				str += '<option class="option" data-id="'+_id+'" value="'+_id+'" >' + _txt + '</option>';	
			}
						
			str += '</select>';
			//--added status icon
			str += '<div class="btn-icon font-icon status"></div>';
			$(this).html(str);
		});
		applyDropDownEvent();
		showAnsValue();
		
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;		
		if(cheatMode){			
			var corrClass = 'ref-corr';
			for(var i =0; i<Selector.answerArray.length; i++){
				var currArr = Selector.answerArray[i];				
				for(var j =0; j<currArr.length; j++){
					var optArr = currArr[j];
					for(var k =0; k<optArr.length; k++){
						var op = optArr[k];						
						Selector.queDivObj.find('.dd-panel_' +i+'-'+j).find('.option[data-value="'+op+'"]').addClass(corrClass);
					}					
				}
			}
			
		}
	}
	
	function loadPrevUserData(){
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			//--to be work here		
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array				
				//answerArray join: 2,3-3,2^1,2-3,1^5-1,3
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					var newArr1 = tempAnsArr[i].split('-');
					newArr[i] = [];
					for(var j=0; j<newArr1.length; j++){
						newArr[i][j] = [];
						newArr[i][j] = newArr1[j].split(',');	
					}				
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			//userArr join: 4,2^1,3^4,3 
			if (Selector.queObj.dataUserArray != null) {
				var tempUsrArr = Selector.queObj.dataUserArray.split('^');
				var newArr = [];
				for(var i=0; i<tempUsrArr.length; i++){
					newArr.push(tempUsrArr[i].split(','));					
				}				
				Selector.userArray = newArr;				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){		
			Selector.queOptions.each(function (inx) {
				$(this).find(Selector.DROP_DOWN_PANEL).each(function (jnx) {
					var currVal = Selector.userArray[inx][jnx];	
					if(currVal != defaultValue){
						$(this).find(Selector.DROP_DOWN).val(currVal);
						$(this).find(Selector.DROP_DOWN).niceSelect('update');
						var valRef = parseInt($(this).data('val-ref'));
						Selector.QUE_INTRACTION_OBJ.userOptText[inx][jnx] = ((Selector.optionObj[valRef][currVal].text).replace(removeSpacialCharPatt,""));
					}					
				})
			});	
				
		}else{
			//Selector.userArray = Selector.initialUserArr.slice();
			Selector.userArray = Selector.initialUserArr.map(function(arr) {
				return arr.slice();
			});
			Selector.QUE_INTRACTION_OBJ.userOptText = Selector.initialUserArr.map(function(arr) {
				return arr.slice();
			});
		}
		
		initQuestion();		
	}
	function initQuestion(){
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		applyNoRepeatSelection();
		updateValue();

		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:true, autoOpen:true});
			}
		}
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
		
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;	
			if(Selector.IS_PRE_TEST){
				processSubmit({feedbackAni:true, autoOpen:true});
			}else{
				processSubmit({feedbackAni:true, autoOpen:true});
			}
		}
	});
	function addTemplateEvent() {				
		Selector.queDivObj.find('.submit-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};	
			Selector.IS_SUBMIT_CLICK = 'cl';				
			processSubmit({feedbackAni:true, autoOpen:true});		
			
		})
		Selector.queDivObj.find('.check-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};							
			if (Selector.ON_CHECK_BTN) {
				Selector.ON_CHECK_BTN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
			}
		})
		Selector.queDivObj.find('.view-feedback-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};					
			showFeedback({isAni: true, playSfx: false});
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyDropDownEvent(){
		Selector.queDivObj.find(Selector.DROP_DOWN).niceSelect();		
		Selector.queDivObj.find(Selector.DROP_DOWN).on('change', function(e){	
			APP.commonFunObj.playSoundEffect({name: 'clicked'});		
			var quid = parseInt($(this).data('quid'));
			var ddid = parseInt($(this).data('ddid'));
			var valRef = parseInt($(this).data('val-ref'));
			var val = $(this).val();
			Selector.userArray[quid][ddid] = val;	
			
			Selector.QUE_INTRACTION_OBJ.userOptText[quid][ddid] = ((Selector.optionObj[valRef][val].text).replace(removeSpacialCharPatt,""));
			extendActivityHeight();		
			updateValue();
			applyNoRepeatSelection();
			//data only send on submit
			//updateStatus();
			
		})
	}
	function applyNoRepeatSelection(){
		if(Selector.NO_REPEAT_OPT_SELECTION){
			
			Selector.queDivObj.find('.select-drop-down').find('.option').removeProp( "disabled" );
			Selector.queDivObj.find('.select-drop-down').find('.option').attr( "disabled",false);
			Selector.queDivObj.find('.select-drop-down').find('.option').removeClass( "disabled" );
			for(var i=0; i<Selector.userArray.length; i++){
				var optArr = Selector.userArray[i];
				for(var j=0; j<optArr.length; j++){						
					var op = optArr[j];					
					if (op != defaultValue) {
						for(var x=0; x<Selector.userArray.length; x++){
							var xOptArr = Selector.userArray[x];
							for(var y=0; y<xOptArr.length; y++){	
								if(i == x && j == y){continue;}								
								Selector.queDivObj.find(Selector.DROP_DOWN+'_'+x+'-'+y).find('.option[value='+op+']').prop( "disabled" );
								Selector.queDivObj.find(Selector.DROP_DOWN+'_'+x+'-'+y).find('.option[value='+op+']').attr( "disabled",true);
								Selector.queDivObj.find(Selector.DROP_DOWN+'_'+x+'-'+y).find('.option[value='+op+']').addClass( "disabled" );
								Selector.queDivObj.find(Selector.DROP_DOWN+'_'+x+'-'+y).niceSelect('update');
							}
						}
					}
				}			
			}
		}
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){
		var isAllSelected = true;
		
		for(var i=0; i<Selector.userArray.length; i++){
			var currArr = Selector.userArray[i];
			for(var j=0; j<currArr.length; j++){
				var curr = currArr[j];
				if(curr == defaultValue){
					isAllSelected = false;
					break;
				}
			}
			if(isAllSelected == false){
				break;
			}
		}
		if(isAllSelected){
			EnabledDisabledBtn('.submit-btn', true);
			EnabledDisabledBtn('.check-btn', true);				
		}else{
			EnabledDisabledBtn('.submit-btn', false);
			EnabledDisabledBtn('.check-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){		
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}

	function EnabledDisableDropDown (_val){		
		var dd = Selector.queDivObj.find(Selector.DROP_DOWN);
		if(dd.length){
			if(_val){
				$(dd)
				.removeAttr('disabled')
				.removeClass('disabled');
			}else{
				$(dd)
				.attr('disabled', 'disabled')
				.addClass('disabled');
			}
		}	
		
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: 0
		}
		
		//[["3","3"],["1","3"],["4","2"]]
		//[[[2,3],[3,2]],[[1,2],[3,1]],[[5],[1,3]]]

		for(var i =0; i<Selector.answerArray.length; i++){
			var currArr = Selector.answerArray[i];
			for(var j =0; j<currArr.length; j++){
				var found=false;	
				obj.totalCorrCount +=1;
				var optArr = currArr[j];
				for(var k =0; k<optArr.length; k++){
					var op = optArr[k];
					
					if (Selector.userArray[i][j].toString() == op.toString()) {
						obj.corrCount += 1;	
						
						found = true;
						break;
					}
				}
				if(!found){
					if (Selector.userArray[i][j] != defaultValue) {
						obj.inCorrCount += 1;
						
					}
				}					
			}
		}			
		
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisableDropDown(false);

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			if(_obj.autoOpen){
				showFeedback({isAni: _obj.feedbackAni, playSfx:true});
			}				
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	}
	function showFeedback(_obj){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName = Selector.SOUND_OBJ.correct;
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
				soundName = Selector.SOUND_OBJ.partialCorrect;			
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
				soundName = Selector.SOUND_OBJ.partialCorrect;			
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){		
				soundName = Selector.SOUND_OBJ.incorrect;		
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
				soundName = Selector.SOUND_OBJ.incorrect;	
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		$(currFeedback).find('.scroll-parent').scrollTop(0);
		aniObj.ON_COMPLETE = function(){
						
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.EL.find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}	
			APP.eventObj.applyGbPopCloseEvent();						
		}else{	
			
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(_obj){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			currFeedback.find('.scroll-parent').scrollTop(0);
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
      		applyPopCloseEvent();
		}
		
	}
		
	function resetQuestion(){			
		EnabledDisableDropDown(true);
   		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		APP.commonFunObj.cleanHookMsg();
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.dropDownPanel.removeClass('tick cross animated headShake');	
		Selector.dropDownPanel.find('.status').removeClass('i-tick').removeClass('i-cross').removeClass('visibility-hidden');
		$(Selector.FEEDBACK_CONTAINER).hide();
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		
		//Selector.userArray = Selector.initialUserArr.slice();
		Selector.userArray = Selector.initialUserArr.map(function(arr) {
			return arr.slice();
		});
		Selector.QUE_INTRACTION_OBJ.userOptText = Selector.initialUserArr.map(function(arr) {
			return arr.slice();
		});
		
		initOptionData();		
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		//to hide status icon
		Selector.queDivObj.find(Selector.DROP_DOWN).parents(Selector.DROP_DOWN_PANEL).find('.status').addClass('visibility-hidden');
		for(var i =0; i<Selector.answerArray.length; i++){
			var currArr = Selector.answerArray[i];							
			for(var j =0; j<currArr.length; j++){
				var found=false;				
				var optArr = currArr[j];
				for(var k =0; k<optArr.length; k++){
					var op = optArr[k];					
					if (Selector.userArray[i][j].toString() == op.toString()) {						
						found = true;
						break;
					}
				}
				if(!found){
					//--consider arr[0] correct answer if multi option available
					var op = currArr[j][0];
					Selector.queDivObj.find(Selector.DROP_DOWN+'_'+i+'-'+j).val(op);
					Selector.queDivObj.find(Selector.DROP_DOWN+'_'+i+'-'+j).niceSelect('update');
					
				}					
			}
		}			
		
	}
	function showUserSelection(){
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);
		//to show status icon
		Selector.queDivObj.find(Selector.DROP_DOWN).parents(Selector.DROP_DOWN_PANEL).find('.status').removeClass('visibility-hidden');
			
		for(var i=0; i<Selector.userArray.length; i++){
			var optArr = Selector.userArray[i];
			for(var j=0; j<optArr.length; j++){	
				var op = optArr[j];
				if (op != defaultValue) {		
					Selector.queDivObj.find(Selector.DROP_DOWN+'_'+i+'-'+j).val(op);
					Selector.queDivObj.find(Selector.DROP_DOWN+'_'+i+'-'+j).niceSelect('update');
				}
			}
			
		}
	}
	function showTickCorss(){
		for(var i =0; i<Selector.answerArray.length; i++){
			var currArr = Selector.answerArray[i];							
			for(var j =0; j<currArr.length; j++){
				var found=false;				
				var optArr = currArr[j];
				var curr = Selector.queDivObj.find('.dd-panel_' +i+'-'+j);
				for(var k =0; k<optArr.length; k++){
					var op = optArr[k];					
					if (Selector.userArray[i][j].toString() == op.toString()) {						
						curr.removeClass('cross')
						.addClass('tick');	

						curr.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.removeClass('i-cross')					
						.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
						.addClass('i-tick');

						found=true;
						break;
					}
				}
				if(!found){
					if (Selector.userArray[i][j] != defaultValue) {	
						curr.removeClass('tick')
						.addClass('cross ');	

						curr.find('.status')
						.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)		
						.removeClass('i-tick')			
						.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
						.addClass('i-cross');						
					}
				}					
			}
		}
		
	}
	function animateIncorrectOption(){
		
		for(var i =0; i<Selector.answerArray.length; i++){
			var currArr = Selector.answerArray[i];							
			for(var j =0; j<currArr.length; j++){
				var found=false;				
				var optArr = currArr[j];
				var curr = Selector.queDivObj.find('.dd-panel_' +i+'-'+j);
				for(var k =0; k<optArr.length; k++){
					var op = optArr[k];					
					if (Selector.userArray[i][j].toString() == op.toString()) {						
						found=true;
						break;
					}
				}
				if(!found){
					if (Selector.userArray[i][j] != defaultValue) {	
						//curr.addClass('animated headShake');	
						TweenMax.to(curr, 0.1, {
							x: '+=10',
							yoyo: true,
							repeat: 3,
							clearProps: "all"							
						});					
					}
				}					
			}
		}
	}
	function updateStatus() {
    	if(Selector.SEND_INTRACTION && Selector.QUE_INTRACTION_OBJ.dataTobeSend){	
			Selector.QUE_INTRACTION_OBJ.dataUserArray = Selector.userArray.join("^");			
			Selector.QUE_INTRACTION_OBJ.dataUserOptText = Selector.QUE_INTRACTION_OBJ.userOptText.join('^');

			var toarr = [];
			for(var i=0; i<Selector.QUE_INTRACTION_OBJ.corrOptText.length; i++){
				toarr[i] = Selector.QUE_INTRACTION_OBJ.corrOptText[i].join("-");
			}
			Selector.QUE_INTRACTION_OBJ.dataCorrOptText = toarr.join("^");

			var tarr = [];
			for(var i=0; i<Selector.answerArray.length; i++){
				tarr[i] = Selector.answerArray[i].join("-");
			}
			Selector.QUE_INTRACTION_OBJ.dataAnswerArray = tarr.join("^");
			Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
			Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				var currArr = Selector.userArray[i];
				for(var j=0; j<currArr.length; j++){
					if (currArr[j] != defaultValue) {
						anySelect = true;
						break;
					}
				}
				if(anySelect){
					break;
				}
			}
			if (anySelect) {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = true;
			} else {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.QUE_INTRACTION_OBJ.dataStatus = "correct";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 1;
			}else{
				Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
				if (Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected) {
					Selector.QUE_INTRACTION_OBJ.dataStatus = "incorrect";
				}
			}
						
			Selector.QUE_INTRACTION_OBJ.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInlineInteractionData(Selector.QUE_INTRACTION_OBJ);
			
		}
		/*if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			//have to work in data compliance intraction send function
			Selector.queObj.dataUserArray = Selector.userArray.join("^");
			var tarr = [];
			for(var i=0; i<Selector.answerArray.length; i++){
				tarr[i] = Selector.answerArray[i].join("-");
			}
			Selector.queObj.dataAnswerArray = tarr.join("^");
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			
			for (var i = 0; i < Selector.userArray.length; i++) {
				var currArr = Selector.userArray[i];
				for(var j=0; j<currArr.length; j++){
					if (currArr[j] != defaultValue) {
						anySelect = true;
						break;
					}
				}
				if(anySelect){
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partiallyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
					
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}*/
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function extendActivityHeight(){
		//waited for animation complete
		setTimeout(function(){
			var openObj = $(Selector.queDivObj).find('.drop-down.open').find('.list');
			var panel = $(Selector.ACTIVITY_CONTAINER);
			//for responsive
			/* if (Selector.IS_ASSESSMENT) {
				panel = $(Selector.ACTIVITY_CONTAINER).find('.activity-panel');
			} */
			if(openObj.length){
				var t = openObj.offset();
				var panelPoss = panel.offset();
				var top = t.top;
				var panelTop = panelPoss.top;
				openMenuHt = openObj.outerHeight() || 100;
				var gap = (top - panelTop)  + openMenuHt;	
				if(panel.height() < gap){
					panel.css('min-height', gap+'px');
				}
				
			}else{
				panel.css('min-height', '150px');
			}
		}, 200);
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}

	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	$(document).on(APP.eventObj.ON_NICE_SELECT_CLICK, function (e) {
		extendActivityHeight();
	});
	
	function updateTemplateLayout() {
		extendActivityHeight();
	}
}