function SpotTheErrorQuestion() {
	var _this = this;
	var Selector = {};
	var feedbackAudio = '';
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {			
			CLASS_NAME: 'spot-the-error-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			SHOW_PREVIOUS_SELECTION: false,			
			OPTION_WISE_FEEDBACK: false,
			ANIMATE_INCORR_OPTION: true,
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
			SOUND_OBJ: {
				blank: 'blank',
				correct: 'correct',
				incorrect: 'incorrect',
				partialCorrect: 'incorrect'
			},
			ON_INIT: null,
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,
			ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			isCompleted:false,
			queObj:null,
			

		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];		
		Selector.isCompleted = false;	
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
		}
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		initialRender();			
	}

	function initialRender(){
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//-- create correct_ans_array
		var cheatMode = APP.configObj.cheatMode;
		Selector.CORRECT_ANS_ARRAY = [];
		Selector.queDivObj.find('.word').each(function(inx){
			var isError = $(this).data('ierr');
			if(isError == '1'){
				//apply ref-corr class
				if(cheatMode){			
					$(this).addClass('ref-corr');
				}
				var pId = $(this).data('paraId');
				var wordId = $(this).data('wordId');
				Selector.CORRECT_ANS_ARRAY.push(pId+'_'+wordId);
				
			}
			$(this).data('selected', false);
		})
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}
	}
	function loadPrevUserData(){
		Selector.userArray = Selector.USER_ARRAY;
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){	
			for(var i =0; i<Selector.userArray.length; i++){
				var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
				curr.addClass('selected');
				curr.data('selected', true);
			}			
		}else{
			Selector.userArray = [];
		}
		
		initQuestion();		
	}
	function initQuestion(){		
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		updateValue();
		if(Selector.ON_INIT){
			Selector.ON_INIT();
		}
/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:false});
			}
		} */
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
		
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		}
	});

	function addTemplateEvent() {
		Selector.queDivObj.find('.word').hover(function(){
				if($(this).hasClass('disabled') || $(this).hasClass('selected')){return false;};
				$(this).addClass('hover');
			}, function(){
				$(this).removeClass('hover');
		});					
		
		Selector.queDivObj.find('.word').on('click', function(){
			if($(this).hasClass('disabled')){return false;};				
			selectOption($(this));					
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};					
			processSubmit({feedbackAni:true});		
			
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function selectOption(_currOpt){
		var $options = Selector.queDivObj.find('.word');
		var $currentOption = _currOpt;
		var _id = parseInt($currentOption.data('id'));	
		$currentOption.removeClass('hover');						
		if ($currentOption.hasClass('selected')) {					
			$currentOption.removeClass('selected');
			$currentOption.data('selected', false);
		} else {
			$currentOption.addClass('selected');
			$currentOption.data('selected', true);
		}	
		updateValue();		
	}
	function updateValue(){
		Selector.userArray = [];	
		Selector.queDivObj.find('.word').each(function(inx){
			if($(this).hasClass('selected')){
				var pId = $(this).data('paraId');
				var wordId = $(this).data('wordId');
				Selector.userArray.push(pId+'_'+wordId);
			}
		})
			
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
	}
	function submitBtnStatus(){		
		if(Selector.userArray.length > 0){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.CORRECT_ANS_ARRAY.length
		}
				
		for(var i=0; i<Selector.userArray.length; i++){	
			var found = false;
			for(var j=0; j<Selector.CORRECT_ANS_ARRAY.length; j++){
				if (Selector.userArray[i].toString() == Selector.CORRECT_ANS_ARRAY[j].toString()) {		
					obj.corrCount += 1;
					found = true;
					break;	
				}
			}
			if(!found){
				if (Selector.userArray[i] != null) {
					obj.inCorrCount += 1;
				}
			}
		}
		
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		Selector.queDivObj.find('.word').addClass('disabled');

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}else{
			
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			showFeedback(_obj.feedbackAni);	
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
		
	}
	function showFeedback(isAni){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.IS_OPTIONWISE_FEEDBACK === true && Selector.TYPE == "mcq"){
			//work only for mcq
			var selOpt = null;
			for(var i=0; i<Selector.userArray.length; i++){
				var curr = Selector.userArray[i];
				if(curr == 1){
					selOpt = i;
					break;
				}
			}
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName =Selector.SOUND_OBJ.correct;
			}else{
				soundName =Selector.SOUND_OBJ.incorrect;	
			}
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.option-feedback-'+selOpt);
		}else{
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName =Selector.SOUND_OBJ.correct;
				Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
			soundName = Selector.SOUND_OBJ.partialCorrect;			
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
			soundName = Selector.SOUND_OBJ.partialCorrect;				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){	
			soundName = Selector.SOUND_OBJ.incorrect;				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
			soundName = Selector.SOUND_OBJ.incorrect;
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		$(currFeedback).find('.scroll-parent').scrollTop(0);
		aniObj.ON_COMPLETE = function(){
			
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.EL.find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}	
			APP.eventObj.applyGbPopCloseEvent();						
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			currFeedback.find('.scroll-parent').scrollTop(0);
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
		
	}
	
	function resetQuestion(){
    	Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		APP.commonFunObj.cleanHookMsg();
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.queDivObj.find('.word')
		.removeClass('selected corr-ans user-corr-ans tick cross user-incorr-ans disabled animated headShake')
		.data('selected', false);
		Selector.queDivObj.find('.word').find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');

		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();			
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		//to hide status icon
		Selector.queDivObj.find('.word').find('.status').addClass('visibility-hidden');
		for(var i=0; i<Selector.userArray.length; i++){	
			var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
			curr.removeClass('selected');			
		}
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){		
			var curr = Selector.queDivObj.find('.word-'+Selector.CORRECT_ANS_ARRAY[i])
			curr.addClass('corr-ans');								
		}
		
	}
	function showUserSelection(){
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);	
		for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){		
			var curr = Selector.queDivObj.find('.word-'+Selector.CORRECT_ANS_ARRAY[i])
			curr.removeClass('corr-ans');							
		}	
		for(var i=0; i<Selector.userArray.length; i++){	
			var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
			curr.addClass('selected');
			curr.find('.status').removeClass('visibility-hidden');
		}
	}
	function showTickCorss(){
		for(var i=0; i<Selector.userArray.length; i++){	
			var found = false;
			for(var j=0; j<Selector.CORRECT_ANS_ARRAY.length; j++){
				if (Selector.userArray[i].toString() == Selector.CORRECT_ANS_ARRAY[j].toString()) {		
					var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
					curr.addClass('user-corr-ans tick');
					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.removeClass('i-cross')
					.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.addClass('i-tick');	
					found = true;
					break;	
				}
			}
			if(!found){
				if (Selector.userArray[i] != null) {
					var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
					curr.addClass('user-incorr-ans cross');
					//---show incorrect tick 
					/* curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.removeClass('i-tick')
					.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.addClass('i-cross'); */
					//--hide incorrect tick
					curr.find('.status').addClass('visibility-hidden');
					//--
				}
			}
		}
		/* for(var i=0; i<Selector.CORRECT_ANS_ARRAY.length; i++){	
			if(Selector.SHOW_CORR_ANS_ON_SUBMIT){
				var curr = Selector.queDivObj.find('.word-'+Selector.CORRECT_ANS_ARRAY[i])
				curr.addClass('corr-ans tick');
				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.removeClass('i-cross')
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');				
			}					
		} */
	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.userArray.length; i++){	
			var found = false;
			for(var j=0; j<Selector.CORRECT_ANS_ARRAY.length; j++){
				if (Selector.userArray[i].toString() == Selector.CORRECT_ANS_ARRAY[j].toString()) {		
					
					found = true;
					break;	
				}
			}
			if(!found){
				if (Selector.userArray[i] != null) {
					var curr = Selector.queDivObj.find('.word-'+Selector.userArray[i]);
					//curr.addClass('animated headShake');
					TweenMax.to(curr, 0.1, {
						x: '+=10',
						yoyo: true,
						repeat: 3,
						clearProps: "all"							
					});	
				}
			}
		}
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_SCREEN_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	function updateStatus() {
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
}