function ToolTipScreen() {
	var _this = this;
	var Selector = {};
	var preloadImgArr=[];
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'tooltip-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			POPUP_CONTAINER: '.tooltip-popup-container',
			SHOW_MULTI_POP: false,
			TYPE: '1',
			TRIGGER: 'hover',
			ON_CLICK: null,
			ON_COMPLETE: null,
			CLICK_ARRAY: [],
			isCompleted:false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		//--create popup
		$(Selector.ACTIVITY_CONTAINER).find(Selector.POPUP_CONTAINER).html('');
		Selector.toolTipBtns = $(Selector.ACTIVITY_CONTAINER).find('*[data-tooltip-content]')
		Selector.toolTipBtns.each(function(inx){			
			$(this).attr('data-tid', inx);
			$(this).addClass('tooltip-btn')
			.addClass('tooltip-btn'+'-'+inx);
			
			var dataContent = $(this).data('tooltip-content');
			var dataArrow = $(this).data('arrow') || 'top';
			
			var str ='';
			str += '<div class="tooltip-pop tooltip-pop-'+inx+' arrow-'+dataArrow+'" data-id="'+inx+'">';
				if(dataArrow == 'top' || dataArrow == 'left'){
					str += '<div class="tooltip-arrow arrow-'+dataArrow+' font-icon icon-triangle-'+dataArrow+'"></div>';
				}
				str += '<div class="tooltip-content">';
					str += '<div class="text-box">';
						str += dataContent;
					str += '</div>';
				str += '</div>';
				if(dataArrow == 'bottom' || dataArrow == 'right'){
					str += '<div class="tooltip-arrow arrow-'+dataArrow+' font-icon icon-triangle-'+dataArrow+'"></div>';
				}
			str += '</div>';
			$(Selector.ACTIVITY_CONTAINER).find(Selector.POPUP_CONTAINER).append(str);
		});
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent(); 
		APP.preloaderObj.hide();
	}
	
	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
	
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			Selector.toolTipBtns.each(function(inx){
				var id = $(this).data('tid');
				if(Selector.userData[id] == 1){
					$(this).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			Selector.toolTipBtns.each(function(inx){
				Selector.userData.push(0);
			});
		}
		
		updateStatus();
	}

	function addTemplateEvent() {
		if(Selector.TRIGGER == 'click'){
			Selector.toolTipBtns.click(function(e){
				if($(this).hasClass('disabled')){return false;};
				e.stopPropagation();
				APP.commonFunObj.playSoundEffect({name: 'clicked'});
				ShowPop($(this));
			})
		}else{
			Selector.toolTipBtns
			.mouseenter(function(e) {
				if($(this).hasClass('disabled') || $(this).hasClass('current')){return false;};
				e.stopPropagation();
				ShowPop($(this));
			})		
			.mouseleave(function(e) {
				if($(this).hasClass('disabled') ){return false;};
				$(Selector.ACTIVITY_CONTAINER).find('.tooltip-pop').hide();	
				$(this).removeClass('current');
				if(Selector.TYPE == '1'){
					$(Selector.ACTIVITY_CONTAINER).find('.line').css('background-color', '#B8B8B8');
				}	
			})
		}
	}
	function ShowPop(_btnObj){
		var id = parseInt($(_btnObj).data('tid'));
		
		if($(_btnObj).hasClass('current')){
			if(Selector.TYPE == '1'){
				$(Selector.ACTIVITY_CONTAINER).find('.line').css('background-color', '#B8B8B8');
			}			
			$(_btnObj).removeClass('current');
			$(Selector.ACTIVITY_CONTAINER).find('.tooltip-pop').hide();	
			return false;	
		}
		
		Selector.toolTipBtns.removeClass('current');
		$(Selector.ACTIVITY_CONTAINER).find('.tooltip-pop').hide();			
		
		if(Selector.TYPE == '1'){
			var dataColor = $(_btnObj).data('color') || '';
			if(dataColor !=null && dataColor!= ''){
				$(Selector.ACTIVITY_CONTAINER).find('.line').css('background-color', dataColor);
			}else{
				$(Selector.ACTIVITY_CONTAINER).find('.line').css('background-color', '#B8B8B8');
			}
		}
		$(_btnObj).addClass('current');
		Selector.userData[id] = 1;			
		var currPop = $(Selector.ACTIVITY_CONTAINER).find('.tooltip-pop[data-id="'+id+'"]');	
		
		currPop.show();
		
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({id: id, arr:Selector.userData});
		}	
		updateStatus();
	}
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_SCREEN_RESIZE, function (e) {
		updateTemplateLayout();
	});

	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
}