function Configuration() {
	var _this = this;
	_this.language = {
		defaultLang:"en",
		defaultDir: "ltr"
    }
    _this.filePath = {
		dataPath: "content/nav/",
		langFolderPath: "content/lang/"
	}
	_this.tracking = {
		/**
		 *  0: STANDALONE/No tracking 
		 *  1: SCORM1.2 
		 *  2: SCORM2004 v4 -- current
		 */
		complianceType: 2,
		lmsIntervalTime: 300000, // 5 minutes
        isReviewMyELearning: false, //-- for some custom updates on bookmark
		onlyQuesNumbericDataSend: true //-- for multi lang questions interactions (only send numbers)
    }
     //-- to use single screenData xml
     _this.isScreenDataXmlAvl = false;
     
    //--to enabled screen jump
    _this.debugMode = false;
    
    //--to view correct answers
    _this.cheatMode = false;

    _this.menu = {
        lockMenu: true,
        lockSubMenu: true
    }

    _this.screenWise = {
        linearNavigation: true,
        showPrevData: false
    }
    _this.blankVidObj = {
        src: "framework/images/blank_video.mp4",
        posterImg: "framework/images/blank_video.jpg",
    }
     _this.genericSoundObj = {
        blank: "framework/sounds/blank_audio.mp3",      
        clicked: "framework/sounds/clicked.mp3",      
        correct: "framework/sounds/correct.mp3",      
        incorrect: "framework/sounds/incorrect.mp3",
        dragNDrop: "framework/sounds/sound_drag_n_drop.mp3",      
        pass: "framework/sounds/pass.mp3",  
        cardFlip: "framework/sounds/sound_card_flip.mp3",  
        coverFlow: "framework/sounds/sound_coverflow.mp3", 
        incomingCall: "framework/sounds/incoming_call.mp3",  
        notification: "framework/sounds/notification.mp3",  
        caseOpen: "framework/sounds/case_open.mp3",  
        typedSound: "framework/sounds/sound_digital_text.mp3",  
     }
    _this.assessment = [
        {
            id: 'mod10-assessment',
            dataFileName: 'assessmentData01.xml',
            dataImagesPath: '/',
            isAvailable: true,            
            passingScore: 70,
            //timer (in minutes) - null means unlimited time access
            timer: null,
            //randomization - false means showing all questions
            randomization: true,
            //noOfAttempts - 0 means unlimited attempts
            noOfAttempts: 0,
            sendQueInteractionData: false,
            applyPointOnPartiallyCorrect: true
        },        
    ]
    
    _this.glossary = {
        isAvailable: false,
        dataFileName: 'glossaryData.xml'
    }
    _this.breakPoint = {
        mobile: 834,
		small:667
    }
	
	_this.system={
		toBeChecked:false,
		supported:[
			{
				id:"OS",
				name: "Operating System",
				data:[
					{
						id:"ios",
						min:"6",
						max:"14"
					},{
						id: "windows",
						min: "6.10",
						max: "10.00"
					}, {
						id: "windows rt",
						min: "8.00",
						max: "10.00"
					}, {
						id: "mac",
						min: "10.08",
						max: "10.14"
					}, {
						id: "android",
						min: "4",
						max: "10"
					}
				]
			},{
                id: "browser",
                name: "Web Browser",
                data: [
                    {
                        "id": "ie",
                        "min": "11",
                        "max": "11"
                    }, {
                        "id": "firefox",
                        "min": "52",
                        "max": "80"
                    }, {
                        "id": "edge",
                        "min": "12",
                        "max": "20"
                    }, {
                        "id": "chrome",
                        "min": "47",
                        "max": "85"
                    }, {
                        "id": "safari",
                        "min": "5",
                        "max": "14"
                    }, {
                        "id": "iron",
                        "min": "1",
                        "max": "14"
                    }
                ]
            }, {
                "id": "device",
                "name": "Device",
                "data": [
                    {
                        "id": "tablet"
                    }, {
                        "id": "mobile"
                    }, {
                        "id": "desktop"
                    }
                ]
            }, {
                "id": "model",
                "name": "Device Model",
                "data": [
                    {
                        "id": "ipad"
                    }, {
                        "id": "iphone"
                    }, {
                        "id": "android"
                    }, {
                        "id": "windows phone"
                    }, {
                        "id": "windows tablet"
                    }
                ]
            }
		]
	}
}