function Common() {
	var _this = this;
	
	var timeInterval = null;
	//--custom edit for client
	var lmsInterval = null;
	var lmsIntervalTime = APP.configObj.tracking.lmsIntervalTime;
	//--
	
	_this.setPassDate = function(){
		
		/* if(APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPassDate== "" || APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPassDate == null){
			var now = new Date();
			var dt= now.getDate() + "_" + (now.getMonth()+1) + "_" + now.getFullYear();
			APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPassDate  = dt;	
		} */		
		if(APP.coursePassDate === "" || APP.coursePassDate == null){
			var now = new Date();
			var dt= now.getDate() + "_" + (now.getMonth()+1) + "_" + now.getFullYear();
			APP.coursePassDate = dt;	
		}
	}
	_this.getFormattedPassDate= function(){
		var _fullDate='';
		//var obj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId].dataPassDate;
		var obj = APP.coursePassDate;
		if(obj === '' || obj == null){return _fullDate;}
		if(obj.indexOf('_') != -1 ){
			var t=obj.split('_');
			var dd=t[0];
			var mm=parseInt(t[1]) - 1;
			var yyyy=t[2];
			var monthStr=APP.globalXmlsObj.globalXML.monthText[0].text[mm].Text;
			_fullDate = dd +' '+monthStr+' '+yyyy;			
		}
		return _fullDate;
	}
	_this.getRandomNumber = function(min, max) {
		min = Math.ceil(min);
		max = Math.floor(max);
		return Math.floor(Math.random() * (max - min) + min); // The maximum is exclusive and the minimum is inclusive
	}
	_this.getShortLangCode = function(){
		let lang = APP.configObj.language.lang;
		return lang.split('-')[0];		
	}
	_this.getRandomArr = function (_len, _start, _end) {
		var len = _len;
		var start = _start != undefined ? _start : 0;
		var end = _end != undefined ? _end : (start + len);
		var unique_random_numbers = [];
		var limit = end - start;
		if (len > limit) len = limit;
		while (unique_random_numbers.length < len) {
			var random_number = Math.floor(Math.random() * (limit) + start);
			if (unique_random_numbers.indexOf(random_number) == -1) {
				unique_random_numbers.push(random_number);
			}
		}
		return unique_random_numbers;
	}
	_this.getLinearArr = function (_len, _start, _end) {
		var len = _len;
		var start = _start != undefined ? _start : 0;
		var end = _end != undefined ? _end : (start + len);
		var linear_array = [];
		var limit = end - start;
		if (len > limit) len = limit;
		for (var i = start; i < end; i++) {
			if (linear_array.length < len) {
				linear_array.push(i);
			}
		}
		return linear_array;
	}
  	_this.startTimer = function (duration) {
		duration = duration * 60;
		var start = Date.now(),
			diff,
			minutes,
			seconds;

		function timer() {
			// get the number of seconds that have elapsed since 
			// startTimer() was called
			diff = duration - (((Date.now() - start) / 1000) | 0);
			// does the same job as parseInt truncates the float
			minutes = (diff / 60) | 0;
			seconds = (diff % 60) | 0;
			minutes = minutes < 10 ? "0" + minutes : minutes;
			seconds = seconds < 10 ? "0" + seconds : seconds;
			var obj = {
				displayTime: minutes + ":" + seconds,
				remainingTime: diff
			};
			$(document).trigger(APP.eventObj.ON_TIME_UPDATE, [obj]);
			if (diff <= 0) {
				// add one second so that the count down starts at the full duration
				// example 05:00 not 04:59
				//start = Date.now() + 1000;
				$(document).trigger(APP.eventObj.ON_TIME_COMPLETE);
				APP.commonFunObj.stopTimer();
				//clearInterval(timeInterval);
			}
		};
		// we don't want to wait a full second before the timer starts
		timer();
		timeInterval = setInterval(timer, 1000);
	}
	_this.stopTimer = function () {
		clearInterval(timeInterval);
	}
	
	_this.changeLanguage = function (_lang, _dir) {
		//console.log('changeLanguage...');
		//console.table(APP.configObj.language);
		APP.prevLanguageObj.lang = APP.configObj.language.lang;
		APP.prevLanguageObj.dir = APP.configObj.language.dir;
		if (APP.configObj.language.lang != _lang) {
			APP.userLanguageChanged = true;
			APP.configObj.language.lang = _lang;
			APP.configObj.language.dir = _dir || 'ltr';			
		}

		if(APP.courseDataObj.isLangChange().isDirChanged){			
			APP.courseDataObj.changeDirWiseFileLocation();
					
		};

		if (APP.userLanguageChanged === true) {
			APP.globalXmlsObj.loadGlobalXML();
		} else {
			APP.navigationObj.loadNextScreen();
		}
	}
	_this.getIndexCourseTitle = function() {
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.indexTitle[0].Text;
		}
		return title;
	}
	_this.getCourseTitle = function() {
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.courseTitle[0].Text;
		}
		return title;
	}
	_this.getProjectTitle = function() {
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.projectTitle[0].Text;
		}
		return title;
	}
	_this.getModuleTitle = function(_obj) {
		var obj = _obj || APP.navData;
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].title[0].Text;
		}
		return title;
	}
	_this.getTopicIconClass = function(_obj) {
		var obj = _obj || APP.navData;
		var iconClass =''
		if(APP.globalXmlsObj.globalXML){
			iconClass = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].topic[obj.topicId].iconClass || '';
		}
		return iconClass;
	}
	_this.getPreTopicTitle = function(_obj) {
		var obj = _obj || APP.navData;
		var preTitle =''
		if(APP.globalXmlsObj.globalXML){
			preTitle = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].topic[obj.topicId].preTitle[0].Text;
		}
		return preTitle;
	}
	_this.getTopicTitle = function(_obj) {
		var obj = _obj || APP.navData;
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].topic[obj.topicId].title[0].Text;
		}
		return title;
	}
	_this.getScreenTitle = function(_obj) {
		var obj = _obj || APP.navData;
		var title =''
		if(APP.globalXmlsObj.globalXML){
			title = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].topic[obj.topicId].screen[obj.screenId].title[0].Text;
		}
		return title;
	}
	_this.getScreenObjFromGlobalXml = function(_obj) {
		var obj = _obj || APP.navData;	
		var sc = null;	
		if(APP.globalXmlsObj.globalXML){
			sc = APP.globalXmlsObj.globalXML.menu[0].module[obj.moduleId].topic[obj.topicId].screen[obj.screenId];
		}
		return sc;
	}
	_this.getScreenObjFromNavigationXml = function(_obj) {
		var obj = _obj || APP.navData;	
		var sc = null;	
		if(APP.globalXmlsObj.navigationXML){
			sc = APP.globalXmlsObj.navigationXML.module[obj.moduleId].topic[obj.topicId].screen[obj.screenId];
		}
		return sc;
	}
	_this.getReportTextObj = function(_id){
		var obj = '';
		if(APP.globalXmlsObj.globalXML){
			var txtObj = APP.globalXmlsObj.globalXML.reportText[0];
			for(var i=0; i<txtObj.screen.length; i++){
				var curr = txtObj.screen[i];
				if(curr.id == _id){
					obj = curr;
					break;					
				}
			}
		}
		return obj;
	}
	_this.updateMenuBgImgPath = function(){
		//--custom for this course		
		var obj1 = APP.navigationObj.getScreenIdByType('menuScreen');
		if(obj1.isAvl){
			var scXmlObj = APP.commonFunObj.getScreenObjFromGlobalXml(obj1);
			var menuBgImgPath = 'menu_state0_bg.jpg';
			var completedMod = APP.courseDataObj.getTotalMandatoryCompleteModuleCount();
			
			if(completedMod != null){
				menuBgImgPath = 'menu_state'+completedMod+'_bg.jpg';
				APP.globalXmlsObj.globalXML.menu[0].module[obj1.moduleId].topic[obj1.topicId].screen[obj1.screenId].bgImg = menuBgImgPath;						
			}
		}
		
		//--
	}
	_this.updateHeaderTitle = function(val) {		
		$('.header').find('.title-panel').html(val);
		$('.mobile-titlebar').find('.title-panel').html(val);
	}
	_this.checkScreenSizePop = function(){
		var ww = 10;
		if(APP.configObj.tracking.isReviewMyELearning === true){ww = 320;}
		var windowWidth = Math.min(window.innerWidth, window.outerWidth);
		var windowHeight = Math.min(window.innerHeight, window.outerHeight);
		if(windowWidth < ww){		
			if(APP.globalModalObj){
				//APP.globalModalObj.closeModal();
			}else{
				_this.showScreenSizePop();
			}				
		}else if(APP.globalModalObj){
			var currClass = APP.globalModalObj.getClassName();				
			if(currClass == 'screen-size-pop'){
				APP.globalModalObj.closeModal();
			}
		}		
	}
	_this.removeDuplicatesFromArr = function(data){
		var unique = data.reduce(function (a,b){
			if(a.indexOf(b) < 0 ) a.push(b);
				return a;
		}, [])
		return unique;
	}
	  
	_this.preloadImages = function(val, _callback) {
		//check if value is Array or Object
		var _arr = val;
		if(val.constructor === Object){
			_arr = []
			for(var key in val) {
				_arr.push(val[key]);
			}
		}
		//--if nothing to load return 
		if(_arr.length <=0){			
			if(_callback){
				_callback();
			}
			return false;
		}
		//--	
		/* //--prevent to load images on mobile
		if(APP.commonFunObj.getCurrentView() === 'mobile'){			
			if(_callback){
				_callback();
			}
			return false;
		}	
		//-- */
		var images = _arr.map(function(x){return 0;});
				
		for (var i = 0; i < _arr.length; i++) {	
			//--prevent to load mobile images on desktop
			var _src = _arr[i];			
			if(APP.commonFunObj.getCurrentView() === 'desktop'){	
				if(_src.indexOf("_m.") >= 0){					
					images[i] = 1;	
					checkStatus();					
					continue;
				}
			}		
			//--				
			$("<img/>")
			.data('inx', i)
			.data('dysrc', _src)
			.on('load', function() { 				
				var inx = parseInt($(this).data('inx'));			
				images[inx] = 1;
				checkStatus();
			})
			.on('error', function() { console.warn("error loading image - "+$(this).data('dysrc')); })
			.attr("src", _src)
		}
		function checkStatus(){
			var count = 0;			
			for(var j = 0; j<images.length; j++){
				if(images[j]==1){
					count++;
				}
			}
			if(count >= images.length){				
				if(_callback){
					_callback();
				}
			}			
		}
		
	}
	_this.updateLearnerNameInScreen = function(){
		var str = APP.dataComObj.getStudentName();
		$('.learner-name').text(str.toString());
	}
	//--for screen audio
	/* call function
	APP.commonFunObj.playScreenAudio({
		path: 'audio.mp3',
		onPlay: function(){},
		onPause: function(){},
		onEnd: function(){}
	}); */
	_this.playScreenAudio = function(_obj){
		var path = _obj.path;		
		if(path == null || path === ''){return false;}
		
		if(APP.screenAudio){APP.screenAudio.stop();}
		APP.screenAudio = new Howl({
			src: [path],
			onplay: function () {
				if(_obj.onPlay){
					_obj.onPlay();
				}
			},
			onpause: function(){
				if(_obj.onPause){
					_obj.onPause();
				}
			},
			onend: function () {
				if(_obj.onEnd){
					_obj.onEnd();
				}
			}
		});
		APP.screenAudio.load();
		if(APP.isScreenAudioPlay){APP.screenAudio.play();}
	}
						
	//--
	_this.playSoundEffect = function(_obj){		
		var path = _obj.path || '';
		var soundName = _obj.name || '';
		//if(APP.soundEffectAudio){APP.soundEffectAudio.stop();}
		if(path == null || path === ''){
			path = APP.configObj.genericSoundObj.clicked;
		}
		if(soundName == 'clicked'){
			path = APP.configObj.genericSoundObj.clicked;
    }else if(soundName == 'blank'){
			path = APP.configObj.genericSoundObj.blank;
		}else if(soundName == 'correct'){
			path = APP.configObj.genericSoundObj.correct;
		}else if(soundName == 'incorrect'){
			path = APP.configObj.genericSoundObj.incorrect;
		}else if(soundName == 'dragNDrop'){
			path = APP.configObj.genericSoundObj.dragNDrop;	
		}else if(soundName == 'pass'){
			path = APP.configObj.genericSoundObj.pass;
		}else if(soundName == 'ipad'){
			path = APP.configObj.genericSoundObj.ipad;
		}else if(soundName == 'notification'){
			path = APP.configObj.genericSoundObj.notification;
		}else if(soundName == 'caseOpen'){
			path = APP.configObj.genericSoundObj.caseOpen;
		}else if(soundName == 'cardFlip'){
			path = APP.configObj.genericSoundObj.cardFlip;
		}else if(soundName == 'coverFlow'){
			path = APP.configObj.genericSoundObj.coverFlow;		
		}else if(soundName == 'typedSound'){
			path = APP.configObj.genericSoundObj.typedSound;		
		}

		//console.log('path: '+path);			
		APP.soundEffectAudio = new Howl({
			src: [path],
			onplay: function () {
				if(_obj.onPlay){
					_obj.onPlay();
				}
			},
			onpause: function(){
				if(_obj.onPause){
					_obj.onPause();
				}
			},
			onend: function () {
				if(_obj.onEnd){
					_obj.onEnd();
				}
			}
		});
		APP.soundEffectAudio.load();
		APP.soundEffectAudio.play();
			
	}
	_this.playBgMusic = function(_path){
		var path = _path;		
		if(path == null || path === ''){return false;}
		//if same audio found
		if(APP.soundBgAudio){
			if(APP.soundBgAudio._src == _path){return false;}
		}	
		
		if(APP.soundBgAudio){APP.soundBgAudio.stop();}
		APP.soundBgAudio = new Howl({
			src: [path],		
			loop: true,
		});
		APP.soundBgAudio.load();
		APP.soundBgAudio.play();	
		APP.soundBgAudio.fade(0,0.5,500);			
	}
	_this.playBgMusic1 = function(_path){
		var path = _path;		
		if(path == null || path === ''){return false;}	
		if(APP.soundBgAudio1){APP.soundBgAudio1.stop();}
		APP.soundBgAudio1 = new Howl({
			src: [path],		
			loop: true,
		});
		APP.soundBgAudio1.load();
		APP.soundBgAudio1.play();
		APP.soundBgAudio1.fade(0,0.5,500);					
	}
	_this.pauseBgMusic = function(){
		if(APP.soundBgAudio){APP.soundBgAudio.pause();}		
	}
	_this.pauseBgMusic1 = function(){
		if(APP.soundBgAudio1){APP.soundBgAudio1.pause();}
	}
	_this.removeScreenAudio = function(){
		if(APP.screenAudio){APP.screenAudio.stop();}
		APP.screenAudio = null;
	}
	_this.removeBgMusic = function(){
		if(APP.soundBgAudio){APP.soundBgAudio.stop();}		
		APP.soundBgAudio = null;
		
	}
	_this.removeSoundEffect = function(){
		if(APP.soundEffectAudio){APP.soundEffectAudio.pause();}		
		APP.soundEffectAudio = null;	
	}
	_this.removeBgMusic1 = function(){
		if(APP.soundBgAudio1){APP.soundBgAudio1.stop();}
		APP.soundBgAudio1 = null;
	}
	_this.getScreenDataFromAllScreenDataXML = function(_obj){
		if(APP.globalXmlsObj.allScreenDataXML == null){return false;}
		var screenData = _obj.name || APP.navData.currentScreenObj.screenData;
		//screenData/1_1_10.xml
		var arr = screenData.split('/');
		var screenId = arr[arr.length - 1].split('.xml')[0];
		var screenXml = null;
		for (var i=0; i< APP.globalXmlsObj.allScreenDataXML.screen.length; i++){
			var curr = APP.globalXmlsObj.allScreenDataXML.screen[i];
			//console.log(screenId+'::'+curr.id)
			if(screenId == curr.id){
				screenXml = curr.content[0];
				break;
			}
		}
		if(screenXml){
			return screenXml;
		}else{
			console.error('screenId not found in screenData.xml')
		}
	}
	_this.showExitPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.exitPopText[0],
			CLASS_NAME: 'exit-pop',
			ON_OK:function(){
				APP.winWillClose=true;
				//--
				APP.commonFunObj.stopLmsInterval();		
				//--
				window.top.close();
			}
		});

	}
	
	
	/* _this.showConfirmPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.confirmPopText[0],
			CLASS_NAME: 'confirm-pop',
			ON_OK:function(){
				APP.winWillClose=true;
				//--
				APP.commonFunObj.stopLmsInterval();		
				//--
				window.top.close();
			}
		});

	} */
	
	_this.showResourcesPop = function(){
		var relPath = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + "/";
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.resourcesPopText[0],
			CLASS_NAME: 'resources-pop',
			VIEW_FILE: relPath+'screenView/resources_pop.html',		
		});

	}
	_this.showHelpPop = function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.helpPopText[0],
			CLASS_NAME: 'help-pop'			
		});

	}
	
	_this.showScreenSizePop = function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.screenSizePopText[0],
			CLASS_NAME: 'screen-size-pop',
			SHOW_ANIMATION: false
		});

	}
	_this.showMobileDevicePop = function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.mobileDevicePopText[0],
			CLASS_NAME: 'small-device-pop',
			SHOW_ANIMATION: false,
			ON_OK:function(){
				APP.globalXmlsObj.loadOtherGlobalXML();
			},		
			/* ON_CLOSE: function(){
				APP.winWillClose=true;
				//--
				APP.commonFunObj.stopLmsInterval();		
				//--
				window.top.close();
			} */
		});

	}
	_this.showBookmarkPop = function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.bookmarkPopText[0],
			CLASS_NAME: 'bookmark-pop',
			ON_OK:function(){
				APP.navigationObj.loadScreen();
			},
			ON_CLOSE: function(){
				APP.navData.moduleId=0;
				APP.navData.topicId=0;
				APP.navData.screenId=0;
				
				APP.navigationObj.loadScreen();
			}
		});	
		
	}
	_this.showApiFailPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.apiFailPopText[0],
			CLASS_NAME: 'api-fail-pop',
			ON_OK:function(){
				APP.winWillClose=true;
				//--
				if(APP.commonFunObj){APP.commonFunObj.stopLmsInterval();}	
				//--
				window.top.close();
			}
		});	
	}
	_this.showLmsWinClosedPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.lmsWinClosedPopText[0],
			CLASS_NAME: 'lms-win-closed-pop',
			ON_OK:function(){
				APP.winWillClose=true;
				//--
				if(APP.commonFunObj){APP.commonFunObj.stopLmsInterval();}						
				//--
				window.top.close();
			}
		});	
	}
	/* _this.showTimeoutPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.timeoutPopText[0],
			CLASS_NAME: 'timeout-end-pop',
			ON_OK:function(){
				$(document).trigger(APP.eventObj.ON_TIMEOUT_CONTINUE_CLICKED);	
			}
		});	
	} */
	/* _this.showAttemptEndPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.attemptesEndPopText[0],
			CLASS_NAME: 'attempt-end-pop',
			ON_OK:function(){
				APP.winWillClose=true;
				//--
				APP.commonFunObj.stopLmsInterval();		
				//--
				window.top.close();
			}
		});	
	} */
	/* _this.showAttemptPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.attemptesPopText[0],
			CLASS_NAME: 'attempt-pop',
			ON_OK:function(){
				
			}
		});	
	} */
	_this.showNetworkFailPop=function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.networkFailPopText[0],
			CLASS_NAME: 'network-fail-pop'
		});	
			
	}
	/* _this.showCompleteMandatoryPop = function(){
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.completeMandatoryPopText[0],
			CLASS_NAME: 'complete-mandatory-pop'
		});	
			
	}
	_this.showGlossaryPop = function(){
		if(APP.globalXmlsObj.glossaryXML != null){
			APP.globalModalObj = new Glossary();
			APP.globalModalObj.start({
				XML_NODE: APP.globalXmlsObj.glossaryXML.glossaryPopText[0],
				CLASS_NAME: 'glossary-pop',
				SHOW_ANIMATION: true
			});
		}
	} */
	_this.loadBlankBgVid = function(){
		isBlankVid = true;
		
		var vidSrc = APP.configObj.blankVidObj.src;
		var posterImg = APP.configObj.blankVidObj.posterImg;
		$('#bg-video')
		.attr('class', 'bg-video')
		.addClass('blank-vid');	
		if($('#bg-video').find('#mp4_src').attr('src') != null && $('#bg-video').find('#mp4_src').attr('src') != ''){
			$('#bg-video').get(0).pause();
		}
		
		$('#bg-video').find('#mp4_src').attr('src', vidSrc);
		//$('#bg-video').attr('poster', posterImg);
		$('#bg-video').get(0).load();
	}
	_this.applyBgVidSource = function(_obj){
		var obj = _obj || APP.bgVideoObj;
		$('#bg-video').removeClass('hide');
		var currVidObj = obj;
		var vidSrc = currVidObj.src;
		//var posterImg = currVidObj.posterImg;
		var prevSrc = $('#bg-video').find('#mp4_src').attr('src');		
		//--if prev video is same then only play
		if(prevSrc.toString() == vidSrc.toString()){
			$('#bg-video').get(0).currentTime = 0;
			$('#bg-video').get(0).play();
			return false;
		}
		$('#bg-video')
		.attr('class', 'bg-video')
		.addClass(currVidObj.id);	
		if($('#bg-video').find('#mp4_src').attr('src') != null && $('#bg-video').find('#mp4_src').attr('src') != ''){
			$('#bg-video').get(0).pause();
		}
		isBlankVid = false;
		$('#bg-video').find('#mp4_src').attr('src', vidSrc);
		//$('#bg-video').attr('poster', posterImg);
		$('#bg-video').get(0).load();
		$('#bg-video').get(0).play();
	}
	_this.insertDelay = function(amount){
		vDate = new Date() 
		while (1)
		{
			vMill=new Date() 
			vDiff = vMill-vDate;
			if( vDiff > amount ) 
				break;
		}
	}
	_this.isScorm = function(){
		var scrom=false;
		//-- 1: scorm1.2, 2:scorm2004
		if(APP.configObj.tracking.complianceType==1 || APP.configObj.tracking.complianceType==2){
			scrom = true;
		}
		return scrom;
		//return true;
	} 
	_this.isOnlineHttp = function(){
		var isHttp = false;	
		isHttp = String(window.location).indexOf("http") >= 0 || String(window.location).indexOf("https") >= 0
		return isHttp;
		//return true;
	}
	
	_this.checkConnection=function(callBack){
		/* document.getElementById('net-con').innerHTML +=
			'<img id="testImage" style="display: none;" ' +
			'src="framework/images/for_network_check.png?' + Math.random() + '" ' +
			'onerror="testConnectionCallback(false);" ' +
			'onload="testConnectionCallback(true);">';

		testConnectionCallback = function(result){
			callBack(result);
			//alert("called")
			var element = document.getElementById('testImage');
			if(element!=null){
			element.parentNode.removeChild(element);
			}
		}  */   
		APP.eventObj.updateOnlineStatus();
	}
	_this.documentScrollTop = function() {
		return (document.documentElement.scrollTop + document.body.scrollTop
		== document.documentElement.scrollTop) ?
		document.documentElement.scrollTop : document.body.scrollTop;
	}
	
	_this.isElementInView = function (elem,dir) {
		var docViewTop = _this.documentScrollTop();
		var docViewBottom = (window.innerHeight + docViewTop);

		var elemTop = $(elem).offset().top;
		var elemBottom = elemTop + ($(elem).height() / 2);
		var elemBottom2 = elemTop + $(elem).height();
	   
		if(dir == 'top'){		
			if((elemTop <= docViewTop && elemBottom2 >= docViewTop)){		
				return (elemBottom2 -docViewTop) > (window.innerHeight/2);	
			}else if(elemTop > docViewTop && elemBottom2 >= docViewTop){			
				return (docViewBottom - elemTop) > (window.innerHeight/2);			
			}else{
				return false;
			}				
		}else{
			return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop ));
		}	
	}

	_this.scrollToElement = function ($el, showAnimation, type, gap){        
		if($el.length<=0){return false;}
		if (type == undefined){type = "bottom";}
		if (gap == undefined || gap == ''){gap = 0;}
		var marginTop;
   
		var viewportTop = _this.documentScrollTop();
		
		var viewportBottom = viewportTop + ($(window).height());
		
		var elOffsetTop = $el.offset().top;
		var headerEl = $('.header');
		
		if (type == "bottom"){
			marginTop = (elOffsetTop + $el.outerHeight()+10);
			//marginTop = (elOffsetTop + $el.outerHeight()+10);
			if (marginTop < viewportTop || marginTop > $(window).height()){
				type = "top";
			}
		}
		if (type == "top"){
			if(headerEl.length){
				marginTop = elOffsetTop - ($('.header').outerHeight(true, true) - gap);
			}else{
				marginTop = elOffsetTop - gap;
			}			
		}
		if(showAnimation){
			$("html, body").stop().animate({scrollTop:marginTop}, 1000, function() { 
			
			});	  
		}else{
			$("html, body").scrollTop(marginTop);
		}
    }
	_this.startLmsInterval = function(){	
		APP.commonFunObj.stopLmsInterval();	
		
		lmsInterval = setInterval(function(){APP.dataComObj.updateUserData()}, lmsIntervalTime);
	}
	_this.stopLmsInterval = function(){
		
		clearInterval(lmsInterval);
	}
	_this.removeMediaElement = function(){
		if(APP.vidPlayer){
			APP.vidPlayer.destroy();
			APP.vidPlayer = null;
		} 
		if(APP.modalVidPlayer){
			APP.modalVidPlayer.destroy();
			APP.modalVidPlayer = null;
		} 
		if(APP.screenAudio){
			APP.screenAudio.stop();
			APP.screenAudio.unload();
			APP.screenAudio = null;
		}
	}
	_this.getNumberTxt = function (_currIndx, _actualNo){
		var inx = (_currIndx+1);
		if(_actualNo === undefined) {
			  _actualNo = false;
		   }
		if(_actualNo == true){
			inx = _currIndx;
		}
		var num = APP.globalXmlsObj.globalXML.numbers[0].number[inx];
			if(num == null || num == undefined){
				num = inx;
			}else{
				num = num.Text;
			}
		return num;
	}
	_this.convertMinsToHrsMins = function (minutes){
		var obj= {
			hour: '00',
			minute: '00'
		}
		//--to prevent millisecond value
		var mn = Math.round(minutes);
		if(mn > 0){
			var h = Math.floor(mn / 60);
			var m = mn % 60;
			obj.hour = h < 10 ? '0' + h : h;
			obj.minute = m < 10 ? '0' + m : m;
			return obj;
		}else{
			return obj;
		}		
	}
	_this.updateScreenModalPopLayout = function(){
		var currModalEl = $('#main-div > .screen-modal-pop')
		if(currModalEl.length){			
			var contHt = currModalEl.height();
			var boxHt = currModalEl.find('.modal-box').outerHeight(true);			
			if((boxHt!=null && contHt!=null) && (boxHt > contHt)){
				currModalEl.find('.modal-box').addClass('top');
			}else{
				currModalEl.find('.modal-box').removeClass('top');
			}
		}
	}
	
	
	_this.getQueryStringParams = function getQueryStringParams(){
		var url = document.location.href;
		var qs = url.substring(url.indexOf('?') + 1).split('&');
		for(var i = 0, result = {}; i < qs.length; i++){
			qs[i] = qs[i].split('=');
			result[qs[i][0]] = decodeURIComponent(qs[i][1]);
		}
		return result;
	}	
	
	_this.getCurrentView = function (){
		/* 
		var winWd = Math.min(window.innerWidth, window.outerWidth);
   		var winHt = Math.min(window.innerHeight, window.outerHeight);
		if(winWd <= APP.configObj.breakPoint.mobile){
			return 'mobile'
		}else{
			return 'desktop'
		} */
		return 'desktop';
	}
	var widthToHeight, heightToWidth, windowWidth, windowHeight, newScale, newWidth, 
	contentWidth = $("#app-body").width(),
    contentHeight = $("#app-body").height(),
    heightToWidth = (contentHeight / contentWidth).toFixed(2),
    widthToHeight = (contentWidth / contentHeight).toFixed(2)
	
	function scaleByWidth() {
		windowWidth = Math.min(window.innerWidth, window.outerWidth);
		windowHeight = Math.min(window.innerHeight, window.outerHeight);
		newScale = (windowWidth / contentWidth).toFixed(2);
		newScale -= 0.0;
		convertToEven(newScale);
		/* setTimeout(function(){
			console.log('tScale: '+tScale);
		},1000) */
		/* TweenMax.set(document.body, {
			scale: newScale,
			transformOrigin: "center center"
		})  */
		/* $('body').css({
			'transform': 'scale('+newScale+')',
			'transform-origin': "center center"
		}); */
	}
	
	function scaleByHeight() {		
		windowWidth = Math.min(window.innerWidth, window.outerWidth);
		windowHeight = Math.min(window.innerHeight, window.outerHeight);
		newWidth = (windowHeight * widthToHeight).toFixed(0);
		newScale = (newWidth / contentWidth).toFixed(2);
		newScale -= 0.0;
		convertToEven(newScale);
		/* setTimeout(function(){
			console.log('tScale: '+tScale);
		},1000) */
		
		/* TweenMax.set(document.body, {
			scale: newScale,
			transformOrigin: "center center"
		}) */
		/* $('body').css({
			'transform': 'scale('+newScale+')',
			'transform-origin': "center center"
		}); */
	}
	
	_this.scaleContents = function() {		
		//-- for adaptive design only scale for desktop / breakpoint
		var currentView = _this.getCurrentView();
		if(currentView == 'mobile'){
			//mobile
			$('body').removeClass('adaptive').addClass('responsive');
			$("#app-body").removeClass('centered');
			$('body').attr('style', '');
		}else{
			//desktop
			$("html, body").scrollTop(0);
			$('body').removeClass('responsive').addClass('adaptive');
			$("#app-body").addClass('centered');
			
			//window.innerHeight / window.innerWidth) < heightToWidth ? scaleByHeight() : (window.innerHeight, window.innerWidth, scaleByWidth())
			windowWidth = Math.min(window.innerWidth, window.outerWidth);
			windowHeight = Math.min(window.innerHeight, window.outerHeight);
			//alert('innerWidth: '+window.innerWidth +' ::innerHeight: '+window.innerHeight+'\n\nouterWidth: '+window.outerWidth+' ::outerHeight: '+window.outerHeight+'\n\nwindowWidth: '+windowWidth+' ::windowHeight: '+windowHeight);
			if((windowHeight / windowWidth) < heightToWidth){
				scaleByHeight();
			}else{
				scaleByWidth();
			}
		}
	} 
	//for scale only
	function convertToEven(_num){
		//console.log('_num: '+_num)
		if(_num == 0 || _num == 1){
			TweenMax.set(document.body, {
				scale: 1,
				transformOrigin: "center center"
			})
			return false;
		};
		var num = _num.toFixed(2);
		var numStr = num.toString();			
		if(numStr.indexOf('.') == -1){			
			//integer 
			if(num % 2 == 0){				
				TweenMax.set(document.body, {
					scale: num,
					transformOrigin: "center center"
				})
				return false;
				/* return num */
			}else{				
				convertToEven((num - 1));
			}
		}else{						
			//float number
			var lastNum = numStr[numStr.length - 1];			
			if(lastNum % 2 == 0){				
				TweenMax.set(document.body, {
					scale: num,
					transformOrigin: "center center"
				})
				return false;
				//return num
			}else{				
				convertToEven((num - 0.01));
			}
		}
	}
	
}
(function ($) {
	$.fn.shuffle = function () {
		var parent = this.parent();
		var divs = parent.children();
		while (divs.length) {
			parent.append(divs.splice(Math.floor(Math.random() * divs.length), 1)[0]);
		}
	};
})(jQuery);
(function($) {
    $.fn.countTo = function(options) {
        options = $.extend({}, $.fn.countTo.defaults, options || {});

        var loops = Math.ceil(options.speed / options.refreshInterval),
            increment = (options.from - options.to) / loops;
		Number.prototype.formatMoney = function(c, d, t){
		var n = this, 
			c = isNaN(c = Math.abs(c)) ? 2 : c, 
			d = d == undefined ? "." : d, 
			t = t == undefined ? "," : t, 
			s = n < 0 ? "-" : "", 
			i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))), 
			j = (j = i.length) > 3 ? j % 3 : 0;
		   return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
		 };

        return $(this).each(function() {
            var _this = this,
                loopCount = 0,
                value = options.from,
                interval = setInterval(updateTimer, options.refreshInterval);

            function updateTimer() {
                value -= increment;
                loopCount++;
				var newVal = value.formatMoney(options.decimals, options.separator);
                $(_this).html(newVal);

                if (typeof(options.onUpdate) == 'function') {
                    options.onUpdate.call(_this, value);
                }

                if (loopCount >= loops) {
                    clearInterval(interval);
                    value = options.to;

                    if (typeof(options.onComplete) == 'function') {
                        options.onComplete.call(_this, value);
                    }
                }
            }
        });
    };

    $.fn.countTo.defaults = {
        from: 100,
        to: 10,
        speed: 500,
        refreshInterval: 100,
        decimals: 0,
        onUpdate: null,
        onComplete: null,
		separator: '.'
    };
})(jQuery);
String.prototype.replaceAll = function(search, replacement) {
    var target = this;
    return target.split(search).join(replacement);
};

if (typeof Object.assign !== 'function') {
  // Must be writable: true, enumerable: false, configurable: true
  Object.defineProperty(Object, "assign", {
    value: function assign(target, varArgs) { // .length of function is 2
      'use strict';
      if (target === null || target === undefined) {
        throw new TypeError('Cannot convert undefined or null to object');
      }

      var to = Object(target);

      for (var index = 1; index < arguments.length; index++) {
        var nextSource = arguments[index];

        if (nextSource !== null && nextSource !== undefined) { 
          for (var nextKey in nextSource) {
            // Avoid bugs when hasOwnProperty is shadowed
            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
              to[nextKey] = nextSource[nextKey];
            }
          }
        }
      }
      return to;
    },
    writable: true,
    configurable: true
  });
}

// Production steps of ECMA-262, Edition 6, 22.1.2.1
if (!Array.from) {
    Array.from = (function () {
        var symbolIterator;
        try {
            symbolIterator = Symbol.iterator
                ? Symbol.iterator
                : 'Symbol(Symbol.iterator)';
        } catch (e) {
            symbolIterator = 'Symbol(Symbol.iterator)';
        }

        var toStr = Object.prototype.toString;
        var isCallable = function (fn) {
            return (
                typeof fn === 'function' ||
                toStr.call(fn) === '[object Function]'
            );
        };
        var toInteger = function (value) {
            var number = Number(value);
            if (isNaN(number)) return 0;
            if (number === 0 || !isFinite(number)) return number;
            return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
        };
        var maxSafeInteger = Math.pow(2, 53) - 1;
        var toLength = function (value) {
            var len = toInteger(value);
            return Math.min(Math.max(len, 0), maxSafeInteger);
        };

        var setGetItemHandler = function setGetItemHandler(isIterator, items) {
            var iterator = isIterator && items[symbolIterator]();
            return function getItem(k) {
                return isIterator ? iterator.next() : items[k];
            };
        };

        var getArray = function getArray(
            T,
            A,
            len,
            getItem,
            isIterator,
            mapFn
        ) {
            // 16. Let k be 0.
            var k = 0;

            // 17. Repeat, while k < len� or while iterator is done (also steps a - h)
            while (k < len || isIterator) {
                var item = getItem(k);
                var kValue = isIterator ? item.value : item;

                if (isIterator && item.done) {
                    return A;
                } else {
                    if (mapFn) {
                        A[k] =
                            typeof T === 'undefined'
                                ? mapFn(kValue, k)
                                : mapFn.call(T, kValue, k);
                    } else {
                        A[k] = kValue;
                    }
                }
                k += 1;
            }

            if (isIterator) {
                throw new TypeError(
                    'Array.from: provided arrayLike or iterator has length more then 2 ** 52 - 1'
                );
            } else {
                A.length = len;
            }

            return A;
        };

        // The length property of the from method is 1.
        return function from(arrayLikeOrIterator /*, mapFn, thisArg */) {
            // 1. Let C be the this value.
            var C = this;

            // 2. Let items be ToObject(arrayLikeOrIterator).
            var items = Object(arrayLikeOrIterator);
            var isIterator = isCallable(items[symbolIterator]);

            // 3. ReturnIfAbrupt(items).
            if (arrayLikeOrIterator == null && !isIterator) {
                throw new TypeError(
                    'Array.from requires an array-like object or iterator - not null or undefined'
                );
            }

            // 4. If mapfn is undefined, then let mapping be false.
            var mapFn = arguments.length > 1 ? arguments[1] : void undefined;
            var T;
            if (typeof mapFn !== 'undefined') {
                // 5. else
                // 5. a If IsCallable(mapfn) is false, throw a TypeError exception.
                if (!isCallable(mapFn)) {
                    throw new TypeError(
                        'Array.from: when provided, the second argument must be a function'
                    );
                }

                // 5. b. If thisArg was supplied, let T be thisArg; else let T be undefined.
                if (arguments.length > 2) {
                    T = arguments[2];
                }
            }

            // 10. Let lenValue be Get(items, "length").
            // 11. Let len be ToLength(lenValue).
            var len = toLength(items.length);

            // 13. If IsConstructor(C) is true, then
            // 13. a. Let A be the result of calling the [[Construct]] internal method
            // of C with an argument list containing the single item len.
            // 14. a. Else, Let A be ArrayCreate(len).
            var A = isCallable(C) ? Object(new C(len)) : new Array(len);

            return getArray(
                T,
                A,
                len,
                setGetItemHandler(isIterator, items),
                isIterator,
                mapFn
            );
        };
    })();
}
// Production steps of ECMA-262, Edition 5, 15.4.4.18
// Reference: https://es5.github.io/#x15.4.4.18

if (!Array.prototype['forEach']) {

	Array.prototype.forEach = function(callback, thisArg) {
  
	  if (this == null) { throw new TypeError('Array.prototype.forEach called on null or undefined'); }
  
	  var T, k;
	  // 1. Let O be the result of calling toObject() passing the
	  // |this| value as the argument.
	  var O = Object(this);
  
	  // 2. Let lenValue be the result of calling the Get() internal
	  // method of O with the argument "length".
	  // 3. Let len be toUint32(lenValue).
	  var len = O.length >>> 0;
  
	  // 4. If isCallable(callback) is false, throw a TypeError exception.
	  // See: https://es5.github.com/#x9.11
	  if (typeof callback !== "function") { throw new TypeError(callback + ' is not a function'); }
  
	  // 5. If thisArg was supplied, let T be thisArg; else let
	  // T be undefined.
	  if (arguments.length > 1) { T = thisArg; }
  
	  // 6. Let k be 0
	  k = 0;
  
	  // 7. Repeat, while k < len
	  while (k < len) {
  
		var kValue;
  
		// a. Let Pk be ToString(k).
		//    This is implicit for LHS operands of the in operator
		// b. Let kPresent be the result of calling the HasProperty
		//    internal method of O with argument Pk.
		//    This step can be combined with c
		// c. If kPresent is true, then
		if (k in O) {
  
		  // i. Let kValue be the result of calling the Get internal
		  // method of O with argument Pk.
		  kValue = O[k];
  
		  // ii. Call the Call internal method of callback with T as
		  // the this value and argument list containing kValue, k, and O.
		  callback.call(T, kValue, k, O);
		}
		// d. Increase k by 1.
		k++;
	  }
	  // 8. return undefined
	};
  }