function LoadFiles() {
	var _this = this;
	_this.loadXML = function (_url, _callbackFunction, _attempt) {
		let attempt = _attempt || 0;
			
		$.ajax({
			type: "GET",
			url: _url,
			dataType: "xml",
			success: function (xml) {
				var jXml = $.xmlToJSON(xml);
				_callbackFunction(jXml);
			},
			error: function (err) {				
				attempt++;
				if(attempt <= 1){
					setTimeout(function(){
						_this.loadXML(_url, _callbackFunction, attempt);
					}, 500);					
				}else{
					console.warn("An error occured: " + err.status + " " + err.statusText +" while loading file: " +_url)
					alert("An error occured: " + err.status + " " + err.statusText +" while loading file: " +_url);
				}
			}
		});
	}
}