function SystemValidator() {
	var _this = this;
	var Selector={};
	var SystemConfigObj;
	_this.start=function(){
		SystemConfigObj=APP.configObj.system;
		init();
	
	}
	function init(){
		Selector.userBrowser=APP.systemDetectorObj.browserName;
		Selector.userBrowserVersion=APP.systemDetectorObj.browserVersion;
		Selector.userDeviceType=APP.systemDetectorObj.deviceType;
		Selector.userOS=APP.systemDetectorObj.osName;
		Selector.userOSVersion=APP.systemDetectorObj.osVersion;
		var validateOS=checkOS();
		var validateBrowser=checkBrowser();
		var validateDevice=checkDevice();
		
		if(validateOS && validateBrowser && validateDevice){
			loadFramework();
			//showFailMessage();
		}else{
			showFailMessage();
		}
		
	}
	function checkOS(){
		var osObj=SystemConfigObj.supported[0];
		var found=false;
		
		for(var i=0; i<osObj.data.length; i++){
			var curr=osObj.data[i];
			if(Selector.userOS == curr.id){
				if(parseFloat(Selector.userOSVersion) >= parseFloat(curr.min)){
					found = true;
					break;
				}
			}
		}
		return found;
	}
	function checkBrowser(){
		//--custom edit for allow all browsers on tablet
		if(Selector.userDeviceType=="tablet"){
			return true;
		}
		
		var brObj=SystemConfigObj.supported[1];
		var found=false;
		for(var i=0; i<brObj.data.length; i++){
			var curr=brObj.data[i];
			if(Selector.userBrowser == curr.id){
				if(parseFloat(Selector.userBrowserVersion) >= parseFloat(curr.min)){
					found = true;
					break;
				}
			}
		}
		return found;
	}
	function checkDevice(){
		if(Selector.userDeviceType=="mobile"){
			return false;
		}
		var devObj=SystemConfigObj.supported[2];
		var found=false;
		for(var i=0; i<devObj.data.length; i++){
			var curr=devObj.data[i];
			if(Selector.userDeviceType == curr.id){
				found = true;
				break;				
			}
		}
		return found;
	}
	function showFailMessage(){
		var str="";
		str+='<div class="system-fail-msg">';
			str+='<div class="panel display-table">';
				str+='<div class="txt-panel display-cell">';					
					str+='<p>Your system does not meet the minimum requirement to run this course. Please contact your Technical Support.</p>';
					
				str+='</div>';
			str+='</div>';
		str+='</div>';
		$('body').html(str);
		$('body').css('overflow','auto');
	}
}