function Assessment() {
	var _this = this;
	var Selector = {};
	var submitBtnObj;
	var submitWarnMessageObj;
	var prevQuestion=0;
	var failArr=[];
	var isBtnApply=false;
	var activityPanelBaseClass ='';
	_this.start = function (_obj) {
		Selector = {
			ACTIVITY_CONTAINER: '#screen-container',
			ACTIVITY_PANEL: '#activity-panel',
			FEEDBACK_CONTAINER:'#feedback-container',
			QUE_PROCESS_CONTAINER:'#que-process-container',
			VISITED_CLASS: 'visited',
			ACTIVE_ITEM_CLASS: 'active',
			ITEM: '.question-item',
			NEXT_BTN: '.question-next',
			BACK_BTN: '.question-back',
			SUBMIT_BTN: '.question-submit',			
			REVIEW_PANEL: '#review-mode-panel',
			CLOSE_REVIEW_BTN: '.btn-close-review',
			INNER_NEXT_BTN: '.question-inner-next',
			INNER_BACK_BTN: '.question-inner-back',
			QUE_IMAGES_PRE_PATH: '',
			QUE_SVG_IMG_PRE_PATH: '',
			DEFAULT_GAP: 20,
			ON_CHANGE: null,
			ON_SUBMIT: null,
			ON_COMPLETE: null,
			QUIZ_OBJ: APP.configObj.assessment[APP.globalQuizObj.currentQuizId]
		};
		Selector = $.extend(true, Selector, _obj);
		preLoadQueImages();
	}
	function preLoadQueImages(){
		if(!Selector.QUIZ_OBJ.isAvailable){console.error('Assessement is not available'); return false;}
		Selector.QUE_IMAGES_PRE_PATH = 'content/images/'+APP.configObj.language.dir + Selector.QUIZ_OBJ.dataImagesPath;
		Selector.QUE_SVG_IMG_PRE_PATH = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang;

		APP.preloaderObj.show();
		var imgArr = [];
		for(var i=0; i<Selector.QUIZ_OBJ.dataFinalAssessmentObj.length; i++){
			var curr = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
			var bgImgPath = curr.bgImgPath;
			if(bgImgPath != null && bgImgPath != ''){
				imgArr.push(Selector.QUE_IMAGES_PRE_PATH + bgImgPath);
				//curr.dataBgImgPath = Selector.QUE_IMAGES_PRE_PATH+bgImgPath;
			}			
		}
		if(imgArr.length){			
			APP.commonFunObj.preloadImages(imgArr, 
			function(){
				APP.preloaderObj.hide();
				initTemplate();
			});	
		}else{
			APP.preloaderObj.hide();
			initTemplate();
		}
	}
	function initTemplate() {		
		activityPanelBaseClass = $(Selector.ACTIVITY_CONTAINER).find(Selector.ACTIVITY_PANEL).attr('class'); 
		if(Selector.QUIZ_OBJ.noOfAttempts != 0){
			if (!Selector.QUIZ_OBJ.dataReviewMode && Selector.QUIZ_OBJ.dataCurrentAttempt >= Selector.QUIZ_OBJ.noOfAttempts) {
				$(Selector.ACTIVITY_CONTAINER).hide(); 
				APP.commonFunObj.showAttemptEndPop();
				return false;
			}
		}
		//Selector.currentQuestion = 0;
		Selector.currentQuestion = Selector.QUIZ_OBJ.dataCurrentQue;
		if(Selector.QUIZ_OBJ.dataReviewMode){
			$(Selector.ACTIVITY_CONTAINER).addClass('review-mode');
			failArr = getFailQueNavigationArr();
			if(failArr.length){
				Selector.currentQuestion = failArr[0];
			}
		}else{
			
		}
		Selector.totalQuestions = Selector.QUIZ_OBJ.dataFinalAssessmentObj.length;
		Selector.QUIZ_OBJ.dataTotalQue = Selector.totalQuestions;
		prevQuestion = Selector.currentQuestion;
		Selector.isCompleted = false;

		createQuestionsNav();
		addTemplateEvent();		
		//showQuestion();
		updateTemplateLayout();

		if(Selector.QUIZ_OBJ.dataReviewMode){			
			updateTimerText(Selector.QUIZ_OBJ.dataDisplayTime);
			$(Selector.ACTIVITY_CONTAINER).find(Selector.REVIEW_PANEL).show();
			$(Selector.ACTIVITY_CONTAINER).find('.timer').hide();
			$(Selector.ACTIVITY_CONTAINER).find('.points').hide();
		}else{
			startAssessmentTimer();
			//$(Selector.ACTIVITY_CONTAINER).find(Selector.REVIEW_PANEL).remove();
		}
	}
	$(document).one(APP.eventObj.ON_TIME_UPDATE, function (event, obj) {
		
		var num=(obj.remainingTime  / 60);
		var n = num.toFixed(2);
		Selector.QUIZ_OBJ.dataRemainingTime = parseFloat(n);
		Selector.QUIZ_OBJ.dataDisplayTime = obj.displayTime;
		updateTimerText(Selector.QUIZ_OBJ.dataDisplayTime);
		
	});
	$(document).one(APP.eventObj.ON_TIME_COMPLETE, function (event) {
		Selector.QUIZ_OBJ.dataTimeOut=true;
		screenCompleted();
		APP.commonFunObj.showTimeoutPop();
		$(this).unbind(event);
	});
	$(document).one(APP.eventObj.ON_TIMEOUT_CONTINUE_CLICKED, function (event) {		
		APP.dataComObj.sendInteractionData(prevQuestion);
		showResult();
		$(this).unbind(event);
	});
	$(document).off(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);	
	$(document).on(APP.eventObj.ON_ASSESSMENT_NEXT_QUE, function (e) {		
		if(isLastQuestion()){
			screenCompleted();			
			showResult();				
		}else{
			loadNextQuestion();
		}
	});
	$(document).off(APP.eventObj.ON_ASSESSMENT_BACK_QUE);
	$(document).on(APP.eventObj.ON_ASSESSMENT_BACK_QUE, function (e) {		
		if(isFirstQuestion()){
			APP.navigationObj.loadBackScreen();			
		}else{
			loadPrevQuestion();
		}
	});
	function updateTimerText(time) {
		var _tm=time;
		if(Selector.QUIZ_OBJ.dataReviewMode){			
			_tm=Selector.QUIZ_OBJ.dataDisplayTime;
		}
		$(Selector.ACTIVITY_CONTAINER).find('.time-text').html(_tm);
	}

	function updateQuesCount() {
		var c = (Selector.currentQuestion + 1);
		var curr = c < 10 ? "" + c : c;
		var t = Selector.totalQuestions;
		var tot = t < 10 ? "" + t : t;
		var queNo = curr + "/" + tot;
		var _str = APP.globalXmlsObj.globalXML.commonText[0].queCounter[0].Text;
		var newStr = _str.replace('~##~', curr).replace('-##-', tot);
		$(Selector.ACTIVITY_CONTAINER).find('.screen-title-div').find('.title').html(newStr);
		
		//-- for testing
		if(APP.configObj.cheatMode){
			if(Selector.QUIZ_OBJ.dataFinalAssessmentObj[Selector.currentQuestion].sbRef !=null && ($(Selector.ACTIVITY_CONTAINER).find('.sb-que-ref').length)){
				$(Selector.ACTIVITY_CONTAINER).find('.sb-que-ref').html(Selector.QUIZ_OBJ.dataFinalAssessmentObj[Selector.currentQuestion].sbRef);
			}
		}
		//--
	}

	function updatePoint(_str) {
		//var point = Selector.QUIZ_OBJ.dataCurrentPoint;
		$(Selector.ACTIVITY_CONTAINER).find('.point-text').html(_str);
	}

	function startAssessmentTimer() {
		if(Selector.QUIZ_OBJ.timer != null){
			Selector.QUIZ_OBJ.dataTimeOut=false;
			var _timer = parseFloat(Selector.QUIZ_OBJ.timer);
			APP.commonFunObj.startTimer(_timer);
		}
	}

	function stopAssessmentTimer() {
		if(Selector.QUIZ_OBJ.timer != null){
			APP.commonFunObj.stopTimer();
		}
	}

	function createQuestionsNav() {		
		showQuestion();
	}

	function addTemplateEvent() {
		$(Selector.ACTIVITY_CONTAINER).find(Selector.ITEM).on('click', function () {
			if ($(this).hasClass('disabled') || $(this).hasClass(Selector.VISITED_CLASS) || $(this).hasClass(Selector.ACTIVE_ITEM_CLASS)) {
				return false;
			}
			var id = parseInt($(this).attr('id'));
			prevQuestion = Selector.currentQuestion;
			Selector.currentQuestion = id;			
			showQuestion();
		});
		$(Selector.ACTIVITY_CONTAINER).find(Selector.NEXT_BTN).on('click', function () {
			if ($(this).hasClass('disabled')) {
				return false;
			}			
			if(isLastQuestion()){
				screenCompleted();
				showResult();				
			}else{
				loadNextQuestion();
			}
		});
		$(Selector.ACTIVITY_CONTAINER).find(Selector.BACK_BTN).on('click', function () {
			if ($(this).hasClass('disabled')) {
				return false;
			}
			loadPrevQuestion();
		});
		
		$(Selector.ACTIVITY_CONTAINER).find(Selector.SUBMIT_BTN).on('click', function (event) {
			if ($(this).hasClass('disabled')) {
				return false;
			}
			$(this).unbind(event);
			$(this).addClass('disabled');
			//for last question data 
			//APP.dataComObj.sendInteractionData(Selector.currentQuestion);
			screenCompleted();
			showResult();
			
		});
		
		$(Selector.ACTIVITY_CONTAINER).find(Selector.CLOSE_REVIEW_BTN).on('click', function () {
			if ($(this).hasClass('disabled')) {
				return false;
			}
			closeReviewMode();
		});
	}
	function viewResultEvent(){
		$(Selector.ACTIVITY_CONTAINER).find('.view-result-btn').on('click', function (event) {
			if ($(this).hasClass('disabled')) {
				return false;
			}
			$(this).unbind(event);
			$(this).addClass('disabled');
			//for last question data 
			//APP.dataComObj.sendInteractionData(Selector.currentQuestion);			
			showResult();	
			screenCompleted();		
		});
	}
	function updateTemplateLayout() {}
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});

	function isFirstQuestion() {
		if(Selector.QUIZ_OBJ.dataReviewMode){
			if (Selector.currentQuestion == failArr[0]) {
				return true
			}
		}else{
			if (Selector.currentQuestion == 0) {
				return true
			}
		}
		return false
	}

	function isLastQuestion() {
		if(Selector.QUIZ_OBJ.dataReviewMode){
			var lastElement=failArr.length - 1;
			if (failArr.length > 1 && Selector.currentQuestion == failArr[lastElement]) {
				return true
			}
		}else{
			if (Selector.currentQuestion == Selector.totalQuestions - 1) {
				return true
			}
		}
		return false
	}

	function loadNextQuestion() {		
		prevQuestion=Selector.currentQuestion;
		if(Selector.QUIZ_OBJ.dataReviewMode){		
			Selector.currentQuestion = getQuestionForReview("next");
		}else{
			Selector.currentQuestion++;
		}
		showQuestion();
	}

	function loadPrevQuestion() {
		prevQuestion=Selector.currentQuestion;
		if(Selector.QUIZ_OBJ.dataReviewMode){		
			Selector.currentQuestion = getQuestionForReview("back");
		}else{
			Selector.currentQuestion--;
		}
		showQuestion();
	}

	function showQuestion() {
		/* if($('#correct-ans-sound').length){
			try {
				$('#correct-ans-sound').get(0).pause();
			} catch (error) {
				
			}
		}	 */	
		$("html, body").scrollTop(0);
		
		Selector.QUIZ_OBJ.dataCurrentQue = Selector.currentQuestion;
		Selector.QUIZ_OBJ.dataCurrentPoint = getCurrentPoints();
		updateBtns();				
		initQuestion();
		updateQuesCount();
		
	}

	function initQuestion() {
		//remove other class
		$(Selector.ACTIVITY_CONTAINER).find(Selector.ACTIVITY_PANEL).attr('class', activityPanelBaseClass).html('');
		//--
		var currQueObj = Selector.QUIZ_OBJ.dataFinalAssessmentObj[Selector.currentQuestion];
		var type = currQueObj.type.toLowerCase();
		var point = currQueObj.dataQuePoint;
		
		updatePoint(point);
		switch (type) {
		case 'mcq':
		case 'mrq':
			showMcqMrqQuestion();
			break;
		case 'multicoloption':
			showMultiColOptionQuestion();
			break;
		case 'dragndrop':
			showDragNDropQuestion();
			break;
		case 'categorydragndrop':
			showCategoryDragNDropQuestion();
			break;
		case 'dropdown':
			showDropDownQuestion();
			break;
		case 'slidingscale':
			showSlidingScaleQuestion();
			break;
		case 'matchinglines':
			showMatchingLinesQuestion();
			break;
		default:
			console.error(type + " Template work in progress...")
			$(Selector.ACTIVITY_CONTAINER).find(Selector.ACTIVITY_PANEL).html(type + "  Template work in progress...");
			//--for demo
			currQueObj.dataEarnPoint = currQueObj.dataQuePoint;
			currQueObj.dataIsUserOptionSelected = true;
		}
		//applySubmitBtn();
		
	}

	function showMcqMrqQuestion() {
		
		var quiz = new McqMrqQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			SHOW_PREVIOUS_SELECTION: true,
			SHOW_CORR_ANS_ON_SUBMIT: false,
			CURRENT_QUESTION: Selector.currentQuestion,	
			QUE_IMAGES_PRE_PATH: Selector.QUE_IMAGES_PRE_PATH,
			QUE_SVG_IMG_PRE_PATH: Selector.QUE_SVG_IMG_PRE_PATH,	
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_SUBMIT: function(){
				APP.eventObj.blinkNextButton();
				$('#app-body').find('.btn-next').removeClass('disabled');
				//to go direct next ques
				//$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
				//showNextInstr();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});
		
	}
	function showMultiColOptionQuestion() {
		
		var quiz = new MultiColOptQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			CURRENT_QUESTION: Selector.currentQuestion,	
			SHOW_CORR_ANS_ON_SUBMIT: false,
			ANIMATE_INCORR_OPTION: false,		
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_SUBMIT: function(){
				//APP.eventObj.blinkNextButton();
				//$('#app-body').find('.btn-next').removeClass('disabled');
				//to go direct next ques
				//$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
				animateEndAniQuestion();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function showDragNDropQuestion() {
		
		var quiz = new DragNDropQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			SHOW_CORR_ANS_ON_SUBMIT: true,
			CURRENT_QUESTION: Selector.currentQuestion,			
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function showCategoryDragNDropQuestion() {
		
		var quiz = new DragNDropCategoryQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			SHOW_CORR_ANS_ON_SUBMIT: true,
			CURRENT_QUESTION: Selector.currentQuestion,			
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function showDropDownQuestion() {		
		var quiz = new MultiDropDownQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			CURRENT_QUESTION: Selector.currentQuestion,	
			SHOW_PREVIOUS_SELECTION: true,		
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_SUBMIT: function(){
				APP.eventObj.blinkNextButton();
				$('#app-body').find('.btn-next').removeClass('disabled');
				//to go direct next ques
				//$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
				//showNextInstr();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function showSlidingScaleQuestion() {
		
		var quiz = new SlidingScaleQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			CURRENT_QUESTION: Selector.currentQuestion,			
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function showMatchingLinesQuestion() {		
		var quiz = new MatchingLineQuestion();
		quiz.start({
			ACTIVITY_CONTAINER: Selector.ACTIVITY_PANEL,
			IS_ASSESSMENT: true,
			SHOW_PREVIOUS_SELECTION: true,
			CURRENT_QUESTION: Selector.currentQuestion,			
			ON_SHOW: function(){
				animateShowQuestion();
			},
			ON_SUBMIT: function(){
				APP.eventObj.blinkNextButton();
				$('#app-body').find('.btn-next').removeClass('disabled');
				//to go direct next ques
				$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
				//showNextInstr();
			},
			ON_FEEDBACK_CONTINUE: function(_state){
								
				//animateHideQuestion(_state);
			}
		});		
	}
	function animateEndAniQuestion (){		
		var queActivity = $(Selector.ACTIVITY_CONTAINER).find('.question-activity');		
		APP.animationObj.animate({
			EL: $(queActivity).find('.ani-box-left'),
			TYPE: 'fade-out',
			DURATION: 0.5,			
			ON_COMPLETE: function(){							
				$(document).trigger(APP.eventObj.ON_ASSESSMENT_NEXT_QUE);
			}
		}); 
		
		APP.animationObj.animate({
			EL: $(queActivity).find('.ani-box-right'),
			TYPE: 'fade-out',
			DURATION: 0.5,
			ON_COMPLETE: function(){							
					
			}
		});
		
	}
	function animateShowQuestion (){		
		var queActivity = $(Selector.ACTIVITY_CONTAINER).find('.question-activity');
		queActivity.show();
		$(Selector.ACTIVITY_CONTAINER).find('.scroll-parent').scrollTop(0);
		APP.animationObj.animate({
			EL: $(queActivity).find('.ani-box-left'),
			TYPE: 'fade-in-left',
			START_VAL: '20px',
			DURATION: 0.5,
			DELAY: 0.5,
			ON_COMPLETE: function(){							
				$(document).trigger(APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE);
			}
		}); 
		
		APP.animationObj.animate({
			EL: $(queActivity).find('.ani-box-right'),
			TYPE: 'fade-in-right',
			START_VAL: '20px',
			DURATION: 0.5,
			ON_COMPLETE: function(){							
					
			}
		});
		
	}
	function showNextInstr(){
		$(Selector.ACTIVITY_CONTAINER).find('.screen-comp-instr-txt').removeClass('hide').fadeIn();
	}
	function applySubmitBtn() {
		if(Selector.QUIZ_OBJ.dataReviewMode){return false;}
		
		if (isLastQuestion()) {
			$(Selector.ACTIVITY_CONTAINER).find('#last-questions').removeClass('hide');
			var $submitWarnMsg = $(Selector.ACTIVITY_CONTAINER).find('#warn-submit-msg');
			var $submitBtn = $(Selector.ACTIVITY_CONTAINER).find(Selector.SUBMIT_BTN);
			$(Selector.ACTIVITY_CONTAINER).find(Selector.ACTIVITY_PANEL).css('min-height', 'auto');
			if (checkAllQuesOptionSelected()) {
				$submitWarnMsg.hide();
				$submitBtn.removeClass('disabled');
			} else {
				$submitWarnMsg.show();
				$submitBtn.addClass('disabled');
			}			
		} else {	
			$(Selector.ACTIVITY_CONTAINER).find(Selector.ACTIVITY_PANEL).css('min-height', '350px');
			$(Selector.ACTIVITY_CONTAINER).find('#last-questions').addClass('hide');
		}
	}
	function showHideDisablePatch(_str){
		if(_str){
			$(Selector.ACTIVITY_CONTAINER).find('.disable-patch').show();
		}else{
			$(Selector.ACTIVITY_CONTAINER).find('.disable-patch').hide();
		}
	}
	function updateBtns() {
		if (isFirstQuestion()) {
			$(Selector.ACTIVITY_CONTAINER).find(Selector.BACK_BTN).addClass('disabled');
		} else {
			$(Selector.ACTIVITY_CONTAINER).find(Selector.BACK_BTN).removeClass('disabled');
		}
		if (isLastQuestion()) {
			$(Selector.ACTIVITY_CONTAINER).find(Selector.NEXT_BTN).addClass('disabled');
		} else {
			$(Selector.ACTIVITY_CONTAINER).find(Selector.NEXT_BTN).removeClass('disabled');
		}
		//--for global btn
		APP.eventObj.removeBlinkNextButton();
		$('#app-body').find('.btn-next').addClass('disabled assessment-next-que');
		
		if (isFirstQuestion()) {
			$('#app-body').find('.btn-back').removeClass('assessment-back-que').addClass('disabled');
		} else {
			$('#app-body').find('.btn-back').removeClass('disabled').addClass('assessment-back-que');
		}
		$('#app-body').find('.btn-back').removeClass('assessment-back-que').addClass('disabled');
		//--
		var $item = $(Selector.ACTIVITY_CONTAINER).find(Selector.ITEM);
		$item.each(function (id) {
			$(this).removeClass(Selector.ACTIVE_ITEM_CLASS).removeClass(Selector.VISITED_CLASS).removeClass('disabled');
			//--for visited status
			var isVisited = Selector.QUIZ_OBJ.dataFinalAssessmentObj[id].dataIsUserOptionSelected;
			if (isVisited) {
				$(this).addClass(Selector.VISITED_CLASS).addClass('disabled');
			}
			//--
		});
		$item.eq(Selector.currentQuestion).addClass(Selector.ACTIVE_ITEM_CLASS).addClass('disabled');
		showHideDisablePatch(true);
	}
	
	function getCurrentPoints() {
		var point = 0;
		for (var i = 0; i < Selector.totalQuestions; i++) {
			var current = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
			if (current.dataIsUserOptionSelected) {
				point += parseFloat(current.dataEarnPoint);
			}
		}
		//for 2 decimal
		var num = point;
		var n = num.toFixed(2);
		point = parseFloat(n);
		return point;
	}
	function getCorrectQueCount() {
		var count = 0;
		for (var i = 0; i < Selector.totalQuestions; i++) {
			var current = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
			if (current.dataStatus == 'correct') {
				count += 1;
			}
		}
		return count;
	}
	function checkAllQuesOptionSelected() {
		var isCompleted = true;
		for (var i = 0; i < Selector.totalQuestions; i++) {
			var current = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
			if (!current.dataIsUserOptionSelected) {
				isCompleted = false;
				break;
			}
		}
		return isCompleted;
	}

	function getTotalPoints() {
		var point = 0;
		for (var i = 0; i < Selector.totalQuestions; i++) {
			var current = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
			point += parseFloat(current.dataQuePoint);
		}
		//for 2 decimal
		var num = point;
		var n = num.toFixed(2);
		point = parseFloat(n);
		return point;
	}
	function closeReviewMode(){
		Selector.QUIZ_OBJ.dataReviewMode=false;
		APP.navigationObj.loadNextScreen();
	}
	function showResult() {
		//stopAssessmentTimer();
		//console.log('Selector.QUIZ_OBJ: ', Selector.QUIZ_OBJ);			
		var currPoint = getCurrentPoints();
		var totalPoint = getTotalPoints();
		//console.log('currPoint: ', currPoint);
		//console.log('totalPoint: ', totalPoint);
		//var correctQues = getCorrectQueCount();
		//var totalQues = Selector.QUIZ_OBJ.dataTotalQue;
		Selector.QUIZ_OBJ.dataCorrQueCount = getCorrectQueCount();
		Selector.QUIZ_OBJ.dataCurrentPoint = getCurrentPoints();
		var percentage = Math.round((currPoint / totalPoint) * 100);
		//var percentage = Math.round((correctQues / totalQues) * 100);
		Selector.QUIZ_OBJ.dataPercentage = percentage;
		if(Selector.QUIZ_OBJ.noOfAttempts != 0){			
			Selector.QUIZ_OBJ.dataCurrentAttempt++;
			//APP.globalQuizObj.globalAttempt++;
		}
   		APP.globalQuizObj.globalAttempt++;
		//assessment-result		
		if(Selector.QUIZ_OBJ.dataPercentage >= Selector.QUIZ_OBJ.passingScore){
			Selector.QUIZ_OBJ.dataStatus = "passed";
			//set in certificate screen
			APP.commonFunObj.setPassDate();	
		}else{		
			Selector.QUIZ_OBJ.dataStatus = "failed";
		}		
		APP.dataComObj.updateUserData();
		APP.navigationObj.loadNextScreen();	
	}
	function getFailQueNavigationArr(){
		var obj=Selector.QUIZ_OBJ.dataFinalAssessmentObj;
		var arr=[];
		for(var i=0; i<obj.length; i++){
			var qStatus=obj[i].dataStatus;
			//include not attempted questions too			
			if(qStatus != "correct"){
				arr.push(i);
			}
		}
		return arr;
	}
	function getQuestionForReview(_str){
		var num=0;
		if(failArr.length){				
			if(_str=="next"){
				for(var i=0; i<failArr.length; i++){
					if(Selector.currentQuestion < failArr[i] && Selector.currentQuestion != failArr[i]){
						num = failArr[i];
						break;
					}
				}
			}else if(_str=="back"){
			var tempArr=failArr.slice().reverse();
				for(var i=0; i<tempArr.length; i++){
					if(Selector.currentQuestion > tempArr[i] && Selector.currentQuestion != tempArr[i]){
						num = tempArr[i];
						break;
					}
				}
			}			
		}
		return num;
	}
	function screenCompleted() {
		if(Selector.ON_COMPLETE){
			Selector.ON_COMPLETE();
		}
	}
}