function AssessmentResult() {
	var _this = this;
	var Selector = {};
	
	_this.start = function (_obj) {
		Selector = {			
			QUIZ_OBJ: null,
			CLASS_NAME: 'assessment-result-box',
			ACTIVITY_CONTAINER: '#screen-container'
			
		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
	_this.getClassName = function(){
		return Selector.CLASS_NAME;
	}
	_this.closeModal = function(){
		processModal(true);
	}
	function initTemplate() {
		
		if(Selector.QUIZ_OBJ.dataFinalAssessmentObj == null){
			console.warn('ASSESSMENT QUIZ OBJECT NOT FOUND...')
			return;
		}
		//--double check if all question is attempted
		if(Selector.QUIZ_OBJ.dataStatus == null || Selector.QUIZ_OBJ.dataStatus === ''){
			console.warn('ASSESSMENT QUIZ NOT COMPLETED...')
			return;
		}
		//--
		APP.preloaderObj.show();
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).html(getHtml());		
		applyData();
	}
	function getHtml(){
		var str="";
		if(Selector.QUIZ_OBJ.dataFinalAssessmentObj.length){
			/* 1 */str += '<div class="result-data">';
				for(var i=0; i<Selector.QUIZ_OBJ.dataFinalAssessmentObj.length; i++){
					var _currQue = Selector.QUIZ_OBJ.dataFinalAssessmentObj[i];
					var _type = _currQue.type.toLowerCase();					
					//--create question
					switch (_type) {
						case 'mcq':
						case 'mrq':
							str += getMcqMrqQuestion(_currQue, i);
							break;
						case 'multicoloption':
							str += getMultiColOptQuestion(_currQue, i);
							break;
						case 'dragndrop':
							console.error(_type + " result work in progress...")
							break;
						case 'categorydragndrop':
							console.error(_type + " result work in progress...")
							break;
						case 'dropdown':
							console.error(_type + " result work in progress...")
							break;
						case 'slidingscale':
							console.error(_type + " result work in progress...")
							break;
						default:
							console.error(_type + " result work in progress...")							
					}					
				}
			/* 1 */str += '</div>';
		}
		return str;
	}
	function getMcqMrqQuestion(qObj, qIndex){
		
		var _currQue = qObj;
		var _sbRef =_currQue.sbRef || '';
		var _type = _currQue.type.toLowerCase();
		var _dataId = _currQue.dataId;		
		var _className = _currQue.className || '';
		var str='';
		var mcqIconObj = {
			optNormal: "icon-radio-unchecked",
			optSelected: "icon-radio-checked"
		}
		var mrqIconObj = {
			optNormal: "icon-checkbox-unchecked",
			optSelected: "icon-checkbox-checked"
		}
		var iconObj = {
			optNormal: '',
			optSelected: '',
			tick: 'icon-checkmark-1',
			cross: 'icon-cross-1'
		}
		//check type
		var corrCount = 0;
		for(var i=0; i<_currQue.dataAnswerArray.length; i++){
			var curr = _currQue.dataAnswerArray[i];
			if(curr == 1){
				corrCount++;
			}
		}
		if(corrCount > 1){	
			_type = 'mrq';		
			iconObj.optNormal = mrqIconObj.optNormal;
			iconObj.optSelected = mrqIconObj.optSelected;
		}else{	
			_type = 'mcq';		
			iconObj.optNormal = mcqIconObj.optNormal;
			iconObj.optSelected = mcqIconObj.optSelected;	
		}
		/* 1 */str += '<div class="question-div mcq-mrq-question '+_sbRef+'">';
			/* 2 */str += '<div id="'+_dataId+'" class="question '+_type+' '+_className+' '+_dataId+'">';
				var c = (qIndex + 1);
				var curr = c < 10 ? "" + c : c;
				var t = Selector.QUIZ_OBJ.dataFinalAssessmentObj.length;
				var tot = t < 10 ? "" + t : t;
				var tTxt = APP.globalXmlsObj.globalXML.commonText[0].resultQueCounter[0].Text;
				var newtTxt=tTxt.replace('~##~', curr).replace('-##-', tot);
				str += '<div class="screen-title-div">';
					str += '<span class="title">'+newtTxt+'</span>';
				str += '</div>';
				str += '<div class="que-txt-panel">';		
					str += APP.getHtmlStructObj.textPanelStruct(_currQue.questionText[0]);
				str += '</div>';
				/* 3 */str += '<div class="que-options">';		
						var optObj = _currQue.options[0].option;
						var optLen = optObj.length;
						for (var i = 0; i < optLen; i++) {	
							var curr = optObj[i]		
							var _className = curr.className || "";
							var _style = curr.style || "";
							var _txt = curr.Text;
							//check if img option
							//--for normal image
							var _optImgPath = curr.optImgPath;
							//--for text svg
							var _optImgPath_Svg = curr.optImgPath_Svg;
							var _optImg = '';
							var _classObj = {
								firstClass: "",
								secondClass: "",
								magnifyClass: "",
							}
							if(_optImgPath != null && _optImgPath != ''){
								_optImg = 'content/images/'+APP.configObj.language.dir + Selector.QUIZ_OBJ.dataImagesPath + _optImgPath;
								_classObj.firstClass = 'img-box';						
								_classObj.secondClass = 'normal-img';						
							}
							if(_optImgPath_Svg != null && _optImgPath_Svg != ''){
								_optImg = APP.configObj.filePath.langFolderPath + APP.configObj.language.lang + _optImgPath_Svg;
								_classObj.firstClass = 'svg-img-box';
								_classObj.secondClass = 'svg-img';
							}
							var _showMagnify = curr.showMagnify;
							if(_showMagnify === 'true'){
								_classObj.magnifyClass = 'magnify';
							}
							var _classObj1 = {
								optClass: '',
								icoClass: iconObj.optNormal,
								statusIcoClass: '',
							}
							var currUserOptVal = _currQue.dataUserArray[i];
							var currAnsOptVal = _currQue.dataAnswerArray[i];

							if(currAnsOptVal == 1){
								_classObj1.optClass += ' corr-ans';
								_classObj1.statusIcoClass = ' tick '+iconObj.tick;					
							}
							if(currUserOptVal == 1){
								_classObj1.optClass += ' selected';
								_classObj1.icoClass = iconObj.optSelected;						
							}

							if (currUserOptVal == 1 && currAnsOptVal == 0) {
								_classObj1.statusIcoClass = ' cross '+iconObj.cross;
							}
											
							if(_optImg != null && _optImg != ''){
								str += '<div class="btn disabled option-item opt-with-img ' + _className + ' ' + _classObj.firstClass + ' ' + _classObj.magnifyClass + ' '+_classObj1.optClass+'" style="' + _style + '" >';
								//--difficult to show 2 modal pop so hide magnify button in result pop
									/* if(_showMagnify === 'true'){
										str += '<div class="top-div">';
											str += '<div class="magnify-box" data-id="mgp_'+i+'">';
												str += '<span class="magnify-icon font-icon icon-magnify "></span>';
											str += '</div>';	
										str += '</div>';
									} */
									str += '<img class="img-tag '+ _classObj.secondClass +'" src="'+_optImg+'" alt="">';
									str += '<div class="bottom-div">';
										str += '<div class="status-cell ">';
											str += '<span class="btn-icon font-icon status '+_classObj1.statusIcoClass+'"></span>';
										str += '</div>'; 
										str += '<div class="opt-cell">';
											str += '<div class="btn-icon font-icon icon '+_classObj1.icoClass+'"></div>';
										str += '</div>';	
									str += '</div>';
									if(_txt != null && _txt != ''){
										str += '<div class="btn-text" >' + _txt + '</div>';
									}							
								str += '</div>';
							}else{
								str += '<div class="btn disabled option-item display-table ' + _className + ' '+_classObj1.optClass+'" style="' + _style + '"  >';
								str += '<div class="display-cell status-cell v-center">';
									str += '<span class="btn-icon font-icon status '+_classObj1.statusIcoClass+'"></span>';
								str += '</div>'; 
									str += '<div class="display-cell opt-cell v-center">';
										str += '<div class="btn-icon font-icon icon '+_classObj1.icoClass+'"></div>';
									str += '</div>';
									str += '<div class="display-cell btn-text v-center left" >' + _txt + '</div>';
								str += '</div>';
							}
						}
				/* 3 */str += '</div>';
				if(_currQue.summaryFeedbacks[0]){
					str += '<div class="feedback-panel">';	
						str += APP.getHtmlStructObj.textPanelStruct(_currQue.summaryFeedbacks[0].commonFeedback[0]);
					str += '</div>';
				}
				
			/* 2 */str += '</div>';
		/* 1 */str += '</div>';
		return str;
	}

	function getMultiColOptQuestion(qObj, qIndex){
		
		var _currQue = qObj;
		var _sbRef =_currQue.sbRef || '';
		var _type = _currQue.type.toLowerCase();
		var _dataId = _currQue.dataId;		
		var _className = _currQue.className || '';
		var str='';
		//console.log('_currQue', _currQue);
		
		var iconObj = {
			optNormal: "icon-radio-unchecked",
			optSelected: "icon-radio-checked",
			tick: 'icon-checkmark-1',
			cross: 'icon-cross-1'
		}
				
		/* 1 */str += '<div class="question-activity multi-col-opt-question '+_sbRef+'">';
			/* 2 */str += '<div id="'+_dataId+'" class="question '+_type+' '+_className+' '+_dataId+'">';
				var c = (qIndex + 1);
				var curr = c < 10 ? "" + c : c;
				var t = Selector.QUIZ_OBJ.dataFinalAssessmentObj.length;
				var tot = t < 10 ? "" + t : t;
				var tTxt = APP.globalXmlsObj.globalXML.commonText[0].resultQueCounter[0].Text;
				var newtTxt=tTxt.replace('~##~', curr).replace('-##-', tot);
				var _tTitle = '';
				if(_currQue.titleText){
					_tTitle = _currQue.titleText[0].Text || "";
				}
				var _queImg = '';
				if(_currQue.questionText[0].imgPath){
					_queImg = _currQue.questionText[0].imgPath || "";
				}
				var _quePanelClass = _currQue.questionText[0].className || "";
				
				str += '<div class="screen-title-div">';
					/* str += '<span class="title">'+newtTxt+'</span>'; */
					str += '<span class="sub-title xuppercase">'+_tTitle+'</span>';
				str += '</div>';

				
				str += '<div class="review-panel">';
					str += '<div class="btn-panel">';
						str += '<a class="btn font-3 review-case-btn " href="javascript:void(0);">';	
							str += '<span class="btn-txt uppercase">'+APP.globalXmlsObj.globalXML.commonText[0].reviewCaseText[0].Text+'</span>';
							str += '<span class="font-icon btn-icon icon1 icon-next"></span>';
						str += '</a>';
					str += '</div>';
					str += '<div class="review-popup ">';	
						str += '<div class="que-txt-panel '+_quePanelClass+'">';	
							str += '<div class="que-cell">';		
							str += APP.getHtmlStructObj.textPanelStruct(_currQue.questionText[0]);
						str += '</div>';
						if(_queImg !=''){
							str += '<div class="img-cell"><img src="'+_queImg+'"></div>';		
						}	
						str += '</div>';
					str += '</div>';
				str += '</div>';
				
				/* 3 */str += '<div class="que-options">';		
						var optObj = _currQue.options[0].option;
						var optLen = optObj.length;
						for (var i = 0; i < optLen; i++) {	
							var curr = optObj[i]		
							var _className = curr.className || "";
							var _style = curr.style || "";
							var _txt = curr.Text;
							var _correctId = curr.correctId;

							var _classObj1 = {
								optClass: '',
								icoClass: iconObj.optNormal,
								statusIcoClass: '',
							}
							var currUserOptVal = _currQue.dataUserArray[i];
							var currAnsOptVal = _currQue.dataAnswerArray[i];

							if(currAnsOptVal == 1){
								_classObj1.optClass += ' corr-ans';
								_classObj1.statusIcoClass = ' tick '+iconObj.tick;					
							}
							if(currUserOptVal == 1){
								_classObj1.optClass += ' selected';
								_classObj1.icoClass = iconObj.optSelected;						
							}

							if (currUserOptVal == 1 && currAnsOptVal == 0) {
								_classObj1.statusIcoClass = ' cross '+iconObj.cross;
							}
							if(currUserOptVal == 0){
								var t0Color = 'green';
							}else{
								var t0Color = 'red';
							}
							if(currAnsOptVal == 0){
								var t1Color = 'green';
							}else{
								var t1Color = 'red';
							}

							str += '<div class="option-row ">';
								str += '<div class="option-text ">'+curr.Text+'</div>';
								
								str += '<div class="user-ans "><span class="pre-text">'+APP.globalXmlsObj.globalXML.commonText[0].youAnsPreText[0].Text+'</span><span class="ans-txt strong '+t0Color+'">'+_currQue.header[0].headerText[currUserOptVal].Text+'</span></div>';
								
								str += '<div class="corr-ans"><span class="pre-text">'+APP.globalXmlsObj.globalXML.commonText[0].corrAnsPreText[0].Text+'</span><span class="ans-txt strong '+t1Color+'">'+_currQue.header[0].headerText[currAnsOptVal].Text+'</span></div>';
								
								let summFeedObj = _currQue.summaryFeedbacks[0]; 
								if(summFeedObj){
									if(summFeedObj.optionwiseFeedback){
										str += '<div class="feedback-panel">';	
											str += APP.getHtmlStructObj.textPanelStruct(summFeedObj.optionwiseFeedback[0].option[i]);
										str += '</div>';
									}else{
										str += '<div class="feedback-panel">';	
											str += APP.getHtmlStructObj.textPanelStruct(_currQue.summaryFeedbacks[0].commonFeedback[0]);
										str += '</div>';
									}									
								}
							str += '</div>';
							
						}
				/* 3 */str += '</div>';
								
			/* 2 */str += '</div>';
		/* 1 */str += '</div>';
		return str;
	}

	function applyData(){		
		loadComplete();	
		$(Selector.ACTIVITY_CONTAINER).find('.hide-on-result').remove();
			
		$(Selector.ACTIVITY_CONTAINER).find('.review-case-btn').on('click', function(){
			if($(this).hasClass('disabled') || $(this).hasClass('animate') ){return false;};
			var currBtn = $(this);
			var parentBlock = currBtn.parents('.review-panel');
			currBtn.addClass('animate');
			if(currBtn.hasClass('selected')){
				parentBlock.find('.review-popup').slideUp("slow", function(){
					currBtn.removeClass('selected');
					currBtn.removeClass('animate');
				});
				
			}else{
				parentBlock.find('.review-popup').slideDown("slow", function(){
					currBtn.addClass(' visited selected');
					currBtn.removeClass('animate');
				});
				
			}
		});
	}
	
	function loadComplete(){
		APP.preloaderObj.hide();
		$(Selector.ACTIVITY_CONTAINER).find('.scroll-parent').scrollTop(0);
	}
	function addTemplateEvent() {
		
	}
	
}