function Glossary() {
	var _this = this;
	var Selector = {};
	var searchWordDataArr = [];
   	var letterDataArr = [];
  	var isVidPlaying = false;
	var isVidEnded = false;
	var isAudPlaying = false;
	_this.start = function (_obj) {
		Selector = {			
			XML_NODE: null,
			CLASS_NAME: 'glossary-pop',
			CONTAINER: '#global-modal-pop',
			SHOW_ANIMATION: true,
			
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.getClassName = function(){
		return Selector.CLASS_NAME;
	}
	_this.closeModal = function(){
		processModal(true);
	}
	_this.showWordDefinition = function(_word){
		if(searchWordDataArr.length){
			if(_word != null && _word !== ''){
				var lId = 0;
				var wId = 0;
				for(var i=0; i<searchWordDataArr.length; i++){
					//console.log(searchWordDataArr[i].value.toLowerCase()+'=='+_word.toLowerCase());
					if(searchWordDataArr[i].value.toLowerCase() == _word.toLowerCase()){
						lId = searchWordDataArr[i].letterId;
						wId = searchWordDataArr[i].wordId;
						break;
					}
				}
				showWords(lId);
				showdefinition(lId, wId);	
			}			
		}
	}
	function initTemplate() {
		
		if(Selector.XML_NODE == null){
			console.warn('XML NOT FOUND...')
			return;
		}
		if(APP.globalMessageOpen){return false;}
		APP.preloaderObj.show();
		$(Selector.CONTAINER).addClass(Selector.CLASS_NAME).html(getHtml());		
		applyData();
	}
	function getHtml(){
		var str="";
		str+='<div class="modal-box">';
			str+='<div class="modal-alert">';
				str+='<div class="modal-titlebar">';
						
				str+='</div>';
				str+='<div class="modal-content-box">';
					str+='<div class="scroll-parent">';
						str+='<div class="scrollable">';
						
							str+='<div class="ost-panel"></div>';
							str+='<div class="alphabets-panel"></div>';
							str+='<div class="desc-panel">';
								str += '<div class="term-panel scroll-parent"></div>';
								str += '<div class="line-seperator"><span class="line"></span></div>';
								str += '<div class="definition-panel scroll-parent">';
							str += '</div>';
						str+='</div>';
						str+='<div class="modal-btnpane">';
							str+='<div class="modal-btn"></div>';
						str+='</div>';
					str+='</div>';
				str+='</div>';
			str+='</div>';
		str+='</div>';
		return str;
	}
	function applyData(){
		var textObj = Selector.XML_NODE;		
		//--apply animation data
		if(textObj.dataAnimateType && textObj.dataAnimateType != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-type', textObj.dataAnimateType);
		}
		if(textObj.dataAnimateStartVal && textObj.dataAnimateStartVal != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-start-val', textObj.dataAnimateStartVal);
		}
		if(textObj.dataAnimateEndVal && textObj.dataAnimateEndVal != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-end-val', textObj.dataAnimateEndVal);
		}
		if(textObj.dataAnimateEase && textObj.dataAnimateEase != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-ease', textObj.dataAnimateEase);
		}
		if(textObj.dataAnimateDuration && textObj.dataAnimateDuration != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-duration', textObj.dataAnimateDuration);
		}
		if(textObj.dataAnimateDelay && textObj.dataAnimateDelay != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-delay', textObj.dataAnimateDelay);
		}
		if(textObj.dataAnimateRepeat && textObj.dataAnimateRepeat != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-repeat', textObj.dataAnimateRepeat);
		}
		if(textObj.dataAnimateYoyo && textObj.dataAnimateYoyo != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-yoyo', textObj.dataAnimateYoyo);
		}	
		if(textObj.dataAnimateReversed && textObj.dataAnimateReversed != ''){
			$(Selector.CONTAINER).find('.modal-alert').attr('data-animate-reversed', textObj.dataAnimateReversed);
		}		
	
		//--
		createSearchData();
		createHeader();
		createOstPanel();
		createAlphabetsPanel();
		createBottomPanel();	
		loadComplete();		
	}
	function createSearchData(){
		var textObj = Selector.XML_NODE;
		
		  searchWordDataArr  = [];
		  letterDataArr = [];
		  var glossaryObj = textObj.glossary[0];
		  for(var i=0; i< glossaryObj.letter.length; i++){
			  var letterObj = glossaryObj.letter[i];
			  var count = 0;			  
			for(var j=0; j<letterObj.term.length; j++){
				var termObj = letterObj.term[j];
				//--check if word text is available or not
				if(termObj.word){
					if(termObj.word[0].Text != null && $.trim(termObj.word[0].Text) != ''){
						count ++;
						searchWordDataArr.push({
							label: $.trim(termObj.word[0].Text),
							value: $.trim(termObj.word[0].Text),
							letterId: i,
							wordId: j
						})
					}
				}
			}
			letterDataArr[i] = count;
		}
		
	}
	function createHeader(){
		var textObj = Selector.XML_NODE;
		var str = '';
		if(textObj.headerBar){
			var headerObj = textObj.headerBar[0];
			if(headerObj.closeBtn){
				var _obj = headerObj.closeBtn[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str += '<a class=" btn modal-btn '+_className+' close-modal-btn" style ="'+_style+'" href="javascript:void(0);" >';
					str +='<span class="btn-txt display-cell v-center">'+_txt+'</span>';
					str +='<span class="btn-icon font-icon icon-cross display-cell v-center"></span>';
				str+='</a>';
			}
			if(headerObj.title){
				var _obj = headerObj.title[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str+='<span class="modal-title '+_className+'" style="'+_style+'">'+_txt+'</span>';	
			}
			if(headerObj.text){
				var _obj = headerObj.text[0];
				var _className = _obj.className || '';
				var _style = _obj.style || '';
				var _txt = _obj.Text;
				str+='<span class="modal-title-txt '+_className+'" style="'+_style+'">'+_txt+'</span>';	
			}
			
			$(Selector.CONTAINER).find('.modal-titlebar').html(str);
		}else{
			$(Selector.CONTAINER).find('.modal-titlebar').remove();
		}
	}
	function createOstPanel(){
		var textObj = Selector.XML_NODE;
		var str ='';
		if(textObj.onScreenTxt){
			var ostObj = textObj.onScreenTxt[0];
			var _className = ostObj.className || '';
			var _style = ostObj.style || '';
			str += '<div class="parent-box">';
				if(ostObj.text){
					str+='<div class="content-panel '+_className+'" style="'+_style+'">';
						str += APP.getHtmlStructObj.textPanelStruct(ostObj);					
					str+='</div>';				
				}
				//--add search input
				if(textObj.searchTxt){
					var searchObj = textObj.searchTxt[0];
					var _className = searchObj.className || '';
					var _style = searchObj.style || '';
					str += '<div class="search-panel '+_className+'" style="'+_style+'">';
						str += '<span class="search-txt" >'+searchObj.Text+'</span>';
						str += '<input id="search-input" class="input-box" type="text" placeholder="'+textObj.inputPlacehoderTxt[0].Text+'">';
					str += '</div>';
				}		
			str+='</div>';	
			$(Selector.CONTAINER).find('.modal-content-box .ost-panel').html(str);
		}else{
			$(Selector.CONTAINER).find('.modal-content-box .ost-panel').remove();
		}
	}
	function createBottomPanel(){
		var textObj = Selector.XML_NODE;
		var str ='';
		if(textObj.bottomBar){
			var btmObj = textObj.bottomBar[0];
			if(btmObj.buttonTag){
				for(var i=0; i<btmObj.buttonTag.length; i++){
					var btnTagObj = btmObj.buttonTag[i];
					var _class = btnTagObj.className || '';
					var _style = btnTagObj.style || '';
					
					str += '<div class="btn-panel"><a class=" btn modal-btn '+_class+' " style ="'+_style+'" href="javascript:void(0);" data-id="'+i+'">';
					var iconObj = btnTagObj.btnIcon;
					if(iconObj){
						var _class = iconObj[0].className || '';
						var _style = iconObj[0].style || '';
						var _txt = iconObj[0].Text || '';					
						str += '<span class="btn-icon display-cell v-center '+_class+' " style ="'+_style+'">'+_txt+'</span>';
					}	
					var btnTextObj = btnTagObj.btnText;
					if(btnTextObj){
						var _class = btnTextObj[0].className || '';
						var _style = btnTextObj[0].style || '';
						var _txt = btnTextObj[0].Text || '';					
						str += '<span class="btn-txt display-cell v-center">'+_txt+'</span>';
					}
					str += '</a></div>';
				}				
			}
			$(Selector.CONTAINER).find('.modal-btnpane').html(str);
		}else{
			$(Selector.CONTAINER).find('.modal-btnpane').remove();
		}	
	}
	function createAlphabetsPanel(){
		var textObj = Selector.XML_NODE;
		
		var alphabetsObj = textObj.glossary;
		var str = '';
		for(var i=0; i< alphabetsObj[0].letter.length; i++){
			var curr = alphabetsObj[0].letter[i];
			var extraClass = '';
			if(letterDataArr[i] == 0 || letterDataArr === null){
				extraClass = 'disabled'
			}		
			str += '<a id="alphabets_'+i+'" class="btn alphabets alphabets_'+i+' '+extraClass+'" data-id="'+i+'" data-letter="'+curr.id+'" href="javascript:void(0);">';
				str += '<span class="txt">'+curr.title[0].Text+'</span>';
			str += '</a>';
		}
		$(Selector.CONTAINER).find('.modal-content-box .alphabets-panel').html(str);
	}
	function loadComplete(){
		APP.preloaderObj.hide();		
		
		//--pause video and audio
		if(APP.vidPlayer){
			isVidPlaying = !(APP.vidPlayer.paused);
			isVidEnded = (APP.vidPlayer.ended);
			if(isVidPlaying && !isVidEnded){
				//video is playing so stop them
				APP.vidPlayer.pause();
			}
		}			
		if(APP.screenAudio){isAudPlaying = APP.screenAudio.playing() || false;}		
		
		if(isAudPlaying){APP.screenAudio.pause();}
		
		//--
		$(Selector.CONTAINER).show();
		var alertObj = $(Selector.CONTAINER).find('.modal-alert');
		APP.globalMessageOpen = true;
		if(Selector.SHOW_ANIMATION){			
			var aniObj = APP.animationObj.generateAniObj($(alertObj));
			aniObj.ON_COMPLETE = function(){
				
			}			
			APP.animationObj.animate(aniObj);
		}else{
			alertObj.show();
			
		}
		updateTemplateLayout();
		addTemplateEvent();
		//--open 1st letter
		$(Selector.CONTAINER).find('.alphabets').eq(0).trigger('click');
		$(Selector.CONTAINER).find('.modal-content-box .scroll-parent:first-child').stop().animate({scrollTop:0}, 1000, function() { 
			
		});	 
	}
	function addTemplateEvent() {
		$(Selector.CONTAINER).find('.modal-btn').on('click', function(){
			if($(this).hasClass('yes-btn') || $(this).hasClass('ok-btn') || $(this).hasClass('continue-btn')){				
				processModal('true');
			}
			if($(this).hasClass('close-modal-btn') || $(this).hasClass('cancel-btn') || $(this).hasClass('hide-btn') || $(this).hasClass('no-btn')){				
				processModal('false');
			}			
		})
		$(Selector.CONTAINER).find('.alphabets').on('click', function(){
			if($(this).hasClass('disabled') || $(this).hasClass('current')){return false;}
			var _letterId = parseInt($(this).data('id'));
			$(Selector.CONTAINER).find('.alphabets').removeClass('current');
			$(this).addClass('current');
			showWords(_letterId);	
		});
		//autocomplete
		$(Selector.CONTAINER).find( "#search-input" ).autocomplete({
			appendTo: $(Selector.CONTAINER).find( ".search-panel" ),
			source: searchWordDataArr,
			classes: {
				"ui-autocomplete": "search-word-list"
			},
			create: function( event, ui ) {
				
			},
			open: function( event, ui ) {
				$('.search-word-list').scrollTop(0);
			},
			select: function( event, ui ) {				
				showWords(ui.item.letterId);
				showdefinition(ui.item.letterId, ui.item.wordId);				
			},
			close: function( event, ui ) {
				$(Selector.CONTAINER).find( "#search-input" ).val('')
			}
		});
		//-- brower hack for position 
		$(Selector.CONTAINER).find( "#search-input" ).autocomplete( "search", "a" );
		$(Selector.CONTAINER).find( "#search-input" ).autocomplete("close");
	}
	function showWords(_letterId){	
		var textObj = Selector.XML_NODE;	
		var LetterObj = textObj.glossary[0].letter[_letterId];
		var str = '';
		if(LetterObj.term){
			str += '<div class="scrollable">';
			for(var i=0; i<LetterObj.term.length; i++){
				var curr = LetterObj.term[i];
				if(curr.word){
					if(curr.word[0].Text != null && $.trim(curr.word[0].Text) != ''){
						str += '<a id="word_'+_letterId+'-'+i+'" class="btn word word_'+_letterId+'-'+i+'" data-letter-id="'+_letterId+'" data-id="'+i+'"  href="javascript:void(0);">';
							str += '<span class="txt">'+$.trim(curr.word[0].Text)+'</span>';
						str += '</a>';
					}
				}
			}
			str += '</div>';			
		}
		$(Selector.CONTAINER).find('.modal-content-box .term-panel').html(str).scrollTop(0);
		//reset definition panel
		$(Selector.CONTAINER).find('.modal-content-box .definition-panel').html('');
		//apply event
		$(Selector.CONTAINER).find('.term-panel .word').off('click')
		.on('click', function(){
			if($(this).hasClass('disabled') || $(this).hasClass('current')){return false;}

			var _letterId = parseInt($(this).data('letter-id'));
			var _id = parseInt($(this).data('id'));

			$(Selector.CONTAINER).find('.word').removeClass('current');
			$(this).addClass('current');
			showdefinition(_letterId, _id);
		})
		//default 1st open
		$(Selector.CONTAINER).find('.term-panel .word').eq(0).trigger('click');
	}
	function showdefinition(_letterId, _id){
		var textObj = Selector.XML_NODE;
		$(Selector.CONTAINER).find('.alphabets').removeClass('current');
		$(Selector.CONTAINER).find('.word').removeClass('current');

		$(Selector.CONTAINER).find('.alphabets[data-id="'+_letterId+'"]').addClass('current');
		$(Selector.CONTAINER).find('.word_'+_letterId+'-'+_id).addClass('current');

		var termObj = textObj.glossary[0].letter[_letterId].term[_id];
		var str = '';
		if(termObj.definition){
			if(termObj.definition[0].text){
				str+='<div class="scrollable" >';
					str += APP.getHtmlStructObj.textPanelStruct(termObj.definition[0]);					
				str+='</div>';				
			}						
		}
		$(Selector.CONTAINER).find('.modal-content-box .definition-panel').html(str).scrollTop(0);
		var isInView = APP.commonFunObj.isElementInView($(Selector.CONTAINER).find('.definition-panel'));
		if(!isInView){
			
			/* $(Selector.CONTAINER).find('.modal-content-box .scroll-parent:first-child').stop().animate({scrollTop:300}, 1000, function() { 
			
			});	 */ 
		}
	}
	function processModal(_state){
		var alertObj = $(Selector.CONTAINER).find('.modal-alert');
		
		if(Selector.SHOW_ANIMATION){
			var aniObj = APP.animationObj.generateAniObj($(alertObj));
			aniObj.EL = $(alertObj);
			aniObj.REVERSED = true;
			aniObj.ON_COMPLETE = function(){					
				APP.globalMessageOpen = false;
				if(APP.vidPlayer){
					if(isVidPlaying && !isVidEnded){
						//video is playing so play them again 
						APP.vidPlayer.play();					
					}
				}
				if(isAudPlaying){APP.screenAudio.play();}					
				$(Selector.CONTAINER).attr('class', 'global-modal-pop');
				$(Selector.CONTAINER).attr('style', '');
				$(Selector.CONTAINER).html('');
				$(Selector.CONTAINER).fadeOut('fast');		
				APP.globalModalObj = null;
				APP.commonFunObj.checkScreenSizePop();	
			}
			APP.animationObj.animate(aniObj);

		}else{
			$(Selector.CONTAINER).find('.modal-alert').hide();
			APP.globalMessageOpen = false;				
			$(Selector.CONTAINER).attr('class', 'global-modal-pop');
			$(Selector.CONTAINER).attr('style', '');
			$(Selector.CONTAINER).html('');
			$(Selector.CONTAINER).fadeOut('fast');	
			if(APP.vidPlayer){
				if(isVidPlaying && !isVidEnded){
					//video is playing so play them again 
					APP.vidPlayer.play();					
				}
			}
			if(isAudPlaying){APP.screenAudio.play();}		
			APP.globalModalObj = null;
			APP.commonFunObj.checkScreenSizePop();
		}
	
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_SCREEN_RESIZE, function (e) {
		updateTemplateLayout();
	});
}