function Menu() {
	var _this = this;
	var Selector = {};
	
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'main-menu',
			ACTIVITY_CONTAINER: '#screen-container',
			MENU_CONTAINER: '.menu-activity-panel',
			SUB_MENU_CONTAINER: '.sub-menu-activity-panel',
			XML_NODE: APP.globalXmlsObj.globalXML,
			FONT_ICON_CLASS_OBJ: {				
				plus: 'icon-plus',
				minus: 'icon-minus'
			},
			MODE:'',
			CLICK_ARRAY:[],
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			isCompleted: false,
			userData:null
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	
	function initTemplate() {
		if(Selector.XML_NODE == null){
			console.warn('XML NOT FOUND...')
			return;
		}
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.MODE);
		
		//--get prev value
		Selector.userData = Selector.CLICK_ARRAY;		
		loadMainMenu(true);				
		updateStatus();
	}
	function loadMainMenu(isFirstTime){	
		createMenu();
		$(Selector.ACTIVITY_CONTAINER).find(Selector.SUB_MENU_CONTAINER).hide();
		$(Selector.ACTIVITY_CONTAINER).find(Selector.MENU_CONTAINER).show();
		updateTemplateLayout();
		addTemplateEvent();
	}
	function loadSubMenu(directedLoaded){
		Selector.userData.currView = 'subMenu';
		createSubMenu(Selector.userData.modId);
		$(Selector.ACTIVITY_CONTAINER).find(Selector.MENU_CONTAINER).hide();		
		$(Selector.ACTIVITY_CONTAINER).find(Selector.SUB_MENU_CONTAINER).show();
		updateTemplateLayout();
		addTemplateEvent();
	}

	function createMenu(){		
		createContent();
		APP.preloaderObj.hide();
		updateDurationTxt();
		$(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block').find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.minus).addClass(Selector.FONT_ICON_CLASS_OBJ.plus);	
	}
	function createContent(){		
		var str ='';		
		var _imgPathPrx = 'content/images/'+APP.configObj.language.dir+'/';	
		var menuXmlObj = Selector.XML_NODE.menu[0];
		$(Selector.ACTIVITY_CONTAINER).find('.right-area-panel').find('.pop-panel').html('');
		for (var i=0; i<menuXmlObj.module.length; i++){
			var curr = menuXmlObj.module[i];
			if(curr.hideOnMenu == 'true'){
				continue;
			}
			var statusClass="not-attempted"
			var modStatus = APP.courseDataObj.getModuleStatus(i);
			if(modStatus == '1'){
				statusClass = "incomplete"
			}
			if(modStatus == '2'){
				statusClass = "complete"
			}
			var mref = 'mod-'+i;
			var dtxt = curr.durationMin || 1;
			var mtxt = curr.title[0].Text;
			var mImg = _imgPathPrx + curr.homeBtnImg;
			var visibleClass = '';
			if(mtxt == null || mtxt == ''){
				visibleClass = 'no-title'
			}
			var overText = '';
			if(curr.overText){				
				overText = curr.overText[0].Text;
			}	
			var extraClass = curr.className || '';
				

			/* 1 */str += '<div id="'+mref+'" class="mod-btn-block '+mref+' '+statusClass+' '+visibleClass+' '+extraClass+'">';
					str+='<a class="btn module-btn " data-modid="'+i+'" href="javascript:void(0)">';
						str += '<div class="name-cell font-2">';
							str += '<span class="title-div ">'+mtxt+'</span><span class="time-div">'+curr.timeText[0].Text+'</span>';
						str += '</div>';
						str += '<div class="indicator indicator-cell "><span class="font-icon status-icon"></span></div>';

					str += '</a>';
			/* 1 */str += '</div>';
			
		}
		
		//module end
		$(Selector.ACTIVITY_CONTAINER).find('.dynamic-panel').html(str);		
		
		applyTopicBtnEvent();
		updateModButtonStatus();
		$(Selector.ACTIVITY_CONTAINER).find('.dynamic-panel').find('.scroll-parent').css('overflow', 'auto');		
			
		/* var modEl = $(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block');
		TweenMax.fromTo(modEl, 0.7, 
			{opacity:0}, 
			{opacity:1, delay: 1.0,		
					
			ease: 'Power1.easeOut',
			onComplete: function(){
				$(Selector.ACTIVITY_CONTAINER).find('.dynamic-panel').find('.scroll-parent').css('overflow', 'auto');
				
			}
			
		}); */
	}

	function addTemplateEvent() {
		$(Selector.ACTIVITY_CONTAINER).find('.module-btn').on('click', function(e){
			var parentBlock = $(this).parents('.mod-btn-block');			
			if(parentBlock.hasClass('locked') || $(this).hasClass('disabled')){return false;};
			e.stopPropagation();
			updateStatus();	
			$(this).addClass('disabled');		
			APP.navData.moduleId = $(this).data('modid');
			APP.navData.topicId = 0;
			APP.navData.screenId = 0;
			APP.navigationObj.loadScreen();
			
		})
		
		$(Selector.ACTIVITY_CONTAINER).find('.confirm-learning-btn').on('click', function(){
			if($(this).hasClass('disabled')){return false;};
			APP.userTopicSelectionObj.userSelectedTopicArr = [];
			var currentView = APP.commonFunObj.getCurrentView();
			var topicBtnObj = $(Selector.ACTIVITY_CONTAINER).find('.right-area-panel').find('.topic-btn');
			/* if(currentView == 'mobile'){
				topicBtnObj = $(Selector.ACTIVITY_CONTAINER).find('.collapse-mod').find('.topic-btn');
			} */
			topicBtnObj.each(function(inx){
				if($(this).hasClass('selected')){
					var mId = $(this).data('modid');
					var topicId = $(this).data('topicid');
					APP.userTopicSelectionObj.userSelectedTopicArr.push(mId+'_'+topicId);
				}
			})
			
			APP.courseDataObj.applyUserLearningPlan();
			updateStatus();
			APP.navigationObj.loadMainMenuScreen();
		})
		$(Selector.ACTIVITY_CONTAINER).find('.reset-learning-btn').on('click', function(){
			if($(this).hasClass('disabled')){return false;};			
			//APP.navigationObj.loadScreenByType('profiler1Screen');
			APP.commonFunObj.showResetTrainingPop();
		})
		//--for certificate
		$(Selector.ACTIVITY_CONTAINER).find('.certificate-btn').on('click', function(){
			var sts = APP.dataComObj.getLessonStatus();
			if(sts == 'completed' || APP.courseDataObj.isAllMandatoryTopicCompleted()){			
				APP.navigationObj.loadCertificateScreen();
			}else{
				APP.commonFunObj.showCompleteMandatoryPop();					
			}	
				
		});	
	}
	function applyTopicBtnEvent(){
		$(Selector.ACTIVITY_CONTAINER).find('.topic-btn').on('click', function(){			
			if(Selector.MODE === 'selectable'){
				if($(this).hasClass('mandatory')){return false;};
				var _idClass = $(this).attr('id');
				if($(this).hasClass('selected')){
					//to apply class for both instance
					$('.'+_idClass).removeClass('selected');
					$('.'+_idClass).find('.check-icon').removeClass('icon-checkbox-checked').addClass('icon-checkbox-unchecked');
				}else{
					$('.'+_idClass).addClass('selected');
					$('.'+_idClass).find('.check-icon').removeClass('icon-checkbox-unchecked').addClass('icon-checkbox-checked');
				}
				checkConfirmBtn();
			}else{
				if($(this).hasClass('locked') || $(this).hasClass('disabled') || $(this).hasClass('current')){return false;};
			
				$(Selector.ACTIVITY_CONTAINER).find('.topic-btn').removeClass('current');
				$(this).addClass('current');
				var isOverPopAvl = $(this).data('over-pop-avl');
				if(isOverPopAvl){
					var obj = {
						modId: $(this).data('modid'),
						topicId: $(this).data('topicid')
					}
					createOverPopup(obj);
				}else{
					//APP.progressBarObj.resetHorizontalProgressBar();
					updateStatus();			
					APP.navData.moduleId = $(this).data('modid');
					APP.navData.topicId = $(this).data('topicid');
					APP.navData.screenId = 0;
					APP.navigationObj.loadScreen();
					//--same function code applied in start btn applyStartBtnEvent()
				}
			}
		})
	}
	
	function createSubTopicPop(_modId, _view){
		var str = '';
		/* 1 */str += '<div class="module-pop module-pop_'+_modId+'">';			
			var curr = Selector.XML_NODE.menu[0].module[_modId];
			var mtxt = _modId+'. '+curr.title[0].Text;
			/* 1a */str += '<div class="display-table topic-table">';
			/* 1b */str += '<div class="display-row topic-title-row">';
				/* str += '<div class="display-cell topic-cell">'; */
					str += '<div class="display-cell indecator-cell v-center center"></div>';
					str += '<div class="display-cell title-cell v-center left"><p>'+mtxt+'</p></div>';
					str += '<div class="display-cell minute-cell v-center right">';
						str += '<span class="font-icon time-icon icon-clock"></span>';
						str += '<span class="duration-txt">'+Selector.XML_NODE.commonText[0].menuMinTxt[0].Text+'</span>';
					str += '</div>';
				/* str += '</div>'; */
			/* 1b */str += '</div>';
			var subTopicXmlObj = curr.topic;
			for (var j=0; j<subTopicXmlObj.length; j++){
				var currSubTopic = subTopicXmlObj[j];
				if(currSubTopic.hideOnMenu == 'true'){
					continue;
				}
				var subTopicStatusClass="not-attempted"
				var subTopicStatus = APP.courseDataObj.getTopicStatus(_modId, j);
				if(subTopicStatus == '1'){
					subTopicStatusClass = "incomplete"
				}
				if(subTopicStatus == '2'){
					subTopicStatusClass = "complete"
				}
				var tref = 'topic-'+_modId+'_'+j;

				var ttxt = currSubTopic.title[0].Text;
				var icoClass = currSubTopic.iconClass || '';
				var className = currSubTopic.className || '';
				var durationMin = currSubTopic.durationMin || '';
				var dataType = currSubTopic.dataType || '';

				var tvisibleClass = '';
				if(ttxt == null || ttxt == ''){
					tvisibleClass = 'no-title'
				}
				
				//--build by mode
				if(Selector.MODE === 'selectable'){
					str+='<a id="'+tref+'" class="display-row btn transBg topic-btn strong '+tref+' '+tvisibleClass+' '+className+' '+dataType+'" data-modid="'+_modId+'" data-topicid="'+j+'" href="javascript:void(0)">';
						str += '<div class="indicator indicator-cell display-cell v-center center">';	
							if(dataType == 'optional'){
								str += '<div class="icon-bg11"><span class="font-icon check-icon icon-checkbox-unchecked"></span></div>';
							}else{
							}							
						str += '</div>';
						str+= '<div class ="btn-txt display-cell v-center left" >'+ttxt+'</div>';
						str+= '<div class ="time-cell display-cell v-center right" >'+durationMin+'</div>';
					str += '</a>';
								
				}else{					
					str+='<a id="'+tref+'" class="display-row btn transBg topic-btn strong '+tref+' '+subTopicStatusClass+' '+tvisibleClass+' '+className+' '+dataType+'" data-modid="'+_modId+'" data-topicid="'+j+'" href="javascript:void(0)">';
						str += '<div class="indicator indicator-cell display-cell v-center center">';	
							if(dataType == 'optional'){
								str += '<div class="icon-bg11"><span class="font-icon optional-icon '+APP.iconObj.optional+'"></span></div>';
							}else{
								str += '<div class="icon-bg11"><span class="font-icon status-icon"></span></div>';
							}							
						str += '</div>';
						str+= '<div class ="btn-txt display-cell v-center left" >'+ttxt+'</div>';
						str+= '<div class ="time-cell display-cell v-center right" >'+durationMin+'</div>';
					str += '</a>';									
				}
			}
			
			/* 1a */str += '</div>';
		/* 1 */str += '</div>';
		return str;
	}
	function checkConfirmBtn(){
		updateDurationTxt();
	}
	function updateDurationTxt(){
		var mandatoryTopicDuration = APP.courseDataObj.getTotalDuration();
		var userSelectedTopicDuration = 0;
		if(Selector.MODE === 'selectable'){
			var currentView = APP.commonFunObj.getCurrentView();
			var topicBtnObj = $(Selector.ACTIVITY_CONTAINER).find('.right-area-panel').find('.topic-btn');
			/* if(currentView == 'mobile'){
				topicBtnObj = $(Selector.ACTIVITY_CONTAINER).find('.collapse-mod').find('.topic-btn');
			} */
			topicBtnObj.each(function(inx){
				if($(this).hasClass('selected')){
					var mId = $(this).data('modid');
					var topicId = $(this).data('topicid');
					var dur = APP.courseDataObj.getTopicDuration({moduleId: mId, topicId: topicId});
					if(dur != null && dur != ''){
						userSelectedTopicDuration += parseFloat(dur);
					}
				}
			})
			userSelectedTopicDuration.toFixed(2);
		}
		
		var t = parseFloat(mandatoryTopicDuration) + parseFloat(userSelectedTopicDuration);
		
		var timeObj = APP.commonFunObj.convertMinsToHrsMins(t);
		$(Selector.ACTIVITY_CONTAINER).find('.dyn-hour').html(timeObj.hour);
		$(Selector.ACTIVITY_CONTAINER).find('.dyn-minute').html(timeObj.minute);
	}
	function applyStartBtnEvent(){
		$(Selector.ACTIVITY_CONTAINER).find('.start-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};			
				//APP.progressBarObj.resetHorizontalProgressBar();
				updateStatus();			
				APP.navData.moduleId = $(this).data('modid');
				APP.navData.topicId = $(this).data('topicid');
				APP.navData.screenId = 0;
				APP.navigationObj.loadScreen();
		})
	}
	function createOverPopup(_obj){
		var modId = _obj.modId;
		var topicId = _obj.topicId;
		var menuXmlObj = Selector.XML_NODE.menu[0];
		topicObj = menuXmlObj.module[modId].topic[topicId];
		var str = '';
		str += '<div class="topic-over-pop topic-over-pop_'+modId+'-'+topicId+'">';			
			str +='<div class="main-box">';				
				str +='<p class="txt topic-title">'+topicObj.preTitle[0].Text+' '+topicObj.title[0].Text+'</p>';
				str +='<div class="text-box">';
					str += APP.getHtmlStructObj.textPanelStruct(topicObj.overPopText[0]);
				str +='</div>';
				str +='<div class="btn-panel start-btn-panel border-btn">';
					str +='<a class="btn start-btn " href="javascript:void(0);" data-modid="'+modId+'" data-topicid="'+topicId+'">';
						str +='<span class="btn-txt display-cell v-center center" >'+APP.globalXmlsObj.globalXML.commonText[0].startBtnText[0].Text+'</span>';
						str +='<span class="btn-icon font-icon icon-next display-cell v-center center" ></span>';
					str +='</a>';
				str +='</div>';
			str +='</div>';
		str +='</div>';
		$(Selector.ACTIVITY_CONTAINER).find(Selector.SUB_MENU_CONTAINER).find('.topic-over-panel').html(str);
		applyStartBtnEvent();
		APP.animationObj.animate({
			EL: $(Selector.ACTIVITY_CONTAINER).find(Selector.SUB_MENU_CONTAINER).find('.topic-over-pop .main-box'),
			TYPE: 'zoom-in',
			STAGGER: false,
			START_VAL: '0.5',
			DURATION: 1,
			ON_COMPLETE: function(){
				
			}
		});
		APP.animationObj.animate({
			EL: $(Selector.ACTIVITY_CONTAINER).find(Selector.SUB_MENU_CONTAINER).find('.topic-over-pop .line'),
			TYPE: 'fade-in-left',
			STAGGER: false,
			DURATION: 1,
			ON_COMPLETE: function(){
				
			}
		});
	}
	function updateTemplateLayout() {
		
		//don't call heavy function here as it is run on screen resize	
		//to prevent being call from other screen 
		/* var activityContainer = $('.menu-container');
		var currentPop = $(activityContainer).data('current-pop');
		
		if(currentPop != null && currentPop!=''){						
			var modBtnBLockObj = $(activityContainer).find('.mod-btn-block.mod-'+currentPop);
			if(modBtnBLockObj.length){					
				var currentView = APP.commonFunObj.getCurrentView();
				if(currentView == 'mobile'){
					modBtnBLockObj.addClass('open');
					modBtnBLockObj.find('.module-btn').removeClass('selected');
					$(activityContainer).find('.right-area-panel').hide();
					var collapseObj = modBtnBLockObj.siblings('.collapse-mod-'+currentPop);	
					collapseObj.show();
					modBtnBLockObj.find('.plus-minus').removeClass(Selector.FONT_ICON_CLASS_OBJ.plus).addClass(Selector.FONT_ICON_CLASS_OBJ.minus);	
				}else{
					modBtnBLockObj.removeClass('open');
					modBtnBLockObj.find('.module-btn').addClass('selected');
					$(activityContainer).find('.collapse-mod').hide();
					$(activityContainer).find('.right-area-panel').show();
					$(activityContainer).find('.right-area-panel').find('.module-pop').hide();	
					$(activityContainer).find('.right-area-panel').find('.module-pop_'+currentPop).show();
				}			
			}		
		} */
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	function updateModButtonStatus(){	
		var cheatMode = APP.configObj.cheatMode;	
		var menuContainer = $(Selector.ACTIVITY_CONTAINER).find(Selector.MENU_CONTAINER);
		if(APP.configObj.menu.lockMenu == true && !cheatMode){
			//menuContainer.find('.mod-btn-block.not-attempted').addClass('locked');
			//menuContainer.find('.mod-btn-block').eq(0).removeClass('locked');
			//menuContainer.find('.mod-btn-block.complete').next().removeClass('locked');

			//custom for client - only lock last module 
			menuContainer.find('.mod-btn-block.quiz').addClass('locked');
			var totMandatoryModule = menuContainer.find('.mod-btn-block:not(.quiz)').length;
			var comMandatoryModule = menuContainer.find('.mod-btn-block.complete').length;
			//console.log(comMandatoryModule,totMandatoryModule );
			
			if(comMandatoryModule >= totMandatoryModule){				
				menuContainer.find('.mod-btn-block.quiz').removeClass('locked');
			}
		}
		//--indicator changes	
		menuContainer.find('.mod-btn-block.locked').find('.indicator .status-icon').addClass(APP.iconObj.locked);	
		menuContainer.find('.mod-btn-block.not-attempted:not(.locked)').find('.indicator .status-icon').addClass(APP.iconObj.notAttempted);
		
		menuContainer.find('.mod-btn-block.incomplete').find('.indicator .status-icon').addClass(APP.iconObj.incomplete);
		menuContainer.find('.mod-btn-block.complete').find('.indicator .status-icon').addClass(APP.iconObj.complete);

				
	}
	function updateTopicButtonStatus(){
		var cheatMode = APP.configObj.cheatMode;
		var subMenuContainer = $(Selector.ACTIVITY_CONTAINER).find('.module-pop')
		if(APP.configObj.menu.lockSubMenu == true && !cheatMode){
			//apply locked class only for mandatory module
			/* subMenuContainer.find('.topic-btn.mandatory.not-attempted').addClass('locked');
			//to get both view 1st elemnt
			var firstELIdClass = subMenuContainer.find('.topic-btn.mandatory.not-attempted').eq(0).attr('id');
			$('.'+firstELIdClass).removeClass('locked'); */
			//custom for client - only lock last module 
			/* subMenuContainer.find('.topic-btn.topic-summary').addClass('locked');
			var totMandatoryTopics = $(Selector.ACTIVITY_CONTAINER).find('.collapse-mod').find('.topic-btn.mandatory:not(.topic-summary)').length;
			var comMandatoryTopics = $(Selector.ACTIVITY_CONTAINER).find('.collapse-mod').find('.topic-btn.mandatory.complete').length;
			
			if(comMandatoryTopics >= totMandatoryTopics){				
				subMenuContainer.find('.topic-btn.topic-summary').removeClass('locked');
			} */
			subMenuContainer.find('.topic-btn').removeClass('locked');
		}		
		//--indicator changes
		subMenuContainer.find('.topic-btn.locked').find('.indicator .status-icon').addClass(APP.iconObj.locked);
		subMenuContainer.find('.topic-btn.not-attempted').find('.indicator .status-icon').addClass(APP.iconObj.notAttempted);
		subMenuContainer.find('.topic-btn.incomplete').find('.indicator .status-icon').addClass(APP.iconObj.incomplete);
		subMenuContainer.find('.topic-btn.complete').find('.indicator .status-icon').addClass(APP.iconObj.complete);
		
	}
	function updateStatus() {	
		if (Selector.ON_CLICK) {
			
			Selector.ON_CLICK({arr: Selector.userData});
		}
		Selector.isCompleted = true;		
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}

	}
}