function ModalVideoScreen() {
	var _this = this;
	var Selector = {};
	var isVidPlaying = false;
	
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'modal-video-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			VIDEO_BLOCK: '.video-block',
			TYPE: 'regular',
			ON_VIDEO_PLAY: null,
			ON_VIDEO_PAUSE: null,
			ON_VIDEO_PAUSE: null,
			ON_VIDEO_ENDED: null,
			IS_CONTROL_AVL: null,
			ON_COMPLETE: null,			
			
			CLICK_ARRAY: [],
			isCompleted:false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.replayVideo = function(_id){
		
		if(APP.modalVidPlayer){
			APP.modalVidPlayer.currentTime = 0;
			APP.modalVidPlayer.play();
		}
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);

		$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){			
			$(this).attr('data-id', inx);
			$(this)
			.find('.vid-transcript-btn')
			.attr('data-id', inx)
			.addClass('transcript-btn-'+inx);
			$(this)
			.find('.vid-transcript-popup')
			.attr('data-id', inx)
			.addClass('vid-transcript-popup-'+inx);
		})
		if(Selector.TYPE == 'video-step' || Selector.IS_CONTROL_AVL == false){
			APP.modalVidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
				controls: ['play-large'],
				iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
				clickToPlay: false,
				keyboard: { focused: false, global: false },
				fullscreen: {enabled: false}
			});
		}else{
			var deviceType = APP.systemDetectorObj.deviceType;
			var browserName = APP.systemDetectorObj.browserName;
			if(browserName != 'safari' && deviceType == 'desktop'){
				APP.modalVidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
					controls: ['play-large', 'play', 'progress', 'current-time', 'mute','captions', 'fullscreen'],
					iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
					captions: { active: true, language: 'auto', update: false },
				});
			}else{
				//for mobile remove fullscreen button
				APP.modalVidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
					controls: ['play-large', 'play', 'progress', 'current-time', 'mute','captions'],
					iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
					captions: { active: true, language: 'auto', update: false },
					fullscreen: {enabled: false}
				});
			}
		}
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
	}

	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				var id = $(this).data('id');
				if(Selector.userData[id] == 1){
					$(this).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				Selector.userData.push(0);
			});
		}
		
		updateStatus();

	}
	
	function addTemplateEvent() {
		if(APP.modalVidPlayer){
			APP.modalVidPlayer.on('loadstart', function(e){	
				//console.log('loadstart')				
				//APP.preloaderObj.show();				
			})
			APP.modalVidPlayer.on('canplay', function(e){
				//console.log('canplay')		
				$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();
				if(APP.isScreenAudioPlay){
					APP.modalVidPlayer.muted = false;
				}else{
					APP.modalVidPlayer.muted = true;
				}				
			})
			APP.modalVidPlayer.on('canplaythrough', function(e){	
				//console.log('canplaythrough')
				if(e.target.readyState >= 3){				
					//APP.preloaderObj.hide();
					$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();
				}
			});
			APP.modalVidPlayer.on('pause', function(e){		
				//console.log('pause')
				if(Selector.ON_VIDEO_PAUSE){
					Selector.ON_VIDEO_PAUSE({id: 0, arr:Selector.userData})
				}
			});
			APP.modalVidPlayer.on('play', function(e){
				//console.log('play')	
				$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();
				$('#play-overlay').addClass('hide');
				//APP.commonFunObj.removeScreenAudio();
				
				//APP.commonFunObj.removeBgMusic();
				if(Selector.ON_VIDEO_PLAY){
					Selector.ON_VIDEO_PLAY({id: 0, arr:Selector.userData})
				}
			});
			APP.modalVidPlayer.on('timeupdate', function(e){
				//console.log('timeupdate')				
				if(Selector.ON_TIMEUPDATE){
					Selector.ON_TIMEUPDATE({id: 0, vidObj: e.currentTarget});
				}
			});
			APP.modalVidPlayer.on('ended', function(e){
				//console.log('ended')
					if(APP.modalVidPlayer.fullscreen.active){
						APP.modalVidPlayer.fullscreen.exit();
					}
								
				if(Selector.ON_VIDEO_ENDED){
					Selector.userData[0] = 1;
					updateStatus();
					Selector.ON_VIDEO_ENDED({id: 0, arr:Selector.userData})
					
				}
			});
		}
		

		$(Selector.ACTIVITY_CONTAINER).find('.vid-transcript-btn').on('click', function(e){
			if($(this).parents('.clickable').hasClass('disabled') || $(this).parents('.clickable').hasClass('current')){return false;};
			e.stopPropagation();

			isVidPlaying = !(APP.modalVidPlayer.paused);

			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				var currVidObj = $(this).find('.media-video-player').eq(0);
				$(currVidObj).get(0).pause();
			});
			
			var id = parseInt($(this).parents(Selector.VIDEO_BLOCK).data('id'));
			//$(this).parents('.clickable').addClass('visited current');
			
			Selector.userData[id] = 1;	
			var t = $(this).attr('data-link');
			//to open transcript pdf 
			if(t){
				var transWin = window.open(t,'_blank');
				transWin.focus();
				if (Selector.ON_CLICK) {
					Selector.ON_CLICK({id: id, arr:Selector.userData});
				}	
				updateStatus();	
				return false;
			}	
			
			var currPop = $(Selector.ACTIVITY_CONTAINER).find('.vid-transcript-popup[data-id="'+id+'"].no-popup');//for animation
							
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			aniObj.ON_COMPLETE = function(){
				$(currPop).find('.scroll-parent').scrollTop(0);
				
				$(currPop).parents('.scroll-parent').animate({scrollTop:455}, 1000, function() { 
			
				});	  
			};
					
			currPop.show();
			if(currPop.hasClass('no-popup')) {
				//$(this).parents('.clickable').addClass('hide');	
				$(this).parents('.trascript-btn-block').addClass('hide');	
			}	
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currPop));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
				}
				
			}
			APP.animationObj.animate(aniObj);	
						
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr:Selector.userData});
			}	
			updateStatus();			
		})
		//---
	}
			
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
}