function DropDownQuestion() {
	var _this = this;
	var Selector = {};	
	var optArr = [];
	var defaultValue = '0'
	var time = new Date();
	var startTime;
	var questionPanelHt;
	var openMenuHt;

	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'dropdown-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			IS_ASSESSMENT: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			DROP_DOWN_PANEL: '.drop-down-panel',
			DROP_DOWN: '.drop-down',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: 'icon-triangle-bottom',
				optSelected: 'icon-triangle-top',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
     		ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,
			ON_CHANGE: null,
     	ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
      NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			isCompleted:false,
     		queObj:null,
			
			
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];
		Selector.answerArray = [];
		Selector.isCompleted = false;		
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
		}
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			initialRender();
		}	
	}
	function getHTML() {
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		var _className = Selector.queObj.className || "";
		var _subType = Selector.queObj.subType || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		var _colWidth = Selector.queObj.colWidth || "col-60";
		
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _subType + ' ' + _id + ' " style="' + _style + '">';
			/* 2 */ str += '<div class="col col-text '+_colWidth+' white-alpha-bg ani-box-left">';		
				str += '<div class="sb-que-ref"></div>';
				str += '<div class="screen-title-div">';
					str += '<span class="icon font-icon icon-exercise"></span>';
					str += '<span class="title"></span>';
				str += '</div>';				
			/* 3 */str += '<div class="que-txt-panel">';	
				str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);	
			/* 3 */str += '</div>';
			str += '<select class="placeholder-dropdown">';
			var optionObj = Selector.queObj.options[0].option;
			for (var j = 0; j < optionObj.length; j++) {					
				var _className = optionObj[j].className || "";
				var _style = optionObj[j].style || "";
				var _txt = optionObj[j].Text;
				var _correctId = optionObj[j].correctId.toLowerCase();
				if (_correctId != "na") {								
					//--logic for multiple correct option
					//Selector.CORRECT_ANS_ARRAY
					var arr =_correctId.split(',');					
					for(var m=0; m<arr.length; m++){									
						if(Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])] != null && Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].constructor === Array){		
							
						}else{
							Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])]=[];							
						}
						//rearrange id's as 0 set for initial option 'select an anwer'
						Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].push(j - 1);
					}
				}		
				str += '<option >'+_txt+'</option>';
			}	
			str += '</select>';
			
			/* 4 */str += '<div class="display-block submit-panel bottom-align">';			
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn " href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn additional-hint-btn " href="javascript:void(0);" >';
							str += '<span class="btn-icon font-icon icon-hint display-cell v-center center" ></span>';
							str += '<span class="btn-txt display-cell v-center center" >'+APP.globalXmlsObj.globalXML.commonText[0].getAddHintsBtnText[0].Text+'</span>';
						str += '</a>';
					str += '</div>';						
			/* 4 */str += '</div>';	
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
								str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partiallyCorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';
			}				
			/* 2 */str += '</div>';
			if(_colWidth != 'full'){			
				if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
					var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
					str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
				}else{
					str += '<div class="col col-blank"><p></p></div>';
				}
			}
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}
	function initialRender() {	
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);

		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		Selector.dropDownPanel = Selector.queDivObj.find(Selector.DROP_DOWN_PANEL);	

		Selector.placeHolderDropDown = Selector.queDivObj.find('.placeholder-dropdown');		
		Selector.optionObj = Selector.placeHolderDropDown.find('option');
		Selector.placeHolderDropDown.hide();

		//validate CORRECT_ANS_ARRAY
		var totOpt = Selector.queDivObj.find(Selector.DROP_DOWN_PANEL).length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		//--create UserArray 
				
		Selector.dropDownPanel.each(function (inx) {			
			Selector.initialUserArr.push(defaultValue);
			$(this).attr('data-index', inx);
		});
		//--create answerArray
		var tempArr = Selector.CORRECT_ANS_ARRAY.slice();
		//rearrange id's as 0 set for initial option 'select an anwer'
		
		for (var i=0; i<tempArr.length; i++){
			var currArr = tempArr[i];	
			Selector.answerArray[i] = [];			
			for(var j =0; j<currArr.length; j++){
				Selector.answerArray[i][j] = parseInt(currArr[j]) + 1;
			}
		}
		
		questionPanelHt = $(Selector.queDivObj).find('.que-txt-panel').outerHeight() || 200;
		openMenuHt = $(Selector.queDivObj).find('.drop-down.open').find('.list').outerHeight() || 200;

		initOptionData();
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}		
	}
	function initOptionData(){
		optArr = [];
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
			//--escape default value
			optArr = APP.commonFunObj.getRandomArr((Selector.optionObj.length - 1), 1);
			//--add default value to 1st in array
			optArr.unshift(0);
		}else{
			optArr = APP.commonFunObj.getLinearArr(Selector.optionObj.length);
		}
		
		//--create dropdown panel				
		var str = "";
		var isFirstTime = true;
		Selector.dropDownPanel.each(function (idx) {			
			str = "";
			str += '<select class="drop-down" id="drop-down_' + idx + '" data-id="' + idx + '">';
			for (var i = 0; i < optArr.length; i++) {
				var _txt = Selector.optionObj.eq(optArr[i]).text();
				var _id = optArr[i];
				str += '<option data-id="'+_id+'" value="'+_id+'" >' + _txt + '</option>';	
			}
			isFirstTime = false;			
			str += '</select>';
			//--added status icon
			str += '<div class="btn-icon font-icon status"></div>';
			$(this).html(str);
		});
		applyDropDownEvent();
		showAnsValue();
		
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;		
		if(cheatMode){			
			var corrClass = 'ref-corr';
			for(var i =0; i<Selector.answerArray.length; i++){
				var currArr = Selector.answerArray[i];				
				for(var j =0; j<currArr.length; j++){
					var op = currArr[j];
				
					Selector.dropDownPanel.eq(i).find('.option[data-value="'+op+'"]').addClass(corrClass);
				}
			}
		}
	}
	function loadPrevUserData(){
		if (Selector.IS_ASSESSMENT && assessmentQuizObj.dataReviewMode) {			
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					newArr.push(tempAnsArr[i].split(','));					
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			if (Selector.queObj.dataUserArray != null) {
				Selector.userArray = Selector.queObj.dataUserArray;				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){			
			Selector.dropDownPanel.each(function (idx) {					
				var currVal = Selector.userArray[idx];		
				$(this).find(Selector.DROP_DOWN).val(currVal);
				$(this).find(Selector.DROP_DOWN).niceSelect('update');
			});			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}
	
		initQuestion();		
	}
	function initQuestion(){
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		updateValue();

		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:false});
			}
		} */
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
		
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		}
	});
	function addTemplateEvent() {				
		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			processSubmit({feedbackAni:true});		
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyDropDownEvent(){
		Selector.queDivObj.find(Selector.DROP_DOWN).niceSelect();		
		Selector.queDivObj.find(Selector.DROP_DOWN).on('change', function(e){
			var id = parseInt($(this).data('id'));
			Selector.userArray[id] = $(this).val();	
			extendActivityHeight();		
			updateValue();
			updateStatus();
			
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
	}
	function submitBtnStatus(){
		var isAllSelected = true;
		for(var i=0; i<Selector.userArray.length; i++){
			var curr = Selector.userArray[i];
			if(curr == 0){
				isAllSelected = false;
				break;
			}
		}
		if(isAllSelected){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){		
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}

	function EnabledDisableDropDown (_val){		
		var dd = Selector.queDivObj.find(Selector.DROP_DOWN);
		if(dd.length){
			if(_val){
				$(dd)
				.removeAttr('disabled')
				.removeClass('disabled');
			}else{
				$(dd)
				.attr('disabled', 'disabled')
				.addClass('disabled');
			}
		}	
		
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.answerArray.length
		}
				
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr=Selector.answerArray[i];
			var found=false;
			for (var j = 0; j < crrArr.length; j++) {
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					obj.corrCount += 1;	
					found=true;
					break;
				}else{
					
				}
			}
			if(!found){
				if (Selector.userArray[i] != defaultValue) {
					obj.inCorrCount += 1;
				}
			}
		}
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisableDropDown(false);

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			showFeedback(_obj.feedbackAni);	
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
	}
	function showFeedback(isAni){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName ='correct'
				Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
				soundName ='incorrect'			
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
				soundName ='incorrect'				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){
				soundName ='incorrect'					
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
				soundName ='incorrect'	
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		aniObj.ON_COMPLETE = function(){
			$(currFeedback).find('.scroll-parent').scrollTop(0);
			APP.commonFunObj.playSoundEffect({name: soundName});	
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.playSoundEffect({name: soundName});
				APP.commonFunObj.updateScreenModalPopLayout();
			}		
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}						
		}else{	
			
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}
		}
		applyPopCloseEvent();
		
	}
		
	function resetQuestion(){			
		EnabledDisableDropDown(true);
    Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.dropDownPanel.removeClass('tick').removeClass('cross');	
		Selector.dropDownPanel.find('.status').removeClass('i-tick').removeClass('i-cross').removeClass('visibility-hidden');
		$(Selector.FEEDBACK_CONTAINER).hide();
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		Selector.userArray = Selector.initialUserArr.slice();
		initOptionData();		
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		//to hide status icon
		Selector.queDivObj.find(Selector.DROP_DOWN).parents(Selector.DROP_DOWN_PANEL).find('.status').addClass('visibility-hidden');
		for(var i =0; i<Selector.answerArray.length; i++){
			var crrArr=Selector.answerArray[i];	
			var found = false;
			for(var j =0; j<crrArr.length; j++){
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					found=true;
					break;
				}else{
					
				}				
			}
			if(!found){	
				//--consider arr[0] correct answer if multi option available
				var op = crrArr[0];	
				Selector.dropDownPanel.eq(i).find(Selector.DROP_DOWN).val(op);
				Selector.dropDownPanel.eq(i).find(Selector.DROP_DOWN).niceSelect('update');
			}
		}
		
	}
	function showUserSelection(){
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);
		//to show status icon
		Selector.queDivObj.find(Selector.DROP_DOWN).parents(Selector.DROP_DOWN_PANEL).find('.status').removeClass('visibility-hidden');
			
		for(var i=0; i<Selector.userArray.length; i++){	
			if (Selector.userArray[i] != defaultValue) {		
				var op = Selector.userArray[i];	
				Selector.dropDownPanel.eq(i).find(Selector.DROP_DOWN).val(op);
				Selector.dropDownPanel.eq(i).find(Selector.DROP_DOWN).niceSelect('update');
			}
		}
	}
	function showTickCorss(){		
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr=Selector.answerArray[i];
			var found=false;
			var curr = Selector.dropDownPanel.eq(i);
			for (var j = 0; j < crrArr.length; j++) {
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {		
					curr.removeClass('cross')
					.addClass('tick');	

					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.removeClass('i-cross')					
					.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.addClass('i-tick');

					found=true;
					break;
				}else{
					
				}
			}
			if(!found){
				if (Selector.userArray[i] != defaultValue) {	
					curr.removeClass('tick')
					.addClass('cross');	

					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)		
					.removeClass('i-tick')			
					.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.addClass('i-cross');	
					
				}
			}			
		}
		
	}
	function updateStatus() {
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			Selector.queObj.dataUserArray = Selector.userArray;
			Selector.queObj.dataAnswerArray = Selector.answerArray.join("^");
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			/* var obj = {
				corrCount: 0,
				inCorrCount: 0,
				allCorrected: false,
				totalCorrCount: 0
			   } */
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partiallyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
					
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function extendActivityHeight(){
		//waited for animation complete
		setTimeout(function(){
			var openObj = $(Selector.queDivObj).find('.drop-down.open').find('.list');
			var panel = $(Selector.ACTIVITY_CONTAINER);
			//for responsive
			/* if (Selector.IS_ASSESSMENT) {
				panel = $(Selector.ACTIVITY_CONTAINER).find('.activity-panel');
			} */
			if(openObj.length){
				var t = openObj.offset();
				var panelPoss = panel.offset();
				var top = t.top;
				var panelTop = panelPoss.top;
				openMenuHt = openObj.outerHeight() || 100;
				var gap = (top - panelTop)  + openMenuHt;	
				if(panel.height() < gap){
					panel.css('min-height', gap+'px');
				}
				
			}else{
				panel.css('min-height', '150px');
			}
		}, 200);
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}

	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	$(document).on(APP.eventObj.ON_NICE_SELECT_CLICK, function (e) {
		extendActivityHeight();
	});
	
	function updateTemplateLayout() {
		extendActivityHeight();
	}
}