function InputBoxQuestion() {
	var _this = this;
	var Selector = {};
	var feedbackAudio = '';
	var time = new Date();
	var startTime;
	
	var defaultValue="-blank-";
	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'input-box-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			INPUT_PANEL_CLASS: 'input-panel',
			INPUT_BOX_CLASS: 'input-box',
			IS_ASSESSMENT: false,
			CURRENT_QUESTION: 0,
			SHOW_PREVIOUS_SELECTION: false,
			ANIMATE_INCORR_OPTION: true,
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
			SOUND_OBJ: {
				blank: 'blank',
				correct: 'correct',
				incorrect: 'incorrect',
				partialCorrect: 'incorrect'
			},
			QUE_IMAGES_PRE_PATH: '',
			QUE_SVG_IMG_PRE_PATH: '',
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CHANGE: null,
			ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			isCompleted:false,
			queObj:null,
			

		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
	_this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];	
		Selector.answerArray = [];	
		Selector.isCompleted = false;	
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}
				
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			initialRender();
		}		
	}

	function getHTML() {
		//--WIP template for Assessment quiz
		Selector.userArray = [];
		
		var str = "";
		Selector.queObj = APP.configObj.assessment.finalAssessmentObj[Selector.CURRENT_QUESTION];
		
		var _className = Selector.queObj.className || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		
		/* 1 */
		str += '<div id="' + _id + '" class="question ' + _className + ' ' + _id + ' " style="' + _style + '">';
		
		if (APP.configObj.assessment.showAnswerForTesting) {
			str += '<span class="ans-value-txt"></span>';
		}
		/* 2 */
		str += '<div class="que-txt-panel">';
		var txtObj = Selector.queObj.questionText[0].text;
		var txtLen = txtObj.length;
		for (var i = 0; i < txtLen; i++) {
			var _className = txtObj[i].className || "";
			var _style = txtObj[i].style || "";
			var _txt = txtObj[i].Text;
			var _type = txtObj[i].type;
			if (_type == "custom") {
				str += '<div class="que-text ' + _className + ' custom" style="' + _style + '">' + _txt + '</div>';
			} else {
				str += '<p class="que-text ' + _className + '" style="' + _style + '">' + _txt + '</p>';
			}
		}
		/* 2 */
		str += '</div>';
		/* 3 */
		str += '<div class="dd-menu-panel">';
		/* 3 */
		str += '</div>';
		/* 1 */
		str += '</div>';
		$(Selector.ACTIVITY_PANEL).html(str);
		
		initialRender();
	}
	function initialRender(){
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		Selector.inputPanel = Selector.queDivObj.find('.'+Selector.INPUT_PANEL_CLASS);
		//validate CORRECT_ANS_ARRAY
		var totInputBox = Selector.inputPanel.length;
		if(Selector.CORRECT_ANS_ARRAY.length != totInputBox){			
			console.error('Answer are not matched with input box...');
			alert('Answer are not matched with input box...');
			return false;
		}
		//create input
		Selector.inputPanel.each(function (idx) {
			Selector.initialUserArr.push(defaultValue);
			$(this).attr('data-id', idx);
			var placeholder = $(this).data('placeholder') || "";
			var inputType = $(this).data('input-type') || "number";
			var len = $(this).data('length') || 30;			
			var rows = $(this).data('rows') || 1;			
			var str = "";
			if(inputType === 'number'){
				str += '<input class="input-box '+Selector.INPUT_BOX_CLASS+'" id="input-box_' + idx + '" data-id="' + idx + '" data-type="'+inputType+'" maxLength="'+len+'" placeholder="'+placeholder+'" type="text" >';
			}else if(inputType === 'text-number'){
				str += '<input class="input-box '+Selector.INPUT_BOX_CLASS+'" id="input-box_' + idx + '" data-id="' + idx + '" data-type="text" maxLength="'+len+'" placeholder="'+placeholder+'" type="text" >';
			}else{				 
				str += '<textarea class="text-area input-box '+Selector.INPUT_BOX_CLASS+'" id="input-box_' + idx + '" data-id="' + idx + '" data-type="'+inputType+'" maxLength="'+len+'" placeholder="'+placeholder+'" rows="'+rows+'" type="text" ></textarea>';
			}		
			
			//--added status icon
			str += '<div class="btn-icon font-icon status"></div>';
			str += '<div class="char-left-div char-left-div_'+idx+'"><span class="txt"></span></div>';
			$(this).append(str);
		});
		
		//--create answerArray
		var tempArr = Selector.CORRECT_ANS_ARRAY.slice();
		var showAnswers="Correct values - ";
		for (var i=0; i<tempArr.length; i++){
			var currObj = tempArr[i];	
			var matchingType = currObj.matchingType.toLowerCase();
			if(matchingType == "all"){
				Selector.answerArray[i] = currObj.corrValue;
			}else if(matchingType == "range"){
				var minVal = currObj.minValue;
				var maxVal = currObj.maxValue;
				Selector.answerArray[i] = minVal+"^"+maxVal;
			}
			showAnswers+=(i+1)+" is: "+Selector.answerArray[i]+", ";
		}
		//show answerDiv
		var cheatMode = APP.configObj.cheatMode;
		var ansTxt = Selector.queDivObj.find('.ans-value-txt');
		if(cheatMode){
			ansTxt.show();
			ansTxt.html(showAnswers);
		}else{			
			ansTxt.hide();
		}

		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}		
	}
	function loadPrevUserData(){
		
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			if (Selector.queObj.dataAnswerArray != null) {
				Selector.answerArray = Selector.queObj.dataAnswerArray;
			}
			if (Selector.queObj.dataUserArray != null) {
				Selector.userArray = Selector.queObj.dataUserArray;				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){
			Selector.inputPanel.each(function (idx) {
				var _id = parseInt($(this).data('id'));		
				
				var currVal = Selector.userArray[_id];
							
				if(currVal !== defaultValue){
					$(this).find('.'+Selector.INPUT_BOX_CLASS).val(currVal);
				}
			});			
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}
		
		initQuestion();
		
	}
	function initQuestion(){
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		updateValue();

		/* if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {
			
			if(Selector.queObj.dataIsUserOptionSelected){
				processSubmit({feedbackAni:false});
			}
		} */
		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
		
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			processSubmit({feedbackAni:true});			
		}
	});
	function addTemplateEvent() {
		var inputBoxObj = Selector.queDivObj.find('.'+Selector.INPUT_BOX_CLASS);
		//for disabled....
		if(assessmentQuizObj.dataReviewMode){
			inputBoxObj.focus(function(e) {
				$(this).blur();
			});
		}
		//--support only number input
		var evt="keydown keyup blur";
		if(APP.systemDetectorObj.browserName == 'ie'){
			evt= "keypress keyup blur"
		}
		inputBoxObj.on(evt,function (event) {
			if(assessmentQuizObj.dataReviewMode){return false;}
			var type = $(this).attr('type');
			if(type == 'number'){
				/* key.which
					8=backspace
					46=delete
					48-57=0 to 9
					190=.
					37-40=arrows key
				*/	
				var keyName = event.key;
				
				if(keyName == null){return false;}
				//var txtVal=$(this).val($(this).val().replace(/[^0-9\.]/g,''));
				
				
				//--condition for input only 1 period allowed...
				if((keyName == '.' && $(this).val().indexOf('.') != -1) || (keyName==' ' || keyName.toLowerCase() == 'spacebar')){
					event.preventDefault();				
				}
				// IE return arrow key as 'left, up, right, down' and delete will be 'del'
				var isArrow = (keyName.toLowerCase() == 'arrowleft' || keyName.toLowerCase() == 'arrowup' || keyName.toLowerCase() == 'arrowright' || keyName.toLowerCase() == 'arrowdown' || keyName.toLowerCase() == 'left' || keyName.toLowerCase() == 'up' || keyName.toLowerCase() == 'right' || keyName.toLowerCase() == 'down');
				
				var isNum =false;
				var keyNum = Number(keyName);
				
				if(keyNum !=NaN && keyNum!=null){
					isNum = (keyNum >=0 && keyNum<=9);
					
				}
				
				var isDelKey=false;
				if(APP.systemDetectorObj.browserName == 'ie'){
					isDelKey = (keyName.toLowerCase() == 'del');
				}else{
					isDelKey = (keyName.toLowerCase() == 'delete');
				}
				if (!isNum && !isArrow && !isDelKey && keyName.toLowerCase() != 'backspace' && keyName != '.' && keyName.toLowerCase() != 'tab' && keyName.toLowerCase() != 'home' && keyName.toLowerCase() != 'end') {
					event.preventDefault();	
					
				}			
				var _id = $(this).data('id');
				var val= $(this).val().trim() || defaultValue;
				Selector.userArray[_id]=val;
				updateValue();
			}else{
				//--have to check validation for input type = text
				var _id = $(this).data('id');
				var val= $(this).val().trim() || defaultValue;
				Selector.userArray[_id] = val;
				updateValue();
			}
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};	
			Selector.IS_SUBMIT_CLICK = 'cl';				
			processSubmit({feedbackAni:true});		
			
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
		Selector.queDivObj.find('.magnify-box').on('click', function(e){	
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			$(this).removeClass('hover');					
			var id = $(this).data('id');		
			var currPop = $(Selector.ACTIVITY_CONTAINER).find('.magnify-pop[data-id="'+id+'"]');
			//for animation				
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			aniObj.ON_COMPLETE = function(){
				
			};
			
			var isModalPop = currPop.hasClass('screen-modal-pop');
			if(isModalPop){
				//--for responsive
				$('body').addClass('modal-open');
				//--
				$('#alpha-bg').fadeIn();
				//IE hack placing pop on root level
				currPop.clone(true)
				.appendTo("#main-div")
				.fadeIn()
					
				APP.commonFunObj.updateScreenModalPopLayout();
				aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
				aniObj.ON_COMPLETE = function(){
					APP.commonFunObj.updateScreenModalPopLayout();
				}	
				APP.animationObj.animate(aniObj);
				APP.eventObj.applyGbPopCloseEvent();					
			}else{			
				currPop.show();
				if($('body').hasClass('responsive')){	
					//--check only when responsive 			
					isInView = APP.commonFunObj.isElementInView($(currPop));
					if(!isInView){
						APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
					}
				}
				APP.animationObj.animate(aniObj);		
				applyPopCloseEvent();		
			}
					
		});
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){		
		var inputBoxObj = Selector.queDivObj.find('.'+Selector.INPUT_BOX_CLASS);
		inputBoxObj.each(function(inx){
			var _this = $(this);
			var totLength = _this.attr('maxLength');
			var currLength = _this.val().length;
			var avl = totLength - currLength;
			_this.parents('.input-panel').find('.char-left-div').find('.txt').html(avl);
		})
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CHANGE) {
			Selector.ON_CHANGE({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){
		var isAllSelected = true;
		for(var i=0; i<Selector.userArray.length; i++){
			var curr = Selector.userArray[i];
			if(curr == defaultValue || curr == ''){
				isAllSelected = false;
				break;
			}
		}
		if(isAllSelected){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function EnabledDisableInputBox (_val){		
		var inputBoxObj = Selector.queDivObj.find('.'+Selector.INPUT_BOX_CLASS);
		if(inputBoxObj.length){
			if(_val){
				$(inputBoxObj)
				.removeAttr('disabled')
				.removeClass('disabled');
			}else{
				$(inputBoxObj)
				.attr('disabled', 'disabled')
				.addClass('disabled');
			}
		}	
		
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.answerArray.length
		}
		
		for (var i = 0; i < Selector.answerArray.length; i++) {
			var crrVal = Selector.answerArray[i];
			
			//for range check
			if(crrVal.indexOf('^') != -1){
				var userVal = parseFloat(Selector.userArray[i]);
				var t = crrVal.split('^');
				var minVal = parseFloat(t[0]);
				var maxVal = parseFloat(t[1]);
				
				if (userVal >= minVal && userVal <= maxVal) {
					obj.corrCount += 1;	
				}else{
					if (Selector.userArray[i] != defaultValue) {
						obj.inCorrCount += 1;
					}
				}
			}else{
				var userVal = Selector.userArray[i];
				//for all value check
				if (userVal == crrVal) {
					obj.corrCount += 1;
				}else{
					if (Selector.userArray[i] != defaultValue) {
						obj.inCorrCount += 1;
					}
				}
			}			
		}		
		
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		//console.log('processSubmit...');
		
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisableInputBox(false);

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){			
			Selector.isCompleted = true;			
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			showFeedback(_obj.feedbackAni);	
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}
	}
	function showFeedback(isAni){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.FEEDBACK_STATE == 'corr'){
			soundName = Selector.SOUND_OBJ.correct;
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
		}else if(Selector.FEEDBACK_STATE == 'pcorr'){		
			soundName = Selector.SOUND_OBJ.partialCorrect;		
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
		}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
			soundName = Selector.SOUND_OBJ.partialCorrect;			
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
			if(plfObj.length){
				currFeedback = plfObj;
			}else if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}					
			
		}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){
			soundName = Selector.SOUND_OBJ.incorrect;			
			//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
			var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
			if(lfObj.length){
				currFeedback = lfObj;
			}else{
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}								
			
		}else{
			soundName = Selector.SOUND_OBJ.incorrect;
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
		}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		//console.log('feedbackAudio: '+feedbackAudio);
		$(currFeedback).find('.scroll-parent').scrollTop(0);
		aniObj.ON_COMPLETE = function(){
			
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.EL.find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}
			APP.eventObj.applyGbPopCloseEvent();							
		}else{	
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			currFeedback.find('.scroll-parent').scrollTop(0);
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
				
			}			
			if(isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
		
	}
	
	function resetQuestion(){
		EnabledDisableInputBox(true);
    	Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		//--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.inputPanel.removeClass('tick cross animated headShake');	
		Selector.inputPanel.find('.status').removeClass('i-tick').removeClass('i-cross').removeClass('visibility-hidden');
		$(Selector.FEEDBACK_CONTAINER).hide();
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		Selector.userArray = Selector.initialUserArr.slice();
		Selector.inputPanel.each(function (idx) {			
			$(this).find('.'+Selector.INPUT_BOX_CLASS).val('');			
		});			
		initQuestion();	
		if (Selector.ON_TRY_AGAIN) {
			Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		//to hide status icon
		Selector.inputPanel.find('.status').addClass('visibility-hidden');

		for (var i = 0; i < Selector.answerArray.length; i++) {
			var crrVal = Selector.answerArray[i];
			
			var found = false;
			//for range check
			if(crrVal.indexOf('^') != -1){
				var userVal = parseFloat(Selector.userArray[i]);
				var t = crrVal.split('^');
				var minVal = parseFloat(t[0]);
				var maxVal = parseFloat(t[1]);
				
				if (userVal >= minVal && userVal <= maxVal) {
					
				}else{
					Selector.inputPanel.eq(i).find('.'+Selector.INPUT_BOX_CLASS).val(minVal);
				}
			}else{
				var userVal = Selector.userArray[i];
				//for all value check
				if (userVal == crrVal) {
					
				}else{
					Selector.inputPanel.eq(i).find('.'+Selector.INPUT_BOX_CLASS).val(crrVal);
				}
			}			
		}	
	}
	function showUserSelection(){
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);
		//to show status icon
		Selector.inputPanel.find('.status').removeClass('visibility-hidden');
			
		for(var i=0; i<Selector.userArray.length; i++){	
			if (Selector.userArray[i] != defaultValue) {		
				var op = Selector.userArray[i];	
				Selector.inputPanel.eq(i).find('.'+Selector.INPUT_BOX_CLASS).val(op);
			}
		}
	}
	function showTickCorss(){	
		for (var i = 0; i < Selector.answerArray.length; i++) {
			var crrVal = Selector.answerArray[i];
			
			var curr = Selector.inputPanel.eq(i);
			var val = '';
			//for range check
			if(crrVal.indexOf('^') != -1){
				var userVal = parseFloat(Selector.userArray[i]);
				var t = crrVal.split('^');
				var minVal = parseFloat(t[0]);
				var maxVal = parseFloat(t[1]);
				
				if (userVal >= minVal && userVal <= maxVal) {
					val = 'correct';
				}else{
					if (userVal != defaultValue) {	
						val = 'incorrect';
					}
				}
			}else{
				var userVal = Selector.userArray[i];
				//for all value check
				if (userVal == crrVal) {
					val = 'correct';
				}else{
					if (userVal != defaultValue) {	
						val = 'incorrect';						
					}
				}
			}	
			if(val == 'correct'){
				curr.removeClass('cross')
				.addClass('tick');	

				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.removeClass('i-cross')					
				.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
				.addClass('i-tick');
			}else{
				curr.removeClass('tick')
				.addClass('cross');	

				curr.find('.status')
				.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)		
				.removeClass('i-tick')			
				.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
				.addClass('i-cross');
			}		
		}		
	}
	function animateIncorrectOption(){
		for (var i = 0; i < Selector.answerArray.length; i++) {
			var crrVal = Selector.answerArray[i];
			
			var curr = Selector.inputPanel.eq(i);
			var val = '';
			//for range check
			if(crrVal.indexOf('^') != -1){
				var userVal = parseFloat(Selector.userArray[i]);
				var t = crrVal.split('^');
				var minVal = parseFloat(t[0]);
				var maxVal = parseFloat(t[1]);
				
				if (userVal >= minVal && userVal <= maxVal) {
					val = 'correct';
				}else{
					if (userVal != defaultValue) {	
						val = 'incorrect';
					}
				}
			}else{
				var userVal = Selector.userArray[i];
				//for all value check
				if (userVal == crrVal) {
					val = 'correct';
				}else{
					if (userVal != defaultValue) {	
						val = 'incorrect';						
					}
				}
			}	
			if(val == 'correct'){
				
			}else{
				//curr.addClass('animated headShake');
				TweenMax.to(curr, 0.1, {
					x: '+=10',
					yoyo: true,
					repeat: 3,
					clearProps: "all"							
				});	
			}		
		}	
	}	
	function updateStatus() {
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataassessmentQuizObj.dataReviewMode) {
			Selector.queObj.dataUserArray = Selector.userArray;
			Selector.queObj.dataAnswerArray = Selector.answerArray;
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			/* var obj = {
				corrCount: 0,
				inCorrCount: 0,
				allCorrected: false,
				totalCorrCount: 0
			   } */
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (assessmentQuizObj.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partiallyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
					
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}

	function updateTemplateLayout() {
		scalex = APP.scalex || 1;			
	}
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	
}
