function SlidingScaleQuestion() {
	var _this = this;
	var Selector = {};	
	var feedbackAudio = '';
	var defaultValue = -1;
	var time = new Date();
	var startTime;
	var scalex = APP.scalex || 1;
	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];
	var coverflowTemplate = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'sliding-scale-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',						
			DRAG_ITEM_CLASS: 'drag-item',
			DROP_ITEM_CLASS: 'drop-item',	
			//type will be 'horizontal-slide','vertical-slide'
			TYPE: 'horizontal-slide',		
			IS_ASSESSMENT: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
      		IS_OPTIONWISE_FEEDBACK: false,
			ANIMATE_INCORR_OPTION: true,
			THRESHOLD: '10%',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			DEFAULT_POSS_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: '',
				optSelected: '',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
			SOUND_OBJ: {
				blank: 'blank',
				correct: 'correct',
				incorrect: 'incorrect',
				partialCorrect: 'incorrect'
			},
			QUE_IMAGES_PRE_PATH: '',
			QUE_SVG_IMG_PRE_PATH: '',
			ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_SHOW_ME: null,
			ON_CLICK: null,
			ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			NO_OF_ATTEMPTS: 0,
			CURRENT_ATTEMPT: 0,
			FEEDBACK_STATE:'',
			IS_SUBMIT_CLICK: 'na',
			QUE_INTRACTION_OBJ: {},
			SEND_INTRACTION: false,
			isCompleted:false,
     		queObj:null,
			
		};
		Selector = $.extend(true, Selector, _obj);
		initTemplate();
	}
	_this.EnabledDisableDrag = function(_str){
		EnabledDisableDrag(_str);
	}
  _this.resetQuestion = function(){
		resetQuestion();
	}
	_this.getUserArray = function(){
		return Selector.userArray;
	}
	_this.getCurrentAttempt= function(){
		return Selector.CURRENT_ATTEMPT;
	}
	_this.getfeedbackState= function(){
		return Selector.FEEDBACK_STATE;
	}
	_this.processSubmit = function(){
		processSubmit({feedbackAni:true, autoOpen:false});
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];		
		Selector.initialDefaultPossArr = [];		
		Selector.isCompleted = false;			
		if(Selector.SHOW_PREVIOUS_SELECTION){

		}else{
			Selector.CURRENT_ATTEMPT = 0;
			Selector.FEEDBACK_STATE = '';
			Selector.IS_SUBMIT_CLICK = 'na';
		}
				
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			//-- for inline cmi intraction
			startTime = time;
			initialRender();
		}
	}
	function getHTML() {
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		//this is for global images
	/* 	if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
			var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
			$('#global-bg').css({
				'background-image':'url('+path+')',
				'background-position': 'center'
			});
		} */
		var _className = Selector.queObj.className || "";
		var _subType = Selector.queObj.subType || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		/* 1 */str += '<div class="activity-panel" >';		
		/* 2 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _subType + ' ' + _id + ' " style="' + _style + '">';		
				str += '<div class="sb-que-ref"></div>';
				str += '<span class="ans-value-txt"></span>';
			/* 3 */str += '<div class="que-txt-panel">';		
					str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);	
				/* 3 */str += '</div>';
			/* 4 */str += '<div class="option-block">';	
				/* 4a */str += '<div class="table-div display-table">';
					//create header	
					str += '<div class="title-row display-row" >';
						//option title cell
						str += '<div class="option-txt-cell display-cell v-center center"></div>';
						str += '<div class="option-title-cell display-cell v-center center">';
							str += '<div class="title-flex-box">';
								var headerObj = Selector.queObj.header[0].headerText;
								for (var i = 0; i < headerObj.length; i++) {					
									var _className = headerObj[i].className || "";
									var _style = headerObj[i].style || "";
									var _txt = headerObj[i].Text;
									str += '<div class="title-cell '+_className+' " style="' + _style + '">';
										str += '<span class="txt" >'+_txt+'</span>';
										str += '<span class=" icon1 font-icon icon-triangle-bottom"></span>';
									str += '</div>';
								}								
							str += '</div>';
						str += '</div>';
					str += '</div>';
					//end header
					//create option row
					var optionObj = Selector.queObj.options[0].option;
					for (var j = 0; j < optionObj.length; j++) {					
						var _className = optionObj[j].className || "";
						var _style = optionObj[j].style || "";
						var _txt = optionObj[j].Text;
						var _correctId = optionObj[j].correctId.toLowerCase();	
									
						if (_correctId != "na") {								
							//--logic for multiple correct option
							//Selector.CORRECT_ANS_ARRAY
							var arr =_correctId.split(',');	
							Selector.CORRECT_ANS_ARRAY[j] = [];					
							for(var m=0; m<arr.length; m++){	
								Selector.CORRECT_ANS_ARRAY[j][m] = arr[m];
							}
						}
						str += '<div class="option-row display-row" >';
							str += '<div class="txt-cell display-cell v-center left '+_className+' " style="' + _style + '">';
								str += '<span class="txt" >'+_txt+'</span>';
							str += '</div>';
							str += '<div class="btn-cell display-cell v-center center">';
								str += '<div class="liner"><span class="line"></span></div>';
								str += '<div class="drop-panel">';
									for (var k = 0; k < headerObj.length; k++) {
										str += '<div class="drop-item " >';
											str += '<div class="drag-area-panel">';
												str += '<div class="drag-area centered"><span class="bg"></span></div>';	
											str += '</div>';
										str += '</div>';
									}
								str += '</div>';
								str += '<div class="drag-panel">';
									str += '<div class="drag-item">';
										str += '<div class="btn-icon font-icon status"></div>';
									str += '</div>';
								str += '</div>';	
							str += '</div>';
						str += '</div>';
					}
					//end option row					
				/* 4a */str += '</div>';
			/* 4 */str += '</div>';
			
			/* 5 */str += '<div class="display-block submit-panel">';			
					str += '<div class=" btn-panel border-btn clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn disabled" href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML.globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';									
			/* 5 */str += '</div>';	
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = APP.globalXmlsObj.assessmentXML.globalText[0].feedbacks[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " >';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';	
									str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);	
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML.globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = APP.globalXmlsObj.assessmentXML.globalText[0].feedbacks[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " >';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML.globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partiallyCorrect-pop
					var prcorrFeedTxtObj = APP.globalXmlsObj.assessmentXML.globalText[0].feedbacks[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " >';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML.globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';			
			/* 2 */str += '</div>';
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}

	function initialRender() {		
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);
		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		//validate CORRECT_ANS_ARRAY
		//-- for inline cmi intraction
		Selector.QUE_INTRACTION_OBJ.type = 'slidingScale'; 
		Selector.QUE_INTRACTION_OBJ.options = [];
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
		//--
		var totOpt = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){	
			Selector.initialDefaultPossArr[inx] = 0;
			$(this).attr('id', Selector.DRAG_ITEM_CLASS+'_'+inx);
			$(this).attr('data-index', inx);			
						
		});
		Selector.queDivObj.find('.option-row').each(function(inx){	
			Selector.initialUserArr[inx] = defaultValue;
			Selector.QUE_INTRACTION_OBJ.options[inx] = [];	
			var row = $(this);			
			$(row).find('.'+Selector.DROP_ITEM_CLASS).each(function (jnx){
				$(this).addClass(Selector.DROP_ITEM_CLASS+'_'+inx+'-'+jnx)
				.attr('id', Selector.DROP_ITEM_CLASS+'_'+inx+'-'+jnx)
				.attr('data-index', jnx)
				.attr('data-row-id', inx)
				.attr('data-col-id', jnx);		
				//-- for inline cmi intraction
				Selector.QUE_INTRACTION_OBJ.options[inx][jnx] = $(this).find('.opt-text p').text();
				//--		
			})
		});		
		
		Selector.answerArray = Selector.CORRECT_ANS_ARRAY.slice();
		
		
		initOptionData();		
		//-- for better animation when SHOW_PREVIOUS_SELECTION is true
		//if (!Selector.IS_ASSESSMENT) {
			loadPrevUserData();
			addTemplateEvent();	
		/* }else{
			//listen APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE event below
		} */
		APP.preloaderObj.hide();	
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}	
	}
	function initOptionData(){
		if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
			//Selector.queDivObj.find('.drop-item').shuffle();
			Selector.queDivObj.find('.option-row').shuffle();
			//--move header row always top
			Selector.queDivObj.find('.title-row').parent().prepend($('.title-row'));
		}
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){	
			var x=0;
			var y=0;			
			var refId = $(this).data('index');		
			$(this).data({
                'refId': refId,
                'dropBox': null,
				'dropBoxInner': null,
				'origLeft': x,
                'origTop': y                
            });
		});
		Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).each(function(inx){	
			var refId = $(this).data('index');			
			$(this).data({
                'refId': refId,               
				'isOccupied': false							
			});
			$(this).find('.drag-area-panel').data('isOccupied', false);
			
		});
		//-- for default position setting
		if(Selector.DEFAULT_POSS_ARRAY.length == 0 || Selector.DEFAULT_POSS_ARRAY == null){
			//always set to initial 0 position
			Selector.DEFAULT_POSS_ARRAY = Selector.initialDefaultPossArr.slice();
		}
		
		if(Selector.DEFAULT_POSS_ARRAY != null && Selector.DEFAULT_POSS_ARRAY.length){
			for(var i=0; i<Selector.DEFAULT_POSS_ARRAY.length; i++){
				var curr=Selector.DEFAULT_POSS_ARRAY[i];
				if(curr != defaultValue){
					if(typeof(curr) == 'string'){
						$(Selector.ACTIVITY_CONTAINER).addClass('default-poss-satic');
						var dragPanel = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i).parent('.drag-panel');
						var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i);
						var _x = 0;
						var _y = 0;						
						if(Selector.TYPE == 'vertical-slide'){
							//--for horizontal center
							_x = 0;
							_y = curr;

						}else{
							_x = curr;
							//--for vertical center							
							_y = 0;
						}
						TweenMax.to(drag, 0.0, {
							x: _x,
							y: _y,							
							onComplete: function(){
								$(this.target).data('origLeft', _x);
								$(this.target).data('origTop', _y);
							}
						});	
					}else{
						$(Selector.ACTIVITY_CONTAINER).addClass('default-poss-option');
						var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i);
						var drop = Selector.queDivObj.find('#'+Selector.DROP_ITEM_CLASS+'_'+i+'-'+curr);
						var dArea = drop.find('.drag-area-panel');
					
						drag.data('dropBox', drop);
						drag.data('dropBoxInner', dArea);
						var dropBoxInner = drag.data('dropBoxInner'); 
						var x=0;
						var y=0;
						var rect1 = $(drag).get(0).getBoundingClientRect();					
						var rect2 = $(dropBoxInner).find('.drag-area').get(0).getBoundingClientRect();
						
						x = "+=" + (rect2.left/scalex - rect1.left/scalex);
						y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
						
						TweenMax.to(drag, 0.0, {
							x: x,
							y: y,
							onComplete: function(){
								$(this.target).data('origLeft', 0);
								$(this.target).data('origTop', 0);
							}
						});					
						drag.addClass('dropped');
						dropBoxInner.data('isOccupied', true);
					}
				}
			} 
		}
		//--
		
		updateTemplateLayout();
		showAnsValue();
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;
		var $ansTxt=Selector.queDivObj.find('.ans-value-txt');
		
		if(cheatMode){			
			var showAns = '';	
			Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){	
				var id = parseInt($(this).data('index'));
				showAns += 	Selector.answerArray[id].join('^');
				if(inx != Selector.answerArray.length - 1){
					showAns+= ',';
				}		
			})
			
			$ansTxt.show();
			$ansTxt.html(showAns);
		}else{			
			$ansTxt.hide();
		}
	}
	function loadPrevUserData(){
		
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					newArr.push(tempAnsArr[i].split(','));					
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			if (Selector.queObj.dataUserArray != null) {
				Selector.userArray = Selector.queObj.dataUserArray;				
				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		//--previous position not shown due to animation...
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){
			for(var i=0; i<Selector.userArray.length; i++){
				var curr=Selector.userArray[i];
				if(curr != defaultValue){
					var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i);
					var drop = Selector.queDivObj.find('#'+Selector.DROP_ITEM_CLASS+'_'+i+'-'+curr);
					var dArea = drop.find('.drag-area-panel');
				
					drag.data('dropBox', drop);
					drag.data('dropBoxInner', dArea);
					var dropBoxInner = drag.data('dropBoxInner'); 
					var x=0;
					var y=0;
					var rect1 = $(drag).get(0).getBoundingClientRect();					
					var rect2 = $(dropBoxInner).find('.drag-area').get(0).getBoundingClientRect();
					
					 x = "+=" + (rect2.left/scalex - rect1.left/scalex);
					 y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
					
					 TweenMax.to(drag, 0.3, {
						x: x,
						y: y
					  });
					
					drag.addClass('dropped');
					dropBoxInner.data('isOccupied', true);
				}
			} 
		}else{
			Selector.userArray = Selector.initialUserArr.slice();
		}	
		initQuestion();			
	}
	
	function initQuestion(){		
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
    	EnabledDisabledBtn('.view-feedback-btn', false);
		updateValue();		
		/* if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			processSubmit({feedbackAni:true});			
		} */
	}
	//--wait to complete on screen animation
	$(document).one(APP.eventObj.ON_INITIAL_ANIM_COMPLETE, function (e) {		
		if (Selector.SHOW_PREVIOUS_SELECTION && Selector.FEEDBACK_STATE !='') {
			Selector.IS_SUBMIT_CLICK = 'na';
			Selector.QUE_INTRACTION_OBJ.dataTobeSend = false;	
			if(Selector.IS_PRE_TEST){
				processSubmit({feedbackAni:true, autoOpen:true});
			}else{
				processSubmit({feedbackAni:true, autoOpen:true});
			}
		}
	}); 
	function addTemplateEvent() {
		
		var $dragBox = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS);
		$dragBox.hover(function(){
			if($(this).hasClass('disabled')){return false;};
				$(this).addClass('hover');
				
			}, function(){
				$(this).removeClass('hover');
		});
		$dragBox.on('click',function(){
			if($(this).hasClass('disabled')){return false;};
			//$(this).addClass('hover');
			
		});
		var tp="x"
		//type will be 'horizontal-slide','vertical-slide'			
		if(Selector.TYPE == 'vertical-slide'){
			tp="y"
		}
		var animation = null;
		 Selector.draggables = Draggable.create($dragBox, {
			type: tp,
			bounds: Selector.queDivObj.find('.liner .line'),
			cursor:"grab",
			zIndexBoost: true,
			throwProps:true,
			//--for mobile autoScroll
			autoScroll:0,
			onDragStart: function() {
				animation = TweenMax.to($(this.target), 0.3, {
					boxShadow: "rgba(0,0,0,0.2) 0px 16px 32px 0px",
					force3D: true,
					scale: 1.0,
					paused: true
				  });
				  animation.play();
				$(this.target).css('cursor','grabbing');				
				var dropBox = $(this.target).data('dropBox');
				var dropBoxInner = $(this.target).data('dropBoxInner'); 
				$(this.target).removeClass('dropped');
                if (dropBox !== null)
                {
					$(dropBoxInner).data('isOccupied', false);
					Selector.userArray[$(this.target).data('refId')] = defaultValue;
                }
                $(this.target).data('dropBox', null);
                $(this.target).data('dropBoxInner', null);
			},
			onDrag: function() {
				
				var $dropBox = $(this.target).parents('.option-row').find('.'+Selector.DROP_ITEM_CLASS);
				for (var i = 0; i < $dropBox.length; i++) {      
					var dropTile = $dropBox[i];	
					var dArea=$(dropTile).find('.drag-area-panel');				
					if (dArea.data('isOccupied')) {					  
					  // continue to next loop iteration
					  // drop tile already isOccupied, so no need to proceed any further
					  	$(this.target).removeClass('dropped');
					  	$(this.target).data('dropBox', null);
						$(this.target).data('dropBoxInner', null);
					  continue;
					}					
					if (this.hitTest(dropTile, Selector.THRESHOLD)) {					  
					  // we hit an empty drop tile, so link the two together and exit the function
						$(this.target).data('dropBox', $(dropTile));
						$(this.target).data('dropBoxInner', dArea);
					  return;
					}else{
						$(this.target).removeClass('dropped');
					  	$(this.target).data('dropBox', null);
						$(this.target).data('dropBoxInner', null);
					}
				}
			
			},	
			onRelease: function() {
				if(animation){animation.reverse();}				
			},		
			onDragEnd:function() {
				
				var dropBox = $(this.target).data('dropBox');
				var dropBoxInner = $(this.target).data('dropBoxInner');
				var x = 0;
  				var y = 0;
				APP.commonFunObj.playSoundEffect({name: 'dragNDrop'});
				if (dropBox !== null){					
					var rect1 = this.target.getBoundingClientRect();					
					var rect2 = $(dropBoxInner).find('.drag-area').get(0).getBoundingClientRect();
					
					 x = "+=" + (rect2.left/scalex - rect1.left/scalex);
					 y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
					
					 TweenMax.to(this.target, 0.3, {
						x: x,
						y: y
					  });
					$(this.target).addClass('dropped');
					$(dropBoxInner).data('isOccupied', true);
					Selector.userArray[$(this.target).data('refId')] = dropBox.data('refId');
					
				}else {					
					TweenMax.to(this.target,0.3,{
						x:$(this.target).data('origLeft'),
						y:$(this.target).data('origTop')
					});
					
                    $(this.target).removeClass('dropped');
					
                    $(this.target).data('dropBox', null);
                    $(this.target).data('dropBoxInner', null);
					if(dropBoxInner){
						$(dropBoxInner).data('isOccupied', false);
					}                    
				}				
				updateValue();
			}
		});
		Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).find('.drag-area-panel').on('click',function(){			
			var _this = $(this).parents('.drop-item');
			if(_this.hasClass('de-active') || _this.hasClass('disabled')){return false;}
			var dData = _this.data();			
			var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+dData.rowId);
			var drop = _this;
			var dArea = drop.find('.drag-area-panel');
			//console.log('prev drop', drag.data())
			drag.removeClass('dropped');					
			drag.data('dropBox', null);
			var prevDropBoxInner = drag.data('dropBoxInner');
			
			if(prevDropBoxInner){
				$(prevDropBoxInner).data('isOccupied', false);
			} 
			drag.data('dropBoxInner', null);

			drag.data('dropBox', drop);
			drag.data('dropBoxInner', dArea);
			var dropBoxInner = drag.data('dropBoxInner'); 
			
			var x=0;
			var y=0;
			var rect1 = $(drag).get(0).getBoundingClientRect();					
			var rect2 = $(dropBoxInner).find('.drag-area').get(0).getBoundingClientRect();
			
				x = "+=" + (rect2.left/scalex - rect1.left/scalex);
				y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
			
				TweenMax.to(drag, 0.3, {
				x: x,
				y: y
				});
			
			drag.addClass('dropped');
			dropBoxInner.data('isOccupied', true);
			Selector.userArray[drag.data('refId')] = drop.data('refId');
			updateValue();
		})
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).hover(function(){
			if($(this).hasClass('disabled')){return false;};
				$(this).addClass('hover');
			}, function(){
				$(this).removeClass('hover');
		});

		Selector.queDivObj.find('.submit-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};
			Selector.IS_SUBMIT_CLICK = 'cl';					
			processSubmit({feedbackAni:true, autoOpen:true});		
			
		})
		Selector.queDivObj.find('.view-feedback-btn').on('click', function(){			
			if($(this).hasClass('disabled') ){return false;};					
			showFeedback({isAni: true, playSfx: false});
		})
		Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.FEEDBACK_STATE);
			}
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){
		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	}
	function submitBtnStatus(){
		var isAllDropped = true;
		for(var i=0; i<Selector.userArray.length; i++){
			var curr = Selector.userArray[i];
			if(curr == defaultValue){
				isAllDropped = false;
				break;
			}
		}
		if(isAllDropped){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}
	function EnabledDisableDrag (_val){
		if(Selector.draggables){
			for(var i =0; i<Selector.draggables.length; i++){
				var curr = Selector.draggables[i];
				if(_val){
					curr.enable();
					$(curr.target).removeClass('disabled');
				}else{					
					curr.disable();
					$(curr.target).addClass('disabled');
				}
			}
		}
		//--for drop-item clickable
		if(_val){
			Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).removeClass('de-active disabled');
		}else{
			Selector.queDivObj.find('.'+Selector.DROP_ITEM_CLASS).addClass('de-active disabled');
		}
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: Selector.answerArray.length,
		}
					
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr=Selector.answerArray[i];
			var found=false;
			for (var j = 0; j < crrArr.length; j++) {
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					obj.corrCount += 1;	
					found=true;
					break;
				}else{
					
				}
			}
			if(!found){
				if (Selector.userArray[i] != defaultValue) {
					obj.inCorrCount += 1;
				}
			}
		}
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(_obj){
		
		$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').hide();
		EnabledDisabledBtn('.submit-btn', false);
		EnabledDisableDrag(false);
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).addClass('disabled');

		var corrObj = getCorrectCounts();

		var isPartialFeedbackAvl = false
		if($(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct').length){
			isPartialFeedbackAvl = true;
		}
		
		if(Selector.NO_OF_ATTEMPTS == 0){
			Selector.isCompleted = true;
		}
		var allowTryAgain = true;
		if(Selector.NO_OF_ATTEMPTS != 0 && Selector.CURRENT_ATTEMPT >= (Selector.NO_OF_ATTEMPTS - 1)){			
			allowTryAgain = false;
			Selector.isCompleted = true;
		}
		if(corrObj.allCorrected){
			showTickCorss();
			Selector.isCompleted = true;
			Selector.FEEDBACK_STATE = 'corr';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else if(isPartialFeedbackAvl && corrObj.corrCount > 0 && allowTryAgain){
			Selector.FEEDBACK_STATE = 'pcorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(allowTryAgain) {
			Selector.FEEDBACK_STATE = 'incorr';
			EnabledDisabledBtn('.try-again-btn', true);
			EnabledDisabledBtn('.show-ans-btn', false);
			EnabledDisabledBtn('.view-feedback-btn', true);
			if(Selector.NO_OF_ATTEMPTS == 0){
				showTickCorss();
				EnabledDisabledBtn('.show-ans-btn', true);
			}
		}else if(corrObj.corrCount > 0 && !allowTryAgain){
			showTickCorss();
			Selector.FEEDBACK_STATE = 'pcorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}else{
			showTickCorss();
			Selector.FEEDBACK_STATE = 'incorr-l-a';
			EnabledDisabledBtn('.try-again-btn', false);
			EnabledDisabledBtn('.show-ans-btn', true);
			EnabledDisabledBtn('.view-feedback-btn', true);
		}
		if(Selector.ANIMATE_INCORR_OPTION){
			animateIncorrectOption();
		}
		if($(Selector.FEEDBACK_CONTAINER).length){
			$(Selector.FEEDBACK_CONTAINER).removeClass('hide');
			if(_obj.autoOpen){
				showFeedback({isAni: _obj.feedbackAni, playSfx:true});
			}				
		}else{
			//no feedback
		}	
		updateStatus();
		if (Selector.IS_ASSESSMENT) {
			//$(this).parents('.submit-panel').addClass('hide');	
		}
		if (Selector.ON_SUBMIT) {
			Selector.ON_SUBMIT({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk:Selector.IS_SUBMIT_CLICK});
		}
	
	}
	function showFeedback(_obj){		
		if($(Selector.FEEDBACK_CONTAINER).length <=0){return false;}
		var currFeedback = null;
		var soundName = '';
		if(Selector.IS_OPTIONWISE_FEEDBACK === true && Selector.userArray.length === 1){
			//work only if single slider
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName = Selector.SOUND_OBJ.correct;
			}else{
				soundName = Selector.SOUND_OBJ.incorrect;		
			}
			currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.option-feedback-'+Selector.userArray[0]);
		}else{
			if(Selector.FEEDBACK_STATE == 'corr'){
				soundName = Selector.SOUND_OBJ.correct;
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.correct');
			}else if(Selector.FEEDBACK_STATE == 'pcorr'){	
				soundName = Selector.SOUND_OBJ.partialCorrect;			
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct:not(.last-attempt)');
			}else if(Selector.FEEDBACK_STATE == 'pcorr-l-a'){	
				soundName = Selector.SOUND_OBJ.partialCorrect;			
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var plfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.partial-correct.last-attempt');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt');
				if(plfObj.length){
					currFeedback = plfObj;
				}else if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}					
				
			}else if(Selector.FEEDBACK_STATE == 'incorr-l-a'){	
				soundName = Selector.SOUND_OBJ.incorrect;				
				//Selector.queDivObj.find('.bottom-btn-panel').addClass('hide');
				var lfObj = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect.last-attempt')
				if(lfObj.length){
					currFeedback = lfObj;
				}else{
					currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
				}								
				
			}else{
				soundName = Selector.SOUND_OBJ.incorrect;
				currFeedback = $(Selector.FEEDBACK_CONTAINER).find('.popup.incorrect:not(.last-attempt)');
			}
		}
		$(Selector.FEEDBACK_CONTAINER).show();
		var aniObj = APP.animationObj.generateAniObj($(currFeedback));
		feedbackAudio = $(currFeedback).data('audioPath') || '';
		$(currFeedback).find('.scroll-parent').scrollTop(0);
		//console.log('feedbackAudio: '+feedbackAudio);
		aniObj.ON_COMPLETE = function(){
			
			if(feedbackAudio != null && feedbackAudio != ''){
				APP.commonFunObj.playScreenAudio({
					path: feedbackAudio,
					onPlay: function(){
					},
					onEnd: function(){								
					}
				});
			}else{
				APP.commonFunObj.playSoundEffect({name: soundName});	
			}
		}
		
		if(currFeedback.hasClass('screen-modal-pop')){
			//--for responsive
			$('body').addClass('modal-open');
			//--
			$('#alpha-bg').fadeIn();
			//IE hack placing pop on root level
			currFeedback.clone(true, true)
			.appendTo("#main-div").fadeIn();
			//--for init modal window templates...
			if (Selector.ON_MODAL_POP_SHOW) {
				Selector.ON_MODAL_POP_SHOW();
			}
			APP.commonFunObj.updateScreenModalPopLayout();
			aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
			aniObj.EL.find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				APP.commonFunObj.updateScreenModalPopLayout();
				//--for popup el animation			
				var aniEl = $('#main-div > .screen-modal-pop').find('.modal-alert').find('.pop-ani-el');
				if(aniEl.length){
					aniEl.each(function(inx){
						$(this).removeClass('visibility-hidden'); 
						var aniObj = APP.animationObj.generateAniObj($(this));
						aniObj.ON_COMPLETE = function(){
							
						}
						APP.animationObj.animate(aniObj);
					})
				}
				//--
				if(feedbackAudio != null && feedbackAudio != ''){
					APP.commonFunObj.playScreenAudio({
						path: feedbackAudio,
						onPlay: function(){
						},
						onEnd: function(){								
						}
					});
				}else{					
					APP.commonFunObj.playSoundEffect({name: soundName});							
        		}				
			}		
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}	
			APP.eventObj.applyGbPopCloseEvent();						
		}else{	
			
			currFeedback.show();
			if(coverflowTemplate){
				coverflowTemplate.destroySwiper();
			}
			if(currFeedback.find('.coverflow-activity').length){
				coverflowTemplate = new CoverflowScreen();				
				coverflowTemplate.start({
					CLASS_NAME: 'coverflow-screen',
					ACTIVITY_CONTAINER: currFeedback.find('.coverflow-activity'),
					ACTIVITY_SLIDE_CLASS: 'swiper-slide',					
					USE_SCREEN_LEVEL_NAV: true,
					PARAM_OBJ:{	
						//--effect: Could be "slide", "fade", "cube", "coverflow" or "flip"
						effect: 'slide',	
						//--direction: Could be 'horizontal' or 'vertical'
						direction: 'horizontal',			
						pagination: {
							el: currFeedback.find('.coverflow-activity').find('.swiper-pagination').eq(0),
							//type: Could be "bullets", "fraction", "progressbar" or "custom"
							type: 'bullets',
						},
						navigation: {
							nextEl: currFeedback.find('.coverflow-activity').find('.swiper-next'),
							prevEl: currFeedback.find('.coverflow-activity').find('.swiper-back'),
						}
					},	
					ON_INIT: function(_obj){
						
					},
					ON_CLICK: function(_obj){							
						
						if (_obj.swiObj.isEnd) {
	
						}
					},					
					ON_COMPLETE: function(){						
						
					}			
				})
			}	
			if(currFeedback.find('.tab-activity').length){
				var tabTemplate = new TabScreen();
				tabTemplate.start({
					CLASS_NAME: 'tab-screen',			
					ACTIVITY_CONTAINER: currFeedback.find('.tab-activity'),						
					SHOW_MULTI_POP: false,
					ON_CLICK: function(_obj){
						/* _self.updateStatus({arr: _obj.arr, templateIndex:'00'}); */
					},
					ON_COMPLETE: function(){						
						
					}
				})
			}		
			currFeedback.find('.scroll-parent').scrollTop(0);
			if($('body').hasClass('responsive')){	
				//--check only when responsive 			
				isInView = APP.commonFunObj.isElementInView($(currFeedback));
				if(!isInView){
					APP.commonFunObj.scrollToElement($(currFeedback), true, 'top', -200);
				}
			}			
			if(_obj.isAni == true){
				APP.animationObj.animate(aniObj);
			}
			//--for popup el animation
			var aniEl = $(currFeedback).find('.pop-ani-el');
			if(aniEl.length){
				aniEl.each(function(inx){
					$(this).removeClass('visibility-hidden'); 
					var aniObj = APP.animationObj.generateAniObj($(this));
					aniObj.ON_COMPLETE = function(){
						
					}
					APP.animationObj.animate(aniObj);
				})
			}
			//--
			applyPopCloseEvent();
		}
		
	}
		
	function resetQuestion(){
		Selector.CURRENT_ATTEMPT++;
		Selector.FEEDBACK_STATE = '';
		Selector.IS_SUBMIT_CLICK = 'na';
		Selector.QUE_INTRACTION_OBJ.dataTobeSend = true;
   		 //--to remove feedback audio
		if(feedbackAudio != null && feedbackAudio != ''){
			APP.commonFunObj.removeScreenAudio();
		}
		//--
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).removeClass('selected corr-ans tick cross disabled dropped');
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status')
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
		.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
		.removeClass('i-tick i-cross visibility-hidden');
		$(Selector.FEEDBACK_CONTAINER).hide();

		EnabledDisableDrag(true);
		$(Selector.FEEDBACK_CONTAINER).find('.popup').hide();	
		Selector.userArray = Selector.initialUserArr.slice();
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).each(function(inx){
			//time will be 0 to prevent default position jurk
			TweenMax.to($(this),0.0,{
				x: $(this).data('origLeft'),
				y: $(this).data('origTop'),
				onComplete: function(){
					initOptionData();		
					initQuestion();
				}
			});
		})	
		if (Selector.ON_TRY_AGAIN) {
		Selector.ON_TRY_AGAIN({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE, clk: Selector.IS_SUBMIT_CLICK});
		}	
	}

	function showAnswer(){		
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', true);
		//to hide status icon
		Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').addClass('visibility-hidden');
	
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr = Selector.answerArray[i];
			var found = false;
			for (var j = 0; j < crrArr.length; j++) {	
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					found=true;
					break;
				}else{
					
				}
			}
			if(!found){							
				var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i);
				var drop = Selector.queDivObj.find('#'+Selector.DROP_ITEM_CLASS+'_'+i+'-'+crrArr[0]);
				var x=0;
				var y=0;
				var rect1 = $(drag).get(0).getBoundingClientRect();					
				var rect2 = $(drop).find('.drag-area').get(0).getBoundingClientRect();
				
				x = "+=" + (rect2.left/scalex - rect1.left/scalex);
				y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
				
				TweenMax.to(drag, 0.3, {
					x: x,
					y: y
				});				
			}
		}	
		if (Selector.ON_SHOW_ME) {
			Selector.ON_SHOW_ME({arr:Selector.userArray, atp:Selector.CURRENT_ATTEMPT, sts: Selector.FEEDBACK_STATE});
		}
	}
	function showUserSelection(){
		EnabledDisabledBtn('.show-user-selection-btn', false);
		EnabledDisabledBtn('.show-ans-btn', true);		
	
		for(var i=0; i<Selector.userArray.length; i++){	
			if (Selector.userArray[i] != defaultValue) {			
				var drag = Selector.queDivObj.find('#'+Selector.DRAG_ITEM_CLASS+'_'+i);
				var drop = Selector.queDivObj.find('#'+Selector.DROP_ITEM_CLASS+'_'+i+'-'+Selector.userArray[i]);
				var x=0;
				var y=0;
				var rect1 = $(drag).get(0).getBoundingClientRect();					
				var rect2 = $(drop).find('.drag-area').get(0).getBoundingClientRect();
				
				x = "+=" + (rect2.left/scalex - rect1.left/scalex);
				y = "+=" + (rect2.top/scalex - rect1.top/scalex); 
				
				TweenMax.to(drag, 0.3, {
					x: x,
					y: y,
					onComplete: function(){
						//to show status icon
						Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS).find('.status').removeClass('visibility-hidden');
					}
				});				
			}	
		}
	}
	function showTickCorss(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr=Selector.answerArray[i];
			var found=false;
			for (var j = 0; j < crrArr.length; j++) {
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					var curr = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS+'[data-index="'+i+'"]');
					curr.addClass('tick');	
					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.removeClass('i-cross')
					.addClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.addClass('i-tick');		
					found=true;
					break;
				}else{
					
				}
			}
			if(!found){
				if (Selector.userArray[i] != defaultValue) {
					var curr = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS+'[data-index="'+i+'"]');
					curr.addClass('cross');	
					curr.find('.status')
					.removeClass(Selector.FONT_ICON_CLASS_OBJ.tick)
					.removeClass('i-tick')
					.addClass(Selector.FONT_ICON_CLASS_OBJ.cross)
					.addClass('i-cross');
				}
			}
		}
		
	}
	function animateIncorrectOption(){
		for(var i=0; i<Selector.answerArray.length; i++){	
			var crrArr=Selector.answerArray[i];
			var found=false;
			for (var j = 0; j < crrArr.length; j++) {
				if (Selector.userArray[i].toString() == crrArr[j].toString()) {
					
					found=true;
					break;
				}else{
					
				}
			}
			if(!found){
				if (Selector.userArray[i] != defaultValue) {
					var incorrOpt = Selector.queDivObj.find('.'+Selector.DRAG_ITEM_CLASS+'[data-index="'+i+'"]');					
					APP.animationObj.animate({
						EL: incorrOpt,
						TYPE: 'shake-x',
						START_VAL: '+=10',						
						YOYO:true,
						REPEAT:3,
						STAGGER: false,
						DURATION: 0.1,
						ON_COMPLETE: function(){
							
						}
					});
				}
			}
		}
	}
	function updateStatus() {
		if(Selector.SEND_INTRACTION && Selector.QUE_INTRACTION_OBJ.dataTobeSend){	
			Selector.QUE_INTRACTION_OBJ.dataUserArray = Selector.userArray;
			Selector.QUE_INTRACTION_OBJ.dataAnswerArray = Selector.answerArray.join("^");
			Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
			Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = true;
			} else {
				Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected = false;
			}
			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.QUE_INTRACTION_OBJ.dataStatus = "correct";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 1;
			}else{
				Selector.QUE_INTRACTION_OBJ.dataStatus = "NA";
				Selector.QUE_INTRACTION_OBJ.dataEarnPoint = 0;
				if (Selector.QUE_INTRACTION_OBJ.dataIsUserOptionSelected) {
					Selector.QUE_INTRACTION_OBJ.dataStatus = "incorrect";
				}
			}
						
			Selector.QUE_INTRACTION_OBJ.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInlineInteractionData(Selector.QUE_INTRACTION_OBJ);
			
		}
		//--prevent to send attempted que data 
		/*if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode && !Selector.queObj.dataIsUserOptionSelected) {
			Selector.queObj.dataUserArray = Selector.userArray;
			Selector.queObj.dataAnswerArray = Selector.answerArray.join("^");
			Selector.queObj.dataStatus = "NA";
			Selector.queObj.dataEarnPoint = 0;
			var anySelect = false;
			for (var i = 0; i < Selector.userArray.length; i++) {
				if (Selector.userArray[i] != defaultValue) {
					anySelect = true;
					break;
				}
			}
			if (anySelect) {
				Selector.queObj.dataIsUserOptionSelected = true;
			} else {
				Selector.queObj.dataIsUserOptionSelected = false;
			}

			var corrObj = getCorrectCounts();
			
			if(corrObj.allCorrected){
				Selector.queObj.dataStatus = "correct";
				Selector.queObj.dataEarnPoint = Selector.queObj.dataQuePoint;
			}else if (anySelect) {
				Selector.queObj.dataStatus = "NA";
				Selector.queObj.dataEarnPoint = 0;
				
				if (corrObj.corrCount >= 1 && corrObj.inCorrCount == 0) {
					if (APP.configObj.assessment.applyPointOnPartiallyCorrect) {
						var qPoint = parseInt(Selector.queObj.dataQuePoint);
						var perOptionPoint = qPoint / corrObj.totalCorrCount;
						var num = perOptionPoint * corrObj.corrCount;
						var n = num.toFixed(2);
						var earnPoint = parseFloat(n);
						Selector.queObj.dataEarnPoint = earnPoint > qPoint ? qPoint : earnPoint;
					} else {
						Selector.queObj.dataEarnPoint = 0;
					}
					Selector.queObj.dataStatus = "partiallyCorrect";
				} else {
					Selector.queObj.dataStatus = "incorrect";
				}
			}
					
			Selector.queObj.dataStartTime = startTime;
			APP.dataComObj.updateUserData();
			APP.dataComObj.sendInteractionData(Selector.CURRENT_QUESTION);
		}*/
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}
	
	function updateTemplateLayout() {
		scalex = APP.scalex || 1;
		//as display: flex not work well in IE11
		if(Selector.queDivObj.length){
			Selector.queDivObj.find('.option-row').each(function(inx){
				var parentHt = $(this).find('.btn-cell').outerHeight();
				$(this).find('.liner').height(parentHt+'px');
				$(this).find('.drop-panel').height(parentHt+'px');
				$(this).find('.drag-panel').height(parentHt+'px');
			});			
		}
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	/* $(document).one(APP.eventObj.ON_ASSESSMENT_QUE_SHOW_ANI_DONE, function (e) {
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
	}); */
}
