function SelectRole() {
	var _this = this;
	var Selector = {};	
	var optArr = [];
	var defaultValue = '0'
	var time = new Date();
	var startTime;
	var questionPanelHt;
	var openMenuHt;

	var assessmentQuizObj = APP.configObj.assessment[APP.globalQuizObj.currentQuizId];

	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'dropdown-question',
			ACTIVITY_CONTAINER: '#screen-container',
			FEEDBACK_CONTAINER:'.feedback-container',
			QUS_BLOCK: '.question',
			IS_ASSESSMENT: false,
			CURRENT_QUESTION: 0,
			OPTION_RANDOMIZE: false,
			SHOW_PREVIOUS_SELECTION: false,
			QUE_OPT_PANEL: '.que-txt-panel',
			DROP_DOWN_PANEL: '.drop-down-panel',
			DROP_DOWN: '.drop-down',
			CORRECT_ANS_ARRAY:[],
			USER_ARRAY:[],
			FONT_ICON_CLASS_OBJ: {
				optNormal: 'icon-triangle-bottom',
				optSelected: 'icon-triangle-top',
				tick: 'icon-checkmark-1',
				cross: 'icon-cross-1'
			},
     		ON_SHOW: null,
			ON_SUBMIT: null,
			ON_TRY_AGAIN: null,
			ON_CLICK: null,
			ON_CHANGE: null,
     		ON_FEEDBACK_CONTINUE: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			isCompleted:false,
     		queObj:null,
			feedbackState:''
			
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}

	function initTemplate() {
		APP.preloaderObj.show();
		Selector.initialUserArr = [];
		Selector.answerArray = [];
		Selector.isCompleted = false;		
		if (Selector.IS_ASSESSMENT) {	
			getHTML();
			startTime = time; 
		}else{
			initialRender();
		}	
	}
	function getHTML() {
		/* WIP for assessment template... */
		Selector.userArray = [];
		Selector.CORRECT_ANS_ARRAY = [];
		var str = "";
		Selector.queObj = assessmentQuizObj.dataFinalAssessmentObj[Selector.CURRENT_QUESTION];
		
		if ((assessmentQuizObj.randomization) && (Selector.queObj.optionRandomize == "true")) {
			Selector.OPTION_RANDOMIZE = true;
		}else{
			Selector.OPTION_RANDOMIZE = false;
		}
		var _className = Selector.queObj.className || "";
		var _subType = Selector.queObj.subType || "";
		var _style = Selector.queObj.style || "";
		var _id = Selector.queObj.dataId;
		var _colWidth = Selector.queObj.colWidth || "col-60";
		
		/* 1 */str += '<div id="' + _id + '" class="question ' + _className + ' ' + _subType + ' ' + _id + ' " style="' + _style + '">';
			/* 2 */ str += '<div class="col col-text '+_colWidth+' white-alpha-bg ani-box-left">';		
				str += '<div class="sb-que-ref"></div>';
				str += '<div class="screen-title-div">';
					str += '<span class="icon font-icon icon-exercise"></span>';
					str += '<span class="title"></span>';
				str += '</div>';				
			/* 3 */str += '<div class="que-txt-panel">';	
				str += APP.getHtmlStructObj.textPanelStruct(Selector.queObj.questionText[0]);	
			/* 3 */str += '</div>';
			str += '<select class="placeholder-dropdown">';
			var optionObj = Selector.queObj.options[0].option;
			for (var j = 0; j < optionObj.length; j++) {					
				var _className = optionObj[j].className || "";
				var _style = optionObj[j].style || "";
				var _txt = optionObj[j].Text;
				var _correctId = optionObj[j].correctId.toLowerCase();
				if (_correctId != "na") {								
					//--logic for multiple correct option
					//Selector.CORRECT_ANS_ARRAY
					var arr =_correctId.split(',');					
					for(var m=0; m<arr.length; m++){									
						if(Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])] != null && Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].constructor === Array){		
							
						}else{
							Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])]=[];							
						}
						//rearrange id's as 0 set for initial option 'select an anwer'
						Selector.CORRECT_ANS_ARRAY[parseInt(arr[m])].push(j - 1);
					}
				}		
				str += '<option >'+_txt+'</option>';
			}	
			str += '</select>';
			
			/* 4 */str += '<div class="display-block submit-panel bottom-align">';			
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn submit-btn " href="javascript:void(0);" >';
							str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].submitBtn[0].Text+'</span>';
						str += '</a>';
					str += '</div>';
					str += '<div class=" btn-panel clickable display-inline-block" >';
						str += '<a class="btn click-btn additional-hint-btn " href="javascript:void(0);" >';
							str += '<span class="btn-icon font-icon icon-hint display-cell v-center center" ></span>';
							str += '<span class="btn-txt display-cell v-center center" >'+APP.globalXmlsObj.globalXML.commonText[0].getAddHintsBtnText[0].Text+'</span>';
						str += '</a>';
					str += '</div>';						
			/* 4 */str += '</div>';	
			var feedbacksObj = Selector.queObj.feedbacks
			if(feedbacksObj != null){
			/* 6 */str += '<div class="feedback-container">';
					//correct-pop
					var corrFeedTxtObj = feedbacksObj[0].correctFeedback;
					if(corrFeedTxtObj != null){
						str += '<div class="popup correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
								str += APP.getHtmlStructObj.textPanelStruct(corrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//incorrect-pop
					var incorrFeedTxtObj = feedbacksObj[0].incorrectFeedback;
					if(incorrFeedTxtObj != null){
						str += '<div class="popup incorrect " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(incorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}
					//partiallyCorrect-pop
					var prcorrFeedTxtObj = feedbacksObj[0].partialCorrectFeedback;
					if(prcorrFeedTxtObj != null){
						str += '<div class="popup partial-correct " data-animate-type="fade-in-bottom">';	
							str += '<div class="popup-content-box ">';
								str += '<div class="pop-col pop-col-text full" >';
									str += APP.getHtmlStructObj.textPanelStruct(prcorrFeedTxtObj[0]);
									str += '<div class=" btn-panel clickable display-inline-block" >';
										str += '<a class="btn click-btn continue-btn " href="javascript:void(0);" >';
											str += '<span class="btn-txt display-cell v-center" >'+APP.globalXmlsObj.assessmentXML[APP.globalQuizObj.currentQuizId].globalText[0].ContinueBtn[0].Text+'</span>';
										str += '</a>';
									str += '</div>';
								str += '</div>';
							str += '</div>';
						str += '</div>';
					}									
				/* 6 */str += '</div>';
			}				
			/* 2 */str += '</div>';
			if(_colWidth != 'full'){			
				if(Selector.queObj.bgImgPath != null && Selector.queObj.bgImgPath != ''){
					var path = 'content/images/'+APP.configObj.language.dir + assessmentQuizObj.dataImagesPath + Selector.queObj.bgImgPath;
					str += '<div class="col col-img screen-background background ani-box-right" style="background-image: url('+path+')"></div>';
				}else{
					str += '<div class="col col-blank"><p></p></div>';
				}
			}
		/* 1 */str += '</div>';
		$(Selector.ACTIVITY_CONTAINER).html(str);
		initialRender();
	}
	function initialRender() {	
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME);

		Selector.queDivObj = $(Selector.ACTIVITY_CONTAINER).find('.question');
		Selector.queOptions = Selector.queDivObj.find(Selector.QUE_OPT_PANEL);	
		Selector.queOptions.each(function (inx) {
			$(this).addClass('que-txt-panel_'+inx).data('id', inx);
			Selector.initialUserArr[inx] = [];
			$(this).find(Selector.DROP_DOWN_PANEL).each(function (jnx) {
				$(this).addClass('dd-panel_'+inx+'-'+jnx).data('quid', inx).data('ddid', jnx);
				Selector.initialUserArr[inx][jnx] = defaultValue;
			})
		});
		
		Selector.dropDownPanel = Selector.queDivObj.find(Selector.DROP_DOWN_PANEL);	

		Selector.placeHolderDropDown = Selector.queDivObj.find('.placeholder-dropdown');
		Selector.optionObj = [];	
		Selector.placeHolderDropDown.each(function (inx) {
			Selector.optionObj[inx] = $(this).find('option');
		});		
		Selector.placeHolderDropDown.hide();
		
		//validate CORRECT_ANS_ARRAY
		var totOpt = Selector.queOptions.length;
		if(Selector.CORRECT_ANS_ARRAY.length != totOpt){			
			console.error('Answer are not matched with option(s)...');
			alert('Answer are not matched with option(s)...');
			return false;
		}
		
		//--create answerArray
		//var tempArr = Selector.CORRECT_ANS_ARRAY.slice();
		var tempArr = Selector.CORRECT_ANS_ARRAY.map(function(arr) {
			return arr.slice();
		});
		//rearrange id's as 0 set for initial option 'select an answer'
		//for support multi drop down panel and multi option
		//que-option array
		for (var i=0; i<tempArr.length; i++){
			var currArr = tempArr[i];	
			Selector.answerArray[i] = [];
			//drop-down array			
			for(var j =0; j<currArr.length; j++){
				var optArr = currArr[j];	
				Selector.answerArray[i][j] = [];
				//drop-down multi option array
				for(var k =0; k<optArr.length; k++){
					Selector.answerArray[i][j][k] = parseInt(optArr[k]) + 1;
				}
			}
		}
		
		
		initOptionData();
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
		if(Selector.ON_SHOW){
			Selector.ON_SHOW();
		}		
	}
	function initOptionData(){
		optArr = [];
		
		for(var i=0; i<Selector.optionObj.length; i++){
			optArr[i] = [];
			
			if(Selector.OPTION_RANDOMIZE.toString() == 'true'){
				//--escape default value
				optArr[i] = APP.commonFunObj.getRandomArr((Selector.optionObj[i].length - 1), 1);
				//--add default value to 1st in array
				optArr[i].unshift(0);
			}else{
				optArr[i] = APP.commonFunObj.getLinearArr(Selector.optionObj[i].length);
			}
		}		
		
		//--create dropdown panel				
		var str = "";
		
		Selector.dropDownPanel.each(function (idx) {			
			str = "";
			var valRef = $(this).data('val-ref') || 0;
			var quid = $(this).data('quid');
			var ddid = $(this).data('ddid');	
			
			str += '<select class="drop-down select-drop-down drop-down_' +quid+'-'+ddid+'" id="drop-down_' +quid+'-'+ddid+'" data-quid="'+quid+'"  data-ddid="'+ddid+'" data-val-ref="'+valRef+'">';
			for (var i = 0; i < optArr[valRef].length; i++) {
				var _txt = Selector.optionObj[valRef].eq(optArr[valRef][i]).text();
				var _id = optArr[valRef][i];
				str += '<option class="option" data-id="'+_id+'" value="'+_id+'" >' + _txt + '</option>';	
			}
						
			str += '</select>';
			//--added status icon
			str += '<div class="btn-icon font-icon status"></div>';
			$(this).html(str);
		});
		applyDropDownEvent();
		showAnsValue();
		
	}
	function showAnsValue (){
		var cheatMode = APP.configObj.cheatMode;		
		if(cheatMode){			
			var corrClass = 'ref-corr';
			for(var i =0; i<Selector.answerArray.length; i++){
				var currArr = Selector.answerArray[i];				
				for(var j =0; j<currArr.length; j++){
					var optArr = currArr[j];
					for(var k =0; k<optArr.length; k++){
						var op = optArr[k];						
						//Selector.queDivObj.find('.dd-panel_' +i+'-'+j).find('.option[data-value="'+op+'"]').addClass(corrClass);
					}					
				}
			}
			
		}
	}
	
	function loadPrevUserData(){
		if (Selector.IS_ASSESSMENT && !assessmentQuizObj.dataReviewMode) {	
			//--to be work here		
			if (Selector.queObj.dataAnswerArray != null) {
				// for multi multidimensional array				
				//answerArray join: 2,3-3,2^1,2-3,1^5-1,3
				var tempAnsArr = Selector.queObj.dataAnswerArray.split('^');
				var newArr = [];
				for(var i=0; i<tempAnsArr.length; i++){
					var newArr1 = tempAnsArr[i].split('-');
					newArr[i] = [];
					for(var j=0; j<newArr1.length; j++){
						newArr[i][j] = [];
						newArr[i][j] = newArr1[j].split(',');	
					}				
				}
				Selector.CORRECT_ANS_ARRAY = newArr;
			}
			//userArr join: 4,2^1,3^4,3 
			if (Selector.queObj.dataUserArray != null) {
				var tempUsrArr = Selector.queObj.dataUserArray.split('^');
				var newArr = [];
				for(var i=0; i<tempUsrArr.length; i++){
					newArr.push(tempUsrArr[i].split(','));					
				}				
				Selector.userArray = newArr;				
			}			
		}else{
			Selector.userArray = Selector.USER_ARRAY;
		}
		
		if(Selector.userArray.length && Selector.SHOW_PREVIOUS_SELECTION){		
			Selector.queOptions.each(function (inx) {
				$(this).find(Selector.DROP_DOWN_PANEL).each(function (jnx) {
					var currVal = Selector.userArray[inx][jnx];	
					if(currVal != defaultValue){
						$(this).find(Selector.DROP_DOWN).val(currVal);
						$(this).find(Selector.DROP_DOWN).niceSelect('update');
					}					
				})
			});	
					
		}else{
			//Selector.userArray = Selector.initialUserArr.slice();
			Selector.userArray = Selector.initialUserArr.map(function(arr) {
				return arr.slice();
			});
		}
		
		initQuestion();		
	}
	function initQuestion(){
		EnabledDisabledBtn('.try-again-btn', false);
		EnabledDisabledBtn('.show-ans-btn', false);
		EnabledDisabledBtn('.show-user-selection-btn', false);
		updateValue();
		updateStatus();
	}

	function addTemplateEvent() {				
		Selector.queDivObj.find('.submit-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			processSubmit();
		})
		
		
		
		/* Selector.queDivObj.find('.try-again-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};
			resetQuestion();
			
		})
		Selector.queDivObj.find('.show-ans-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showAnswer();
		})
		Selector.queDivObj.find('.show-user-selection-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};	
			showUserSelection();
		})
		Selector.queDivObj.find('.continue-btn').on('click', function(){
			if($(this).hasClass('disabled') ){return false;};			
			if (Selector.ON_FEEDBACK_CONTINUE) {
				Selector.ON_FEEDBACK_CONTINUE(Selector.feedbackState);
			}
		}) */
	}
	function applyDropDownEvent(){
		Selector.queDivObj.find(Selector.DROP_DOWN).niceSelect();		
		Selector.queDivObj.find(Selector.DROP_DOWN).on('change', function(e){			
			var quid = parseInt($(this).data('quid'));
			var ddid = parseInt($(this).data('ddid'));
			var val = $(this).val();
			Selector.userArray[quid][ddid] = val;	
			
			extendActivityHeight();		
			updateValue();
			updateStatus();
			
		})
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var feedbackObj = $(this).parents('.popup');
			isModalPop = feedbackObj.hasClass('screen-modal-pop');
			var aniObj1 = APP.animationObj.generateAniObj($(feedbackObj));
			aniObj1.REVERSED = true;
			
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');
				aniObj1.EL = $(currObj).find('.modal-alert');	
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					$(Selector.FEEDBACK_CONTAINER).hide();
				}	
				APP.animationObj.animate(aniObj1);
			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					$(Selector.FEEDBACK_CONTAINER).hide();
				}
				APP.animationObj.animate(aniObj1);
			}	
			$(Selector.ACTIVITY_CONTAINER).find('.col-img .text-block').fadeIn();

		});
	}
	function updateValue(){		
		submitBtnStatus();
		//as value also modified on try again button
		if (Selector.ON_CLICK) {
			Selector.ON_CLICK(Selector.userArray);
		}
	}
	function submitBtnStatus(){
		var isAllSelected = true;
		
		for(var i=0; i<Selector.userArray.length; i++){
			var currArr = Selector.userArray[i];
			for(var j=0; j<currArr.length; j++){
				var curr = currArr[j];
				if(curr == defaultValue){
					isAllSelected = false;
					break;
				}
			}
			if(isAllSelected == false){
				break;
			}
		}
		if(isAllSelected){
			EnabledDisabledBtn('.submit-btn', true);			
		}else{
			EnabledDisabledBtn('.submit-btn', false);
		}
	}	
	function EnabledDisabledBtn(_div, _val){		
		if(_val){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
			Selector.queDivObj.find(_div).removeClass('disabled');
		}else{
			Selector.queDivObj.find(_div).parent('.clickable').addClass('hide');
			Selector.queDivObj.find(_div).addClass('disabled');
		}
		if(_div == '.submit-btn'){
			Selector.queDivObj.find(_div).parent('.clickable').removeClass('hide');
		}
	}

	function EnabledDisableDropDown (_val){		
		var dd = Selector.queDivObj.find(Selector.DROP_DOWN);
		if(dd.length){
			if(_val){
				$(dd)
				.removeAttr('disabled')
				.removeClass('disabled');
			}else{
				$(dd)
				.attr('disabled', 'disabled')
				.addClass('disabled');
			}
		}	
		
	}
	function getCorrectCounts(){
		var obj = {
		 corrCount: 0,
		 inCorrCount: 0,
		 allCorrected: false,
		 totalCorrCount: 0
		}
		
		//[["3","3"],["1","3"],["4","2"]]
		//[[[2,3],[3,2]],[[1,2],[3,1]],[[5],[1,3]]]

		for(var i =0; i<Selector.answerArray.length; i++){
			var currArr = Selector.answerArray[i];
			for(var j =0; j<currArr.length; j++){
				var found=false;	
				obj.totalCorrCount +=1;
				var optArr = currArr[j];
				for(var k =0; k<optArr.length; k++){
					var op = optArr[k];
					
					if (Selector.userArray[i][j].toString() == op.toString()) {
						obj.corrCount += 1;	
						
						found = true;
						break;
					}
				}
				if(!found){
					if (Selector.userArray[i][j] != defaultValue) {
						obj.inCorrCount += 1;
						
					}
				}					
			}
		}			
		
		if(obj.corrCount >= obj.totalCorrCount && obj.inCorrCount <= 0){
			obj.allCorrected = true;
		}
		
		return obj;
	}
	function processSubmit(){
	
		var id = parseInt($(this).parents(Selector.QUS_BLOCK).data('id'));
		//$(this).parents('.clickable').addClass('visited current');
		//console.log('id--Selector.userData: '+id+'--'+Selector.userData)
		id = 0;	
		
		APP.globalModalObj = new ModalPop();
		APP.globalModalObj.start({
			XML_NODE: APP.globalXmlsObj.globalXML.confirmPopText[0],
			CLASS_NAME: 'confirm-pop',
			ON_OK:function(){
				//custom logic for course
				if(Selector.userArray[0] >=1 && Selector.userArray[0] <=5){
					APP.userTopicSelectionObj.profilerOne = 'A';
				}else{
					APP.userTopicSelectionObj.profilerOne = 'B';
				}				
				APP.userTopicSelectionObj.profilerTwo = Selector.userArray[1].toString();
				APP.courseDataObj.applyUserProfile();
				screenCompleted();
			}
		});
		
		
	}
		
	function updateStatus() {
			
	}
	function extendActivityHeight(){
		//waited for animation complete
		setTimeout(function(){
			var openObj = $(Selector.queDivObj).find('.drop-down.open').find('.list');
			var panel = $(Selector.ACTIVITY_CONTAINER);
			//for responsive
			/* if (Selector.IS_ASSESSMENT) {
				panel = $(Selector.ACTIVITY_CONTAINER).find('.activity-panel');
			} */
			if(openObj.length){
				var t = openObj.offset();
				var panelPoss = panel.offset();
				var top = t.top;
				var panelTop = panelPoss.top;
				openMenuHt = openObj.outerHeight() || 100;
				var gap = (top - panelTop)  + openMenuHt;	
				if(panel.height() < gap){
					panel.css('min-height', gap+'px');
				}
				
			}else{
				panel.css('min-height', '150px');
			}
		}, 200);
	}
	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}		
	}

	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	$(document).on(APP.eventObj.ON_NICE_SELECT_CLICK, function (e) {
		extendActivityHeight();
	});
	
	function updateTemplateLayout() {
		extendActivityHeight();
	}
	
	
	
	
	
	
}