function SideNavMenu() {
	var _this = this;
	var Selector = {};	
	var iconObj = Object.assign({}, APP.iconObj);
	var isVidPlaying = false;
	var isVidEnded = false;
	var isAudPlaying = false;
	_this.start = function (_obj) {
		Selector = {
			ACTIVITY_CONTAINER: '#sidenav_menu',
			XML_NODE: APP.globalXmlsObj.globalXML,
			ON_INIT: null,
			ON_COMPLETE: null,
			ON_CLICK: null,
			isLoaded: false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.hidePanel = function(){
		hidePanel();
	}
	function initTemplate() {
		APP.preloaderObj.show();
		if(Selector.XML_NODE == null){
			console.warn('XML NOT FOUND...')
			return;
		}
		
		Selector.isLoaded = false;
		APP.eventObj.sideNavMenuStatus(true);
		$(Selector.ACTIVITY_CONTAINER).html(getHtml());
		//--for responsive
		$('body').addClass('modal-open');
		//--
		createHeader();
		createContent();
		createFooter();
		addTemplateEvent();
		updateModButtonStatus();
		updateTopicButtonStatus();
		updateScreenButtonStatus();
		showPanel();
		APP.preloaderObj.hide();
	}
	function getHtml(){
		str ='';
		str += '<div class="side-panel">';
			str += '<div class="side-body">';
				str += '<div class="side-header">';				
				str += '</div>';
				str += '<div class="side-content">';
					/* str += '<img class="bg-img" src="framework/images/menu_mobile.svg" alt="">'; */
					str += '<div class="scroll-parent">';				
						str += '<div class="scrollable"></div>';
					str += '</div>';				
				str += '</div>';
				str += '<div class="side-footer">';				
				str += '</div>';
			str += '</div>';
		str += '</div>';
		return str;
	}
	function createHeader(){
		var obj = $(Selector.ACTIVITY_CONTAINER).find('.side-header');
		var str ='';
		/* str +='<div class="display-table header-table">';
			str +='<div class="display-cell header-cell title-cell font-1">';
				str += '<span class="txt"></span>';
			str += '</div>';
			str +='<div class="display-cell header-cell status-cell font-1">';
				str += '<span class="txt"></span>';
			str += '</div>';
			str +='<div class="display-cell header-cell close-btn-cell">';
				str += '<a class="btn transBg close-btn" href="javascript:void(0);" >';
					str += '<span class="btn-icon font-icon icon-cross display-cell v-center"></span>';
				str += '</a>';
			str += '</div>';
		str += '</div>'; */
		$(obj).html(str);
	}
	function createContent(){
		var obj = $(Selector.ACTIVITY_CONTAINER).find('.side-content .scrollable');
		var str ='';
		
		var menuXmlObj = Selector.XML_NODE.menu[0];
		for (var i=0; i<menuXmlObj.module.length; i++){
			var curr = menuXmlObj.module[i];
			if(curr.hideOnMenu == 'true'){
				continue;
			}
			var statusClass="not-attempted"
			var modStatus = APP.courseDataObj.getModuleStatus(i);
			if(modStatus == '1'){
				statusClass = "incomplete"
			}
			if(modStatus == '2'){
				statusClass = "complete"
			}
			var mref = 'mod-'+i;
			var mtxt = curr.title[0].Text;
			var visibleClass = '';
			if(mtxt == null || mtxt == ''){
				visibleClass = 'no-title'
			}
			var txtClassName = curr.title[0].className || '';
			//depend upon profiler
			var dataType = curr.topic[0].dataType || '';
							
			if(dataType == 'mandatory'){
				/* 1 */str += '<div id="'+mref+'" class="mod-btn-block '+mref+'  '+statusClass+' '+visibleClass+'">';
						str+='<a class="btn module-btn " data-modid="'+i+'" href="javascript:void(0)">';
							if(curr.extraText){
								str += '<div class="time-div"><div class="txt">'+curr.extraText[0].timeTxt[0].Text+'</div></div>'
								str += '<div class="col-div">'
									str += '<div class="name-div"><div class="txt">'+curr.extraText[0].nameTxt[0].Text+'</div></div>'
									str += '<div class="minute-div hide"><div class="txt">'+curr.extraText[0].minuteTxt[0].Text+'</div></div>'
								str += '</div>'
							}
							str += '<div class="txt-cell '+txtClassName+'">'+mtxt+'</div>';
							str += '<div class="indicator indicator-cell "><div class="icon-bg11"><span class="font-icon icon"></span></div></div>';											
						str += '</a>';
				/* 1 */str += '</div>';		
			}
		}
		//module end
		$(obj).html(str);
	}
	function createFooter(){
		//future development plan
	}

	function addTemplateEvent() {
		$(Selector.ACTIVITY_CONTAINER).find('.module-btn').on('click', function(e){
			var parentBlock = $(this).parents('.mod-btn-block');
			if(parentBlock.hasClass('locked') || $(this).hasClass('disabled')){return false;};
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			var id = parentBlock.attr('id');
			var collapseObj = parentBlock.siblings('.collapse-'+id);
			//--if only 1 topic then direct load that screen
			var avlTopic = collapseObj.find('.topic-btn-block').length;
			if(avlTopic > 0){
				if(parentBlock.hasClass('open')){				
					collapseObj.find('.topic-btn-block').removeClass('open')
					collapseObj.find('.collapse-topic').slideUp('slow');
					collapseObj.slideUp('slow', function(){					
						
					});
					parentBlock.removeClass('open');
				}else{
					collapseObj.slideDown('slow', function(){
						//default open all topic
						//collapseObj.find('.collapse-topic').slideDown();
						//collapseObj.find('.topic-btn-block').addClass('open');
						//default open 1st topic
						//collapseObj.find('.collapse-topic').hide();
						//collapseObj.find('.collapse-topic').eq(0).slideDown();					
					});	
					parentBlock.addClass('open');			
				}
			}else{
				APP.navData.moduleId = $(this).data('modid');
				APP.navData.topicId = 0;
				APP.navData.screenId = 0;
				hidePanel(function (){
					APP.navigationObj.loadScreen();
				});
			}
			//--
			
		})
		$(Selector.ACTIVITY_CONTAINER).find('.topic-btn').on('click', function(e){
			var parentBlock = $(this).parents('.topic-btn-block');
			if(parentBlock.hasClass('locked') || $(this).hasClass('disabled')){return false;};	
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			var id = parentBlock.attr('id');
			var collapseObj = parentBlock.siblings('.collapse-'+id);
			//-- to check screen count
			var scrLen = collapseObj.find('.screen-btn').length;
			if(scrLen === 0){
				APP.navData.moduleId = $(this).data('modid');
				APP.navData.topicId = $(this).data('topicid');
				APP.navData.screenId = 0;
				hidePanel(function (){
					APP.navigationObj.loadScreen();
				});
			}else{
				if(parentBlock.hasClass('open')){
					collapseObj.slideUp('slow', function(){				
					});	
					parentBlock.removeClass('open');
				}else{
					collapseObj.slideDown('slow', function(){				
					});	
					parentBlock.addClass('open');	
				}
			}
			//--		
			
		})
		$(Selector.ACTIVITY_CONTAINER).find('.screen-btn').on('click', function(e){
			if($(this).parents('.screen-btn-block').hasClass('locked') || $(this).hasClass('disabled')){return false;};	
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			APP.navData.moduleId = $(this).data('modid');
			APP.navData.topicId = $(this).data('topicid');
			APP.navData.screenId = $(this).data('screenid');
			hidePanel(function (){
				APP.navigationObj.loadScreen();
			});
			
		})
		$(Selector.ACTIVITY_CONTAINER).find('.close-btn').on('click', function(e){
			if($(this).hasClass('disabled')){return false;};
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			if(Selector.isLoaded){
				hidePanel();
			}
		})
		$(Selector.ACTIVITY_CONTAINER).off('click');
		$(Selector.ACTIVITY_CONTAINER).on('click', function(e){
			
			if($(this).attr('class') == $(e.target).attr('class')){
				if(Selector.isLoaded){
					hidePanel();
				}
			}
		});
	}

	function updateModButtonStatus(){	
		var cheatMode = APP.configObj.cheatMode;	
		var menuContainer = $(Selector.ACTIVITY_CONTAINER).find('.side-content');
		if(APP.configObj.menu.lockMenu == true && !cheatMode){
			menuContainer.find('.mod-btn-block.not-attempted').addClass('locked');
			menuContainer.find('.mod-btn-block').eq(0).removeClass('locked');
			menuContainer.find('.mod-btn-block.complete').next().removeClass('locked');
		}
		//--indicator changes
		menuContainer.find('.mod-btn-block.locked').find('.indicator .icon').addClass(iconObj.locked);
		menuContainer.find('.mod-btn-block.not-attempted:not(.locked)').find('.indicator .icon').addClass(APP.iconObj.notAttempted);
		menuContainer.find('.mod-btn-block.incomplete').find('.indicator .icon').addClass(iconObj.incomplete);
		menuContainer.find('.mod-btn-block.complete').find('.indicator .icon').addClass(iconObj.complete);
	}
	function updateTopicButtonStatus(){
		var cheatMode = APP.configObj.cheatMode;
		var subMenuContainer = $(Selector.ACTIVITY_CONTAINER).find('.side-content');
		if(APP.configObj.menu.lockSubMenu == true && !cheatMode){
			subMenuContainer.find('.topic-btn-block.not-attempted').addClass('locked');
			subMenuContainer.find('.topic-btn-block').eq(0).removeClass('locked');	
			subMenuContainer.find('.mod-btn-block.locked').next('.collapse-mod').find('.topic-btn-block').eq(0).addClass('locked');				
			subMenuContainer.find('.topic-btn-block.complete').next().removeClass('locked');
		}
		
		//--indicator changes
		subMenuContainer.find('.topic-btn-block.locked').find('.indicator .icon').addClass(iconObj.locked);
		subMenuContainer.find('.topic-btn-block.not-attempted:not(.locked)').find('.indicator .icon').addClass(APP.iconObj.notAttempted);
		subMenuContainer.find('.topic-btn-block.incomplete').find('.indicator .icon').addClass(iconObj.incomplete);
		subMenuContainer.find('.topic-btn-block.complete').find('.indicator .icon').addClass(iconObj.complete);
		
	}
	function updateScreenButtonStatus(){
		var cheatMode = APP.configObj.cheatMode;
		var subMenuContainer = $(Selector.ACTIVITY_CONTAINER).find('.side-content');
		if(APP.configObj.menu.lockSubMenu == true && !cheatMode){
			subMenuContainer.find('.screen-btn-block.not-attempted').addClass('locked');
			subMenuContainer.find('.screen-btn-block').eq(0).removeClass('locked');		
			subMenuContainer.find('.topic-btn-block.locked').next('.collapse-topic').find('.screen-btn-block').eq(0).addClass('locked');	
			subMenuContainer.find('.screen-btn-block.complete').next().removeClass('locked');
		}
		
		//--indicator changes
		subMenuContainer.find('.screen-btn-block.locked').find('.indicator .icon').addClass(iconObj.locked);
		subMenuContainer.find('.screen-btn-block.not-attempted:not(.locked)').find('.indicator .icon').addClass(iconObj.notAttempted);
		subMenuContainer.find('.screen-btn-block.incomplete').find('.indicator .icon').addClass(iconObj.incomplete);
		subMenuContainer.find('.screen-btn-block.complete').find('.indicator .icon').addClass(iconObj.complete);
		
	}
	function showPanel(){	
		//--pause video and audio
		if(APP.vidPlayer){
			isVidPlaying = !(APP.vidPlayer.paused);
			isVidEnded = (APP.vidPlayer.ended);
			if(isVidPlaying && !isVidEnded){
				//video is playing so stop them
				APP.vidPlayer.pause();
			}
		}			
		if(APP.screenAudio){isAudPlaying = APP.screenAudio.playing() || false;}		
		
		if(isAudPlaying){APP.screenAudio.pause();}
		
		//--	
		//--default expand current screen row
		var currModObj = $(Selector.ACTIVITY_CONTAINER).find('#mod-'+APP.navData.moduleId);
		var currTopicObj = $(Selector.ACTIVITY_CONTAINER).find('#topic-'+APP.navData.moduleId+'_'+APP.navData.topicId);
		var currScreenObj = $(Selector.ACTIVITY_CONTAINER).find('#screen-'+APP.navData.moduleId+'_'+APP.navData.topicId+'_'+APP.navData.screenId);
		currModObj.addClass('current');
		currTopicObj.addClass('current');
		currScreenObj.addClass('current');
		var mid = currModObj.attr('id');
		var tid = currTopicObj.attr('id');
		
		var mcollapseObj = currModObj.siblings('.collapse-'+mid);
		currModObj.addClass('open');
		mcollapseObj.show();

		var tcollapseObj = currTopicObj.siblings('.collapse-'+tid);
		currTopicObj.addClass('open');
		tcollapseObj.show();
 
		/* //to open all
		$(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block').addClass('open');
		$(Selector.ACTIVITY_CONTAINER).find('.collapse-mod').show();
		
		$(Selector.ACTIVITY_CONTAINER).fadeIn('slow'); */

		//---
		//---remove module and direct show topic if module length = 1
		var showModCount = APP.navigationObj.getActualModuleCount();
		if(showModCount <= 1){
			var firstMod = $(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block').eq(0);			
			firstMod.addClass('current open').hide();
			var colObj = firstMod.siblings('.collapse-mod');
			colObj.show();
			colObj.find('.topic-btn-block').addClass('open');
			colObj.find('.collapse-topic').show();
		}
		$(Selector.ACTIVITY_CONTAINER).fadeIn('slow');
		//--slide main-div 		
		//$('#main-div').addClass('ani-slide');
		//custom edit for client remove side animation
		/* APP.animationObj.animate({
			EL: $('#main-div'),
			TYPE: 'margin-left',
			START_VAL: '-30%',
			DURATION: 0.5,
			ON_COMPLETE: function(){							
				
			}
		}); */
		/* $(Selector.ACTIVITY_CONTAINER).find('.side-panel').find('.scroll-parent').css('overflow', 'hidden');
		APP.animationObj.animate({
			EL: $(Selector.ACTIVITY_CONTAINER).find('.side-panel'),
			TYPE: 'fade-in-right',
			DURATION: 0.5,
			ON_COMPLETE: function(){
				
			}
		}); */
		var modEl = $(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block');
		TweenMax.fromTo(modEl, 0.5, 
			{rotationX:90, opacity:0}, 
			{rotationX:0, opacity:1,			
			ease: 'Power1.easeOut',
			onComplete: function(){
				$(Selector.ACTIVITY_CONTAINER).find('.side-panel').find('.scroll-parent').css('overflow', 'auto');
				Selector.isLoaded = true;
				$(this.target).focus();
			}
			
		}); 
		/* APP.animationObj.animate({
			EL: modEl,
			TYPE: 'fade-in-bottom',
			STAGGER: true,			
			DURATION: 0.5,
			DELAY: 0.5,
			ON_COMPLETE: function(){
				$(Selector.ACTIVITY_CONTAINER).find('.side-panel').find('.scroll-parent').css('overflow', 'auto');
				Selector.isLoaded = true;
				$(this.target).focus();
			}
		}); */
	}	
	function hidePanel(callback){	
		Selector.isLoaded = false;	
		APP.sideNavMenu = null;	
		//--for responsive
		$('body').removeClass('modal-open');
		//--	
		//$('#main-div').removeClass('ani-slide');
		//custom edit for client remove side animation
		/* APP.animationObj.animate({
			EL: $('#main-div'),
			TYPE: 'margin-left',
			START_VAL: '0%',
			DURATION: 0.5,
			ON_COMPLETE: function(){							
				
			}
		});	 */
		/* APP.animationObj.animate({
			EL: $(Selector.ACTIVITY_CONTAINER).find('.side-panel'),
			TYPE: 'fade-out-right',
			DURATION: 0.5,
			ON_COMPLETE: function(){							
				
			}
		}); */
		var modEl = $(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block');
		TweenMax.to(modEl, 0.5, 
			{rotationX:90, opacity:0,
			ease: 'Power1.easeOut',
			onComplete: function(){
				$(Selector.ACTIVITY_CONTAINER).hide().html('');
				APP.eventObj.sideNavMenuStatus(false);
				if(APP.vidPlayer){
					if(isVidPlaying && !isVidEnded){
						//video is playing so play them again 
						APP.vidPlayer.play();	
									
					}
				}
				if(isAudPlaying){APP.screenAudio.play();}
				if(callback){
					callback();
				};
			}
			
			});
		/* $(Selector.ACTIVITY_CONTAINER).fadeOut('slow',function(){
			
		});	 */
		/* var modEl = $(Selector.ACTIVITY_CONTAINER).find('.mod-btn-block');
		TweenMax.to(modEl, 0.5, 
			{rotationX:90, opacity:0,
			ease: 'Power1.easeOut',
			onComplete: function(){
				$(Selector.ACTIVITY_CONTAINER).hide().html('');
				APP.eventObj.sideNavMenuStatus(false);
				if(APP.vidPlayer){
					if(isVidPlaying && !isVidEnded){
						//video is playing so play them again 
						APP.vidPlayer.play();	
									
					}
				}
				if(isAudPlaying){APP.screenAudio.play();}
				if(callback){
					callback();
				};
			}
			
			}); */
		
	}
	function updateTemplateLayout() {}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
}