function VideoScreen() {
	var _this = this;
	var Selector = {};
	var isVidPlaying = false;
	var player = null;
	_this.start = function (_obj) {
		Selector = {
			CLASS_NAME: 'video-screen',
			ACTIVITY_CONTAINER: '#screen-container',
			VIDEO_BLOCK: '.video-block',
			TYPE: 'regular',
			ON_VIDEO_PLAY: null,
			ON_VIDEO_PAUSE: null,
			ON_VIDEO_PAUSE: null,
			ON_VIDEO_ENDED: null,
			IS_CONTROL_AVL: null,
			ON_COMPLETE: null,
			ON_MODAL_POP_SHOW:null,
			ON_HOTSPOT_POP_SHOW:null,
			ON_HOTSPOT_POP_CLOSE:null,
			CLICK_ARRAY: [],
			isCompleted:false
		};
		Selector = $.extend(Selector, _obj);
		initTemplate();
	}
	_this.replayVideo = function(_id){
		/* var id = _id || 0;		
		var currVidObj = $(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).eq(id).find('.media-video-player').eq(0);
		window.dd = currVidObj
		currVidObj.currentTime = 0;
		currVidObj.get(0).play(); */
		if(APP.vidPlayer){
			APP.vidPlayer.currentTime = 0;
			APP.vidPlayer.play();
		}
	}
	function initTemplate() {
		APP.preloaderObj.show();
		Selector.isCompleted = false;
		$(Selector.ACTIVITY_CONTAINER).addClass(Selector.CLASS_NAME).addClass(Selector.TYPE);

		$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){			
			$(this).attr('data-id', inx);
			$(this)
			.find('.vid-transcript-btn')
			.attr('data-id', inx)
			.addClass('transcript-btn-'+inx);
			$(this)
			.find('.vid-transcript-popup')
			.attr('data-id', inx)
			.addClass('vid-transcript-popup-'+inx);
		})
		if(Selector.TYPE == 'video-step' || Selector.IS_CONTROL_AVL == false){
			APP.vidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
				controls: ['play-large'],
				iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
				clickToPlay: false,
				keyboard: { focused: false, global: false },
				fullscreen: {enabled: false}
			});
		}else{
			var deviceType = APP.systemDetectorObj.deviceType;
			var browserName = APP.systemDetectorObj.browserName;
			if(browserName != 'safari' && deviceType == 'desktop'){
				APP.vidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
					controls: ['play-large', 'play', 'progress', 'current-time', 'mute','captions', 'fullscreen'],
					iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
					captions: { active: true, language: 'auto', update: true },
				});
			}else{
				//for mobile remove fullscreen button
				APP.vidPlayer = new Plyr($(Selector.ACTIVITY_CONTAINER).find('.media-video-player'),{
					controls: ['play-large', 'play', 'progress', 'current-time', 'mute','captions'],
					iconUrl: 'framework/images/'+APP.configObj.language.dir+'/plyr/plyr_sprite.svg',
					captions: { active: true, language: 'auto', update: true },
					fullscreen: {enabled: false}
				});
			}
		}
		
		loadPrevUserData();
		updateTemplateLayout();
		addTemplateEvent();
		APP.preloaderObj.hide();
	}

	function loadPrevUserData(){
		//--get prev value retun object
		Selector.userData = Selector.CLICK_ARRAY;
		
		if(Selector.userData.length && APP.configObj.screenWise.showPrevData == true){
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				var id = $(this).data('id');
				if(Selector.userData[id] == 1){
					$(this).addClass('visited');
				}
			});
		}else{
			Selector.userData = [];
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				Selector.userData.push(0);
			});
		}
		
		updateStatus();

	}
	
	function addTemplateEvent() {
		if(APP.vidPlayer){
			APP.vidPlayer.on('loadstart', function(e){	
				//console.log('loadstart')				
				//APP.preloaderObj.show();			
			})
			APP.vidPlayer.on('canplay', function(e){
				//console.log('canplay');
				//APP.vidPlayer.toggleCaptions(true);	
				$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();				
			})
			APP.vidPlayer.on('canplaythrough', function(e){	
				//console.log('canplaythrough')
				if(e.target.readyState >= 3){				
					//APP.preloaderObj.hide();
					$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();
				}
			});
			APP.vidPlayer.on('pause', function(e){		
				//console.log('pause')
				if(Selector.ON_VIDEO_PAUSE){
					Selector.ON_VIDEO_PAUSE({id: 0, arr:Selector.userData})
				}
			});
			APP.vidPlayer.on('play', function(e){
				//console.log('play')	
				$(Selector.ACTIVITY_CONTAINER).find('.static-poster').hide();
				$('#play-overlay').addClass('hide');
				APP.commonFunObj.removeScreenAudio();
				if(APP.isScreenAudioPlay){
					APP.vidPlayer.muted = false;
				}else{
					APP.vidPlayer.muted = true;
				}
				APP.commonFunObj.removeBgMusic();
				if(Selector.ON_VIDEO_PLAY){
					Selector.ON_VIDEO_PLAY({id: 0, arr:Selector.userData})
				}
			});
			APP.vidPlayer.on('timeupdate', function(e){
				//console.log('timeupdate')				
				if(Selector.ON_TIMEUPDATE){
					Selector.ON_TIMEUPDATE({id: 0, vidObj: e.currentTarget});
				}
			});
			APP.vidPlayer.on('ended', function(e){
				//console.log('ended')
					if(APP.vidPlayer.fullscreen.active){
						APP.vidPlayer.fullscreen.exit();
					}
								
				if(Selector.ON_VIDEO_ENDED){
					Selector.userData[0] = 1;
					updateStatus();
					Selector.ON_VIDEO_ENDED({id: 0, arr:Selector.userData})
					
				}
			});
		}
		

		$(Selector.ACTIVITY_CONTAINER).find('.vid-transcript-btn').on('click', function(e){
			if($(this).parents('.clickable').hasClass('disabled') || $(this).parents('.clickable').hasClass('current')){return false;};
			e.stopPropagation();

			isVidPlaying = !(APP.vidPlayer.paused);

			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
				var currVidObj = $(this).find('.media-video-player').eq(0);
				$(currVidObj).get(0).pause();
			});
			APP.commonFunObj.removeScreenAudio();
			var id = parseInt($(this).parents(Selector.VIDEO_BLOCK).data('id'));
			//$(this).parents('.clickable').addClass('visited current');
			
			Selector.userData[id] = 1;	
			var t = $(this).attr('data-link');
			//to open transcript pdf 
			if(t){
				var transWin = window.open(t,'_blank');
				transWin.focus();
				if (Selector.ON_CLICK) {
					Selector.ON_CLICK({id: id, arr:Selector.userData});
				}	
				updateStatus();	
				return false;
			}	
			
			var currPop = $(Selector.ACTIVITY_CONTAINER).find('.vid-transcript-popup[data-id="'+id+'"]:not(.mobile-no-popup)');//for animation
			//--
			var currentView = APP.commonFunObj.getCurrentView();
			if(currentView == 'mobile'){
				var mobPop = $(Selector.ACTIVITY_CONTAINER).find('.vid-transcript-popup[data-id="'+id+'"].mobile-no-popup');
				if(mobPop.length){
					currPop = mobPop;
				}
			}
				
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			$(currPop).find('.scroll-parent').scrollTop(0);
			aniObj.ON_COMPLETE = function(){
				
			};
			var isModalPop = currPop.hasClass('screen-modal-pop');
			if(isModalPop){
				//--for responsive
				$('body').addClass('modal-open');
				//--
				$('#alpha-bg').fadeIn();
				//IE hack placing pop on root level
				currPop.clone(true)
				.appendTo("#main-div")
				.fadeIn()
				//--for init modal window templates...
				if (Selector.ON_MODAL_POP_SHOW) {
					Selector.ON_MODAL_POP_SHOW();
				}
				APP.commonFunObj.updateScreenModalPopLayout();
				aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
				aniObj.EL.find('.scroll-parent').scrollTop(0);
				aniObj.ON_COMPLETE = function(){
					APP.commonFunObj.updateScreenModalPopLayout();
				}
				APP.animationObj.animate(aniObj);	
				APP.eventObj.applyGbPopCloseEvent();			
			}else{			
				currPop.show();
				if(currPop.hasClass('mobile-no-popup')) {
					//$(this).parents('.clickable').addClass('hide');	
					$(this).parents('.trascript-btn-block').addClass('hide');	
				}	
				if($('body').hasClass('responsive')){	
					//--check only when responsive 			
					isInView = APP.commonFunObj.isElementInView($(currPop));
					if(!isInView){
						APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
					}
					
				}
				APP.animationObj.animate(aniObj);
				currPop.find('.scroll-parent').scrollTop(0);	
				applyPopCloseEvent();				
			}
			
			
			if (Selector.ON_CLICK) {
				Selector.ON_CLICK({id: id, arr:Selector.userData});
			}	
			updateStatus();			
		})
		//---
		$(Selector.ACTIVITY_CONTAINER).find('.hotspot-btn').on('click', function(e){
			if($(this).parents('.clickable').hasClass('disabled') || $(this).parents('.clickable').hasClass('current')){return false;};
			e.stopPropagation();
			APP.commonFunObj.playSoundEffect({name: 'clicked'});
			var currPop = $(this).parents('.hotspot-block').find('.hotspot-popup');//for animation	
			var aniObj = APP.animationObj.generateAniObj($(currPop));
			aniObj.ON_COMPLETE = function(){
				
			};
			var isModalPop = currPop.hasClass('screen-modal-pop');
			if(isModalPop){
				//--for responsive
				$('body').addClass('modal-open');
				//--
				$('#alpha-bg').fadeIn();
				//IE hack placing pop on root level
				currPop.clone(true)
				.appendTo("#main-div")
				.fadeIn()
				
				APP.commonFunObj.updateScreenModalPopLayout();
				aniObj.EL = $('#main-div > .screen-modal-pop').find('.modal-alert');
				aniObj.EL.find('.scroll-parent').scrollTop(0);
				aniObj.ON_COMPLETE = function(){
					APP.commonFunObj.updateScreenModalPopLayout();
				}
				APP.animationObj.animate(aniObj);			
			}else{			
				currPop.show();
				if($('body').hasClass('responsive')){	
					//--check only when responsive 			
					isInView = APP.commonFunObj.isElementInView($(currPop));
					if(!isInView){
						APP.commonFunObj.scrollToElement($(currPop), true, 'top', -200);
					}
				}
				APP.animationObj.animate(aniObj);	
				currPop.find('.scroll-parent').scrollTop(0);			
			}
			if (Selector.ON_HOTSPOT_POP_SHOW) {
				Selector.ON_HOTSPOT_POP_SHOW();
			}
			applyPopHotSpotCloseEvent();	
		})
		
	}
	function applyPopCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			var _this = $(this);
			var currObj = $(this).parents('.vid-transcript-popup');
			var isModalPop = currObj.hasClass('screen-modal-pop');
      if(isVidPlaying){
					$(Selector.ACTIVITY_CONTAINER).find(Selector.VIDEO_BLOCK).each(function(inx){
						var currVidObj = $(this).find('.media-video-player').eq(0);
						$(currVidObj).get(0).play();
					});
				}
			
			var aniObj1 = APP.animationObj.generateAniObj($(currObj));
			aniObj1.REVERSED = true;
						
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');				
				aniObj1.EL = $(currObj).find('.modal-alert');
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}					
				APP.animationObj.animate(aniObj1);			

			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					//data-load-next
					var dn = _this.data('load-next');					
					if(dn){APP.navigationObj.loadNextScreen();}
				}				
				APP.animationObj.animate(aniObj1);
			}	
			
		});
	}	
	function applyPopHotSpotCloseEvent(){
		$('#main-div').find('.close-popup-btn').off('click');
		$('#main-div').find('.close-popup-btn').one('click', function(){
			if($(this).hasClass('disabled')){return false;};
			
			var currObj = $(this).parents('.hotspot-popup');
			var isModalPop = currObj.hasClass('screen-modal-pop');
			
			var aniObj1 = APP.animationObj.generateAniObj($(currObj));
			aniObj1.REVERSED = true;
						
			//IE hack for position fixed			
			if(isModalPop){
				//--for responsive
				$('body').removeClass('modal-open');
				//--
				var currObj = $('#main-div > .screen-modal-pop');				
				aniObj1.EL = $(currObj).find('.modal-alert');
				aniObj1.ON_COMPLETE = function(){					
					$('#alpha-bg').fadeOut('fast');
					currObj.remove();
					if (Selector.ON_HOTSPOT_POP_CLOSE) {
						Selector.ON_HOTSPOT_POP_CLOSE();
					}
				}					
				APP.animationObj.animate(aniObj1);			

			}else{
				aniObj1.ON_COMPLETE = function(){					
					$(currObj).hide();
					if (Selector.ON_HOTSPOT_POP_CLOSE) {
						Selector.ON_HOTSPOT_POP_CLOSE();
					}
				}				
				APP.animationObj.animate(aniObj1);
			}	
			
		});
	}	
	function updateTemplateLayout() {
		
	}
	
	$(document).on(APP.eventObj.ON_CUSTOM_RESIZE, function (e) {
		updateTemplateLayout();
	});
	
	function updateStatus() {		
		Selector.isCompleted = false;	
		
		var count =0;
		for(var i=0; i<Selector.userData.length; i++){
			var curr = Selector.userData[i];
			if(curr == 1){
				count++;
			}
		}	
		if(count >= Selector.userData.length){
			Selector.isCompleted = true;
		}
		if (Selector.isCompleted) {
			screenCompleted();
		}
	}

	function screenCompleted() {
		if (Selector.ON_COMPLETE) {
			Selector.ON_COMPLETE();
		}
		
	}
}